(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                        Inverse_Image.v                                   *)
(****************************************************************************)
(*                         Bruno Barras                                     *)
(****************************************************************************)

 Section Inverse_Image.

 Variables A,B:Set.
 Variable R : B->B->Prop.
 Variable f:A->B.

 Local Rof : A->A->Prop := [x,y:A](R (f x) (f y)).

    Remark Acc_lemma : (y:B)(Acc B R y)->(x:A)(y=(f x))->(Acc A Rof x).
    Induction 1; Intros.
    Apply Acc_intro; Intros.
    Apply (H1 (f y0)); Try Trivial.
    Rewrite H2; Trivial.
    Save.

    Lemma Acc_inverse_image : (x:A)(Acc B R (f x)) -> (Acc A Rof x).
    Intros; Apply (Acc_lemma (f x)); Trivial.
    Save.

    Theorem wf_inverse_image: (well_founded B R)->(well_founded A Rof).
    Red; Intros; Apply Acc_inverse_image; Auto.
    Save.
 End Inverse_Image.















(* $Id: Inverse_Image.v,v 1.5 1999/06/29 07:48:56 loiseleu Exp $ *)
