(*							*)
(*	lex_coq.mll	(JCF  4/5/94)			*)
(*							*)
{
 open Init;;
 open Lexing;;

 let comment_depth = ref 0;;
 
 exception Fin_fichier;;

 let module_name = ref "";;

 let specif = ref false;;

 let mllist = ref ([] : string list);;
}

let space = [' ' '\t' '\n']
let ident = ['a'-'z' '_' '0'-'9' 'A'-'Z']+

rule action = parse
    "Require" space+
      { specif := false; opened_file lexbuf }
  | "Require" space+ "Export" space+
      { specif := false; opened_file lexbuf}
  | "Require" space+ "Syntax" space+
      { specif := false; opened_file lexbuf}
  | "Require" space+ "Import" space+
      { specif := false; opened_file lexbuf}
  | "Declare" space+ "ML" space+ "Module" space+
      { mllist := []; modules lexbuf}
  | "\""
      { chaine lexbuf; action lexbuf}
  | "(*"
      { comment_depth := 1; comment lexbuf; action lexbuf }  
  | eof { raise Fin_fichier} 
  | _   { action lexbuf }
and comment = parse
    "(*"
      { comment_depth := succ !comment_depth; comment lexbuf }
  | "*)"
      { comment_depth := pred !comment_depth;
        if !comment_depth > 0 then comment lexbuf }
  | "'" [^ '\\' '\''] "'"
      { comment lexbuf }
  | "'" '\\' ['\\' '\'' 'n' 't' 'b' 'r'] "'"
      { comment lexbuf }
  | "'" '\\' ['0'-'9'] ['0'-'9'] ['0'-'9'] "'"
      { comment lexbuf }
  | eof
      { raise Fin_fichier } 
  | _ { comment lexbuf }
and chaine = parse
    '"'                { () }
  | '\\' ['"' '\\']    { chaine lexbuf }
  | _		       { chaine lexbuf }
and opened_file = parse
    "(*"  	{ comment_depth := 1; comment lexbuf; opened_file lexbuf }
  | space+
      	       	{ opened_file lexbuf }
  | "Implementation"
                { opened_file lexbuf }
  | "Specification"
                { specif := true; opened_file lexbuf }
  | ident
       	       	{ module_name := (Lexing.lexeme lexbuf);
                  opened_file_end lexbuf }
and opened_file_end = parse
    '.'               { Require (!specif, !module_name) }
  | space+            { opened_file_end lexbuf }
  | "(*"              { comment_depth := 1; comment lexbuf;
      	       	       	opened_file_end lexbuf }
  | '"' [^'"']* '"'   { let lex = Lexing.lexeme lexbuf in
      	       	       	let str = String.sub lex 1 (String.length lex - 2) in
			RequireString (!specif, str) }
  | eof		      { raise Fin_fichier }
  | _		      { opened_file_end lexbuf }
and modules = parse
    space+              { modules lexbuf }
  | "(*"		{ comment_depth := 1; comment lexbuf;
      	       	       	  modules lexbuf }
  | '"' [^'"']* '"'
        { let lex = (Lexing.lexeme lexbuf) in 
	  let str = String.sub lex 1 (String.length lex - 2) in
	  mllist := str :: !mllist; modules lexbuf }
  | _   { (Declare (List.rev !mllist)) }   
