(**************************************************************************)
(*                               filter.ml                                *)
(**************************************************************************)

open Lexer;;

let clevel = ref 0;;  (* comment level *)


module type PRINT = sig
  val initial : token Stream.t -> unit
  val print_token : token -> unit
end;;


module FFilter = functor (P :PRINT) -> struct
  
  let print_t = function
    CB  -> clevel := succ !clevel ;
           P.print_token CB
  | CE  -> if !clevel > 0 then clevel := pred !clevel ;
           P.print_token CE
  | tok -> P.print_token tok
  ;;

  let filter st =
    P.initial st ;
    Stream.iter print_t st
  ;;

end;;

   
