
(* A quick library for TeX *)

let escaped_char = function
  | '_'  -> "\\_"
  | '$'  -> "\\$"
  | '~'  -> "\\char'176"
  | '^'  -> "\\char'136"
  | '\\' -> "$\\backslash$"
  | '{'  -> "\\{" 
  | '}'  -> "\\}" 
  | '&'  -> "\\&" 
  | '%'  -> "\\%"
  | '#'  -> "\\#"
  | '<'  -> "$<$" 
  | '>'  -> "$>$" 
  | '|'  -> "$|$" 
  | c    -> String.make 1 c


let escaped_string s =
  let res = ref "" in
    for i = 0 to String.length s - 1 do
      res := !res ^ (escaped_char (String.get s i))
    done;
    !res

(**
let string_of_char_list cl =
  let n = List.length cl in
  let s = String.create n in
  let rec aux i = function
     []    -> s
   | c::l  -> String.set s i c ; aux (succ i) l
  in aux 0 cl

let escaped_string str =
  let rec tex_rec = parser
    [< ''_' ; s >] -> '\\'::'_'::(tex_rec s)
  | [< ''$' ; s >] -> '\\'::'$'::(tex_rec s)
  | [< 'c ; s >]   -> c::(tex_rec s)
  | [< >]          -> []
  in
  let st = Stream.of_string str in
  let l = tex_rec st in
  string_of_char_list l
**)
