-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Contains miscellaneous routines"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class MISC

feature {NONE}

	append_arrays(a, b: ARRAY[ANY]) is
			-- append array b to end of array a
		require
			a_is_valid: a /= Void
			b_is_valid: b /= Void
		local
			offset: INTEGER
			old_upper: INTEGER
		do
			old_upper := a.upper
			a.resize(a.lower, a.upper + b.count)
			from
				offset := 0
			until
				offset >= b.count
			loop
				a.put(b @ (b.lower + offset), old_upper + offset + 1)
				offset := offset + 1
			end
		end
			
end
