-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This class writes the root class"
	author:			"Daniel Elphick <de397@ecs.soton.ac.uk>"
	date:          "August 1999"
	changed_by:    "Oliver Elphick <olly@lfix.co.uk> - 30th Oct 1999"
	cvs:           "$Id: root_class_writer.e,v 1.6 1999/10/30 23:46:11 olly Exp $"

class ROOT_CLASS_WRITER

inherit

	CLASS_WRITER
		rename
			widget_tree as interface
		end

creation
	make

feature
	
	name: STRING is "GTK-Interface"
	root_features: LINKED_LIST[CAN_BE_CREATED]

	inherit_from: STRING is "GTK_APPLICATION%N%N%TTOP_LEVEL_WINDOWS%N%N%TCUSTOMISATION"

	make(interface_tree, project_tree: TAG_TREE; src: STRING) is
			-- Writes all the source files
		require
			valid_project: project_tree /= Void
			valid_interface: interface_tree /= Void
			valid_src: src /= Void and then not src.empty
		do
			src_dir := src
			classname := clone(project_tree.get_string_from_field("name"))
			classname.to_upper
			filename := clone(project_tree.get_string_from_field("name"))
			filename.to_lower
			filename.prepend(src_dir)
			filename.append(".e")
			interface := interface_tree
			!!root_features.make
			!!inherit_list.make
			inherit_list.add(inherit_klass)
		ensure
			interface /= Void
		end
	
	write_gtk_classes is
			-- write a class file for each widget
		local
			i: INTEGER
			cl: TAG_TREE
		do
			if interface.count = 1 then
				print("No widgets defined in interface%N")
			else
				print("Writing widget classes%N")
				from
					i := 1 -- (start from 1 because 0 is project)
						   -- this is a hack as nothing says that the project
						   -- field has to be first although it always is!
				variant
					interface.count - i
				until
					i >= interface.count
				loop
					cl ?= interface @ i
					create_child_class(cl)
					inherit_list.merge_with(last_class.parent_inherit)
					root_features.add_last(last_class);
					(root_features @ i).make_top_level
					i := i + 1
				end
			end
		end

	write_features is
		do
		end

	write_make_body is
		local
			i: INTEGER
			code: ARRAY[STRING]
		do
			write_line("make is")
			indent
			write_line("do")
			indent
			write_line("initialize_tool_kit")
			from
				i := root_features.lower
			variant
				root_features.count - i
			until
				i > root_features.upper
			loop
				!!code.make(0,-1);
				(root_features @ i).append_top_level_show(code)
				write_lines(code)
				i := i + 1
			end
			write_line("begin")
			write_line("wait_for_events")
			outdent
			write_line("end")
			outdent
		end

end
