indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GDK"
	gtk_file: "gdk.h"
	status: "See notice at end of class"
	signals: ""
	events: ""

class
	C_GDK

feature -- External C functions

	gdk_init (a_argc: POINTER; a_argv: POINTER) is 
			-- Parsed as:
			-- void gdk_init (
			--     gint *a_argc,
			--     gchar ***a_argv
			-- );
			--
			-- Original C code from gdk.h:
			-- void 	  gdk_init		   	(gint	   	*argc,
			-- 					 gchar        ***argv);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_init_check (a_argc: POINTER; a_argv: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_init_check (
			--     gint *a_argc,
			--     gchar ***a_argv
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean  gdk_init_check   	        (gint	   	*argc,
			-- 					 gchar        ***argv);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_exit (a_error_code: INTEGER) is 
			-- Parsed as:
			-- void gdk_exit (
			--     gint a_error_code
			-- );
			--
			-- Original C code from gdk.h:
			-- void  	  gdk_exit		   	(gint	    	 error_code);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_set_locale: POINTER is 
			-- Parsed as:
			-- gchar* gdk_set_locale (
			-- );
			--
			-- Original C code from gdk.h:
			-- gchar*	  gdk_set_locale	   	(void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_error_trap_push is 
			-- Parsed as:
			-- void gdk_error_trap_push (
			-- );
			--
			-- Original C code from gdk.h:
			-- void      gdk_error_trap_push           (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_error_trap_pop: INTEGER is 
			-- Parsed as:
			-- gint gdk_error_trap_pop (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint      gdk_error_trap_pop            (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_events_pending: BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_events_pending (
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean  gdk_events_pending	 	(void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_get: POINTER is 
			-- Parsed as:
			-- GdkEvent* gdk_event_get (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkEvent* gdk_event_get			(void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_peek: POINTER is 
			-- Parsed as:
			-- GdkEvent* gdk_event_peek (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkEvent* gdk_event_peek                (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_get_graphics_expose (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkEvent* gdk_event_get_graphics_expose (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkEvent* gdk_event_get_graphics_expose (GdkWindow 	*window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_put (a_event: POINTER) is 
			-- Parsed as:
			-- void gdk_event_put (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gdk.h:
			-- void      gdk_event_put	 		(GdkEvent  	*event);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_copy (a_event: POINTER): POINTER is 
			-- Parsed as:
			-- GdkEvent* gdk_event_copy (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkEvent* gdk_event_copy     		(GdkEvent 	*event);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_free (a_event: POINTER) is 
			-- Parsed as:
			-- void gdk_event_free (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gdk.h:
			-- void	  gdk_event_free     		(GdkEvent 	*event);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_get_time (a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- guint32 gdk_event_get_time (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gdk.h:
			-- guint32   gdk_event_get_time 		(GdkEvent 	*event);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_handler_set (a_func: POINTER; a_data: POINTER; a_notify: POINTER) is 
			-- Parsed as:
			-- void gdk_event_handler_set (
			--     GdkEventFunc a_func,
			--     gpointer a_data,
			--     GDestroyNotify a_notify
			-- );
			--
			-- Original C code from gdk.h:
			-- void	  gdk_event_handler_set 	(GdkEventFunc    func,
			-- 					 gpointer        data,
			-- 					 GDestroyNotify  notify);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_set_show_events (a_show_events: INTEGER) is 
			-- Parsed as:
			-- void gdk_set_show_events (
			--     gint a_show_events
			-- );
			--
			-- Original C code from gdk.h:
			-- void	  gdk_set_show_events		(gint		 show_events);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_set_use_xshm (a_use_xshm: INTEGER) is 
			-- Parsed as:
			-- void gdk_set_use_xshm (
			--     gint a_use_xshm
			-- );
			--
			-- Original C code from gdk.h:
			-- void	  gdk_set_use_xshm		(gint		 use_xshm);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_get_show_events: INTEGER is 
			-- Parsed as:
			-- gint gdk_get_show_events (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	  gdk_get_show_events		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_get_use_xshm: INTEGER is 
			-- Parsed as:
			-- gint gdk_get_use_xshm (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	  gdk_get_use_xshm		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_get_display: POINTER is 
			-- Parsed as:
			-- gchar* gdk_get_display (
			-- );
			--
			-- Original C code from gdk.h:
			-- gchar*	  gdk_get_display		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_time_get: INTEGER is 
			-- Parsed as:
			-- guint32 gdk_time_get (
			-- );
			--
			-- Original C code from gdk.h:
			-- guint32 gdk_time_get	  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_timer_get: INTEGER is 
			-- Parsed as:
			-- guint32 gdk_timer_get (
			-- );
			--
			-- Original C code from gdk.h:
			-- guint32 gdk_timer_get	  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_timer_set (a_milliseconds: INTEGER) is 
			-- Parsed as:
			-- void gdk_timer_set (
			--     guint32 a_milliseconds
			-- );
			--
			-- Original C code from gdk.h:
			-- void	gdk_timer_set	  (guint32 milliseconds);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_timer_enable is 
			-- Parsed as:
			-- void gdk_timer_enable (
			-- );
			--
			-- Original C code from gdk.h:
			-- void	gdk_timer_enable  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_timer_disable is 
			-- Parsed as:
			-- void gdk_timer_disable (
			-- );
			--
			-- Original C code from gdk.h:
			-- void	gdk_timer_disable (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_add_full (a_source: INTEGER; a_condition: INTEGER; a_function: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_input_add_full (
			--     gint a_source,
			--     GdkInputCondition a_condition,
			--     GdkInputFunction a_function,
			--     gpointer a_data,
			--     GdkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_input_add_full	  (gint		     source,
			-- 			   GdkInputCondition condition,
			-- 			   GdkInputFunction  function,
			-- 			   gpointer	     data,
			-- 			   GdkDestroyNotify  destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_add (a_source: INTEGER; a_condition: INTEGER; a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_input_add (
			--     gint a_source,
			--     GdkInputCondition a_condition,
			--     GdkInputFunction a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_input_add	  (gint		     source,
			-- 			   GdkInputCondition condition,
			-- 			   GdkInputFunction  function,
			-- 			   gpointer	     data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_remove (a_tag: INTEGER) is 
			-- Parsed as:
			-- void gdk_input_remove (
			--     gint a_tag
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_remove	  (gint		     tag);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pointer_grab (a_window: POINTER; a_owner_events: INTEGER; a_event_mask: INTEGER; a_confine_to: POINTER; a_cursor: POINTER; a_time: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_pointer_grab (
			--     GdkWindow *a_window,
			--     gint a_owner_events,
			--     GdkEventMask a_event_mask,
			--     GdkWindow *a_confine_to,
			--     GdkCursor *a_cursor,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_pointer_grab	(GdkWindow *	 window,
			-- 			 gint		 owner_events,
			-- 			 GdkEventMask	 event_mask,
			-- 			 GdkWindow *	 confine_to,
			-- 			 GdkCursor *	 cursor,
			-- 			 guint32	 time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pointer_ungrab (a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_pointer_ungrab (
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_pointer_ungrab (guint32	 time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyboard_grab (a_window: POINTER; a_owner_events: INTEGER; a_time: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_keyboard_grab (
			--     GdkWindow *a_window,
			--     gint a_owner_events,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_keyboard_grab	 (GdkWindow *	  window,
			-- 			  gint		  owner_events,
			-- 			  guint32	  time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyboard_ungrab (a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_keyboard_ungrab (
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_keyboard_ungrab (guint32	  time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pointer_is_grabbed: INTEGER is 
			-- Parsed as:
			-- gint gdk_pointer_is_grabbed (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_pointer_is_grabbed (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_screen_width: INTEGER is 
			-- Parsed as:
			-- gint gdk_screen_width (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_screen_width  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_screen_height: INTEGER is 
			-- Parsed as:
			-- gint gdk_screen_height (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_screen_height (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_screen_width_mm: INTEGER is 
			-- Parsed as:
			-- gint gdk_screen_width_mm (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_screen_width_mm  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_screen_height_mm: INTEGER is 
			-- Parsed as:
			-- gint gdk_screen_height_mm (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_screen_height_mm (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_flush is 
			-- Parsed as:
			-- void gdk_flush (
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_flush (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_beep is 
			-- Parsed as:
			-- void gdk_beep (
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_beep (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_key_repeat_disable is 
			-- Parsed as:
			-- void gdk_key_repeat_disable (
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_key_repeat_disable (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_key_repeat_restore is 
			-- Parsed as:
			-- void gdk_key_repeat_restore (
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_key_repeat_restore (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_best_depth: INTEGER is 
			-- Parsed as:
			-- gint gdk_visual_get_best_depth (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	      gdk_visual_get_best_depth	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_best_type: INTEGER is 
			-- Parsed as:
			-- GdkVisualType gdk_visual_get_best_type (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisualType gdk_visual_get_best_type	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_system: POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_visual_get_system (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual*    gdk_visual_get_system	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_best: POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_visual_get_best (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual*    gdk_visual_get_best	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_best_with_depth (a_depth: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_visual_get_best_with_depth (
			--     gint a_depth
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual*    gdk_visual_get_best_with_depth (gint	     depth);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_best_with_type (a_visual_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_visual_get_best_with_type (
			--     GdkVisualType a_visual_type
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual*    gdk_visual_get_best_with_type  (GdkVisualType  visual_type);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_get_best_with_both (a_depth: INTEGER; a_visual_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_visual_get_best_with_both (
			--     gint a_depth,
			--     GdkVisualType a_visual_type
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual*    gdk_visual_get_best_with_both  (gint	     depth,
			-- 					      GdkVisualType  visual_type);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_ref (a_visual: POINTER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_visual_ref (
			--     GdkVisual *a_visual
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual* gdk_visual_ref (GdkVisual *visual);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_visual_unref (a_visual: POINTER) is 
			-- Parsed as:
			-- void gdk_visual_unref (
			--     GdkVisual *a_visual
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_visual_unref (GdkVisual *visual);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_query_depths (a_depths: POINTER; a_count: POINTER) is 
			-- Parsed as:
			-- void gdk_query_depths (
			--     gint **a_depths,
			--     gint *a_count
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_query_depths	    (gint	    **depths,
			-- 			     gint	     *count);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_query_visual_types (a_visual_types: POINTER; a_count: POINTER) is 
			-- Parsed as:
			-- void gdk_query_visual_types (
			--     GdkVisualType **a_visual_types,
			--     gint *a_count
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_query_visual_types (GdkVisualType  **visual_types,
			-- 			     gint	     *count);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_list_visuals: POINTER is 
			-- Parsed as:
			-- GList* gdk_list_visuals (
			-- );
			--
			-- Original C code from gdk.h:
			-- GList* gdk_list_visuals (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_new (a_parent: POINTER; a_attributes: POINTER; a_attributes_mask: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_window_new (
			--     GdkWindow *a_parent,
			--     GdkWindowAttr *a_attributes,
			--     gint a_attributes_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow*    gdk_window_new	     (GdkWindow	    *parent,
			-- 				      GdkWindowAttr *attributes,
			-- 				      gint	     attributes_mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_destroy (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_destroy (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_destroy     (GdkWindow	    *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_ref (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_window_ref (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow*    gdk_window_ref	     (GdkWindow	    *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_unref (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_unref (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_unref	     (GdkWindow	    *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_at_pointer (a_win_x: POINTER; a_win_y: POINTER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_window_at_pointer (
			--     gint *a_win_x,
			--     gint *a_win_y
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow*    gdk_window_at_pointer  (gint	   *win_x,
			-- 				      gint	   *win_y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_show (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_show (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_show	     (GdkWindow	   *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_hide (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_hide (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_hide	     (GdkWindow	   *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_withdraw (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_withdraw (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_withdraw    (GdkWindow	   *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_move (a_window: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_move (
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_move	     (GdkWindow	   *window,
			-- 				      gint	    x,
			-- 				      gint	    y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_resize (a_window: POINTER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_resize (
			--     GdkWindow *a_window,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_resize	     (GdkWindow	   *window,
			-- 				      gint	    width,
			-- 				      gint	    height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_move_resize (a_window: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_move_resize (
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_move_resize (GdkWindow	   *window,
			-- 				      gint	    x,
			-- 				      gint	    y,
			-- 				      gint	    width,
			-- 				      gint	    height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_reparent (a_window: POINTER; a_new_parent: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_reparent (
			--     GdkWindow *a_window,
			--     GdkWindow *a_new_parent,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_reparent    (GdkWindow	   *window,
			-- 				      GdkWindow	   *new_parent,
			-- 				      gint	    x,
			-- 				      gint	    y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_clear (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_clear (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_clear	     (GdkWindow	   *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_clear_area (a_window: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_clear_area (
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_clear_area  (GdkWindow	   *window,
			-- 				      gint	    x,
			-- 				      gint	    y,
			-- 				      gint	    width,
			-- 				      gint	    height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_clear_area_e (a_window: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_clear_area_e (
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_clear_area_e(GdkWindow	   *window,
			-- 				      gint	    x,
			-- 				      gint	    y,
			-- 				      gint	    width,
			-- 				      gint	    height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_copy_area (a_window: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_source_window: POINTER; a_source_x: INTEGER; a_source_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_copy_area (
			--     GdkWindow *a_window,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     GdkWindow *a_source_window,
			--     gint a_source_x,
			--     gint a_source_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_copy_area   (GdkWindow	   *window,
			-- 				      GdkGC	   *gc,
			-- 				      gint	    x,
			-- 				      gint	    y,
			-- 				      GdkWindow	   *source_window,
			-- 				      gint	    source_x,
			-- 				      gint	    source_y,
			-- 				      gint	    width,
			-- 				      gint	    height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_raise (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_raise (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_raise	     (GdkWindow	   *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_lower (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_lower (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_lower	     (GdkWindow	   *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_user_data (a_window: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_user_data (
			--     GdkWindow *a_window,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_user_data	 (GdkWindow	  *window,
			-- 					  gpointer	   user_data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_override_redirect (a_window: POINTER; a_override_redirect: BOOLEAN) is 
			-- Parsed as:
			-- void gdk_window_set_override_redirect (
			--     GdkWindow *a_window,
			--     gboolean a_override_redirect
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_override_redirect(GdkWindow  *window,
			-- 					       gboolean override_redirect);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_add_filter (a_window: POINTER; a_function: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gdk_window_add_filter (
			--     GdkWindow *a_window,
			--     GdkFilterFunc a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_add_filter	(GdkWindow     *window,
			-- 					 GdkFilterFunc	function,
			-- 					 gpointer	data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_remove_filter (a_window: POINTER; a_function: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gdk_window_remove_filter (
			--     GdkWindow *a_window,
			--     GdkFilterFunc a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_remove_filter	(GdkWindow     *window,
			-- 					 GdkFilterFunc	function,
			-- 					 gpointer	data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_shape_combine_mask (a_window: POINTER; a_shape_mask: POINTER; a_offset_x: INTEGER; a_offset_y: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_shape_combine_mask (
			--     GdkWindow *a_window,
			--     GdkBitmap *a_shape_mask,
			--     gint a_offset_x,
			--     gint a_offset_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_window_shape_combine_mask (GdkWindow	    *window,
			-- 				    GdkBitmap	    *shape_mask,
			-- 				    gint	     offset_x,
			-- 				    gint	     offset_y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_child_shapes (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_child_shapes (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_window_set_child_shapes (GdkWindow *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_merge_child_shapes (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_merge_child_shapes (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_window_merge_child_shapes (GdkWindow *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_is_visible (a_window: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_window_is_visible (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_window_is_visible     (GdkWindow *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_is_viewable (a_window: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_window_is_viewable (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_window_is_viewable    (GdkWindow *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_static_gravities (a_window: POINTER; a_use_static: BOOLEAN): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_window_set_static_gravities (
			--     GdkWindow *a_window,
			--     gboolean a_use_static
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_window_set_static_gravities (GdkWindow *window,
			-- 					  gboolean   use_static);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_add_client_message_filter (a_message_type: INTEGER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gdk_add_client_message_filter (
			--     GdkAtom a_message_type,
			--     GdkFilterFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_add_client_message_filter (GdkAtom       message_type,
			-- 				    GdkFilterFunc func,
			-- 				    gpointer      data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_context_new: POINTER is 
			-- Parsed as:
			-- GdkDragContext* gdk_drag_context_new (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkDragContext * gdk_drag_context_new        (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_context_ref (a_context: POINTER) is 
			-- Parsed as:
			-- void gdk_drag_context_ref (
			--     GdkDragContext *a_context
			-- );
			--
			-- Original C code from gdk.h:
			-- void             gdk_drag_context_ref        (GdkDragContext *context);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_context_unref (a_context: POINTER) is 
			-- Parsed as:
			-- void gdk_drag_context_unref (
			--     GdkDragContext *a_context
			-- );
			--
			-- Original C code from gdk.h:
			-- void             gdk_drag_context_unref      (GdkDragContext *context);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_status (a_context: POINTER; a_action: INTEGER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_drag_status (
			--     GdkDragContext *a_context,
			--     GdkDragAction a_action,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void             gdk_drag_status        (GdkDragContext   *context,
			-- 				         GdkDragAction     action,
			-- 					 guint32           time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drop_reply (a_context: POINTER; a_ok: BOOLEAN; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_drop_reply (
			--     GdkDragContext *a_context,
			--     gboolean a_ok,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void             gdk_drop_reply         (GdkDragContext   *context,
			-- 					 gboolean          ok,
			-- 					 guint32           time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drop_finish (a_context: POINTER; a_success: BOOLEAN; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_drop_finish (
			--     GdkDragContext *a_context,
			--     gboolean a_success,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void             gdk_drop_finish        (GdkDragContext   *context,
			-- 					 gboolean          success,
			-- 					 guint32           time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_get_selection (a_context: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkAtom gdk_drag_get_selection (
			--     GdkDragContext *a_context
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkAtom          gdk_drag_get_selection (GdkDragContext   *context);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_begin (a_window: POINTER; a_targets: POINTER): POINTER is 
			-- Parsed as:
			-- GdkDragContext* gdk_drag_begin (
			--     GdkWindow *a_window,
			--     GList *a_targets
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkDragContext * gdk_drag_begin      (GdkWindow      *window,
			-- 				      GList          *targets);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_get_protocol (a_xid: INTEGER; a_protocol: POINTER): INTEGER is 
			-- Parsed as:
			-- guint32 gdk_drag_get_protocol (
			--     guint32 a_xid,
			--     GdkDragProtocol *a_protocol
			-- );
			--
			-- Original C code from gdk.h:
			-- guint32         gdk_drag_get_protocol (guint32          xid,
			-- 				       GdkDragProtocol *protocol);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_find_window (a_context: POINTER; a_drag_window: POINTER; a_x_root: INTEGER; a_y_root: INTEGER; a_dest_window: POINTER; a_protocol: POINTER) is 
			-- Parsed as:
			-- void gdk_drag_find_window (
			--     GdkDragContext *a_context,
			--     GdkWindow *a_drag_window,
			--     gint a_x_root,
			--     gint a_y_root,
			--     GdkWindow **a_dest_window,
			--     GdkDragProtocol *a_protocol
			-- );
			--
			-- Original C code from gdk.h:
			-- void             gdk_drag_find_window (GdkDragContext   *context,
			-- 				       GdkWindow       *drag_window,
			-- 			 	       gint             x_root,
			-- 				       gint             y_root,
			-- 				       GdkWindow      **dest_window,
			-- 				       GdkDragProtocol *protocol);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_motion (a_context: POINTER; a_dest_window: POINTER; a_protocol: INTEGER; a_x_root: INTEGER; a_y_root: INTEGER; a_suggested_action: INTEGER; a_possible_actions: INTEGER; a_time: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_drag_motion (
			--     GdkDragContext *a_context,
			--     GdkWindow *a_dest_window,
			--     GdkDragProtocol a_protocol,
			--     gint a_x_root,
			--     gint a_y_root,
			--     GdkDragAction a_suggested_action,
			--     GdkDragAction a_possible_actions,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean        gdk_drag_motion      (GdkDragContext *context,
			-- 				      GdkWindow      *dest_window,
			-- 				      GdkDragProtocol protocol,
			-- 				      gint            x_root, 
			-- 				      gint            y_root,
			-- 				      GdkDragAction   suggested_action,
			-- 				      GdkDragAction   possible_actions,
			-- 				      guint32         time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_drop (a_context: POINTER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_drag_drop (
			--     GdkDragContext *a_context,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void            gdk_drag_drop        (GdkDragContext *context,
			-- 				      guint32         time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drag_abort (a_context: POINTER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_drag_abort (
			--     GdkDragContext *a_context,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void            gdk_drag_abort       (GdkDragContext *context,
			-- 				      guint32         time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_hints (a_window: POINTER; a_x: INTEGER; a_y: INTEGER; a_min_width: INTEGER; a_min_height: INTEGER; a_max_width: INTEGER; a_max_height: INTEGER; a_flags: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_set_hints (
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y,
			--     gint a_min_width,
			--     gint a_min_height,
			--     gint a_max_width,
			--     gint a_max_height,
			--     gint a_flags
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_hints	 (GdkWindow	  *window,
			-- 					  gint		   x,
			-- 					  gint		   y,
			-- 					  gint		   min_width,
			-- 					  gint		   min_height,
			-- 					  gint		   max_width,
			-- 					  gint		   max_height,
			-- 					  gint		   flags);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_geometry_hints (a_window: POINTER; a_geometry: POINTER; a_flags: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_set_geometry_hints (
			--     GdkWindow *a_window,
			--     GdkGeometry *a_geometry,
			--     GdkWindowHints a_flags
			-- );
			--
			-- Original C code from gdk.h:
			-- void          gdk_window_set_geometry_hints (GdkWindow        *window,
			-- 					     GdkGeometry      *geometry,
			-- 					     GdkWindowHints    flags);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_set_sm_client_id (a_sm_client_id: POINTER) is 
			-- Parsed as:
			-- void gdk_set_sm_client_id (
			--     gchar *a_sm_client_id
			-- );
			--
			-- Original C code from gdk.h:
			-- void          gdk_set_sm_client_id         (const gchar *sm_client_id);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_title (a_window: POINTER; a_title: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_title (
			--     GdkWindow *a_window,
			--     gchar *a_title
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_title	   (GdkWindow	  *window,
			-- 					    const gchar	  *title);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_role (a_window: POINTER; a_role: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_role (
			--     GdkWindow *a_window,
			--     gchar *a_role
			-- );
			--
			-- Original C code from gdk.h:
			-- void          gdk_window_set_role          (GdkWindow       *window,
			-- 					    const gchar     *role);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_transient_for (a_window: POINTER; a_leader: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_transient_for (
			--     GdkWindow *a_window,
			--     GdkWindow *a_leader
			-- );
			--
			-- Original C code from gdk.h:
			-- void          gdk_window_set_transient_for (GdkWindow       *window, 
			-- 					    GdkWindow       *leader);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_background (a_window: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_background (
			--     GdkWindow *a_window,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_background	 (GdkWindow	  *window,
			-- 					  GdkColor	  *color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_back_pixmap (a_window: POINTER; a_pixmap: POINTER; a_parent_relative: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_set_back_pixmap (
			--     GdkWindow *a_window,
			--     GdkPixmap *a_pixmap,
			--     gint a_parent_relative
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_back_pixmap (GdkWindow	  *window,
			-- 					  GdkPixmap	  *pixmap,
			-- 					  gint		   parent_relative);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_cursor (a_window: POINTER; a_cursor: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_cursor (
			--     GdkWindow *a_window,
			--     GdkCursor *a_cursor
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_cursor	 (GdkWindow	  *window,
			-- 					  GdkCursor	  *cursor);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_colormap (a_window: POINTER; a_colormap: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_colormap (
			--     GdkWindow *a_window,
			--     GdkColormap *a_colormap
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_colormap	 (GdkWindow	  *window,
			-- 					  GdkColormap	  *colormap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_user_data (a_window: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gdk_window_get_user_data (
			--     GdkWindow *a_window,
			--     gpointer *a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_get_user_data	 (GdkWindow	  *window,
			-- 					  gpointer	  *data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_geometry (a_window: POINTER; a_x: POINTER; a_y: POINTER; a_width: POINTER; a_height: POINTER; a_depth: POINTER) is 
			-- Parsed as:
			-- void gdk_window_get_geometry (
			--     GdkWindow *a_window,
			--     gint *a_x,
			--     gint *a_y,
			--     gint *a_width,
			--     gint *a_height,
			--     gint *a_depth
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_get_geometry	 (GdkWindow	  *window,
			-- 					  gint		  *x,
			-- 					  gint		  *y,
			-- 					  gint		  *width,
			-- 					  gint		  *height,
			-- 					  gint		  *depth);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_position (a_window: POINTER; a_x: POINTER; a_y: POINTER) is 
			-- Parsed as:
			-- void gdk_window_get_position (
			--     GdkWindow *a_window,
			--     gint *a_x,
			--     gint *a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_get_position	 (GdkWindow	  *window,
			-- 					  gint		  *x,
			-- 					  gint		  *y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_size (a_window: POINTER; a_width: POINTER; a_height: POINTER) is 
			-- Parsed as:
			-- void gdk_window_get_size (
			--     GdkWindow *a_window,
			--     gint *a_width,
			--     gint *a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_get_size	 (GdkWindow	  *window,
			-- 					  gint		  *width,
			-- 					  gint		  *height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_visual (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_window_get_visual (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual*    gdk_window_get_visual	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_colormap (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkColormap* gdk_window_get_colormap (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColormap*  gdk_window_get_colormap	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_type (a_window: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkWindowType gdk_window_get_type (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindowType gdk_window_get_type	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_origin (a_window: POINTER; a_x: POINTER; a_y: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_window_get_origin (
			--     GdkWindow *a_window,
			--     gint *a_x,
			--     gint *a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	      gdk_window_get_origin	 (GdkWindow	  *window,
			-- 					  gint		  *x,
			-- 					  gint		  *y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_deskrelative_origin (a_window: POINTER; a_x: POINTER; a_y: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_window_get_deskrelative_origin (
			--     GdkWindow *a_window,
			--     gint *a_x,
			--     gint *a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean      gdk_window_get_deskrelative_origin (GdkWindow	  *window,
			-- 					  gint		  *x,
			-- 					  gint		  *y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_root_origin (a_window: POINTER; a_x: POINTER; a_y: POINTER) is 
			-- Parsed as:
			-- void gdk_window_get_root_origin (
			--     GdkWindow *a_window,
			--     gint *a_x,
			--     gint *a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_get_root_origin (GdkWindow	  *window,
			-- 					  gint		  *x,
			-- 					  gint		  *y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_pointer (a_window: POINTER; a_x: POINTER; a_y: POINTER; a_mask: POINTER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_window_get_pointer (
			--     GdkWindow *a_window,
			--     gint *a_x,
			--     gint *a_y,
			--     GdkModifierType *a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow*    gdk_window_get_pointer	 (GdkWindow	  *window,
			-- 					  gint		  *x,
			-- 					  gint		  *y,
			-- 					  GdkModifierType *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_parent (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_window_get_parent (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow*    gdk_window_get_parent	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_toplevel (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_window_get_toplevel (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow*    gdk_window_get_toplevel	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_children (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GList* gdk_window_get_children (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GList*	      gdk_window_get_children	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_events (a_window: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkEventMask gdk_window_get_events (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkEventMask  gdk_window_get_events	 (GdkWindow	  *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_events (a_window: POINTER; a_event_mask: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_set_events (
			--     GdkWindow *a_window,
			--     GdkEventMask a_event_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_events	 (GdkWindow	  *window,
			-- 					  GdkEventMask	   event_mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_icon (a_window: POINTER; a_icon_window: POINTER; a_pixmap: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_icon (
			--     GdkWindow *a_window,
			--     GdkWindow *a_icon_window,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_icon	 (GdkWindow	  *window, 
			-- 					  GdkWindow	  *icon_window,
			-- 					  GdkPixmap	  *pixmap,
			-- 					  GdkBitmap	  *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_icon_name (a_window: POINTER; a_name: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_icon_name (
			--     GdkWindow *a_window,
			--     gchar *a_name
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_icon_name	 (GdkWindow	  *window, 
			-- 					  gchar		  *name);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_group (a_window: POINTER; a_leader: POINTER) is 
			-- Parsed as:
			-- void gdk_window_set_group (
			--     GdkWindow *a_window,
			--     GdkWindow *a_leader
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_group	 (GdkWindow	  *window, 
			-- 					  GdkWindow	  *leader);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_decorations (a_window: POINTER; a_decorations: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_set_decorations (
			--     GdkWindow *a_window,
			--     GdkWMDecoration a_decorations
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_decorations (GdkWindow	  *window,
			-- 					  GdkWMDecoration  decorations);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_set_functions (a_window: POINTER; a_functions: INTEGER) is 
			-- Parsed as:
			-- void gdk_window_set_functions (
			--     GdkWindow *a_window,
			--     GdkWMFunction a_functions
			-- );
			--
			-- Original C code from gdk.h:
			-- void	      gdk_window_set_functions	 (GdkWindow	  *window,
			-- 					  GdkWMFunction	   functions);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_get_toplevels: POINTER is 
			-- Parsed as:
			-- GList* gdk_window_get_toplevels (
			-- );
			--
			-- Original C code from gdk.h:
			-- GList *       gdk_window_get_toplevels   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_window_register_dnd (a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_window_register_dnd (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void          gdk_window_register_dnd    (GdkWindow       *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_drawable_set_data (a_drawable: POINTER; a_key: POINTER; a_data: POINTER; a_destroy_func: POINTER) is 
			-- Parsed as:
			-- void gdk_drawable_set_data (
			--     GdkDrawable *a_drawable,
			--     gchar *a_key,
			--     gpointer a_data,
			--     GDestroyNotify a_destroy_func
			-- );
			--
			-- Original C code from gdk.h:
			-- void          gdk_drawable_set_data      (GdkDrawable     *drawable,
			-- 					  const gchar     *key,
			-- 					  gpointer	   data,
			-- 					  GDestroyNotify   destroy_func);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_cursor_new (a_cursor_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkCursor* gdk_cursor_new (
			--     GdkCursorType a_cursor_type
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkCursor* gdk_cursor_new		 (GdkCursorType	  cursor_type);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_cursor_new_from_pixmap (a_source: POINTER; a_mask: POINTER; a_fg: POINTER; a_bg: POINTER; a_x: INTEGER; a_y: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkCursor* gdk_cursor_new_from_pixmap (
			--     GdkPixmap *a_source,
			--     GdkPixmap *a_mask,
			--     GdkColor *a_fg,
			--     GdkColor *a_bg,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkCursor* gdk_cursor_new_from_pixmap	 (GdkPixmap	  *source,
			-- 					  GdkPixmap	  *mask,
			-- 					  GdkColor	  *fg,
			-- 					  GdkColor	  *bg,
			-- 					  gint		   x,
			-- 					  gint		   y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_cursor_destroy (a_cursor: POINTER) is 
			-- Parsed as:
			-- void gdk_cursor_destroy (
			--     GdkCursor *a_cursor
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_cursor_destroy		 (GdkCursor	 *cursor);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_new (a_window: POINTER): POINTER is 
			-- Parsed as:
			-- GdkGC* gdk_gc_new (
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkGC* gdk_gc_new		  (GdkWindow	    *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_new_with_values (a_window: POINTER; a_values: POINTER; a_values_mask: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkGC* gdk_gc_new_with_values (
			--     GdkWindow *a_window,
			--     GdkGCValues *a_values,
			--     GdkGCValuesMask a_values_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkGC* gdk_gc_new_with_values	  (GdkWindow	    *window,
			-- 				   GdkGCValues	    *values,
			-- 				   GdkGCValuesMask   values_mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_ref (a_gc: POINTER): POINTER is 
			-- Parsed as:
			-- GdkGC* gdk_gc_ref (
			--     GdkGC *a_gc
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkGC* gdk_gc_ref		  (GdkGC	    *gc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_unref (a_gc: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_unref (
			--     GdkGC *a_gc
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_unref		  (GdkGC	    *gc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_destroy (a_gc: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_destroy (
			--     GdkGC *a_gc
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_destroy		  (GdkGC	    *gc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_get_values (a_gc: POINTER; a_values: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_get_values (
			--     GdkGC *a_gc,
			--     GdkGCValues *a_values
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_get_values	  (GdkGC	    *gc,
			-- 				   GdkGCValues	    *values);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_foreground (a_gc: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_foreground (
			--     GdkGC *a_gc,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_foreground	  (GdkGC	    *gc,
			-- 				   GdkColor	    *color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_background (a_gc: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_background (
			--     GdkGC *a_gc,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_background	  (GdkGC	    *gc,
			-- 				   GdkColor	    *color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_font (a_gc: POINTER; a_font: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_font (
			--     GdkGC *a_gc,
			--     GdkFont *a_font
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_font		  (GdkGC	    *gc,
			-- 				   GdkFont	    *font);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_function (a_gc: POINTER; a_function: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_function (
			--     GdkGC *a_gc,
			--     GdkFunction a_function
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_function	  (GdkGC	    *gc,
			-- 				   GdkFunction	     function);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_fill (a_gc: POINTER; a_fill: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_fill (
			--     GdkGC *a_gc,
			--     GdkFill a_fill
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_fill		  (GdkGC	    *gc,
			-- 				   GdkFill	     fill);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_tile (a_gc: POINTER; a_tile: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_tile (
			--     GdkGC *a_gc,
			--     GdkPixmap *a_tile
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_tile		  (GdkGC	    *gc,
			-- 				   GdkPixmap	    *tile);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_stipple (a_gc: POINTER; a_stipple: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_stipple (
			--     GdkGC *a_gc,
			--     GdkPixmap *a_stipple
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_stipple	  (GdkGC	    *gc,
			-- 				   GdkPixmap	    *stipple);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_ts_origin (a_gc: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_ts_origin (
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_ts_origin	  (GdkGC	    *gc,
			-- 				   gint		     x,
			-- 				   gint		     y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_clip_origin (a_gc: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_clip_origin (
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_clip_origin	  (GdkGC	    *gc,
			-- 				   gint		     x,
			-- 				   gint		     y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_clip_mask (a_gc: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_clip_mask (
			--     GdkGC *a_gc,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_clip_mask	  (GdkGC	    *gc,
			-- 				   GdkBitmap	    *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_clip_rectangle (a_gc: POINTER; a_rectangle: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_clip_rectangle (
			--     GdkGC *a_gc,
			--     GdkRectangle *a_rectangle
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_clip_rectangle  (GdkGC	    *gc,
			-- 				   GdkRectangle	    *rectangle);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_clip_region (a_gc: POINTER; a_region: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_set_clip_region (
			--     GdkGC *a_gc,
			--     GdkRegion *a_region
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_clip_region	  (GdkGC	    *gc,
			-- 				   GdkRegion	    *region);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_subwindow (a_gc: POINTER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_subwindow (
			--     GdkGC *a_gc,
			--     GdkSubwindowMode a_mode
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_subwindow	  (GdkGC	    *gc,
			-- 				   GdkSubwindowMode  mode);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_exposures (a_gc: POINTER; a_exposures: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_exposures (
			--     GdkGC *a_gc,
			--     gint a_exposures
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_exposures	  (GdkGC	    *gc,
			-- 				   gint		     exposures);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_line_attributes (a_gc: POINTER; a_line_width: INTEGER; a_line_style: INTEGER; a_cap_style: INTEGER; a_join_style: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_line_attributes (
			--     GdkGC *a_gc,
			--     gint a_line_width,
			--     GdkLineStyle a_line_style,
			--     GdkCapStyle a_cap_style,
			--     GdkJoinStyle a_join_style
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_line_attributes (GdkGC	    *gc,
			-- 				   gint		     line_width,
			-- 				   GdkLineStyle	     line_style,
			-- 				   GdkCapStyle	     cap_style,
			-- 				   GdkJoinStyle	     join_style);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_set_dashes (a_gc: POINTER; a_dash_offset: INTEGER; a_dash_list: POINTER; a_n: INTEGER) is 
			-- Parsed as:
			-- void gdk_gc_set_dashes (
			--     GdkGC *a_gc,
			--     gint a_dash_offset,
			--     gchar *a_dash_list,
			--     gint a_n
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_set_dashes          (GdkGC            *gc,
			-- 				   gint	             dash_offset,
			-- 				   gchar             dash_list[],
			-- 				   gint              n);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_gc_copy (a_dst_gc: POINTER; a_src_gc: POINTER) is 
			-- Parsed as:
			-- void gdk_gc_copy (
			--     GdkGC *a_dst_gc,
			--     GdkGC *a_src_gc
			-- );
			--
			-- Original C code from gdk.h:
			-- void   gdk_gc_copy		  (GdkGC	     *dst_gc,
			-- 				   GdkGC	     *src_gc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_new (a_window: POINTER; a_width: INTEGER; a_height: INTEGER; a_depth: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_new (
			--     GdkWindow *a_window,
			--     gint a_width,
			--     gint a_height,
			--     gint a_depth
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap* gdk_pixmap_new		(GdkWindow  *window,
			-- 					 gint	     width,
			-- 					 gint	     height,
			-- 					 gint	     depth);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_bitmap_create_from_data (a_window: POINTER; a_data: POINTER; a_width: INTEGER; a_height: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkBitmap* gdk_bitmap_create_from_data (
			--     GdkWindow *a_window,
			--     gchar *a_data,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkBitmap* gdk_bitmap_create_from_data	(GdkWindow   *window,
			-- 					 const gchar *data,
			-- 					 gint	      width,
			-- 					 gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_create_from_data (a_window: POINTER; a_data: POINTER; a_width: INTEGER; a_height: INTEGER; a_depth: INTEGER; a_fg: POINTER; a_bg: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_create_from_data (
			--     GdkWindow *a_window,
			--     gchar *a_data,
			--     gint a_width,
			--     gint a_height,
			--     gint a_depth,
			--     GdkColor *a_fg,
			--     GdkColor *a_bg
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap* gdk_pixmap_create_from_data	(GdkWindow   *window,
			-- 					 const gchar *data,
			-- 					 gint	      width,
			-- 					 gint	      height,
			-- 					 gint	      depth,
			-- 					 GdkColor    *fg,
			-- 					 GdkColor    *bg);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_create_from_xpm (a_window: POINTER; a_mask: POINTER; a_transparent_color: POINTER; a_filename: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_create_from_xpm (
			--     GdkWindow *a_window,
			--     GdkBitmap **a_mask,
			--     GdkColor *a_transparent_color,
			--     gchar *a_filename
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap* gdk_pixmap_create_from_xpm	(GdkWindow  *window,
			-- 					 GdkBitmap **mask,
			-- 					 GdkColor   *transparent_color,
			-- 					 const gchar *filename);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_colormap_create_from_xpm (a_window: POINTER; a_colormap: POINTER; a_mask: POINTER; a_transparent_color: POINTER; a_filename: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_colormap_create_from_xpm (
			--     GdkWindow *a_window,
			--     GdkColormap *a_colormap,
			--     GdkBitmap **a_mask,
			--     GdkColor *a_transparent_color,
			--     gchar *a_filename
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap* gdk_pixmap_colormap_create_from_xpm 
			--                                         (GdkWindow   *window,
			-- 					 GdkColormap *colormap,
			-- 					 GdkBitmap  **mask,
			-- 					 GdkColor    *transparent_color,
			-- 					 const gchar *filename);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_create_from_xpm_d (a_window: POINTER; a_mask: POINTER; a_transparent_color: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_create_from_xpm_d (
			--     GdkWindow *a_window,
			--     GdkBitmap **a_mask,
			--     GdkColor *a_transparent_color,
			--     gchar **a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap* gdk_pixmap_create_from_xpm_d (GdkWindow  *window,
			-- 					 GdkBitmap **mask,
			-- 					 GdkColor   *transparent_color,
			-- 					 gchar	   **data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_colormap_create_from_xpm_d (a_window: POINTER; a_colormap: POINTER; a_mask: POINTER; a_transparent_color: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_colormap_create_from_xpm_d (
			--     GdkWindow *a_window,
			--     GdkColormap *a_colormap,
			--     GdkBitmap **a_mask,
			--     GdkColor *a_transparent_color,
			--     gchar **a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap* gdk_pixmap_colormap_create_from_xpm_d 
			--                                         (GdkWindow   *window,
			-- 					 GdkColormap *colormap,
			-- 					 GdkBitmap  **mask,
			-- 					 GdkColor    *transparent_color,
			-- 					 gchar     **data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_ref (a_pixmap: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gdk_pixmap_ref (
			--     GdkPixmap *a_pixmap
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkPixmap *gdk_pixmap_ref		(GdkPixmap  *pixmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_pixmap_unref (a_pixmap: POINTER) is 
			-- Parsed as:
			-- void gdk_pixmap_unref (
			--     GdkPixmap *a_pixmap
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_pixmap_unref		(GdkPixmap  *pixmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_bitmap_ref (a_pixmap: POINTER): POINTER is 
			-- Parsed as:
			-- GdkBitmap* gdk_bitmap_ref (
			--     GdkBitmap *a_pixmap
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkBitmap *gdk_bitmap_ref		(GdkBitmap  *pixmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_bitmap_unref (a_pixmap: POINTER) is 
			-- Parsed as:
			-- void gdk_bitmap_unref (
			--     GdkBitmap *a_pixmap
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_bitmap_unref		(GdkBitmap  *pixmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_image_new_bitmap (a_visual: POINTER; a_data: POINTER; a_width: INTEGER; a_height: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkImage* gdk_image_new_bitmap (
			--     GdkVisual *a_visual,
			--     gpointer a_data,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkImage* gdk_image_new_bitmap(GdkVisual     *visual,
			-- 				gpointer      data,
			-- 				gint          width,
			-- 				gint          height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_image_new (a_type: INTEGER; a_visual: POINTER; a_width: INTEGER; a_height: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkImage* gdk_image_new (
			--     GdkImageType a_type,
			--     GdkVisual *a_visual,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkImage*  gdk_image_new       (GdkImageType  type,
			-- 				GdkVisual    *visual,
			-- 				gint	      width,
			-- 				gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_image_get (a_window: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkImage* gdk_image_get (
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkImage*  gdk_image_get       (GdkWindow    *window,
			-- 				gint	      x,
			-- 				gint	      y,
			-- 				gint	      width,
			-- 				gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_image_put_pixel (a_image: POINTER; a_x: INTEGER; a_y: INTEGER; a_pixel: INTEGER) is 
			-- Parsed as:
			-- void gdk_image_put_pixel (
			--     GdkImage *a_image,
			--     gint a_x,
			--     gint a_y,
			--     guint32 a_pixel
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_image_put_pixel (GdkImage     *image,
			-- 				gint	      x,
			-- 				gint	      y,
			-- 				guint32	      pixel);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_image_get_pixel (a_image: POINTER; a_x: INTEGER; a_y: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint32 gdk_image_get_pixel (
			--     GdkImage *a_image,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- guint32	   gdk_image_get_pixel (GdkImage     *image,
			-- 				gint	      x,
			-- 				gint	      y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_image_destroy (a_image: POINTER) is 
			-- Parsed as:
			-- void gdk_image_destroy (
			--     GdkImage *a_image
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_image_destroy   (GdkImage     *image);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_new (a_visual: POINTER; a_allocate: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkColormap* gdk_colormap_new (
			--     GdkVisual *a_visual,
			--     gint a_allocate
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColormap* gdk_colormap_new	  (GdkVisual   *visual,
			-- 				   gint		allocate);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_ref (a_cmap: POINTER): POINTER is 
			-- Parsed as:
			-- GdkColormap* gdk_colormap_ref (
			--     GdkColormap *a_cmap
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColormap* gdk_colormap_ref	  (GdkColormap *cmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_unref (a_cmap: POINTER) is 
			-- Parsed as:
			-- void gdk_colormap_unref (
			--     GdkColormap *a_cmap
			-- );
			--
			-- Original C code from gdk.h:
			-- void	     gdk_colormap_unref	  (GdkColormap *cmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_get_system: POINTER is 
			-- Parsed as:
			-- GdkColormap* gdk_colormap_get_system (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColormap* gdk_colormap_get_system	   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_get_system_size: INTEGER is 
			-- Parsed as:
			-- gint gdk_colormap_get_system_size (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	     gdk_colormap_get_system_size  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_change (a_colormap: POINTER; a_ncolors: INTEGER) is 
			-- Parsed as:
			-- void gdk_colormap_change (
			--     GdkColormap *a_colormap,
			--     gint a_ncolors
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_colormap_change (GdkColormap	*colormap,
			-- 			  gint		 ncolors);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_alloc_colors (a_colormap: POINTER; a_colors: POINTER; a_ncolors: INTEGER; a_writeable: BOOLEAN; a_best_match: BOOLEAN; a_success: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_colormap_alloc_colors (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_colors,
			--     gint a_ncolors,
			--     gboolean a_writeable,
			--     gboolean a_best_match,
			--     gboolean *a_success
			-- );
			--
			-- Original C code from gdk.h:
			-- gint  gdk_colormap_alloc_colors   (GdkColormap *colormap,
			-- 				   GdkColor    *colors,
			-- 				   gint         ncolors,
			-- 				   gboolean     writeable,
			-- 				   gboolean     best_match,
			-- 				   gboolean    *success);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_alloc_color (a_colormap: POINTER; a_color: POINTER; a_writeable: BOOLEAN; a_best_match: BOOLEAN): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_colormap_alloc_color (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_color,
			--     gboolean a_writeable,
			--     gboolean a_best_match
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_colormap_alloc_color (GdkColormap *colormap,
			-- 				   GdkColor    *color,
			-- 				   gboolean     writeable,
			-- 				   gboolean     best_match);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_free_colors (a_colormap: POINTER; a_colors: POINTER; a_ncolors: INTEGER) is 
			-- Parsed as:
			-- void gdk_colormap_free_colors (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_colors,
			--     gint a_ncolors
			-- );
			--
			-- Original C code from gdk.h:
			-- void     gdk_colormap_free_colors (GdkColormap *colormap,
			-- 				   GdkColor    *colors,
			-- 				   gint         ncolors);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colormap_get_visual (a_colormap: POINTER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_colormap_get_visual (
			--     GdkColormap *a_colormap
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkVisual *gdk_colormap_get_visual (GdkColormap *colormap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_copy (a_color: POINTER): POINTER is 
			-- Parsed as:
			-- GdkColor* gdk_color_copy (
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColor *gdk_color_copy (GdkColor *color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_free (a_color: POINTER) is 
			-- Parsed as:
			-- void gdk_color_free (
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- void      gdk_color_free (GdkColor *color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_parse (a_spec: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_parse (
			--     gchar *a_spec,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_color_parse	 (const gchar	*spec,
			-- 			  GdkColor	*color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_hash (a_colora: POINTER; a_colorb: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gdk_color_hash (
			--     GdkColor *a_colora,
			--     GdkColor *a_colorb
			-- );
			--
			-- Original C code from gdk.h:
			-- guint gdk_color_hash     (const GdkColor *colora,
			-- 			  const GdkColor *colorb);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_equal (a_colora: POINTER; a_colorb: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_equal (
			--     GdkColor *a_colora,
			--     GdkColor *a_colorb
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_color_equal	 (const GdkColor *colora,
			-- 			  const GdkColor *colorb);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colors_store (a_colormap: POINTER; a_colors: POINTER; a_ncolors: INTEGER) is 
			-- Parsed as:
			-- void gdk_colors_store (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_colors,
			--     gint a_ncolors
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_colors_store	 (GdkColormap	*colormap,
			-- 			  GdkColor	*colors,
			-- 			  gint		 ncolors);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colors_alloc (a_colormap: POINTER; a_contiguous: INTEGER; a_planes: POINTER; a_nplanes: INTEGER; a_pixels: POINTER; a_npixels: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_colors_alloc (
			--     GdkColormap *a_colormap,
			--     gint a_contiguous,
			--     gulong *a_planes,
			--     gint a_nplanes,
			--     gulong *a_pixels,
			--     gint a_npixels
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_colors_alloc	 (GdkColormap	*colormap,
			-- 			  gint		 contiguous,
			-- 			  gulong	*planes,
			-- 			  gint		 nplanes,
			-- 			  gulong	*pixels,
			-- 			  gint		 npixels);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_colors_free (a_colormap: POINTER; a_pixels: POINTER; a_npixels: INTEGER; a_planes: INTEGER) is 
			-- Parsed as:
			-- void gdk_colors_free (
			--     GdkColormap *a_colormap,
			--     gulong *a_pixels,
			--     gint a_npixels,
			--     gulong a_planes
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_colors_free	 (GdkColormap	*colormap,
			-- 			  gulong	*pixels,
			-- 			  gint		 npixels,
			-- 			  gulong	 planes);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_white (a_colormap: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_white (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_color_white	 (GdkColormap	*colormap,
			-- 			  GdkColor	*color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_black (a_colormap: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_black (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_color_black	 (GdkColormap	*colormap,
			-- 			  GdkColor	*color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_alloc (a_colormap: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_alloc (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_color_alloc	 (GdkColormap	*colormap,
			-- 			  GdkColor	*color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_change (a_colormap: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_change (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_color_change	 (GdkColormap	*colormap,
			-- 			  GdkColor	*color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_font_load (a_font_name: POINTER): POINTER is 
			-- Parsed as:
			-- GdkFont* gdk_font_load (
			--     gchar *a_font_name
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkFont* gdk_font_load	    (const gchar    *font_name);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_fontset_load (a_fontset_name: POINTER): POINTER is 
			-- Parsed as:
			-- GdkFont* gdk_fontset_load (
			--     gchar *a_fontset_name
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkFont* gdk_fontset_load   (gchar          *fontset_name);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_font_ref (a_font: POINTER): POINTER is 
			-- Parsed as:
			-- GdkFont* gdk_font_ref (
			--     GdkFont *a_font
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkFont* gdk_font_ref	    (GdkFont        *font);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_font_unref (a_font: POINTER) is 
			-- Parsed as:
			-- void gdk_font_unref (
			--     GdkFont *a_font
			-- );
			--
			-- Original C code from gdk.h:
			-- void	 gdk_font_unref	    (GdkFont        *font);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_font_id (a_font: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_font_id (
			--     GdkFont *a_font
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_font_id	    (const GdkFont  *font);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_font_equal (a_fonta: POINTER; a_fontb: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_font_equal (
			--     GdkFont *a_fonta,
			--     GdkFont *a_fontb
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_font_equal	    (const GdkFont  *fonta,
			-- 			     const GdkFont  *fontb);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_string_width (a_font: POINTER; a_string: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_string_width (
			--     GdkFont *a_font,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_string_width   (GdkFont        *font,
			-- 			     const gchar    *string);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_width (a_font: POINTER; a_text: POINTER; a_text_length: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_text_width (
			--     GdkFont *a_font,
			--     gchar *a_text,
			--     gint a_text_length
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_text_width	    (GdkFont        *font,
			-- 			     const gchar    *text,
			-- 			     gint            text_length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_width_wc (a_font: POINTER; a_text: POINTER; a_text_length: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_text_width_wc (
			--     GdkFont *a_font,
			--     GdkWChar *a_text,
			--     gint a_text_length
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_text_width_wc  (GdkFont        *font,
			-- 			     const GdkWChar *text,
			-- 			     gint            text_length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_char_width (a_font: POINTER; a_character: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_char_width (
			--     GdkFont *a_font,
			--     gchar a_character
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_char_width	    (GdkFont        *font,
			-- 			     gchar           character);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_char_width_wc (a_font: POINTER; a_character: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_char_width_wc (
			--     GdkFont *a_font,
			--     GdkWChar a_character
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_char_width_wc  (GdkFont        *font,
			-- 			     GdkWChar        character);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_string_measure (a_font: POINTER; a_string: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_string_measure (
			--     GdkFont *a_font,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_string_measure (GdkFont        *font,
			-- 			     const gchar    *string);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_measure (a_font: POINTER; a_text: POINTER; a_text_length: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_text_measure (
			--     GdkFont *a_font,
			--     gchar *a_text,
			--     gint a_text_length
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_text_measure   (GdkFont        *font,
			-- 			     const gchar    *text,
			-- 			     gint            text_length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_char_measure (a_font: POINTER; a_character: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_char_measure (
			--     GdkFont *a_font,
			--     gchar a_character
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_char_measure   (GdkFont        *font,
			-- 			     gchar           character);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_string_height (a_font: POINTER; a_string: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_string_height (
			--     GdkFont *a_font,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_string_height  (GdkFont        *font,
			-- 			     const gchar    *string);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_height (a_font: POINTER; a_text: POINTER; a_text_length: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_text_height (
			--     GdkFont *a_font,
			--     gchar *a_text,
			--     gint a_text_length
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_text_height    (GdkFont        *font,
			-- 			     const gchar    *text,
			-- 			     gint            text_length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_char_height (a_font: POINTER; a_character: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_char_height (
			--     GdkFont *a_font,
			--     gchar a_character
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	 gdk_char_height    (GdkFont        *font,
			-- 			     gchar           character);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_extents (a_font: POINTER; a_text: POINTER; a_text_length: INTEGER; a_lbearing: POINTER; a_rbearing: POINTER; a_width: POINTER; a_ascent: POINTER; a_descent: POINTER) is 
			-- Parsed as:
			-- void gdk_text_extents (
			--     GdkFont *a_font,
			--     gchar *a_text,
			--     gint a_text_length,
			--     gint *a_lbearing,
			--     gint *a_rbearing,
			--     gint *a_width,
			--     gint *a_ascent,
			--     gint *a_descent
			-- );
			--
			-- Original C code from gdk.h:
			-- void     gdk_text_extents   (GdkFont     *font,
			-- 			     const gchar *text,
			-- 			     gint         text_length,
			-- 			     gint        *lbearing,
			-- 			     gint        *rbearing,
			-- 			     gint        *width,
			-- 			     gint        *ascent,
			-- 			     gint        *descent);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_extents_wc (a_font: POINTER; a_text: POINTER; a_text_length: INTEGER; a_lbearing: POINTER; a_rbearing: POINTER; a_width: POINTER; a_ascent: POINTER; a_descent: POINTER) is 
			-- Parsed as:
			-- void gdk_text_extents_wc (
			--     GdkFont *a_font,
			--     GdkWChar *a_text,
			--     gint a_text_length,
			--     gint *a_lbearing,
			--     gint *a_rbearing,
			--     gint *a_width,
			--     gint *a_ascent,
			--     gint *a_descent
			-- );
			--
			-- Original C code from gdk.h:
			-- void    gdk_text_extents_wc (GdkFont        *font,
			-- 			     const GdkWChar *text,
			-- 			     gint            text_length,
			-- 			     gint           *lbearing,
			-- 			     gint           *rbearing,
			-- 			     gint           *width,
			-- 			     gint           *ascent,
			-- 			     gint           *descent);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_string_extents (a_font: POINTER; a_string: POINTER; a_lbearing: POINTER; a_rbearing: POINTER; a_width: POINTER; a_ascent: POINTER; a_descent: POINTER) is 
			-- Parsed as:
			-- void gdk_string_extents (
			--     GdkFont *a_font,
			--     gchar *a_string,
			--     gint *a_lbearing,
			--     gint *a_rbearing,
			--     gint *a_width,
			--     gint *a_ascent,
			--     gint *a_descent
			-- );
			--
			-- Original C code from gdk.h:
			-- void     gdk_string_extents (GdkFont     *font,
			-- 			     const gchar *string,
			-- 			     gint        *lbearing,
			-- 			     gint        *rbearing,
			-- 			     gint        *width,
			-- 			     gint        *ascent,
			-- 			     gint        *descent);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_point (a_drawable: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_point (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_point	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  gint		x,
			-- 			  gint		y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_line (a_drawable: POINTER; a_gc: POINTER; a_x1: INTEGER; a_y1: INTEGER; a_x2: INTEGER; a_y2: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_line (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x1,
			--     gint a_y1,
			--     gint a_x2,
			--     gint a_y2
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_line	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  gint		x1,
			-- 			  gint		y1,
			-- 			  gint		x2,
			-- 			  gint		y2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_rectangle (a_drawable: POINTER; a_gc: POINTER; a_filled: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_rectangle (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_filled,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_rectangle	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  gint		filled,
			-- 			  gint		x,
			-- 			  gint		y,
			-- 			  gint		width,
			-- 			  gint		height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_arc (a_drawable: POINTER; a_gc: POINTER; a_filled: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_angle1: INTEGER; a_angle2: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_arc (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_filled,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     gint a_angle1,
			--     gint a_angle2
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_arc	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  gint		filled,
			-- 			  gint		x,
			-- 			  gint		y,
			-- 			  gint		width,
			-- 			  gint		height,
			-- 			  gint		angle1,
			-- 			  gint		angle2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_polygon (a_drawable: POINTER; a_gc: POINTER; a_filled: INTEGER; a_points: POINTER; a_npoints: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_polygon (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_filled,
			--     GdkPoint *a_points,
			--     gint a_npoints
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_polygon	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  gint		filled,
			-- 			  GdkPoint     *points,
			-- 			  gint		npoints);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_string (a_drawable: POINTER; a_font: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_string: POINTER) is 
			-- Parsed as:
			-- void gdk_draw_string (
			--     GdkDrawable *a_drawable,
			--     GdkFont *a_font,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_string	 (GdkDrawable  *drawable,
			-- 			  GdkFont      *font,
			-- 			  GdkGC	       *gc,
			-- 			  gint		x,
			-- 			  gint		y,
			-- 			  const gchar  *string);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_text (a_drawable: POINTER; a_font: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_text: POINTER; a_text_length: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_text (
			--     GdkDrawable *a_drawable,
			--     GdkFont *a_font,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gchar *a_text,
			--     gint a_text_length
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_text	 (GdkDrawable  *drawable,
			-- 			  GdkFont      *font,
			-- 			  GdkGC	       *gc,
			-- 			  gint		x,
			-- 			  gint		y,
			-- 			  const gchar  *text,
			-- 			  gint		text_length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_text_wc (a_drawable: POINTER; a_font: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_text: POINTER; a_text_length: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_text_wc (
			--     GdkDrawable *a_drawable,
			--     GdkFont *a_font,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     GdkWChar *a_text,
			--     gint a_text_length
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_text_wc	 (GdkDrawable	 *drawable,
			-- 			  GdkFont	 *font,
			-- 			  GdkGC		 *gc,
			-- 			  gint		  x,
			-- 			  gint		  y,
			-- 			  const GdkWChar *text,
			-- 			  gint		  text_length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_pixmap (a_drawable: POINTER; a_gc: POINTER; a_src: POINTER; a_xsrc: INTEGER; a_ysrc: INTEGER; a_xdest: INTEGER; a_ydest: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_pixmap (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     GdkDrawable *a_src,
			--     gint a_xsrc,
			--     gint a_ysrc,
			--     gint a_xdest,
			--     gint a_ydest,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_pixmap	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  GdkDrawable  *src,
			-- 			  gint		xsrc,
			-- 			  gint		ysrc,
			-- 			  gint		xdest,
			-- 			  gint		ydest,
			-- 			  gint		width,
			-- 			  gint		height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_bitmap (a_drawable: POINTER; a_gc: POINTER; a_src: POINTER; a_xsrc: INTEGER; a_ysrc: INTEGER; a_xdest: INTEGER; a_ydest: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_bitmap (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     GdkDrawable *a_src,
			--     gint a_xsrc,
			--     gint a_ysrc,
			--     gint a_xdest,
			--     gint a_ydest,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_bitmap	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  GdkDrawable  *src,
			-- 			  gint		xsrc,
			-- 			  gint		ysrc,
			-- 			  gint		xdest,
			-- 			  gint		ydest,
			-- 			  gint		width,
			-- 			  gint		height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_image (a_drawable: POINTER; a_gc: POINTER; a_image: POINTER; a_xsrc: INTEGER; a_ysrc: INTEGER; a_xdest: INTEGER; a_ydest: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_image (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     GdkImage *a_image,
			--     gint a_xsrc,
			--     gint a_ysrc,
			--     gint a_xdest,
			--     gint a_ydest,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_image	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  GdkImage     *image,
			-- 			  gint		xsrc,
			-- 			  gint		ysrc,
			-- 			  gint		xdest,
			-- 			  gint		ydest,
			-- 			  gint		width,
			-- 			  gint		height);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_points (a_drawable: POINTER; a_gc: POINTER; a_points: POINTER; a_npoints: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_points (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     GdkPoint *a_points,
			--     gint a_npoints
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_points	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  GdkPoint     *points,
			-- 			  gint		npoints);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_segments (a_drawable: POINTER; a_gc: POINTER; a_segs: POINTER; a_nsegs: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_segments (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     GdkSegment *a_segs,
			--     gint a_nsegs
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_segments	 (GdkDrawable  *drawable,
			-- 			  GdkGC	       *gc,
			-- 			  GdkSegment   *segs,
			-- 			  gint		nsegs);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_lines (a_drawable: POINTER; a_gc: POINTER; a_points: POINTER; a_npoints: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_lines (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     GdkPoint *a_points,
			--     gint a_npoints
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_draw_lines      (GdkDrawable  *drawable,
			--                           GdkGC        *gc,
			--                           GdkPoint     *points,
			--                           gint          npoints);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_selection_owner_set (a_owner: POINTER; a_selection: INTEGER; a_time: INTEGER; a_send_event: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_selection_owner_set (
			--     GdkWindow *a_owner,
			--     GdkAtom a_selection,
			--     guint32 a_time,
			--     gint a_send_event
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	   gdk_selection_owner_set (GdkWindow	 *owner,
			-- 				    GdkAtom	  selection,
			-- 				    guint32	  time,
			-- 				    gint	  send_event);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_selection_owner_get (a_selection: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gdk_selection_owner_get (
			--     GdkAtom a_selection
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkWindow* gdk_selection_owner_get (GdkAtom	  selection);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_selection_convert (a_requestor: POINTER; a_selection: INTEGER; a_target: INTEGER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_selection_convert (
			--     GdkWindow *a_requestor,
			--     GdkAtom a_selection,
			--     GdkAtom a_target,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_selection_convert   (GdkWindow	 *requestor,
			-- 				    GdkAtom	  selection,
			-- 				    GdkAtom	  target,
			-- 				    guint32	  time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_selection_property_get (a_requestor: POINTER; a_data: POINTER; a_prop_type: POINTER; a_prop_format: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_selection_property_get (
			--     GdkWindow *a_requestor,
			--     guchar **a_data,
			--     GdkAtom *a_prop_type,
			--     gint *a_prop_format
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	   gdk_selection_property_get (GdkWindow  *requestor,
			-- 				       guchar	 **data,
			-- 				       GdkAtom	  *prop_type,
			-- 				       gint	  *prop_format);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_selection_send_notify (a_requestor: INTEGER; a_selection: INTEGER; a_target: INTEGER; a_property: INTEGER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gdk_selection_send_notify (
			--     guint32 a_requestor,
			--     GdkAtom a_selection,
			--     GdkAtom a_target,
			--     GdkAtom a_property,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_selection_send_notify (guint32	    requestor,
			-- 				      GdkAtom	    selection,
			-- 				      GdkAtom	    target,
			-- 				      GdkAtom	    property,
			-- 				      guint32	    time);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_text_property_to_text_list (a_encoding: INTEGER; a_format: INTEGER; a_text: POINTER; a_length: INTEGER; a_list: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_text_property_to_text_list (
			--     GdkAtom a_encoding,
			--     gint a_format,
			--     guchar *a_text,
			--     gint a_length,
			--     gchar ***a_list
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	   gdk_text_property_to_text_list (GdkAtom encoding, gint format,
			-- 					   guchar *text, gint length,
			-- 					   gchar ***list);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_free_text_list (a_list: POINTER) is 
			-- Parsed as:
			-- void gdk_free_text_list (
			--     gchar **a_list
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_free_text_list		  (gchar **list);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_string_to_compound_text (a_str: POINTER; a_encoding: POINTER; a_format: POINTER; a_ctext: POINTER; a_length: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_string_to_compound_text (
			--     gchar *a_str,
			--     GdkAtom *a_encoding,
			--     gint *a_format,
			--     guchar **a_ctext,
			--     gint *a_length
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	   gdk_string_to_compound_text	  (gchar *str,
			-- 					   GdkAtom *encoding, gint *format,
			-- 					   guchar **ctext, gint *length);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_free_compound_text (a_ctext: POINTER) is 
			-- Parsed as:
			-- void gdk_free_compound_text (
			--     guchar *a_ctext
			-- );
			--
			-- Original C code from gdk.h:
			-- void	   gdk_free_compound_text	  (guchar *ctext);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_atom_intern (a_atom_name: POINTER; a_only_if_exists: INTEGER): INTEGER is 
			-- Parsed as:
			-- GdkAtom gdk_atom_intern (
			--     gchar *a_atom_name,
			--     gint a_only_if_exists
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkAtom gdk_atom_intern	    (const gchar *atom_name,
			-- 			     gint	  only_if_exists);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_atom_name (a_atom: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gdk_atom_name (
			--     GdkAtom a_atom
			-- );
			--
			-- Original C code from gdk.h:
			-- gchar*	gdk_atom_name	    (GdkAtom atom);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_property_get (a_window: POINTER; a_property: INTEGER; a_type: INTEGER; a_offset: INTEGER; a_length: INTEGER; a_pdelete: INTEGER; a_actual_property_type: POINTER; a_actual_format: POINTER; a_actual_length: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_property_get (
			--     GdkWindow *a_window,
			--     GdkAtom a_property,
			--     GdkAtom a_type,
			--     gulong a_offset,
			--     gulong a_length,
			--     gint a_pdelete,
			--     GdkAtom *a_actual_property_type,
			--     gint *a_actual_format,
			--     gint *a_actual_length,
			--     guchar **a_data
			-- );
			--
			-- Original C code from gdk.h:
			-- gint	gdk_property_get    (GdkWindow	 *window,
			-- 			     GdkAtom	  property,
			-- 			     GdkAtom	  type,
			-- 			     gulong	  offset,
			-- 			     gulong	  length,
			-- 			     gint	  pdelete,
			-- 			     GdkAtom	 *actual_property_type,
			-- 			     gint	 *actual_format,
			-- 			     gint	 *actual_length,
			-- 			     guchar	**data);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_property_change (a_window: POINTER; a_property: INTEGER; a_type: INTEGER; a_format: INTEGER; a_mode: INTEGER; a_data: POINTER; a_nelements: INTEGER) is 
			-- Parsed as:
			-- void gdk_property_change (
			--     GdkWindow *a_window,
			--     GdkAtom a_property,
			--     GdkAtom a_type,
			--     gint a_format,
			--     GdkPropMode a_mode,
			--     guchar *a_data,
			--     gint a_nelements
			-- );
			--
			-- Original C code from gdk.h:
			-- void	gdk_property_change (GdkWindow	 *window,
			-- 			     GdkAtom	  property,
			-- 			     GdkAtom	  type,
			-- 			     gint	  format,
			-- 			     GdkPropMode  mode,
			-- 			     guchar	 *data,
			-- 			     gint	  nelements);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_property_delete (a_window: POINTER; a_property: INTEGER) is 
			-- Parsed as:
			-- void gdk_property_delete (
			--     GdkWindow *a_window,
			--     GdkAtom a_property
			-- );
			--
			-- Original C code from gdk.h:
			-- void	gdk_property_delete (GdkWindow	 *window,
			-- 			     GdkAtom	  property);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rectangle_intersect (a_src1: POINTER; a_src2: POINTER; a_dest: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_rectangle_intersect (
			--     GdkRectangle *a_src1,
			--     GdkRectangle *a_src2,
			--     GdkRectangle *a_dest
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_rectangle_intersect (GdkRectangle *src1,
			-- 			      GdkRectangle *src2,
			-- 			      GdkRectangle *dest);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rectangle_union (a_src1: POINTER; a_src2: POINTER; a_dest: POINTER) is 
			-- Parsed as:
			-- void gdk_rectangle_union (
			--     GdkRectangle *a_src1,
			--     GdkRectangle *a_src2,
			--     GdkRectangle *a_dest
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_rectangle_union     (GdkRectangle *src1,
			-- 			      GdkRectangle *src2,
			-- 			      GdkRectangle *dest);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_init is 
			-- Parsed as:
			-- void gdk_input_init (
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_init			    (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_exit is 
			-- Parsed as:
			-- void gdk_input_exit (
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_exit			    (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_list_devices: POINTER is 
			-- Parsed as:
			-- GList* gdk_input_list_devices (
			-- );
			--
			-- Original C code from gdk.h:
			-- GList *gdk_input_list_devices		    (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_set_extension_events (a_window: POINTER; a_mask: INTEGER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gdk_input_set_extension_events (
			--     GdkWindow *a_window,
			--     gint a_mask,
			--     GdkExtensionMode a_mode
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_set_extension_events	    (GdkWindow *window,
			-- 					     gint mask,
			-- 					     GdkExtensionMode mode);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_set_source (a_deviceid: INTEGER; a_source: INTEGER) is 
			-- Parsed as:
			-- void gdk_input_set_source (
			--     guint32 a_deviceid,
			--     GdkInputSource a_source
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_set_source		    (guint32 deviceid,
			-- 					     GdkInputSource source);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_set_mode (a_deviceid: INTEGER; a_mode: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_input_set_mode (
			--     guint32 a_deviceid,
			--     GdkInputMode a_mode
			-- );
			--
			-- Original C code from gdk.h:
			-- gint gdk_input_set_mode			    (guint32 deviceid,
			-- 					     GdkInputMode mode);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_set_axes (a_deviceid: INTEGER; a_axes: POINTER) is 
			-- Parsed as:
			-- void gdk_input_set_axes (
			--     guint32 a_deviceid,
			--     GdkAxisUse *a_axes
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_set_axes			    (guint32 deviceid,
			-- 					     GdkAxisUse *axes);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_set_key (a_deviceid: INTEGER; a_index: INTEGER; a_keyval: INTEGER; a_modifiers: INTEGER) is 
			-- Parsed as:
			-- void gdk_input_set_key (
			--     guint32 a_deviceid,
			--     guint a_index,
			--     guint a_keyval,
			--     GdkModifierType a_modifiers
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_set_key			    (guint32 deviceid,
			-- 					     guint   index,
			-- 					     guint   keyval,
			-- 					     GdkModifierType modifiers);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_window_get_pointer (a_window: POINTER; a_deviceid: INTEGER; a_x: POINTER; a_y: POINTER; a_pressure: POINTER; a_xtilt: POINTER; a_ytilt: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gdk_input_window_get_pointer (
			--     GdkWindow *a_window,
			--     guint32 a_deviceid,
			--     gdouble *a_x,
			--     gdouble *a_y,
			--     gdouble *a_pressure,
			--     gdouble *a_xtilt,
			--     gdouble *a_ytilt,
			--     GdkModifierType *a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- void gdk_input_window_get_pointer     (GdkWindow       *window,
			-- 				       guint32	       deviceid,
			-- 				       gdouble	       *x,
			-- 				       gdouble	       *y,
			-- 				       gdouble	       *pressure,
			-- 				       gdouble	       *xtilt,
			-- 				       gdouble	       *ytilt,
			-- 				       GdkModifierType *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_input_motion_events (a_window: POINTER; a_deviceid: INTEGER; a_start: INTEGER; a_stop: INTEGER; a_nevents_return: POINTER): POINTER is 
			-- Parsed as:
			-- GdkTimeCoord* gdk_input_motion_events (
			--     GdkWindow *a_window,
			--     guint32 a_deviceid,
			--     guint32 a_start,
			--     guint32 a_stop,
			--     gint *a_nevents_return
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkTimeCoord *gdk_input_motion_events (GdkWindow *window,
			-- 				       guint32 deviceid,
			-- 				       guint32 start,
			-- 				       guint32 stop,
			-- 				       gint *nevents_return);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_im_ready: INTEGER is 
			-- Parsed as:
			-- gint gdk_im_ready (
			-- );
			--
			-- Original C code from gdk.h:
			-- gint         gdk_im_ready	   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_im_begin (a_ic: POINTER; a_window: POINTER) is 
			-- Parsed as:
			-- void gdk_im_begin (
			--     GdkIC *a_ic,
			--     GdkWindow *a_window
			-- );
			--
			-- Original C code from gdk.h:
			-- void         gdk_im_begin	   (GdkIC               *ic, 
			-- 				    GdkWindow           *window);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_im_end is 
			-- Parsed as:
			-- void gdk_im_end (
			-- );
			--
			-- Original C code from gdk.h:
			-- void         gdk_im_end		   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_im_decide_style (a_supported_style: INTEGER): INTEGER is 
			-- Parsed as:
			-- GdkIMStyle gdk_im_decide_style (
			--     GdkIMStyle a_supported_style
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkIMStyle   gdk_im_decide_style   (GdkIMStyle           supported_style);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_im_set_best_style (a_best_allowed_style: INTEGER): INTEGER is 
			-- Parsed as:
			-- GdkIMStyle gdk_im_set_best_style (
			--     GdkIMStyle a_best_allowed_style
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkIMStyle   gdk_im_set_best_style (GdkIMStyle           best_allowed_style);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_new (a_attr: POINTER; a_mask: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkIC* gdk_ic_new (
			--     GdkICAttr *a_attr,
			--     GdkICAttributesType a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkIC*       gdk_ic_new		   (GdkICAttr 		*attr,
			-- 				    GdkICAttributesType mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_destroy (a_ic: POINTER) is 
			-- Parsed as:
			-- void gdk_ic_destroy (
			--     GdkIC *a_ic
			-- );
			--
			-- Original C code from gdk.h:
			-- void         gdk_ic_destroy	   (GdkIC               *ic);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_get_style (a_ic: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkIMStyle gdk_ic_get_style (
			--     GdkIC *a_ic
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkIMStyle   gdk_ic_get_style	   (GdkIC               *ic);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_get_events (a_ic: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkEventMask gdk_ic_get_events (
			--     GdkIC *a_ic
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkEventMask gdk_ic_get_events     (GdkIC               *ic);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_attr_new: POINTER is 
			-- Parsed as:
			-- GdkICAttr* gdk_ic_attr_new (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkICAttr*   gdk_ic_attr_new       (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_attr_destroy (a_attr: POINTER) is 
			-- Parsed as:
			-- void gdk_ic_attr_destroy (
			--     GdkICAttr *a_attr
			-- );
			--
			-- Original C code from gdk.h:
			-- void         gdk_ic_attr_destroy   (GdkICAttr *attr);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_set_attr (a_ic: POINTER; a_attr: POINTER; a_mask: INTEGER): INTEGER is 
			-- Parsed as:
			-- GdkICAttributesType gdk_ic_set_attr (
			--     GdkIC *a_ic,
			--     GdkICAttr *a_attr,
			--     GdkICAttributesType a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkICAttributesType  gdk_ic_set_attr (GdkIC              *ic,  
			--                                       GdkICAttr          *attr,
			--                                       GdkICAttributesType mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_ic_get_attr (a_ic: POINTER; a_attr: POINTER; a_mask: INTEGER): INTEGER is 
			-- Parsed as:
			-- GdkICAttributesType gdk_ic_get_attr (
			--     GdkIC *a_ic,
			--     GdkICAttr *a_attr,
			--     GdkICAttributesType a_mask
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkICAttributesType  gdk_ic_get_attr (GdkIC              *ic, 
			--                                       GdkICAttr          *attr,
			--                                       GdkICAttributesType mask);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_wcstombs (a_src: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gdk_wcstombs (
			--     GdkWChar *a_src
			-- );
			--
			-- Original C code from gdk.h:
			-- gchar     *gdk_wcstombs          (const GdkWChar   *src);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_mbstowcs (a_dest: POINTER; a_src: POINTER; a_dest_max: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_mbstowcs (
			--     GdkWChar *a_dest,
			--     gchar *a_src,
			--     gint a_dest_max
			-- );
			--
			-- Original C code from gdk.h:
			-- gint       gdk_mbstowcs          (GdkWChar         *dest,
			-- 				  const gchar      *src,
			-- 				  gint              dest_max);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_new (a_visual: POINTER; a_colormap: POINTER): POINTER is 
			-- Parsed as:
			-- GdkColorContext* gdk_color_context_new (
			--     GdkVisual *a_visual,
			--     GdkColormap *a_colormap
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColorContext *gdk_color_context_new			  (GdkVisual   *visual,
			-- 							   GdkColormap *colormap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_new_mono (a_visual: POINTER; a_colormap: POINTER): POINTER is 
			-- Parsed as:
			-- GdkColorContext* gdk_color_context_new_mono (
			--     GdkVisual *a_visual,
			--     GdkColormap *a_colormap
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkColorContext *gdk_color_context_new_mono		  (GdkVisual   *visual,
			-- 							   GdkColormap *colormap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_free (a_cc: POINTER) is 
			-- Parsed as:
			-- void gdk_color_context_free (
			--     GdkColorContext *a_cc
			-- );
			--
			-- Original C code from gdk.h:
			-- void		 gdk_color_context_free			  (GdkColorContext *cc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_get_pixel (a_cc: POINTER; a_red: INTEGER; a_green: INTEGER; a_blue: INTEGER; a_failed: POINTER): INTEGER is 
			-- Parsed as:
			-- gulong gdk_color_context_get_pixel (
			--     GdkColorContext *a_cc,
			--     gushort a_red,
			--     gushort a_green,
			--     gushort a_blue,
			--     gint *a_failed
			-- );
			--
			-- Original C code from gdk.h:
			-- gulong		 gdk_color_context_get_pixel		  (GdkColorContext *cc,
			-- 							   gushort	    red,
			-- 							   gushort	    green,
			-- 							   gushort	    blue,
			-- 							   gint		   *failed);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_get_pixels (a_cc: POINTER; a_reds: POINTER; a_greens: POINTER; a_blues: POINTER; a_ncolors: INTEGER; a_colors: POINTER; a_nallocated: POINTER) is 
			-- Parsed as:
			-- void gdk_color_context_get_pixels (
			--     GdkColorContext *a_cc,
			--     gushort *a_reds,
			--     gushort *a_greens,
			--     gushort *a_blues,
			--     gint a_ncolors,
			--     gulong *a_colors,
			--     gint *a_nallocated
			-- );
			--
			-- Original C code from gdk.h:
			-- void		 gdk_color_context_get_pixels		  (GdkColorContext *cc,
			-- 							   gushort	   *reds,
			-- 							   gushort	   *greens,
			-- 							   gushort	   *blues,
			-- 							   gint		    ncolors,
			-- 							   gulong	   *colors,
			-- 							   gint		   *nallocated);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_get_pixels_incremental (a_cc: POINTER; a_reds: POINTER; a_greens: POINTER; a_blues: POINTER; a_ncolors: INTEGER; a_used: POINTER; a_colors: POINTER; a_nallocated: POINTER) is 
			-- Parsed as:
			-- void gdk_color_context_get_pixels_incremental (
			--     GdkColorContext *a_cc,
			--     gushort *a_reds,
			--     gushort *a_greens,
			--     gushort *a_blues,
			--     gint a_ncolors,
			--     gint *a_used,
			--     gulong *a_colors,
			--     gint *a_nallocated
			-- );
			--
			-- Original C code from gdk.h:
			-- void		 gdk_color_context_get_pixels_incremental (GdkColorContext *cc,
			-- 							   gushort	   *reds,
			-- 							   gushort	   *greens,
			-- 							   gushort	   *blues,
			-- 							   gint		    ncolors,
			-- 							   gint		   *used,
			-- 							   gulong	   *colors,
			-- 							   gint		   *nallocated);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_query_color (a_cc: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_context_query_color (
			--     GdkColorContext *a_cc,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gdk.h:
			-- gint		 gdk_color_context_query_color		  (GdkColorContext *cc,
			-- 							   GdkColor	   *color);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_query_colors (a_cc: POINTER; a_colors: POINTER; a_num_colors: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_context_query_colors (
			--     GdkColorContext *a_cc,
			--     GdkColor *a_colors,
			--     gint a_num_colors
			-- );
			--
			-- Original C code from gdk.h:
			-- gint		 gdk_color_context_query_colors		  (GdkColorContext *cc,
			-- 							   GdkColor	   *colors,
			-- 							   gint		    num_colors);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_add_palette (a_cc: POINTER; a_palette: POINTER; a_num_palette: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gdk_color_context_add_palette (
			--     GdkColorContext *a_cc,
			--     GdkColor *a_palette,
			--     gint a_num_palette
			-- );
			--
			-- Original C code from gdk.h:
			-- gint		 gdk_color_context_add_palette		  (GdkColorContext *cc,
			-- 							   GdkColor	   *palette,
			-- 							   gint		    num_palette);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_init_dither (a_cc: POINTER) is 
			-- Parsed as:
			-- void gdk_color_context_init_dither (
			--     GdkColorContext *a_cc
			-- );
			--
			-- Original C code from gdk.h:
			-- void		 gdk_color_context_init_dither		  (GdkColorContext *cc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_free_dither (a_cc: POINTER) is 
			-- Parsed as:
			-- void gdk_color_context_free_dither (
			--     GdkColorContext *a_cc
			-- );
			--
			-- Original C code from gdk.h:
			-- void		 gdk_color_context_free_dither		  (GdkColorContext *cc);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_get_pixel_from_palette (a_cc: POINTER; a_red: POINTER; a_green: POINTER; a_blue: POINTER; a_failed: POINTER): INTEGER is 
			-- Parsed as:
			-- gulong gdk_color_context_get_pixel_from_palette (
			--     GdkColorContext *a_cc,
			--     gushort *a_red,
			--     gushort *a_green,
			--     gushort *a_blue,
			--     gint *a_failed
			-- );
			--
			-- Original C code from gdk.h:
			-- gulong		 gdk_color_context_get_pixel_from_palette (GdkColorContext *cc,
			-- 							   gushort	   *red,
			-- 							   gushort	   *green,
			-- 							   gushort	   *blue,
			-- 							   gint		   *failed);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_color_context_get_index_from_palette (a_cc: POINTER; a_red: POINTER; a_green: POINTER; a_blue: POINTER; a_failed: POINTER): char is 
			-- Parsed as:
			-- guchar gdk_color_context_get_index_from_palette (
			--     GdkColorContext *a_cc,
			--     gint *a_red,
			--     gint *a_green,
			--     gint *a_blue,
			--     gint *a_failed
			-- );
			--
			-- Original C code from gdk.h:
			-- guchar		 gdk_color_context_get_index_from_palette (GdkColorContext *cc,
			-- 							   gint		   *red,
			-- 							   gint		   *green,
			-- 							   gint		   *blue,
			-- 							   gint		   *failed);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_new: POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_region_new (
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*     gdk_region_new	    (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_destroy (a_region: POINTER) is 
			-- Parsed as:
			-- void gdk_region_destroy (
			--     GdkRegion *a_region
			-- );
			--
			-- Original C code from gdk.h:
			-- void	       gdk_region_destroy   (GdkRegion	   *region);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_get_clipbox (a_region: POINTER; a_rectangle: POINTER) is 
			-- Parsed as:
			-- void gdk_region_get_clipbox (
			--     GdkRegion *a_region,
			--     GdkRectangle *a_rectangle
			-- );
			--
			-- Original C code from gdk.h:
			-- void	       gdk_region_get_clipbox(GdkRegion    *region,
			-- 				      GdkRectangle *rectangle);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_empty (a_region: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_region_empty (
			--     GdkRegion *a_region
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean       gdk_region_empty	    (GdkRegion	   *region);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_equal (a_region1: POINTER; a_region2: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_region_equal (
			--     GdkRegion *a_region1,
			--     GdkRegion *a_region2
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean       gdk_region_equal	    (GdkRegion	   *region1,
			-- 				     GdkRegion	   *region2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_point_in (a_region: POINTER; a_x: INTEGER; a_y: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_region_point_in (
			--     GdkRegion *a_region,
			--     int a_x,
			--     int a_y
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean       gdk_region_point_in  (GdkRegion	   *region,
			-- 				     int		   x,
			-- 				     int		   y);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_rect_in (a_region: POINTER; a_rect: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkOverlapType gdk_region_rect_in (
			--     GdkRegion *a_region,
			--     GdkRectangle *a_rect
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkOverlapType gdk_region_rect_in   (GdkRegion	   *region,
			-- 				     GdkRectangle  *rect);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_polygon (a_points: POINTER; a_npoints: INTEGER; a_fill_rule: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_region_polygon (
			--     GdkPoint *a_points,
			--     gint a_npoints,
			--     GdkFillRule a_fill_rule
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*     gdk_region_polygon   (GdkPoint      *points,
			-- 				     gint           npoints,
			-- 				     GdkFillRule    fill_rule);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_offset (a_region: POINTER; a_dx: INTEGER; a_dy: INTEGER) is 
			-- Parsed as:
			-- void gdk_region_offset (
			--     GdkRegion *a_region,
			--     gint a_dx,
			--     gint a_dy
			-- );
			--
			-- Original C code from gdk.h:
			-- void	       gdk_region_offset   (GdkRegion	   *region,
			-- 				    gint	   dx,
			-- 				    gint	   dy);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_shrink (a_region: POINTER; a_dx: INTEGER; a_dy: INTEGER) is 
			-- Parsed as:
			-- void gdk_region_shrink (
			--     GdkRegion *a_region,
			--     gint a_dx,
			--     gint a_dy
			-- );
			--
			-- Original C code from gdk.h:
			-- void	       gdk_region_shrink   (GdkRegion	   *region,
			-- 				    gint	   dx,
			-- 				    gint	   dy);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_region_union_with_rect (a_region: POINTER; a_rect: POINTER): POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_region_union_with_rect (
			--     GdkRegion *a_region,
			--     GdkRectangle *a_rect
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*    gdk_region_union_with_rect  (GdkRegion	  *region,
			-- 					   GdkRectangle	  *rect);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_regions_intersect (a_source1: POINTER; a_source2: POINTER): POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_regions_intersect (
			--     GdkRegion *a_source1,
			--     GdkRegion *a_source2
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*    gdk_regions_intersect	  (GdkRegion	  *source1,
			-- 					   GdkRegion	  *source2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_regions_union (a_source1: POINTER; a_source2: POINTER): POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_regions_union (
			--     GdkRegion *a_source1,
			--     GdkRegion *a_source2
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*    gdk_regions_union		  (GdkRegion	  *source1,
			-- 					   GdkRegion	  *source2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_regions_subtract (a_source1: POINTER; a_source2: POINTER): POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_regions_subtract (
			--     GdkRegion *a_source1,
			--     GdkRegion *a_source2
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*    gdk_regions_subtract	  (GdkRegion	  *source1,
			-- 					   GdkRegion	  *source2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_regions_xor (a_source1: POINTER; a_source2: POINTER): POINTER is 
			-- Parsed as:
			-- GdkRegion* gdk_regions_xor (
			--     GdkRegion *a_source1,
			--     GdkRegion *a_source2
			-- );
			--
			-- Original C code from gdk.h:
			-- GdkRegion*    gdk_regions_xor		  (GdkRegion	  *source1,
			-- 					   GdkRegion	  *source2);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_send_clientmessage_toall (a_event: POINTER) is 
			-- Parsed as:
			-- void gdk_event_send_clientmessage_toall (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gdk.h:
			-- void     gdk_event_send_clientmessage_toall (GdkEvent    *event);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_event_send_client_message (a_event: POINTER; a_xid: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_event_send_client_message (
			--     GdkEvent *a_event,
			--     guint32 a_xid
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_event_send_client_message (GdkEvent    *event,
			-- 					guint32      xid);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyval_name (a_keyval: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gdk_keyval_name (
			--     guint a_keyval
			-- );
			--
			-- Original C code from gdk.h:
			-- gchar*   gdk_keyval_name		  (guint	keyval);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyval_from_name (a_keyval_name: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gdk_keyval_from_name (
			--     gchar *a_keyval_name
			-- );
			--
			-- Original C code from gdk.h:
			-- guint    gdk_keyval_from_name		  (const gchar *keyval_name);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyval_to_upper (a_keyval: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gdk_keyval_to_upper (
			--     guint a_keyval
			-- );
			--
			-- Original C code from gdk.h:
			-- guint    gdk_keyval_to_upper		  (guint	keyval);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyval_to_lower (a_keyval: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gdk_keyval_to_lower (
			--     guint a_keyval
			-- );
			--
			-- Original C code from gdk.h:
			-- guint    gdk_keyval_to_lower		  (guint	keyval);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyval_is_upper (a_keyval: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_keyval_is_upper (
			--     guint a_keyval
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_keyval_is_upper		  (guint	keyval);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_keyval_is_lower (a_keyval: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_keyval_is_lower (
			--     guint a_keyval
			-- );
			--
			-- Original C code from gdk.h:
			-- gboolean gdk_keyval_is_lower		  (guint	keyval);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_threads_enter is 
			-- Parsed as:
			-- void gdk_threads_enter (
			-- );
			--
			-- Original C code from gdk.h:
			-- void     gdk_threads_enter                (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_threads_leave is 
			-- Parsed as:
			-- void gdk_threads_leave (
			-- );
			--
			-- Original C code from gdk.h:
			-- void     gdk_threads_leave                (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_init is 
			-- Parsed as:
			-- void gdk_rgb_init (
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_init (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_xpixel_from_rgb (a_rgb: INTEGER): INTEGER is 
			-- Parsed as:
			-- gulong gdk_rgb_xpixel_from_rgb (
			--     guint32 a_rgb
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- gulong
			-- gdk_rgb_xpixel_from_rgb (guint32 rgb);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_gc_set_foreground (a_gc: POINTER; a_rgb: INTEGER) is 
			-- Parsed as:
			-- void gdk_rgb_gc_set_foreground (
			--     GdkGC *a_gc,
			--     guint32 a_rgb
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_gc_set_foreground (GdkGC *gc, guint32 rgb);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_gc_set_background (a_gc: POINTER; a_rgb: INTEGER) is 
			-- Parsed as:
			-- void gdk_rgb_gc_set_background (
			--     GdkGC *a_gc,
			--     guint32 a_rgb
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_gc_set_background (GdkGC *gc, guint32 rgb);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_rgb_image (a_drawable: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_dith: INTEGER; a_rgb_buf: POINTER; a_rowstride: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_rgb_image (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GdkRgbDither a_dith,
			--     guchar *a_rgb_buf,
			--     gint a_rowstride
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_draw_rgb_image (GdkDrawable *drawable,
			-- 		    GdkGC *gc,
			-- 		    gint x,
			-- 		    gint y,
			-- 		    gint width,
			-- 		    gint height,
			-- 		    GdkRgbDither dith,
			-- 		    guchar *rgb_buf,
			-- 		    gint rowstride);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_rgb_image_dithalign (a_drawable: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_dith: INTEGER; a_rgb_buf: POINTER; a_rowstride: INTEGER; a_xdith: INTEGER; a_ydith: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_rgb_image_dithalign (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GdkRgbDither a_dith,
			--     guchar *a_rgb_buf,
			--     gint a_rowstride,
			--     gint a_xdith,
			--     gint a_ydith
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_draw_rgb_image_dithalign (GdkDrawable *drawable,
			-- 			      GdkGC *gc,
			-- 			      gint x,
			-- 			      gint y,
			-- 			      gint width,
			-- 			      gint height,
			-- 			      GdkRgbDither dith,
			-- 			      guchar *rgb_buf,
			-- 			      gint rowstride,
			-- 			      gint xdith,
			-- 			      gint ydith);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_rgb_32_image (a_drawable: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_dith: INTEGER; a_buf: POINTER; a_rowstride: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_rgb_32_image (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GdkRgbDither a_dith,
			--     guchar *a_buf,
			--     gint a_rowstride
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_draw_rgb_32_image (GdkDrawable *drawable,
			-- 		       GdkGC *gc,
			-- 		       gint x,
			-- 		       gint y,
			-- 		       gint width,
			-- 		       gint height,
			-- 		       GdkRgbDither dith,
			-- 		       guchar *buf,
			-- 		       gint rowstride);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_gray_image (a_drawable: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_dith: INTEGER; a_buf: POINTER; a_rowstride: INTEGER) is 
			-- Parsed as:
			-- void gdk_draw_gray_image (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GdkRgbDither a_dith,
			--     guchar *a_buf,
			--     gint a_rowstride
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_draw_gray_image (GdkDrawable *drawable,
			-- 		     GdkGC *gc,
			-- 		     gint x,
			-- 		     gint y,
			-- 		     gint width,
			-- 		     gint height,
			-- 		     GdkRgbDither dith,
			-- 		     guchar *buf,
			-- 		     gint rowstride);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_cmap_new (a_colors: POINTER; a_n_colors: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkRgbCmap* gdk_rgb_cmap_new (
			--     guint32 *a_colors,
			--     gint a_n_colors
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- GdkRgbCmap *
			-- gdk_rgb_cmap_new (guint32 *colors, gint n_colors);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_cmap_free (a_cmap: POINTER) is 
			-- Parsed as:
			-- void gdk_rgb_cmap_free (
			--     GdkRgbCmap *a_cmap
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_cmap_free (GdkRgbCmap *cmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_draw_indexed_image (a_drawable: POINTER; a_gc: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_dith: INTEGER; a_buf: POINTER; a_rowstride: INTEGER; a_cmap: POINTER) is 
			-- Parsed as:
			-- void gdk_draw_indexed_image (
			--     GdkDrawable *a_drawable,
			--     GdkGC *a_gc,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GdkRgbDither a_dith,
			--     guchar *a_buf,
			--     gint a_rowstride,
			--     GdkRgbCmap *a_cmap
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_draw_indexed_image (GdkDrawable *drawable,
			-- 			GdkGC *gc,
			-- 			gint x,
			-- 			gint y,
			-- 			gint width,
			-- 			gint height,
			-- 			GdkRgbDither dith,
			-- 			guchar *buf,
			-- 			gint rowstride,
			-- 			GdkRgbCmap *cmap);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_ditherable: BOOLEAN is 
			-- Parsed as:
			-- gboolean gdk_rgb_ditherable (
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- gboolean
			-- gdk_rgb_ditherable (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_set_verbose (a_verbose: BOOLEAN) is 
			-- Parsed as:
			-- void gdk_rgb_set_verbose (
			--     gboolean a_verbose
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_set_verbose (gboolean verbose);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_set_install (a_install: BOOLEAN) is 
			-- Parsed as:
			-- void gdk_rgb_set_install (
			--     gboolean a_install
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_set_install (gboolean install);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_set_min_colors (a_min_colors: INTEGER) is 
			-- Parsed as:
			-- void gdk_rgb_set_min_colors (
			--     gint a_min_colors
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- void
			-- gdk_rgb_set_min_colors (gint min_colors);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_get_cmap: POINTER is 
			-- Parsed as:
			-- GdkColormap* gdk_rgb_get_cmap (
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- GdkColormap *
			-- gdk_rgb_get_cmap (void);
		external
			" C | <gtk/gtk.h>"
		end

	gdk_rgb_get_visual: POINTER is 
			-- Parsed as:
			-- GdkVisual* gdk_rgb_get_visual (
			-- );
			--
			-- Original C code from gdkrgb.h:
			-- GdkVisual *
			-- gdk_rgb_get_visual (void);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GDK

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)