-- Copyright 1999 Pirmin Kalberer and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing
	
	description: "GTK_TREE - a tree widget"
	author: "Pirmin Kalberer"
	CVS: "$Id: gtk_tree.e,v 1.5 1999/08/30 20:09:32 pi Exp $"
	
class GTK_TREE
	
	-- A tree widget
	--
   -- Signals (from gtktree.c):
	--    "select_child"
	--    "selection_changed"
	--    "unselect_child"
	
inherit
	
	GTK_COMPOSED_BIN
		redefine
			add_widget
		end
	
	GTK_TREE_EXTERNALS
		undefine
			copy, is_equal
		end

creation
	
	make,
	make_from_pointer
	
feature
	
	make is 
		do
			widget := gtk_tree_new
			!!children.make (1, 0)
			register_widget
		end
	
	add_widget (a_child: GTK_TREE_ITEM) is
			-- add root item
		do
			precursor (a_child)
--			gtk_container_add (widget, a_child.widget)
--			a_child.set_parent (Current)
		end
	
	append_item (tree_item: GTK_TREE_ITEM) is
		require
			item_not_void: tree_item /= Void
		do
			gtk_tree_append (widget, tree_item.widget)
		end
	
	child_position (child: GTK_TREE_ITEM): INTEGER is
			-- position of this widget in the list
		require
			child_not_void: child /= Void
		do
			Result := gtk_tree_child_position (widget, child.widget)
		end
	
feature -- selections
	
	select_item (it: INTEGER) is
		require
			--	 valid_item_index: (it >= 0) and (it < count)
		do
			gtk_tree_select_item (widget, it)
		end
	
	unselect_item (it: INTEGER) is
		require
			--	 valid_item_index: (it >= 0) and (it < count)
		do
			gtk_tree_unselect_item (widget, it)
		end
	
	
	set_selection_mode (mode: INTEGER) is
		require
			valid_mode: is_selection_mode_valid (mode)
		do
			gtk_tree_set_selection_mode (widget, mode)
		end
	
	is_selection_mode_valid (mode: INTEGER): BOOLEAN is
		do
		   Result := (mode = Gtk_selection_single) 
		      or else (mode = Gtk_selection_browse)
		      or else (mode = Gtk_selection_multiple)
		      or else (mode = Gtk_selection_extended)
		end
	
	set_view_mode (mode: INTEGER) is
		require
			valid_mode: is_view_mode_valid (mode)
		do
			gtk_tree_set_view_mode (widget, mode)
		end
	
	is_view_mode_valid (mode: INTEGER): BOOLEAN is
		do
		   Result := (mode = Gtk_tree_view_line) 
		      or else (mode = Gtk_tree_view_item)
		end
	
feature -- native GTK calls (UNTESTED) - TODO: replace POINTER types

   append ( tree_item : POINTER ) is
      do
         gtk_tree_append ( widget, tree_item )
      end

   prepend ( tree_item : POINTER ) is
      do
         gtk_tree_prepend ( widget, tree_item )
      end

   insert ( tree_item : POINTER; position : INTEGER ) is
      do
         gtk_tree_insert ( widget, tree_item, position )
      end

   remove_items ( items : POINTER ) is
      do
         gtk_tree_remove_items ( widget, items )
      end

   clear_items ( start : INTEGER; last : INTEGER ) is
      do
         gtk_tree_clear_items ( widget, start, last )
      end

   select_child ( tree_item : POINTER ) is
      do
         gtk_tree_select_child ( widget, tree_item )
      end

   unselect_child ( tree_item : POINTER ) is
      do
         gtk_tree_unselect_child ( widget, tree_item )
      end

   set_view_lines ( flag : INTEGER ) is
      do
         gtk_tree_set_view_lines ( widget, flag )
      end
   
end -- GTK_TREE
