/*
 *	fhist - file history and comparison tools
 *	Copyright (C) 1993, 1994, 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for fhist/subroutine.c
 */

#ifndef SUBROUTINE_H
#define SUBROUTINE_H

#include <ac/stdio.h>

#include <main.h>

#define OHF_READ 1
#define OHF_WRITE 2

int history_file_exists _((void));
FILE *openhistoryfile _((int mode));
long findeditnumber _((FILE *fp, char *editname));
POS *readpostable _((FILE *fp));
void startedit _((FILE *fp, long num, char *infoline));
FILE *opensourcefile _((void));
int renamefiles _((char *extension));
int checknewfile _((char *name));
int queryuser _((void));
char *get_a_line _((FILE *fp, long pos, int type, const char *filename));
char *getnumber _((char *cp, long *value));
int pathconf_name_max _((char *path));

#endif /* SUBROUTINE_H */
