{
  $Id: entry.pp,v 1.2 1999/05/10 19:18:19 peter Exp $

  This file extracted from the GTK tutorial.
  entry.c

  Converted from C to Pascal by Frank Loemker
  <floemker@techfak.uni-bielefeld.de>
}
program entry;
uses
  glib,gdk,gtk;

procedure enter_callback(widget,entry : PGtkWidget);{$ifdef win32}stdcall;{$else}cdecl;{$endif}
var
  entry_text : Pgchar;
begin
  entry_text := gtk_entry_get_text(PGtkEntry(entry));
  writeln ('Entry contents: ',entry_text);
end;


procedure entry_toggle_editable (checkbutton, entry: PGtkWidget);{$ifdef win32}stdcall;{$else}cdecl;{$endif}
begin
  gtk_entry_set_editable(pGtkEntry(entry),
                         gboolean(active(pGtkToggleButton(checkbutton)^)));
end;


procedure entry_toggle_visibility (checkbutton,entry : PGtkWidget); cdecl;
begin
  gtk_entry_set_visibility(pGTKENTRY(entry),
                           gboolean(active(pGtkToggleButton(checkbutton)^)));
end;


var window, vbox, hbox,
  fentry, button, check : PGtkWidget;
begin
  gtk_init (@argc, @argv);

  { create a new window }
  window := gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize( pGTKWIDGET (window), 200, 100);
  gtk_window_set_title(pGTKWINDOW (window), 'GTK Entry');
  gtk_signal_connect(pGTKOBJECT (window), 'delete_event',
                     GTK_SIGNAL_FUNC (@gtk_exit), NIL);

  vbox := gtk_vbox_new (gint(false), 0);
  gtk_container_add (pGTKCONTAINER (window), vbox);
  gtk_widget_show (vbox);

  fentry := gtk_entry_new_with_max_length (50);
  gtk_signal_connect(pGTKOBJECT(fentry), 'activate',
                     GTK_SIGNAL_FUNC(@enter_callback),
                     fentry);
  gtk_entry_set_text (pGTKENTRY (fentry), 'hello');
  gtk_entry_append_text (pGTKENTRY (fentry), ' world');
  gtk_entry_select_region (pGTKENTRY (fentry),
                           0, pGTKENTRY(fentry)^.text_length);
  gtk_box_pack_start (pGTKBOX (vbox), fentry, gint(true), gint(true), 0);
  gtk_widget_show (fentry);

  hbox := gtk_hbox_new (gint(false), 0);
  gtk_container_add (pGTKCONTAINER (vbox), hbox);
  gtk_widget_show (hbox);

  check := gtk_check_button_new_with_label('Editable');
  gtk_box_pack_start (pGTKBOX (hbox), check, gint(true), gint(true), 0);
  gtk_signal_connect (pGTKOBJECT(check), 'toggled',
                      GTK_SIGNAL_FUNC(@entry_toggle_editable), fentry);
  gtk_toggle_button_set_state(pGTKTOGGLEBUTTON(check), gint(true));
  gtk_widget_show (check);

  check := gtk_check_button_new_with_label('Visible');
  gtk_box_pack_start (pGTKBOX (hbox), check, gint(true), gint(true), 0);
  gtk_signal_connect (pGTKOBJECT(check), 'toggled',
                      GTK_SIGNAL_FUNC(@entry_toggle_visibility), fentry);
  gtk_toggle_button_set_state(pGTKTOGGLEBUTTON(check), gint(true));
  gtk_widget_show (check);

  button := gtk_button_new_with_label ('Close');
  gtk_signal_connect_object (pGTKOBJECT (button), 'clicked',
                             GTK_SIGNAL_FUNC(@gtk_exit),
                             pGTKOBJECT (window));
  gtk_box_pack_start (pGTKBOX (vbox), button, gint(true), gint(true), 0);

  pGTKOBJECT(button)^.flags := pGTKOBJECT(button)^.flags or GTK_CAN_DEFAULT;
  {  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); }
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_widget_show(window);

  gtk_main();
end.
{
  $Log: entry.pp,v $
  Revision 1.2  1999/05/10 19:18:19  peter
    * more fixes for the examples to work

  Revision 1.1  1999/05/10 09:02:36  peter
    * gtk 1.2 port working

  Revision 1.2  1999/02/02 16:13:35  michael
  + Applied second patch from Frank Loemker

  Revision 1.1  1998/10/21 22:27:01  peter
    + initial version

}
