------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                         G C H . SOURCE_C H E C K                         --
--                                                                          --
--                               S p e c                                    --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

--  This package implements all the high-level actions needed to check
--  source files in an ASIS Context

with Gch.Init; use Gch.Init;

package Gch.Source_Check is

   procedure Check_Source (Source_File : File_Id);
   --  Integrates all the actions needed to check (and then to recompile,
   --  if needed) a given source file.

   procedure Check_Rules
     (Checking_File_Name  : String;
      Tree_Name           : String_Access;
      Success      : in out Boolean;
      Needs_Object : out Boolean);

   --  This procedure runs ASIS-based
   --  checker agains a compilation unit contained the given source file.
   --  Success is set True if all the rules have successfully been checked
   --  for Checking_File and False otherwise. Needs_Object is set True if
   --  Checking_File may be compiled to create an object (that is, it is set
   --  False for subunits and specs which require bodies).
   --
   --  Technically, there is no need to put the spec of this procedure into the
   --  spec of the package. But it is placed here because it is an important
   --  component of the high-level design of Gch.

end Gch.Source_Check;