/*
This file is licensed to you under the license specified in the included file
`LICENSE'. Look there for further details.
*/


#include <stdio.h>

#include "argsdef.h"
#include "ggos.h"
extern struct gengetopt_option * gengetopt_options;
extern char * gengetopt_package;
extern char * gengetopt_version;


long
gengetopt_strlen (char *s)
{
  char * p = s;
  while (*p) p++;
  return p - s;
}


int
generate_main (void)
{
  long max_long, max_short, w;
  struct gengetopt_option * opt;
# define foropt for (opt = gengetopt_options;             \
		     opt != (struct gengetopt_option *)0; \
		     opt=opt->next)

  if (gengetopt_options == (struct gengetopt_option *)0) {
	fprintf (stderr, "gengetopt: none option given\n");
	return 1;
  }



  /* ****************************************************** */
  /* ********************************************** HEADERS */
  /* ****************************************************** */

  printf ("\
/* File autogenerated by gengetopt verson %s.  */\n\
\n\
\n\
#include <stdio.h>\n\
#include <stdlib.h>\n\
/* If we use autoconf.  */\n\
#ifdef HAVE_CONFIG_H\n\
#	include <config.h>\n\
#endif\n\
/* Check for configure's getopt check result.  */\n\
#ifndef HAVE_GETOPT_LONG\n\
#	include \"getopt.h\"\n\
#else\n\
#	include <getopt.h>\n\
#endif\n\
\n\
\n\
/* Don't define PACKAGE and VERSION if we use automake.  */\n\
", VERSION);

  if (gengetopt_package != NULL)
	printf ("\
#define PACKAGE \"%s\"\n\
", gengetopt_package);
  else
	printf ("\
#ifndef PACKAGE\n\
/* ******* WRITE THE NAME OF YOUR PROGRAM HERE ******* */\n\
#define PACKAGE \"\"
#endif\n\
");

  if (gengetopt_version != NULL)
	printf ("\
#define VERSION \"%s\"\n\
", gengetopt_version);
  else
	printf ("\
#ifndef VERSION\n\
/* ******* WRITE THE VERSION OF YOUR PROGRAM HERE ******* */\n\
#define VERSION \"\"
#endif\n\
");

  printf ("\
\n\
\n\
void\n\
print_version (void)\n\
{\n\
\tprintf (\"%%s %%s\\n\", PACKAGE, VERSION);\n\
}\n\
\n\
void\n\
print_help (void)\n\
{\n\
\tprint_version ();\n\
\tprintf (\"\
Usage: %%s \
");



  /* ****************************************************** */
  /* ********************************************** OPTIONS */
  /* ****************************************************** */

  foropt
	if (opt->flagstat_or_required && opt->type != ARG_FLAG && opt->type != ARG_NO)
		switch (opt->type) {
		case ARG_INT:
		case ARG_SHORT:
		case ARG_LONG:
		case ARG_FLOAT:
		case ARG_DOUBLE:
		case ARG_LONGDOUBLE:
		case ARG_LONGLONG:
		case ARG_STRING: printf ("-%c%s|--%s=%s ",
					opt->short_opt, arg_names[opt->type],
					opt->long_opt, arg_names[opt->type]);
		                 break;
		default: fprintf (stderr, "gengetopt: bug found in %s:%d!!\n",
				  __FILE__, __LINE__);
		         abort ();
		}
  foropt
	if (!opt->flagstat_or_required || opt->type == ARG_FLAG || opt->type == ARG_NO)
		switch (opt->type) {
		case ARG_NO:
		case ARG_FLAG: printf ("[-%c|--%s] ",
					opt->short_opt, opt->long_opt);
		               break;
		case ARG_INT:
		case ARG_SHORT:
		case ARG_LONG:
		case ARG_FLOAT:
		case ARG_DOUBLE:
		case ARG_LONGDOUBLE:
		case ARG_LONGLONG:
		case ARG_STRING: printf ("[-%c%s|--%s=%s] ",
					opt->short_opt, arg_names[opt->type],
					opt->long_opt, arg_names[opt->type]);
		                 break;
		default: fprintf (stderr, "gengetopt: bug found in %s:%d!!\n",
				  __FILE__, __LINE__);
		         abort ();
		}
  printf ("\\n\\\n");
  /* calculate columns */
  max_long = max_short = 0;
  foropt {
	w = 3 + gengetopt_strlen (opt->long_opt);
	if (opt->type == ARG_FLAG || opt->type == ARG_NO)
	{
		if (w > max_long) max_long = w;
		if (2 > max_short) max_short = 2;
	}
	else
	{
		w += gengetopt_strlen (arg_names[opt->type]);
		if (w > max_long) max_long = w;
		w = (3 + gengetopt_strlen (arg_names[opt->type]));
		if (w > max_short) max_short = w;
	}
  }
  /* print justified options */
  foropt
	if (opt->type == ARG_FLAG || opt->type == ARG_NO)
	{
		printf ("   -%c", opt->short_opt);
		for (w = 2; w < max_short; w++) printf (" ");
   		printf ("  --%s", opt->long_opt);
		for (w = 2+gengetopt_strlen(opt->long_opt); w < max_long; w++)
			printf (" ");
		printf ("  %s", opt->desc);
		if (opt->type == ARG_FLAG)
			if (opt->flagstat_or_required)
				printf (" (default=yes)");
			else
				printf (" (default=no)");
		printf ("\\n\\\n");
	}
	else
	{
		printf ("   -%c%s", opt->short_opt, arg_names[opt->type]);
		for (w = 2+gengetopt_strlen(arg_names[opt->type]); w < max_short; w++)
			printf (" ");
		printf ("  --%s=%s", opt->long_opt, arg_names[opt->type]);
		for (w = 3+gengetopt_strlen(opt->long_opt)+
		     gengetopt_strlen(arg_names[opt->type]); w < max_long; w++)
			printf (" ");
   		printf ("  %s\\n\\\n", opt->desc);
	}
  printf ("\
\", PACKAGE);\n\
}\n\
\n\
\n\
");

  foropt
	if (opt->type == ARG_STRING) {
		printf ("\
char *\n\
gengetopt_strdup (char * s)\n\
{\n\
\tchar * n, * pn, * ps = s;\n\
\twhile (*ps) ps++;\n\
\tn = malloc (1 + ps - s);\n\
\tif (n != NULL) {\n\
\t\tfor (ps=s,pn=n; *ps; ps++,pn++) *pn = *ps;\n\
\t\t*pn = 0;\n\
\t}\n\
\treturn n;\n\
}\n\
\n\
\n\
");
		break;
	}

  printf ("\
int\n\
main (int argc, char **argv)\n\
{\n\
\tint c;\t/* Character of the parsed option.  */\n\
\n\
");



  /* ****************************************************** */
  /* ******************************************* STRUCTURES */
  /* ****************************************************** */

  foropt
	if (opt->type != ARG_NO) {
		switch (opt->type) {
		case ARG_FLAG:
		case ARG_STRING:
		case ARG_INT:
		case ARG_SHORT:
		case ARG_LONG:
		case ARG_FLOAT:
		case ARG_DOUBLE:
		case ARG_LONGDOUBLE:
		case ARG_LONGLONG: printf ("\t%s ", arg_types[opt->type]);
				   break;
		default: fprintf (stderr, "gengetopt: bug found in %s:%d!!\n",
				  __FILE__, __LINE__);
			 abort ();
		}
		if (opt->type == ARG_FLAG)
			printf ("%s_flag", opt->var_arg);
		else
			printf ("%s_arg", opt->var_arg);
		switch (opt->type) {
		case ARG_STRING: printf (" = NULL"); break;
		case ARG_FLAG: printf (" = %d", opt->flagstat_or_required);
				break;
		}
		printf (";\t/* %s", opt->desc);
		if (opt->type == ARG_FLAG)
                        if (opt->flagstat_or_required)
                                printf (" (default=yes)");
                        else    
                                printf (" (default=no)");
		printf (".  */\n");
	}

  printf ("\n");
  foropt
	if (opt->type != ARG_NO) {
		switch (opt->type) {
		case ARG_FLAG:
		case ARG_STRING:
		case ARG_INT:
		case ARG_SHORT:
		case ARG_LONG:
		case ARG_FLOAT:
		case ARG_DOUBLE:
		case ARG_LONGDOUBLE:
		case ARG_LONGLONG: break;
		default: fprintf (stderr, "gengetopt: bug found in %s:%d!!\n",
				  __FILE__, __LINE__);
			 abort ();
		}
		printf ("\tint %s_given = 0;\t/* Wheter %s was given.  */\n",
			opt->var_arg, opt->long_opt);
	}


  printf ("
#\tdefine clear_args() { \\\n\
");

  foropt
	if (opt->type == ARG_STRING)
		printf ("\t\tif (%s_arg != NULL) free (%s_arg); \\\n",
			opt->var_arg, opt->var_arg);

  printf ("\
\t}\n\
\n\
\n\
\twhile (1)\n\
\t{\n\
\t\tint option_index = 0;
\t\tstatic struct option long_options[] = {\n\
");

  foropt
	printf ("\t\t\t{ \"%s\",\t%d, NULL, \'%c\' },\n", opt->long_opt,
		(opt->type == ARG_NO || opt->type == ARG_FLAG ? 0 : 1),
		opt->short_opt);

  printf ("\
\t\t\t{ NULL,\t0, NULL, 0 }\n\
\t\t};\n\
\n\
\t\tc = getopt_long (argc, argv, \"\
");

  foropt
	printf ("%c%s", opt->short_opt,
		(opt->type == ARG_NO || opt->type == ARG_FLAG ? "" : ":"));

  printf ("\
\",\n\
\t\t\t\tlong_options, &option_index);\n\
\n\
\t\tif (c == -1) break;\t/* Exit from `while (1)' loop.  */\n\
\n\
\t\tswitch (c) {\n\
\t\t\tcase 'h':\t/* Print help and exit.  */\n\
\t\t\t\tclear_args ();\n\
\t\t\t\tprint_help ();\n\
\t\t\t\texit (0);\n\
\n\
\t\t\tcase 'V':\t/* Print version and exit.  */\n\
\t\t\t\tclear_args ();\n\
\t\t\t\tprint_version ();\n\
\t\t\t\texit (0);\n\
");


  /* ****************************************************** */
  /* ********************************************* GENERATE */
  /* ****************************************************** */

#define check_option_given() { \
			printf ("\
if (%s_given) {\n\
fprintf (stderr, \"%%s: `--%s' (`-%c') option redeclared\\n\", PACKAGE);\n\
\t\t\t\t\tclear_args ();\n\
\t\t\t\t\tprint_help ();\n\
\t\t\t\t\texit (1);\n\
\t\t\t\t}\n\
\t\t\t\t%s_given = 1;\n\
\t\t\t\t\
", opt->var_arg, opt->long_opt, opt->short_opt, opt->var_arg); \
}

  foropt {
	if (opt->short_opt == 'h' || opt->short_opt == 'V') continue;

	printf ("\n\t\t\tcase '%c':\t/* %s.  */\n\t\t\t\t", opt->short_opt,
		opt->desc);
	switch (opt->type) {
	case ARG_NO:
			printf ("/* ******* WRITE YOUR CODE HERE ******* */\n");
			break;
	case ARG_FLAG:
			printf ("%s_flag = !%s_flag;\n", opt->var_arg,
				opt->var_arg);
			break;
	case ARG_STRING:
			check_option_given ();
			printf ("%s_arg = gengetopt_strdup (optarg);\n",
				opt->var_arg);
			break;
	case ARG_INT:
			check_option_given ();
			printf ("%s_arg = atoi (optarg);\n",
				opt->var_arg);
			break;
	case ARG_SHORT:
			check_option_given ();
			printf ("%s_arg = (short)atoi (optarg);\n",
				opt->var_arg);
			break;
	case ARG_LONG:
			check_option_given ();
			printf ("%s_arg = atol (optarg);\n", opt->var_arg);
			break;
	case ARG_FLOAT:
			check_option_given ();
			printf ("%s_arg = (float)strtod (optarg, NULL);\n",
				opt->var_arg);
			break;
	case ARG_DOUBLE:
			check_option_given ();
			printf ("%s_arg = strtod (optarg, NULL);\n",
				opt->var_arg);
			break;
	case ARG_LONGDOUBLE:
			check_option_given ();
			printf ("%s_arg = (long double)\n\t\t\t\t\tstrtod (optarg, NULL);\n",
				opt->var_arg);
			break;
	case ARG_LONGLONG:
			check_option_given ();
			printf ("%s_arg = (long long)atol (optarg);\n",
				opt->var_arg);
			break;
	default:
			fprintf (stderr, "gengetopt: bug found in %s:%d\n", __FILE__,
				__LINE__);
			abort ();
	}
	printf ("\t\t\t\tbreak;\n");
  }

  printf ("\
\n\
\t\t\tcase '?':\t/* Invalid option.  */\n\
\t\t\t\t/* `getopt_long' already printed\n\
\t\t\t\t\tan error message.  */\n\
\t\t\t\texit (1);\n\
\n\
\t\t\tdefault:\t/* bug: option not considered.  */\n\
\t\t\t\tfprintf (stderr, \"%%s: option unknown: %%c\\n\",\n\
\t\t\t\t\tPACKAGE, c);\n\
\t\t\t\tabort ();\n\
\t\t}\n\
\t}\n\
\n\
\n\
\t/* ******* WRITE YOUR CODE HERE ******* */
\n\
\n\
\tclear_args ();\n\
\treturn 0;\n\
}\n\
\n\
");

  return 0;
}

