/* GtkEditor - a source editor widget for GTK
 * Copyright (C) 1998 Thomas Mailund.
 *
 * The editor widget was written by Thomas Mailund, so bugs should be
 * reported to <mailund@daimi.au.dk>, not the gtk ppl.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "parent.h"

#define PARBEGMATCH(E,I) (GTK_SCTEXT_INDEX (GTK_SCTEXT (E),(I)) == '(')

static gint
match_back (GtkEditor *editor)
{
  gint beg = gtk_editable_get_position (GTK_EDITABLE (editor)) - 1;
  while (beg > 0 && !PARBEGMATCH (editor, beg-1))
    beg--;
  return beg-1;
}

void
gtk_editor_parenmatch (GtkWidget *editor)
{
  gint pos = gtk_editable_get_position (GTK_EDITABLE (editor));

#if 0
  g_print ("gtk_editor_parenmatch called\n");
  g_print ("looking at '%c'\n",
	   GTK_SCTEXT_INDEX (GTK_SCTEXT (editor), pos-1));


  if (GTK_SCTEXT_INDEX (GTK_SCTEXT (editor), pos-1) == ')') {
    g_print ("')' match!\n");
    g_print ("mached by %c at %d\n", 
	     GTK_SCTEXT_INDEX (GTK_SCTEXT (editor),
			     match_back (GTK_EDITOR (editor))),
	     match_back (GTK_EDITOR (editor)));
  }
#endif
}
