/* $Header: /cvs/gnome/gIDE/src/gI_cfp.c,v 1.3 1999/11/06 17:45:38 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include "structs.h"
#include "gI_cfp.h"
#include "gI_common.h"


/* externs */
extern gchar gide_path[];
extern gI_config *cfg;


gchar *SK_CutLeadingBlanks( gchar *source )
{
	gint i;
	gchar *dest = ""; 

	if( !source )
	{
		printf( "SK_CutLeadingBlanks: NULL-Pointer uebergeben\n" );
		return( "" );
	}

	if( strlen( source ) == 0 )
	{
		printf( "SK_CutLeadingBlanks: Leerer String uebergeben\n" );
		return( "" );
	}

	for(i=0;i<=(strlen( source ));i++)
		if( source[i] != ' ' )
		{
			dest = &source[i];
			break;
		}

	return( dest );

}

#ifndef HAVE_LIBGUILE
gint gI_cf_parse( gchar *config )
{
    gchar buf[STRLEN];
    FILE *cfgfile;
    gchar key[64];
    gchar arg[STRLEN];
    glong i;
    gchar *ptr;

    if( !config )
    {
        g_warning( "cant parse config file, NULL-Pointer given as filename\n" );
        return( -1 );
    }

    cfgfile = fopen( config, "r" );
    if( !cfgfile )
    {
        g_warning( "cant open config file :%s:\n", config );
        return( -1 );
    }

    while( fgets( buf, STRLEN, cfgfile ) )
    {
        strcpy( buf, SK_CutLeadingBlanks( buf ) );
        if( !iscomment( buf ) && !__isblank( buf ) )
        {
            if( sscanf( buf, "%s %s\n", key, arg ) == 2 )
            {
                if( !strcmp( key, "CC:" ) )
                {
                    cfg->cc = (gchar *)realloc( cfg->cc, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->cc, arg );
                    continue;
                }

                if( !strcmp( key, "MAKE:" ) )
                {
                    cfg->make = (gchar *)realloc( cfg->make, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->make, arg );
                    continue;
                }

                if( !strcmp( key, "TMPDIR:" ) )
                {
                    cfg->tmpdir = (gchar *)realloc( cfg->tmpdir, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->tmpdir, arg );
                    continue;
                }

                if( !strcmp( key, "WORDWRAP:" ) )
                {
                    cfg->wordwrap = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "AUTOSAVE:" ) )
                {
                    cfg->autosave = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "AUTOSAVE_FREQ:" ) )
                {
                    cfg->autosave_freq = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "USE_REDIT:" ) )
                {
                    cfg->use_redit = atoi( arg );
                    strcpy( buf, SK_GetBetween( buf, '!', '!' ) );
                    cfg->redit = (gchar *) realloc( cfg->redit, (strlen( buf ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->redit, buf );
                    continue;
                }

                if( !strcmp( key, "HIGHLIGHT:" ) )
                {
                    cfg->highlight = atoi( arg );
                    continue;
                }
                
                if( !strcmp( key, "TOOLBAR:" ) )
                {
                    cfg->toolbar = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "TOOLBAR_CUSTOM:" ) )
                {
                    cfg->toolbar_custom = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "$TOOLBAR_CUSTOM_ITEMS:" ) )
                {
                    cfg->toolbar_custom_items_no = atoi( arg );
                    for(i=0;i<=atoi(arg);i++)
                    {
                        fgets( buf, STRLEN, cfgfile );
                        if( !strcmp( buf, "$END" ) )
                            break;

                        if( feof( cfgfile ) )
                        {
                            printf("ERROR: Unfinished Statement in Configuration FIle\n" );
                            exit( -1 );
                        }

                        ptr = strchr( buf, '\n' );
                        if( ptr )
                            *ptr = '\0';
                        cfg->toolbar_custom_items[i] = (gchar *) realloc( cfg->toolbar_custom_items[i], (strlen( buf ) + 1) * sizeof( gchar ) );
                        strcpy( cfg->toolbar_custom_items[i], buf );
                    }
                    continue;
                }

                if( !strcmp( key, "IGN_FILE:" ) )
                {
                    strcpy( arg, SK_GetBetween( arg, '!', '!' ) );
                    cfg->ign_file = (gchar *) realloc( cfg->ign_file, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->ign_file, arg );
                    continue;
                }

#ifdef HAVE_GTKTEXT_PATCH
                if( !strcmp( key, "HLI_FILE:" ) )
                {
                    strcpy( arg, SK_GetBetween( arg, '!', '!' ) );
                    cfg->hli_file = (gchar *) realloc( cfg->hli_file, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->hli_file, arg );
                    continue;
                }
#endif

                if( !strcmp( key, "PRJFTREE:" ) )
                {
                    cfg->prjftree = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "CHANGELOG:" ) )
                {
                    cfg->changelog = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "REMDONE:" ) )
                {
                    cfg->remdone = atoi( arg );
                    continue;
                }

#ifdef HAVE_GTKTEXT_PATCH
                if( !strcmp( key, "PATTERNFILE:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->patternfile = (gchar *) realloc( cfg->patternfile,
							 (strlen( arg ) + 1)
							 * sizeof( gchar ) );
                    strcpy( cfg->patternfile, arg );
                    continue;
                }

		if( !strcmp ( key, "GLOBASSOCFILE:" ) )
		{
		    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
		    cfg->globassocfile = (gchar *)realloc( cfg->globassocfile,
							  (strlen( arg ) + 1)
							  * sizeof( gchar ) );
		    strcpy( cfg->globassocfile, arg );
		    continue;
		}
#endif

                if( !strcmp( key, "TAB_WIDTH:" ) )
                {
                    cfg->tab_width = atoi( arg );
                    continue;
                }

                if( !strcmp( key, "FONT:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    if( !isempty( arg ) )
                    {
                        cfg->fontname = (gchar *) realloc( cfg->fontname, (strlen( arg ) + 1) * sizeof( gchar ) );
                        strcpy( cfg->fontname, arg );
                    }
                    continue;
                }

                if( !strcmp( key, "INCPATH:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->incpath = (gchar *) realloc( cfg->incpath, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->incpath, arg );
                    continue;
                }

                if( !strcmp( key, "CCOPT:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->ccopt = (gchar *) realloc( cfg->ccopt, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->ccopt, arg );
                    continue;
                }

                if( !strcmp( key, "LIBPATH:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->libpath = (gchar *) realloc( cfg->libpath, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->libpath, arg );
                    continue;
                }

                if( !strcmp( key, "LDOPT:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->ldopt = (gchar *) realloc( cfg->ldopt, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->ldopt, arg );
                    continue;
                }

                if( !strcmp( key, "BASH:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->bash = (gchar *) realloc( cfg->bash, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->bash, arg );
                    continue;
                }

                if( !strcmp( key, "XTERM:" ) )
                {
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->xterm = (gchar *) realloc( cfg->xterm, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->xterm, arg );
                    continue;
                }
#ifdef HAVE_GTKTEXT_PATCH
                if( !strcmp( key, "EDTAB:" ) )
                {
                    cfg->edtab = atoi( arg );
                    continue;
                }
#endif
		
				if( !strcmp( key, "DB:" ) )
				{
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->db = (gchar *) realloc( cfg->db, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->db, arg );
                    continue;
				}

				if( !strcmp( key, "MAN:" ) )
				{
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->man = (gchar *) realloc( cfg->man, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->man, arg );
                    continue;
				}

				if( !strcmp( key, "EMAIL:" ) )
				{
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->email = (gchar *) realloc( cfg->email, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->email, arg );
                    continue;
				}

				if( !strcmp( key, "SMTP:" ) )
				{
                    strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
                    cfg->smtp = (gchar *) realloc( cfg->smtp, (strlen( arg ) + 1) * sizeof( gchar ) );
                    strcpy( cfg->smtp, arg );
                    continue;
				}

				if( !strcmp( key, "SOR:" ) )
				{
					cfg->sor = atoi( arg );
                    continue;
				}
            }
        }
    }

    fclose( cfgfile );

    return( 1 );
}


gint iscomment( gchar *arg )
{
    if( arg[0] == '#' || arg[0] == ';' )
        return( 1 );
    else
        return( 0 );
}

gint __isblank( gchar *arg )
{
    if( strlen( arg ) == 0 )
        return( 1 );
    else
       	return( 0 );
}


gint isnull( gchar *arg )
{
    if( !arg )
        return( 1 );
    else
        return( 0 );
}

#endif /*HAVE_LIBGUILE*/


glong load_compile_sets( gchar *cset_file )
{
	FILE *f_cset;
	gchar buf[STRLEN];
	gI_comp_set *cset = NULL;
	gchar *fnwp;
	gchar *ptr;

	if( !cset_file )
	{
		return( 0 );
	}

	fnwp = g_strconcat( gide_path, "/", cset_file, NULL );
	f_cset = fopen( fnwp, "r" );
	if( !f_cset )
	{
		g_warning( "Unable to open Compile-Sets File!\n" );
		g_free( fnwp );
		return( 0 );
	}		
	g_free( fnwp );

	cfg->csets = NULL;

	while( fgets( buf, sizeof(buf), f_cset ) )
	{
		while( (ptr = strchr( buf, '\n' )) )
		{
			if( ptr )
				*ptr = '\0';
		}

		switch( buf[0] )
		{
			case '#':
			{
				/* comment */

				break;
			}

			case '0':
			{
				/* head, new set */
				cset = (gI_comp_set *) g_malloc0( sizeof( gI_comp_set ) );	
				cset->cset = g_strdup( &buf[1] );

				break;
			}

			case '1':
			{
				/* file pattern */
				cset->fpat = g_strdup( &buf[1] );
			
				break;	
			}
 
			case '2':
			{
				/* compiler */
				cset->compiler = g_strdup( &buf[1] );

				break;
			}

			case '3':
			{
				/* linker */
				cset->linker = g_strdup( &buf[1] );

				break;
			}

/***
			case '4':
			{
				/- make -/
				cset->make = g_strdup( &buf[1] );

				break;
			}
***/

			case '5':
			{
				/* incpath */
				cset->incpath = g_strdup( &buf[1] );
	
				break;
			}

			case '6':
			{
				/* ccopt */
				cset->ccopt = g_strdup( &buf[1] );
				
				break;
			}

			case '7':
			{
				/* libpath */
				cset->libpath = g_strdup( &buf[1] );

				break;
			}


			case '8':
			{
				/* ldopt */
				cset->ldopt = g_strdup( &buf[1] );

				break;
			}

			case '9':
			{
				/* compile cmdline, exec */
				cset->c_cmdline_exec = g_strdup( &buf[1] );

				break;
			}			

			case 'A':
			{
				/* compile cmdline */
				cset->c_cmdline_obj = g_strdup( &buf[1] );

				break;
			}			

			case 'B':
			{
				/* link cmdline, it's complete */
				cset->l_cmdline = g_strdup( &buf[1] );

				if( !cfg->csets )
				{
					cfg->csets = g_list_alloc();
				}
				cfg->csets = g_list_prepend( cfg->csets, (gpointer) cset );

				break;
			}			

			default:
			{
				/* should not happen */
				g_warning( "Parsing Error in Compile Sets File\n" );

				break;
			}
		}
	}

	fclose( f_cset );

	return( 1 );
}


