/* $Header: /cvs/gnome/gIDE/src/gI_hilite.c,v 1.5 1999/11/23 21:14:10 jpr Exp $ */
/*  gIDE
 *  Copyright (C) 1998-2000 Steffen Kern
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>

#ifdef HAVE_GTKTEXT_PATCH

#include <gnome.h>
#include <gtkeditor/gtkeditor.h>

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "structs.h"
#include "gI_document.h"
#include "gI_menus.h"

#include "gI_common.h"

#include "gI_hilite.h"

extern gI_window *main_window;
extern gI_config *cfg;
extern gchar gide_path[];

typedef struct _Pattern {
  gchar                   *name;
  gI_HilitePattern  pat;
} Pattern;
static GList *known_patterns = NULL;
static GList *known_pattern_names = NULL;

static void            patname_changed_cb          (GtkEntry    *nameentry,
						    gI_pat_dialog  *dd);
static void            install_pattern_cb          (GtkWidget   *dummy,
						    gI_pat_dialog  *dd);
static void            close_dialog                (GtkWidget   *dummy,
						    gI_pat_dialog  *dd);
static void            free_pattern                (Pattern     *pat);


/* --<pattern widget>--------------------------------------------------- */
GtkWidget*
gI_hilite_get_pattern_widget (gI_pat_dialog *pd)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *patname;

  GtkWidget *hseparator;
  GtkWidget *table;

  GtkWidget *combeg;
  GtkWidget *comend;
  GtkWidget *strbeg;
  GtkWidget *strend;
  GtkWidget *chbeg;
  GtkWidget *chend;
  GtkWidget *keywords;
  GtkWidget *types;
  GtkWidget *func_regexp;

  GtkWidget *comcolor;
  GtkWidget *strcolor;
  GtkWidget *chcolor;
  GtkWidget *keywordscolor;
  GtkWidget *typescolor;

  vbox = gtk_vbox_new (FALSE, 5);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 10);
  gtk_widget_show (hbox);

  label = gtk_label_new( _("Pattern name:") );
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  patname = gtk_combo_new();
  pd->patname = GTK_COMBO (patname);
  if (known_pattern_names) {
    gtk_combo_set_popdown_strings (GTK_COMBO (patname), known_pattern_names);
  }
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (patname)->entry), "changed",
		      GTK_SIGNAL_FUNC (patname_changed_cb), pd);
  gtk_widget_show (patname);
  gtk_box_pack_start (GTK_BOX (hbox), patname, TRUE, TRUE, 5);

  hseparator = gtk_hseparator_new ();
  gtk_widget_show (hseparator);
  gtk_box_pack_start (GTK_BOX (vbox),
		      hseparator, TRUE, TRUE, 0);

  /*---------------------------------------------------*/

  table = gtk_table_new (6, 5, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 10);

  label = gtk_label_new( _("Comment begin:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  combeg = gtk_entry_new();
  pd->combeg = GTK_ENTRY (combeg);
  gtk_widget_show (combeg);
  gtk_table_attach (GTK_TABLE (table), combeg, 1, 2, 0, 1,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("Comment end:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 6, 0);

  comend = gtk_entry_new();
  pd->comend = GTK_ENTRY (comend);
  gtk_widget_show (comend);
  gtk_table_attach (GTK_TABLE (table), comend, 3, 4, 0, 1,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  comcolor = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha( GNOME_COLOR_PICKER( comcolor ), FALSE );
  gtk_container_set_border_width( GTK_CONTAINER( comcolor ), 5 );
  pd->comcolor = GNOME_COLOR_PICKER( comcolor );
  gtk_widget_show( comcolor );
  gtk_table_attach (GTK_TABLE (table), comcolor, 4, 5, 0, 1,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("String begin:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  strbeg = gtk_entry_new();
  pd->strbeg = GTK_ENTRY (strbeg);
  gtk_widget_show (strbeg);
  gtk_table_attach (GTK_TABLE (table), strbeg, 1, 2, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("String end:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  strend = gtk_entry_new ();
  pd->strend = GTK_ENTRY (strend);
  gtk_widget_show (strend);
  gtk_table_attach (GTK_TABLE (table), strend, 3, 4, 1, 2,
	    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  strcolor = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha( GNOME_COLOR_PICKER( strcolor ), FALSE );
  gtk_container_set_border_width( GTK_CONTAINER( strcolor ), 5 );
  pd->strcolor = GNOME_COLOR_PICKER( strcolor );
  gtk_widget_show( strcolor );
  gtk_table_attach (GTK_TABLE (table), strcolor, 4, 5, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("Char begin:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  chbeg = gtk_entry_new();
  pd->chbeg = GTK_ENTRY (chbeg);
  gtk_widget_show (chbeg);
  gtk_table_attach (GTK_TABLE (table), chbeg, 1, 2, 2, 3,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("Char end:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 2, 3,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  chend = gtk_entry_new ();
  pd->chend = GTK_ENTRY (chend);
  gtk_widget_show (chend);
  gtk_table_attach (GTK_TABLE (table), chend, 3, 4, 2, 3,
	    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  chcolor = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha( GNOME_COLOR_PICKER( chcolor ), FALSE );
  gtk_container_set_border_width( GTK_CONTAINER( chcolor ), 5 );
  pd->chcolor = GNOME_COLOR_PICKER( chcolor );
  gtk_widget_show( chcolor );
  gtk_table_attach (GTK_TABLE (table), chcolor, 4, 5, 2, 3,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("Keywords:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  keywords = gtk_entry_new();
  pd->keywords = GTK_ENTRY (keywords);
  gtk_widget_show (keywords);
  gtk_table_attach (GTK_TABLE (table), keywords, 1, 4, 3, 4,
                   GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_sensitive( label, FALSE );
  gtk_widget_set_sensitive( keywords, FALSE );
  gtk_object_set_data( GTK_OBJECT( pd->keywords ), "keywords", "\\b" );

  keywordscolor = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha( GNOME_COLOR_PICKER( keywordscolor ), FALSE );
  gtk_container_set_border_width( GTK_CONTAINER( keywordscolor ), 5 );
  pd->keywordscolor = GNOME_COLOR_PICKER( keywordscolor );
  gtk_widget_show( keywordscolor );
  gtk_table_attach (GTK_TABLE (table), keywordscolor, 4, 5, 3, 4,
	    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new( _("Types:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 4, 5,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  types = gtk_entry_new();
  pd->types = GTK_ENTRY (types);
  gtk_widget_show (types);
  gtk_table_attach (GTK_TABLE (table), types, 1, 4, 4, 5,
                   GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  typescolor = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha( GNOME_COLOR_PICKER( typescolor ), FALSE );
  gtk_container_set_border_width( GTK_CONTAINER( typescolor ), 5 );
  pd->typescolor = GNOME_COLOR_PICKER( typescolor );
  gtk_widget_show( typescolor );
  gtk_table_attach (GTK_TABLE (table), typescolor, 4, 5, 4, 5,
	    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  label = gtk_label_new ( _("Function Regexp:") );
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 5, 6,
		    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label), 5, 0);

  func_regexp = gtk_entry_new();
  pd->func_regexp = GTK_ENTRY (func_regexp);
  gtk_widget_show (func_regexp);
  gtk_table_attach (GTK_TABLE (table), func_regexp, 1, 4, 5, 6,
                   GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

  /* Call this now to show the patterns initially on display */
  patname_changed_cb( GTK_COMBO(patname)->entry ,pd);

  return vbox;
}

/* --<menu callbacks>--------------------------------------------------- */
void
gI_hilite_set_buffer_patterns_cb (void)
{
  GtkWidget *dialog;
  GtkWidget *vbox;
  GtkWidget *bbox;
  GtkWidget *ok, *cancel;

  gI_document *doc = gI_document_get_current ( main_window );

  gI_pat_dialog *pd = g_new (gI_pat_dialog, 1);
  pd->buf = GTK_EDITOR ( doc->text );

  dialog = gtk_dialog_new ();
  pd->dialog = dialog;
  gtk_window_set_title (GTK_WINDOW (dialog), _("Specify Patterns") );
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, FALSE, FALSE);

  /*----------------------------------------------------------*/
  
  vbox = gI_hilite_get_pattern_widget (pd);
  gtk_widget_show (vbox);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), vbox, TRUE, TRUE, 5);
  

  /*----------------------------------------------------------*/

  bbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_END);

  ok = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (install_pattern_cb), pd);
  gtk_widget_grab_default (ok);
  gtk_box_pack_start (GTK_BOX (bbox), ok, TRUE, TRUE, 10);
  gtk_widget_show (ok);

  cancel = gnome_stock_button( GNOME_STOCK_BUTTON_CANCEL );
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (cancel), "clicked",
		      GTK_SIGNAL_FUNC (close_dialog), pd);
  gtk_box_pack_start (GTK_BOX (bbox), cancel, TRUE, TRUE, 10);
  gtk_widget_show (cancel);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), bbox);

  gtk_widget_show (bbox);
  gtk_widget_show (dialog);
}

void
gI_hilite_rehilite (void)
{
  GtkEditor *buf;
  gI_document *doc = gI_document_get_current ( main_window );
  if( !doc ) return;
  buf = GTK_EDITOR ( doc->text );
  gtk_editor_hilite_buffer (buf);
}

/* --<dialog callbacks>------------------------------------------ */
static gint
patcmp (Pattern *pat, gchar *name)
{
  g_assert (pat); g_assert (name);
  return strcmp (pat->name, name);
}

static void
patname_changed_cb (GtkEntry *nameentry, gI_pat_dialog *dd)
{
  GdkColormap *cmap = gdk_colormap_get_system();
  GList *tmp;
  Pattern *pat;
  gchar *name = gtk_entry_get_text (nameentry);
  if ( (tmp = g_list_find_custom (known_pattern_names, name,
				  (GCompareFunc)strcmp)) ) {
    tmp = g_list_find_custom (known_patterns, name, (GCompareFunc)patcmp);
    g_assert (tmp);
    pat = (Pattern*)tmp->data;
    gtk_entry_set_text (dd->combeg, pat->pat.comment_start);
    gtk_entry_set_text (dd->comend, pat->pat.comment_end);
    gtk_entry_set_text (dd->strbeg, pat->pat.string_start);
    gtk_entry_set_text (dd->strend, pat->pat.string_end);
    gtk_entry_set_text (dd->chbeg, pat->pat.char_start);
    gtk_entry_set_text (dd->chend, pat->pat.char_end);
    /*gtk_entry_set_text (dd->keywords, pat->pat.keywords);*/ gtk_object_set_data( GTK_OBJECT( dd->keywords ), "keywords",
    			(gpointer) pat->pat.keywords );
    gtk_entry_set_text (dd->types, pat->pat.types);
    gtk_entry_set_text (dd->func_regexp, pat->pat.funcs);

    gdk_color_alloc( cmap, &pat->pat.comment_color );
    gdk_color_alloc( cmap, &pat->pat.string_color );
    gdk_color_alloc( cmap, &pat->pat.char_color );
    gdk_color_alloc( cmap, &pat->pat.keywords_color );
    gdk_color_alloc( cmap, &pat->pat.types_color );

    gnome_color_picker_set_i16( dd->comcolor, pat->pat.comment_color.red,
		    			      pat->pat.comment_color.green,
					      pat->pat.comment_color.blue,
					      0 );
    gnome_color_picker_set_i16( dd->strcolor, pat->pat.string_color.red,
		    			      pat->pat.string_color.green,
					      pat->pat.string_color.blue,
					      0 );
    gnome_color_picker_set_i16( dd->chcolor, pat->pat.char_color.red,
		    			      pat->pat.char_color.green,
					      pat->pat.char_color.blue,
					      0 );
    gnome_color_picker_set_i16( dd->keywordscolor, pat->pat.keywords_color.red,
		    			      pat->pat.keywords_color.green,
					      pat->pat.keywords_color.blue,
					      0 );
    gnome_color_picker_set_i16( dd->typescolor, pat->pat.types_color.red,
		    			      pat->pat.types_color.green,
					      pat->pat.types_color.blue,
					      0 );
  }
}


static void
close_dialog (GtkWidget *dummy, gI_pat_dialog *dd)
{
  gtk_widget_destroy (dd->dialog);
  g_free (dd);
}


gint gI_hilite_install_pattern( GtkEditor *editor, gI_HilitePattern *pat )
{
	gchar *StringName, *CharName, *CommentName, *KeywordsName, *TypesName;
	GList *tmpls;
	GdkColormap *cmap = gdk_colormap_get_system();

	/* create descriptions */
	StringName = g_strdup_printf( "%s-Strings", pat->name );
	CommentName = g_strdup_printf( "%s-Comments", pat->name );
	KeywordsName = g_strdup_printf( "%s-Keywords", pat->name );
	CharName = g_strdup_printf( "%s-Char", pat->name );	
	TypesName = g_strdup_printf( "%s-Types", pat->name );

  	gdk_color_alloc( cmap, &pat->comment_color );
    	gdk_color_alloc( cmap, &pat->string_color );
      	gdk_color_alloc( cmap, &pat->char_color );
        gdk_color_alloc( cmap, &pat->keywords_color );
	gdk_color_alloc( cmap, &pat->types_color );

	/* create stentries for 'Comment', 'String' and 'Char' Patterns */
	tmpls = gtk_editor_stentry_new( CommentName,
         	  	                pat->comment_start, pat->comment_end, FALSE,
                             	  	NULL, &pat->comment_color, NULL, 
	  		gtk_editor_stentry_new( StringName,
                                  	pat->string_start, pat->string_end, FALSE,
                                  	NULL, &pat->string_color, NULL,
	  		gtk_editor_stentry_new( CharName,
                                  	pat->char_start, pat->char_end, FALSE,
                                  	NULL, &pat->char_color, NULL, NULL ) ) );

	/* install patterns */	
	gtk_editor_install_stable( editor, tmpls );

	/* free stentries */
	//gtk_editor_free_stentries( tmpls );

	/* create pentries for 'Keywords' and 'Types' Patterns */
	tmpls = gtk_editor_pentry_new( KeywordsName,
		                       pat->keywords,
                                       NULL, &pat->keywords_color, NULL,
		gtk_editor_pentry_new( TypesName,
		                       pat->types,
                                       NULL, &pat->types_color, NULL, NULL ) );

	/* install patterns */	
	gtk_editor_install_patterns( editor, tmpls );

	/* free pentries */
	//gtk_editor_free_pentries( tmpls );

	/* free descriptions */
	g_free( StringName );
	g_free( CommentName );
	g_free( KeywordsName );
	g_free( CharName );
	g_free( TypesName );

	return TRUE;
}


void
gI_hilite_add_pattern_dia (gI_pat_dialog *pd)
{
  Pattern *pat;
  GList *tmpls;
  /*GtkEditorHilitePatterns *tmp;*/

  pat = g_new (Pattern, 1);
  pat->name = g_strdup (gtk_entry_get_text (GTK_ENTRY (pd->patname->entry)));
  pat->pat.name = g_strdup( pat->name );
  pat->pat.comment_start = g_strdup (gtk_entry_get_text (pd->combeg));
  pat->pat.comment_end = g_strdup (gtk_entry_get_text (pd->comend));
  pat->pat.string_start = g_strdup (gtk_entry_get_text (pd->strbeg));
  pat->pat.string_end = g_strdup (gtk_entry_get_text (pd->strend));
  pat->pat.char_start = g_strdup (gtk_entry_get_text (pd->chbeg));
  pat->pat.char_end = g_strdup (gtk_entry_get_text (pd->chend));
  pat->pat.keywords = /*g_strdup (gtk_entry_get_text (pd->keywords));*/
	  	      g_strdup( (gchar *) gtk_object_get_data( GTK_OBJECT( pd->keywords ), "keywords" ) );
  pat->pat.types = g_strdup (gtk_entry_get_text (pd->types));
  pat->pat.funcs = g_strdup (gtk_entry_get_text (pd->func_regexp));

    gnome_color_picker_get_i16( pd->comcolor, &pat->pat.comment_color.red,
	                                      &pat->pat.comment_color.green,
	                                      &pat->pat.comment_color.blue,
	                                      0 );
    gnome_color_picker_get_i16( pd->strcolor, &pat->pat.string_color.red,
                                              &pat->pat.string_color.green,
                                              &pat->pat.string_color.blue,
					      0 );
    gnome_color_picker_get_i16( pd->chcolor, &pat->pat.char_color.red,
                                             &pat->pat.char_color.green,
					     &pat->pat.char_color.blue,
				             0 );
    gnome_color_picker_get_i16( pd->keywordscolor, &pat->pat.keywords_color.red,
	                                 	   &pat->pat.keywords_color.green,
				                   &pat->pat.keywords_color.blue,
						   0 );
    gnome_color_picker_get_i16( pd->typescolor, &pat->pat.types_color.red,
		                                &pat->pat.types_color.green,
						&pat->pat.types_color.blue,
						0 );

  if (!(pat->name[0] && pat->pat.comment_start[0] && pat->pat.comment_end[0]
	&& pat->pat.string_start[0] && pat->pat.string_end[0]
	&& pat->pat.char_start[0] && pat->pat.char_end[0]
	&& pat->pat.keywords[0] && pat->pat.types[0] )) {
    free_pattern (pat);
    gI_error_dialog( _("Pattern Error: You must specify all entries!") );
    return;
  }
/*
  if ( !(tmp = gtk_editor_new_regexps (&pat->pat)) ) {
    free_pattern (pat);
    gI_error_dialog( "Pattern Error: Regex compile error!");
  } else {
    gtk_editor_destroy_regexps (tmp);
  }
*/
  if ( (tmpls = g_list_find_custom (known_patterns, pat->name,
				  (GCompareFunc)patcmp)) ) {
    free_pattern ((Pattern*)tmpls->data);
    known_patterns = g_list_remove_link (known_patterns, tmpls);
    g_list_free_1 (tmpls);
  }
  known_patterns = g_list_prepend (known_patterns, pat);
  if ( !g_list_find_custom (known_pattern_names, pat->name,
			    (GCompareFunc)strcmp) ) {
    known_pattern_names = g_list_prepend (known_pattern_names, pat->name);
  }

  if (known_pattern_names) {
    gtk_combo_set_popdown_strings (pd->patname, known_pattern_names);
  }
}

void
gI_hilite_add_pattern_dia_cb (GtkWidget *dummy, gI_pat_dialog *pd)
{
  gI_hilite_add_pattern_dia (pd);
}


static void
add_pattern (Pattern *pat)
{
  GList *tmpls;
/*  GtkEditorHiliteRegexps *tmp;

  g_assert (pat);

  if ( !(tmp = gtk_editor_new_regexps (&pat->pat)) ) {
    free_pattern (pat);
    g_warning ("Regex compile error!");
  } else {
    gtk_editor_destroy_regexps (tmp);
  }
*/
  if ( (tmpls = g_list_find_custom (known_patterns, pat->name,
				    (GCompareFunc)patcmp)) ) {
    free_pattern ((Pattern*)tmpls->data);
    known_patterns = g_list_remove_link (known_patterns, tmpls);
    g_list_free_1 (tmpls);
  }
  known_patterns = g_list_prepend (known_patterns, pat);
  if ( !g_list_find_custom (known_pattern_names, pat->name,
			    (GCompareFunc)strcmp) ) {
    known_pattern_names = g_list_prepend (known_pattern_names, pat->name);
  }
}

/* a wrapper used around add_pattern...needed as a hack for the guile
 * support...maybe it should be re-implemented later...*/
void
gI_hilite_add_named_pattern (const gchar *patname,
			     const gI_HilitePattern *pat)
{
  Pattern *new = g_new (Pattern, 1);
  new->name = g_strdup (patname);
  new->pat = *pat;
  add_pattern (new);
}

void
gI_hilite_remove_pattern_dia (gI_pat_dialog *pd)
{
  GList *tmp;
  /* NB! do *not* free */
  gchar *name =  gtk_entry_get_text (GTK_ENTRY (pd->patname->entry));

  if ( (tmp = g_list_find_custom (known_patterns, name,
				  (GCompareFunc)patcmp)) ) {
    free_pattern ((Pattern*)tmp->data);
    known_patterns = g_list_remove_link (known_patterns, tmp);
    g_list_free_1 (tmp);
  }
  if ( (tmp = g_list_find_custom (known_pattern_names, name,
				  (GCompareFunc)strcmp)) ) {
    known_pattern_names = g_list_remove_link (known_pattern_names, tmp);
    g_list_free_1 (tmp);
  }

  if (known_pattern_names) {
    gtk_combo_set_popdown_strings (pd->patname, known_pattern_names);
  }
}

void
gI_hilite_remove_pattern_dia_cb (GtkWidget *dummy, gI_pat_dialog *pd)
{
  gI_hilite_remove_pattern_dia (pd);
}


static void
install_pattern_cb (GtkWidget *dummy, gI_pat_dialog *pd)
{
  Pattern *pat;

  pat = g_new (Pattern, 1);
  pat->name = g_strdup (gtk_entry_get_text (GTK_ENTRY (pd->patname->entry)));
  pat->pat.name = g_strdup( pat->name );
  pat->pat.comment_start = g_strdup (gtk_entry_get_text (pd->combeg));
  pat->pat.comment_end = g_strdup (gtk_entry_get_text (pd->comend));
  pat->pat.string_start = g_strdup (gtk_entry_get_text (pd->strbeg));
  pat->pat.string_end = g_strdup (gtk_entry_get_text (pd->strend));
  pat->pat.char_start = g_strdup (gtk_entry_get_text (pd->chbeg));
  pat->pat.char_end = g_strdup (gtk_entry_get_text (pd->chend));
  pat->pat.keywords = /*g_strdup (gtk_entry_get_text (pd->keywords));*/ g_strdup( (gchar *) gtk_object_get_data( GTK_OBJECT( pd->keywords ),
			 "keywords" ) );
  pat->pat.types = g_strdup (gtk_entry_get_text (pd->types));
  pat->pat.funcs = g_strdup (gtk_entry_get_text (pd->func_regexp));

  if (!(pat->name[0] && pat->pat.comment_start[0] && pat->pat.comment_end[0]
	&& pat->pat.string_start[0] && pat->pat.string_end[0]
	&& pat->pat.char_start[0] && pat->pat.char_end[0]
	&& pat->pat.keywords[0] )) {
    gI_error_dialog( _("Pattern Error: You must specify all entries!") );
    return;
  }

  gnome_color_picker_get_i16( pd->comcolor, &pat->pat.comment_color.red,
		  			    &pat->pat.comment_color.green,
					    &pat->pat.comment_color.blue,
					    0 );
  gnome_color_picker_get_i16( pd->strcolor, &pat->pat.string_color.red,
		  			    &pat->pat.string_color.green,
					    &pat->pat.string_color.blue,
					    0 );
  gnome_color_picker_get_i16( pd->chcolor, &pat->pat.char_color.red,
		  			    &pat->pat.char_color.green,
					    &pat->pat.char_color.blue,
					    0 );
  gnome_color_picker_get_i16( pd->keywordscolor, &pat->pat.keywords_color.red,
		  			    &pat->pat.keywords_color.green,
					    &pat->pat.keywords_color.blue,
					    0 );
  gnome_color_picker_get_i16( pd->typescolor, &pat->pat.types_color.red,
		  			    &pat->pat.types_color.green,
					    &pat->pat.types_color.blue,
					    0 );


  if ( !(gI_hilite_install_pattern( pd->buf, &pat->pat )) ) {
    free_pattern (pat);
    gI_error_dialog( _("Pattern Error: Could not compile patterns!") );
    return ;
  } else {
    GList *tmp;
    if ( (tmp = g_list_find_custom (known_patterns, pat->name,
				    (GCompareFunc)patcmp)) ) {
      free_pattern ((Pattern*)tmp->data);
      known_patterns = g_list_remove_link (known_patterns, tmp);
      g_list_free_1 (tmp);
    }
    known_patterns = g_list_prepend (known_patterns, pat);
    if ( !g_list_find_custom (known_pattern_names, pat->name,
			      (GCompareFunc)strcmp) ) {
      known_pattern_names = g_list_prepend (known_pattern_names, pat->name);
    }
    gtk_editor_hilite_buffer (pd->buf);
  }

  gtk_widget_destroy (pd->dialog);
}

void
gI_hilite_set_pattern (GtkWidget *buf, gchar *pattern_name)
{
  GList *tmp;

  tmp = g_list_find_custom (known_patterns, pattern_name,
			    (GCompareFunc)patcmp);
  g_return_if_fail (tmp != NULL);

  gI_hilite_install_pattern( GTK_EDITOR( buf ), &((Pattern*)tmp->data)->pat ); 
  gtk_editor_hilite_buffer (GTK_EDITOR (buf));
}

/* --<load'n'save>------------------------------------------------ */
/* FIXME: The non-guile stuff is *very* primitive...they should probably be
 * be reimplemented or discarded all together if we move entirely to guile */

#if !HAVE_LIBGUILE
static gchar*
check_string (FILE *file) 
{
  gchar buf[MAXLEN];
  gint c, i;

  while (isspace ( (c = fgetc (file)) ));
  if (c != '"') {
    return NULL;
  }
  
  i = 0;
  while (((c = fgetc(file)) != EOF)) {
    if (c == '\\') {
      switch ( (c = fgetc(file)) ) {
      case 'n': 
	buf[i] = '\n';
	break;
      case '"':
	buf[i] = '"';
	break;
      case EOF:
	return NULL;
	break;
      default:
	buf[i] = c;
      }
    } else if (c == '"') {
      break;
    } else {
      buf[i] = c;
    }
    i++;
    if (i > MAXLEN - 2)
      break;
  }
  buf[i] = 0;
  return g_strdup(buf);
}

static gboolean
checkc (FILE *file, gint c)
{
  gint tmp;
  while (isspace ( ( tmp = fgetc (file)) ));
  if (tmp == c) {
    return TRUE;
  } else {
    return FALSE;
  }
}

void
gI_hilite_load_patterns ( const gchar *filename )
{
  Pattern *pat;
  gchar *TempColor;
  FILE *file = fopen (filename, "r");
  if (!file) {
    g_warning ("Could not open pattern config file: %s", filename);
    return;
  }

  while (checkc (file, '(')) {
    pat = g_new (Pattern, 1);

    if (! (pat->name = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat);
      fclose (file);
      return;
    }
  
    pat->pat.name = g_strdup( pat->name );

    if (! (pat->pat.comment_start = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat);
      fclose (file);
      return;
    }
    
    if (! (pat->pat.comment_end = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat);
      fclose (file);
      return;
    }

    if (! (TempColor = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat);
      fclose (file);
      return;
    }
  
    if( sscanf( TempColor, "%hu %hu %hu", &(pat->pat.comment_color.red),
			    		  &(pat->pat.comment_color.green),
					  &(pat->pat.comment_color.blue)) != 3 )
    {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat);
      fclose (file);
      g_free( TempColor );
      return;
    }		
    g_free( TempColor );


    if (! (pat->pat.string_start = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat);
      fclose (file);
      return;
    }
    
    if (! (pat->pat.string_end = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat);
      fclose (file);
      return;
    }
    
    if (! (TempColor = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat);
      fclose (file);
      return;
    }
  
    if( sscanf( TempColor, "%hu %hu %hu", &(pat->pat.string_color.red),
			    		  &(pat->pat.string_color.green),
					  &(pat->pat.string_color.blue)) != 3 )
    {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat);
      fclose (file);
      g_free( TempColor );
      return;
    }		
    g_free( TempColor );

    if (! (pat->pat.char_start = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat);
      fclose (file);
      return;
    }
    
    if (! (pat->pat.char_end = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat);
      fclose (file);
      return;
    }

    if (! (TempColor = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat);
      fclose (file);
      return;
    }
  
    if( sscanf( TempColor, "%hu %hu %hu", &(pat->pat.char_color.red),
			    		  &(pat->pat.char_color.green),
					  &(pat->pat.char_color.blue)) != 3 )
    {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat);
      fclose (file);
      g_free( TempColor );
      return;
    }

    if (! (pat->pat.keywords = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat);
      fclose (file);
      return;
    }

    g_free( pat->pat.keywords );
    pat->pat.keywords = create_keywords_pattern( pat->name );
    if( !pat->pat.keywords )
	pat->pat.keywords = g_strdup( "\\b" );
    
    if (! (TempColor = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat);
      fclose (file);
      return;
    }
  
    if( sscanf( TempColor, "%hu %hu %hu", &(pat->pat.keywords_color.red),
			    		  &(pat->pat.keywords_color.green),
					  &(pat->pat.keywords_color.blue)) != 3 )
    {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat);
      fclose (file);
      g_free( TempColor );
      return;
    }

    if (! (pat->pat.types = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat);
      fclose (file);
      return;
    }

    if (! (TempColor = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat->pat.types);
      g_free (pat);
      fclose (file);
      return;
    }
  
    if( sscanf( TempColor, "%hu %hu %hu", &(pat->pat.types_color.red),
			    		  &(pat->pat.types_color.green),
					  &(pat->pat.types_color.blue)) != 3 )
    {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat->pat.types);
      g_free (pat);
      fclose (file);
      g_free( TempColor );
      return;
    }
    g_free( TempColor );

   if (! (pat->pat.funcs = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat->pat.types);
      g_free (pat);
      fclose (file);
      return;
   }

   if (! (TempColor = check_string (file)) ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat->pat.types);
      g_free (pat->pat.funcs);
      g_free (pat);
      fclose (file);
      return;
   }

    if (! checkc (file, ')') ) {
      gI_error_dialog( _("Syntax error in pattern resource file") );
      g_free (pat->name);
      g_free (pat->pat.comment_start);
      g_free (pat->pat.comment_end);
      g_free (pat->pat.string_start);
      g_free (pat->pat.string_end);
      g_free (pat->pat.char_start);
      g_free (pat->pat.char_end);
      g_free (pat->pat.keywords);
      g_free (pat->pat.types);
      g_free (pat);
      fclose (file);
      return;
    }

    add_pattern (pat);
  }

  fclose (file);
}
#endif /*!HAVE_LIBGUILE*/

static void
quotestr (const gchar *src, gchar *dst)
{
  gint i, j;
  gint len;

  g_assert (src);
  g_assert (dst);

  len = strlen (src);
  
  for (i = j = 0; (i < len) && (j < MAXLEN); i++, j++) {
    if (src[i] == '"' || src[i] == '\\') {
      dst[j++] = '\\';
    }
    dst[j] = src[i];
  }
  dst[j] = '\0';
}

#if HAVE_LIBGUILE
static void
save_pattern_map (Pattern *pat, FILE *file)
{
  gchar tmp[MAXLEN];
  fprintf (file, "(define %s '(", pat->name);
  quotestr (pat->pat.comment_start, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.comment_end, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.string_start, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.string_end, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.char_start, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.char_end, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr ("\\b", tmp);
  /*quotestr (pat->pat.keywords, tmp);*/
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.types, tmp);
  fprintf (file, "\"%s\" ", tmp);
  quotestr (pat->pat.funcs, tmp);
  fprintf (file, "\"%s\" ", tmp);
  fprintf( file, "\"%u %u %u\" ", pat->pat.comment_color.red, pat->pat.comment_color.green, pat->pat.comment_color.blue );
  fprintf( file, "\"%u %u %u\" ", pat->pat.string_color.red, pat->pat.string_color.green, pat->pat.string_color.blue );
  fprintf( file, "\"%u %u %u\" ", pat->pat.char_color.red, pat->pat.char_color.green, pat->pat.char_color.blue );
  fprintf( file, "\"%u %u %u\" ", pat->pat.keywords_color.red, pat->pat.keywords_color.green, pat->pat.keywords_color.blue );
  fprintf( file, "\"%u %u %u\"))\n", pat->pat.types_color.red, pat->pat.types_color.green, pat->pat.types_color.blue );
}

static void
save_pattern_list_map (gchar *patname, FILE *file)
{
  fprintf (file, "%s ", patname);
}


void
gI_hilite_save_patterns ( const gchar *filename )
{
  FILE *file, *backup;
  gchar *backupname = g_strconcat (filename, "~", NULL);
  gchar *tmp;

  rename (filename, backupname);

  file = fopen (filename, "w");
  if (!file) {
    g_warning ("Could not open pattern config file: %s", filename);
    g_free (backupname);
    return;
  }

  /* write header */

  fprintf (file, ";;; gIDE %s Highlight pattern file\n;;;\n", VERSION);
  fprintf (file, ";;; Everything from the beginning of this file and on to\n");
  fprintf (file, ";;; \";;;AUTOMATIC-END\" should not be hand edited, since gIDE\n");
  fprintf (file, ";;; will change this when saving the preferences.\n;;;\n");
  fprintf (file, ";;; Add your hooks after \";;;AUTOMATIC-END\".\n");

  /* write the patterns */
  fprintf (file, "\n;; Pattern definitions\n");
  g_list_foreach (known_patterns, (GFunc)save_pattern_map, file);

  /* write pattern list */
  fprintf (file, "\n;; Pattern list\n");
  fprintf (file, "(define hilite-pattern-list\n\t'(");
  g_list_foreach (known_pattern_names, (GFunc)save_pattern_list_map, file);
  fprintf (file, "))\n");

  fprintf (file, "\n;;;AUTOMATIC-END\n");

  /* attach user hooks */
  if ( (backup = fopen (backupname, "r")) ) {
    tmp = g_malloc (MAXLEN);
    
    while ( fgets (tmp, MAXLEN, backup) ) {
      if (strncmp (tmp, ";;;AUTOMATIC-END", 16) == 0)
	break;			/* end of automatic generated */
    }
    while ( fgets (tmp, MAXLEN, backup) ) {
      fputs (tmp, file);
    }
    
    g_free (tmp);
    fclose (backup);
  }
  
  g_free (backupname);
  fclose (file);
}

#else  /* if !HAVE_LIBGUILE */
static void
save_pattern_map (Pattern *pat, FILE *file)
{
  gchar tmp[MAXLEN];
  fprintf (file, "(\"%s\"\n", pat->name);
  quotestr (pat->pat.comment_start, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  quotestr (pat->pat.comment_end, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  fprintf( file, "\t \"%u %u %u\"\n", pat->pat.comment_color.red, pat->pat.comment_color.green, pat->pat.comment_color.blue );
  quotestr (pat->pat.string_start, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  quotestr (pat->pat.string_end, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  fprintf( file, "\t \"%u %u %u\"\n", pat->pat.string_color.red, pat->pat.string_color.green, pat->pat.string_color.blue );
  quotestr (pat->pat.char_start, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  quotestr (pat->pat.char_end, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  fprintf( file, "\t \"%u %u %u\"\n", pat->pat.char_color.red, pat->pat.char_color.green, pat->pat.char_color.blue );
  quotestr (pat->pat.keywords, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  fprintf( file, "\t \"%u %u %u\"\n", pat->pat.keywords_color.red, pat->pat.keywords_color.green, pat->pat.keywords_color.blue );
  quotestr (pat->pat.types, tmp);
  fprintf (file, "\t \"%s\"\n", tmp);
  fprintf( file, "\t \"%u %u %u\"\n", pat->pat.types_color.red, pat->pat.types_color.green, pat->pat.types_color.blue );
  quotestr (pat->pat.funcs, tmp);
  fprintf (file, "\t \"%s\")\n", tmp);
}

void
gI_hilite_save_patterns ( const gchar *filename )
{
  FILE *file = fopen (filename, "w");
  if (!file) {
    g_warning ("Could not open pattern config file: %s", filename);
    return;
  }

  g_list_foreach (known_patterns, (GFunc)save_pattern_map, file);

  fclose (file);
}
#endif

/* --<misc.>------------------------------------------------------ */
static void
free_pattern (Pattern *pat)
{
  g_free (pat->pat.comment_start);
  g_free (pat->pat.comment_end);
  g_free (pat->pat.string_start);
  g_free (pat->pat.string_end);
  g_free (pat->pat.char_start);
  g_free (pat->pat.char_end);
  g_free (pat->pat.keywords);
  g_free (pat->pat.types);
  g_free (pat->pat.funcs);
  g_free (pat->pat.name);
  g_free (pat);
}

gI_HilitePattern*
gI_hilite_get_pattern_by_name (gchar *name)
{
  GList *tmp;

  g_return_val_if_fail (name != NULL, NULL);

  if (! (tmp = g_list_find_custom (known_patterns, name,
				   (GCompareFunc)patcmp)) ) {
    return NULL;
  }

  return &((Pattern*)tmp->data)->pat;
}


gchar*
create_keywords_pattern( gchar *patname )
{
	FILE *fp;
	gchar buf[STRLEN];
	gchar *pat = NULL;
	gint found = 0;
	gchar *patname_brackets = g_strdup_printf( "[%s]", patname );
	gchar *prefix = "\\b\\(";
	gchar *suffix = "\\)\\b";
	gchar *pattern = NULL;
	gchar *filename;

	if( !patname || isempty( patname ) )
		return NULL;

	if( !cfg || !cfg->hli_file || isempty( cfg->hli_file ) )
		return NULL;

	filename = g_strdup_printf( "%s/%s", gide_path, cfg->hli_file );
	fp = fopen( filename, "r" );
	if( !fp )
	{
		return NULL;
	}
	g_free( filename );

	while( fgets( buf, sizeof(buf), fp ) )
	{
		if( !found )
		{
			if( strncmp( buf, patname_brackets, strlen(patname_brackets) ) == 0 )
				found = 1;
		}
		else
		{
			if( isspace( buf[0] ) )
				continue;

			if( buf[0] == '[' )
				break;

			if( buf[strlen(buf)-1] == '\n' )
				buf[strlen(buf)-1] = '\0';

			if( !pat )	
			{
				pat = g_strdup( buf );

			}
			else
			{
				pat = g_strdup_printf( "%s\\|%s", pat, buf );
			}
		}
	}

	fclose( fp );

	g_free( patname_brackets );

	if( found && pat )
	{
		pattern = g_strdup_printf( "%s%s%s", prefix, pat, suffix );
		g_free( pat );
	}

	return pattern;
}

#endif /*HAVE_GTKTEXT_PATCH*/

