indexing

	description:

		"Eiffel parsers"

	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 1999, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 1999/10/02 12:49:30 $"
	revision:   "$Revision: 1.9 $"

class EIFFEL_PARSER

inherit

	YY_PARSER_SKELETON [ANY]
		rename
			make as make_parser_skeleton
		redefine
			report_error
		end

	EIFFEL_SCANNER
		rename
			make as make_eiffel_scanner
		end

	KL_SHARED_EXCEPTIONS
	KL_SHARED_ARGUMENTS

creation

	make, execute, benchmark


feature {NONE} -- Implementation

	yy_build_parser_tables is
			-- Build parser tables.
		do
			yytranslate ?= yytranslate_template
			yyr1 ?= yyr1_template
			yyr2 ?= yyr2_template
			yydefact ?= yydefact_template
			yydefgoto ?= yydefgoto_template
			yypact ?= yypact_template
			yypgoto ?= yypgoto_template
			yytable ?= yytable_template
			yycheck ?= yycheck_template
		end

feature {NONE} -- Semantic actions

	yy_do_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
			inspect yy_act
			else
					-- No action
				yyval := yyval_default
			end
		end

feature {NONE} -- Table templates

	yytranslate_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    0,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,  122,    2,    2,  124,    2,    2,    2,
			  120,  121,  105,  103,  115,  104,  123,  106,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,  114,  113,
			   99,   97,  100,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,  116,    2,  117,  109,    2,    2,    2,    2,    2,

			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,  118,    2,  119,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,

			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    1,    2,    3,    4,
			    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
			   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
			   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
			   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,

			   45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
			   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
			   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
			   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
			   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
			   95,   96,   98,  101,  102,  107,  108,  110,  111,  112>>)
		end

	yyr1_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    0,  125,  125,  126,  126,  135,  127,  127,  136,  136,
			  136,  137,  137,  137,  137,  139,  139,  139,  140,  140,
			  142,  142,  138,  138,  128,  144,  144,  144,  144,  129,
			  129,  145,  145,  145,  146,  146,  130,  130,  134,  148,
			  148,  148,  148,  148,  148,  149,  149,  149,  149,  149,
			  150,  150,  151,  151,  151,  151,  151,  152,  153,  154,
			  155,  156,  157,  166,  166,  166,  162,  158,  158,  168,
			  168,  168,  169,  169,  169,  170,  172,  172,  173,  173,
			  173,  171,  175,  175,  174,  174,  174,  164,  160,  160,
			  163,  159,  159,  165,  161,  161,  131,  131,  131,  176,

			  177,  177,  177,  132,  132,  132,  178,  179,  179,  179,
			  180,  180,  180,  181,  183,  186,  186,  187,  187,  187,
			  182,  182,  189,  189,  167,  167,  167,  190,  190,  190,
			  190,  191,  191,  191,  191,  191,  191,  191,  191,  191,
			  191,  191,  191,  191,  191,  191,  191,  191,  191,  184,
			  184,  192,  192,  192,  193,  193,  193,  194,  195,  195,
			  185,  185,  188,  199,  199,  199,  199,  203,  203,  198,
			  198,  197,  197,  197,  200,  200,  200,  133,  133,  204,
			  204,  204,  205,  205,  205,  206,  206,  201,  201,  196,
			  196,  196,  196,  196,  196,  196,  147,  209,  210,  210,

			  211,  211,  211,  202,  202,  202,  212,  212,  212,  212,
			  212,  212,  212,  212,  212,  212,  213,  213,  222,  222,
			  215,  224,  224,  216,  226,  226,  225,  225,  225,  217,
			  227,  227,  227,  228,  228,  228,  229,  229,  230,  230,
			  230,  218,  231,  231,  231,  231,  219,  232,  232,  233,
			  233,  233,  220,  214,  214,  214,  214,  214,  214,  214,
			  214,  234,  234,  223,  223,  235,  235,  235,  236,  236,
			  237,  237,  237,  237,  221,  221,  207,  207,  207,  207,
			  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
			  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,

			  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
			  207,  207,  207,  240,  240,  240,  239,  239,  239,  143,
			  143,  143,  143,  143,  143,  238,  238,  208,  208,  208,
			  241,  241,  241,  141,  141>>)
		end

	yyr2_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    0,    1,    2,    8,    5,    3,    0,    2,    0,    1,
			    2,    1,    2,    3,    4,    1,    3,    2,    1,    3,
			    1,    1,    1,    2,    3,    0,    1,    1,    1,    0,
			    3,    0,    2,    4,    0,    2,    0,    2,    2,    2,
			    4,    4,    2,    5,    5,    1,    3,    4,    3,    4,
			    0,    1,    1,    1,    1,    1,    1,    6,    5,    4,
			    3,    2,    2,    0,    3,    5,    2,    0,    1,    0,
			    1,    2,    1,    2,    3,    2,    1,    1,    0,    1,
			    3,    3,    0,    1,    0,    1,    3,    2,    0,    1,
			    2,    0,    1,    2,    0,    1,    0,    1,    2,    3,

			    0,    1,    3,    0,    1,    2,    3,    0,    1,    2,
			    1,    2,    3,    2,    3,    0,    2,    1,    1,    1,
			    1,    3,    1,    2,    1,    2,    2,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
			    3,    0,    1,    2,    1,    2,    3,    3,    1,    3,
			    0,    2,    7,    1,    2,    2,    3,    0,    2,    0,
			    2,    0,    2,    3,    0,    2,    3,    0,    2,    0,
			    1,    2,    1,    2,    3,    1,    2,    0,    2,    1,
			    2,    2,    2,    2,    2,    2,    2,    1,    0,    3,

			    0,    1,    3,    0,    1,    2,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    5,    3,    0,    3,
			    3,    1,    1,    7,    0,    2,    0,    4,    5,    5,
			    0,    4,    5,    0,    1,    3,    1,    3,    1,    1,
			    1,    9,    0,    1,    2,    4,    4,    0,    3,    0,
			    1,    3,    3,    1,    3,    3,    5,    2,    4,    5,
			    7,    2,    4,    0,    3,    0,    1,    3,    1,    2,
			    1,    1,    1,    3,    1,    1,    1,    1,    1,    3,
			    1,    1,    1,    1,    1,    1,    3,    2,    2,    2,
			    2,    3,    3,    3,    3,    3,    3,    3,    3,    3,

			    3,    3,    3,    3,    3,    3,    3,    3,    4,    4,
			    3,    2,    4,    0,    1,    3,    0,    1,    3,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
			    1,    2,    2,    1,    1>>)
		end

	yydefact_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    6,    8,    6,    1,   25,    0,    0,  325,  326,  334,
			  324,  323,  333,  330,  327,  320,    7,    9,   11,   15,
			   20,   18,   21,  321,  319,  322,    2,   28,   27,   26,
			   29,    0,  331,  328,  332,  329,   22,   10,   12,    0,
			   17,   31,   36,    0,   22,    0,   13,   23,   20,   19,
			   16,   34,    0,    0,   96,   24,   14,    0,   32,   30,
			    0,   37,   96,   82,  103,    4,   97,  197,   35,  198,
			   34,  103,    0,   45,   38,   50,   84,   83,  100,   82,
			  177,   98,  104,  200,  196,   33,  177,   39,   78,   78,
			   63,   78,   69,   96,   96,   51,   52,   53,   54,   55,

			   56,   67,   91,   88,   94,    0,   85,    0,  101,   99,
			  107,  179,    0,  105,    0,    0,    0,    0,  189,  201,
			    0,    5,    0,    0,  124,   79,   90,   93,   62,    0,
			   87,   66,   70,   72,   78,   96,    0,   48,   96,    0,
			   46,   91,   68,   88,   92,   94,   89,    0,   95,   61,
			   81,    0,    0,    0,  122,  106,  108,  110,  149,  120,
			    0,    0,    0,    0,    0,    0,    0,  263,  277,  278,
			    0,  316,  285,  284,  283,  282,  281,  263,  178,  180,
			  182,  185,  276,  253,  280,    3,  191,  192,  193,  190,
			    0,    0,  195,  194,  199,    0,  127,  130,  129,  128,

			  125,  148,  146,  145,  143,  147,  144,  142,  141,  140,
			  139,  138,  137,  136,  135,  134,  133,  132,  131,  126,
			    0,    0,    0,   71,   73,   77,   75,   76,    0,   49,
			   41,    0,   47,   40,   88,   94,    0,   60,   86,  102,
			  123,  109,  111,  151,    0,  113,  160,  263,    0,    0,
			  311,  289,  290,  288,  287,  265,  257,    0,    0,  313,
			  317,    0,  186,  261,  181,  183,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,  202,   80,    0,   64,   74,
			   44,   43,   94,    0,   59,  112,  158,    0,  152,  154,

			    0,  121,    0,  115,  279,    0,    0,  268,    0,  266,
			    0,  254,  255,  314,    0,    0,  286,  184,  291,  296,
			  298,  297,  295,  294,  293,  292,  304,  303,  302,  301,
			  300,  299,    0,  305,  307,    0,  306,  310,  263,    0,
			    0,   58,  150,  153,  155,    0,    0,  161,   36,  114,
			    0,  263,    0,  272,  271,  270,  269,  264,    0,  258,
			  312,    0,  318,  308,  309,  262,   65,   57,  156,  159,
			  157,  118,  171,  117,  116,  119,  256,  259,    0,  267,
			  315,  179,  169,    0,  273,  179,  172,  151,    0,  260,
			  173,  170,  203,    0,  203,  163,  174,    0,    0,  215,

			  275,    0,  214,    0,    0,  203,  247,  179,    0,  274,
			  165,  204,  206,  207,  208,  209,  210,  211,  212,  213,
			    0,  167,  164,  179,  187,    0,    0,  230,    0,  177,
			  249,  203,    0,  275,  274,  218,  205,  222,  221,    0,
			    0,  166,  179,  175,  203,    0,    0,    0,  233,  224,
			  203,  242,  250,    0,    0,  252,    0,  217,  220,  168,
			  176,  188,  162,  218,    0,  239,  238,  240,    0,  234,
			  236,  233,  203,    0,  226,  243,    0,  248,    0,  246,
			  263,  216,    0,  203,    0,    0,  225,  229,    0,  224,
			  263,  244,    0,  251,  219,  235,  231,  237,  203,    0,

			    0,    0,    0,    0,  232,  203,    0,  223,  245,  203,
			  227,  203,    0,  228,  241,    0,    0>>)
		end

	yydefgoto_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    2,    3,    4,   30,   42,   54,   71,   80,  112,   65,
			   72,   16,   17,   37,   18,   19,  247,   21,   22,   31,
			   52,   58,  118,   74,   75,   94,   95,   96,   97,   98,
			   99,  100,  101,  141,  143,  145,  147,  102,  144,  146,
			  148,  128,  125,  131,  132,  133,  134,  226,  126,  107,
			   78,   66,  109,   82,  155,  156,  157,  158,  245,  246,
			  303,  349,  374,  375,  159,  200,  219,  297,  298,  299,
			  300,  119,  382,  388,  396,  424,  445,  410,  441,  178,
			  179,  180,  181,   23,   69,   84,  120,  411,  412,  182,
			  414,  415,  416,  417,  418,  419,  420,  457,  263,  439,

			  489,  473,  449,  468,  469,  470,  476,  431,  453,  183,
			  308,  309,  356,  184,  261,  314,   25>>)
		end

	yypact_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			  396,  735,   30, -32768,  170,  335,  331, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768, -32768, -32768, -32768, 1051, -32768,  297,
			  319, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			  316,  406, -32768, -32768, -32768, -32768, 1020,  312, -32768,  735,
			  735,  139,  379,  139, -32768,  458, -32768, -32768, -32768, -32768,
			  297,  392,  157,  404,   40, -32768, -32768,  391, -32768, -32768,
			  139, -32768,   31,  265,   50, -32768, -32768, -32768, -32768,  294,
			  392,   50,  380, -32768, -32768,  303,  139, -32768,  139,  265,
			  137, -32768, -32768,  140, -32768, -32768,  137, -32768,  189,  189,
			  189,  189,  265,  135,   11, -32768, -32768, -32768, -32768, -32768,

			 -32768,  374,  329,  315,  295,  372, -32768,  134, -32768,  284,
			  241,  842,  370, -32768,  391,   41,  391,   25, -32768, -32768,
			  156, -32768,  143, 1274, -32768, -32768,  263,  263,  280,  375,
			  263, -32768,   13, -32768,  183,   31,  364, -32768,   31,  362,
			 -32768,  329, -32768,  315, -32768,  295, -32768,  357, -32768, -32768,
			 -32768,  139,  139,  189, -32768, -32768,   55, -32768,   96, -32768,
			  842,  139,  842,  842,  842,  842,  842,   -3,   60,  166,
			  267,  842, -32768, -32768, -32768, -32768, -32768,  125, -32768,  754,
			 -32768, 1237, -32768,  179, -32768, -32768, -32768, -32768, -32768, -32768,
			  378,  373, -32768, -32768, -32768,  140, -32768, -32768, -32768, -32768,

			 -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			  189,  189,  189,  265, -32768, -32768, -32768,  263,  347, -32768,
			 -32768,  339, -32768, -32768,  315,  295,  336, -32768, -32768, -32768,
			 -32768,  241, -32768,  139,  241, -32768,  248,   -3, 1208,  233,
			 -32768, -32768, -32768, -32768, -32768,  411,  238,  139,  139,  139,
			 1237,   -2, -32768, -32768,  842, -32768,  842,  842,  842,  842,
			  842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
			  723,  842,  688,  842,  139, -32768, -32768,  332, -32768, -32768,
			 -32768, -32768,  295,  320, -32768, -32768, -32768,  225,   12, -32768,

			  215, -32768,  140,  304,   79,  276,   46, 1237,   82, -32768,
			  139,  179,  179, -32768,   66,  842, -32768, -32768, -32768,  198,
			  198,  198,  198,  198,  264,  264,  549,  549,  549,  549,
			  549,  549,  842, 1037, 1287,  842, 1287, 1272,   -3,  189,
			  313, -32768, -32768,  139, -32768,  139,  140, -32768,  616, -32768,
			  139,   -3,  842, -32768, -32768, -32768, -32768, -32768,  411,  179,
			 -32768,  139, 1237, 1037, 1287, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768,  257, -32768, -32768, -32768,  179,  181, 1179, -32768,
			 -32768,  605,  288,  139, -32768,  842, -32768,  139,  227,  179,
			 -32768, -32768,  998,  291,  998, -32768,  262,  140,  842, -32768,

			   60,  166, -32768,  842,  842,  998,  158,  842,   37,  528,
			  998, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			  285,  251,  998,  570,  223,  138, 1109, 1161, 1143,  924,
			  239,  998,  213, -32768, -32768,   67, -32768, -32768, -32768,  842,
			  229, -32768,  842, -32768,  998,  201,   37,   79,   16,    2,
			  998,  161, -32768,  -14,  965, -32768,  139, -32768, 1237, -32768,
			 -32768,  998, -32768,   67,   60, -32768, -32768, -32768,  -44, -32768,
			  162,   16,  998,  119,  883,  842,   70, -32768,  120, -32768,
			   -3, -32768,   16,  998,   16,  -55,  998, -32768,  842,  259,
			  -28, 1237,  842, -32768, -32768, -32768,  998, -32768,  998, 1090,

			  842,   77,  842,  995,  998,  998, 1072, -32768, 1237,  998,
			  998,  998,  850,  998, -32768,   78, -32768>>)
		end

	yypgoto_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			 -32768,  485, -32768, -32768, -32768,  141,  432,  413,  -84, -32768,
			   29, -32768, -32768,  445,  127,  440,   -1,  436,  131, -32768,
			 -32768,  402,  168, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768,  328, -134, -139,  353,  384,  383,
			  382, -32768,  -83, -32768, -32768, -124,  -12, -32768,   51, -32768,
			  377,   -8, -32768,  184, -32768, -32768, -133, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768,  208, -32768, -32768,   64, -32768, -274,
			 -32768, -184, -32768, -32768, -32768, -32768, -32768, -329, -32768, -349,
			 -32768, -166,   44, -116, -32768, -32768, -32768,  -73, -32768, -217,
			 -32768, -32768, -32768, -32768, -32768, -32768, -367,  -13, -152, -32768,

			 -32768,  -43, -32768,  -33,  -46,  -49, -32768, -32768, -32768, -253,
			 -32768,   71, -32768,    9, -32768, -32768, -32768>>)
		end

	yytable_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			   20,  193,  121,  498,  311,  312,  236,  129,  224,  235,
			   24,  285,  316,  265,  483,  256,   20,   67,   12,  465,
			   14,    9,   12,  242,  344,    9,   24,  154,  472,   14,
			  515,   12,  386,   63,    9,   20,  390,   67,   48,   48,
			   51,  435,   55,   12,   20,   24,    9,   12,   24,   24,
			    9,   77,   12,   63,   24,    9,   81,  359,  432,   70,
			  482,   12,   63,   81,    9,  422,  471,   77,    1,  368,
			  240,  482,   63,  154,  443,  106,  429,  108,  516,  463,
			   62,  401,  464,  167,   79,  123,  502,  124,  124,  124,
			  124,  153,  255,  460,  123,  122,  293,  376,  317,  289,

			  292,  478,  454,  433,  122,  507,  187,  477,  295,  124,
			  177,  354,  353,  315,  188,  461,  192,  255,  347,  191,
			  190,  474,  136,  139,  138,  343,  223,  493,  191,  190,
			  389,   76,  492,  124,  161,  -42,  398,  286,  287,  288,
			  127,   67,  130,  486,   38,   12,   67,  487,    9,  117,
			  238,  239,  124,  340,  496,  124,  -42,   63,  154,  -42,
			  249,  154,  370,   46,  228,  -42,  352,  231,  241,  504,
			  116,   79,   56,  -42,  484,  413,  510,  413,  177,  111,
			  512,  361,  513,  257,  115,  227,  365,  360,  413,   12,
			  456,  -42,    9,  413,   29,   12,  114,  358,    9,  377,

			   28,  225,  350,  357,  248,  413,  250,  251,  252,  253,
			  254,  244,  413,  425,  413,  260,  243,  199,  198,  124,
			  124,  124,  123,  355,  475,   68,   27,  413,  123,  462,
			   73,  467,  122,  413,  197,  196,  459,  413,  122,  262,
			  124,  455,  296,  124,  413,  255,  452,   12,  135,  151,
			    9,  395,  394,  150,  467,  413,  366,  413,  313,  393,
			  446,  137,  140,  177,  113,  467,  413,  467,  440,  413,
			  113,  195,   60,  194,   59,  392,  444,  153,  430,  413,
			  123,  413,  186,  338,  189,  472,  500,  413,  413,  258,
			  122,  423,  413,  413,  413,  413,  413,  296,  421,  307,

			  438,  437,  284,  229,  383,  124,  232,  267,  266,  381,
			  318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
			  328,  329,  330,  331,  333,  334,  336,  337,  494,  346,
			  345,   93,  466,  387,   92,   35,   34,  436,  124,   33,
			   32,  367,  296,  351,  369,  451,  342,  348,  341,  436,
			   89,  339,  305,   91,   90,  466,  436,   24,   89,  362,
			  380,  310,  302,   88,  294,   91,  466,  291,  466,  271,
			  270,  269,  268,  267,  266,  290,  363,   35,  220,  364,
			  177,  436,   33,   76,  177,  237,  296,  259,  436,   88,
			  233,  409,  230,  409,  222,  221,  378,   67,  185,  152,

			  149,  436,  307,   57,  409,   92,  177,  434,   87,  409,
			   83,   61,   39,  436,  176,  175,  174,   12,  173,  172,
			    9,  409,  177,  436,  171,   47,   53,   43,  409,  379,
			  409,  436,   41,   40,    1,  497,  495,  436,  485,  436,
			  436,  177,  426,  409,    8,  434,  501,  427,  428,  409,
			  481,  391,  301,  409,  142,  480,  110,  105,  104,  103,
			  409,   15,   14,   13,   12,   11,   10,    9,  170,  234,
			    7,  409,   85,  409,  490,   49,  169,  168,  167,  373,
			   50,   45,  409,  458,   86,  409,   64,   26,    0,  372,
			    0,    8,    0,    0,    0,  409,    0,  409,    0,    0,

			    0,    0,    0,  409,  409,    0,    0,    0,  409,  409,
			  409,  409,  409,    0,  166,  165,    0,    7,    0,  491,
			    0,  164,  163,  162,    0,    0,    0,    0,    0,  161,
			    0,  160,  499,    0, -263,  306,  503, -263, -263,    0,
			    0,    0,    0,    0,  506,    0,  508,    0, -263,    0,
			    0, -263,    0,    0, -263, -263, -263, -263,    0,    0,
			    0,    6,    5, -263,    0, -263,    0,    0,    0, -263,
			 -263,   47,    0,  176,  175,  174,   12,  173,  172,    9,
			    0, -263, -263,  171,    0,    0,    0,    0,    0,    0,
			 -263, -263, -263, -263, -263, -263,    0,    0,    0,    0,

			    0,    0,    0,    8,    0,    0,    0,    0,  176,  175,
			  174,   12,  173,  172,    9,    0,    0,    0,  171,   15,
			   14,   13,    0,   11,   10,    0,    0,  170,  442,    7,
			    0,  385,    0,    0,    0,  169,  168,  167,    8,    0,
			    0, -263,    0,    0,    0,    0, -263,    0,  255,    8,
			 -263, -263,  273,  272,  271,  270,  269,  268,  267,  266,
			    0,    0,  170,   53,    7,    0,    0,    0,    0,    0,
			  169,  168,  167,  166,  165,    7,    0,  371,    0,    0,
			  164,  163,  162,    0,    0,    0,    0,    0,  161,    0,
			  160,  176,  175,  174,   12,  173,  172,    9,    0,    0,

			    0,  171,    0,    0,    0,    0,    0,    0,  166,  165,
			    0,    0,    0,    0,  335,  164,  163,  162,    0,    6,
			    5,    8,    0,  161,    0,  160,  176,  175,  174,   12,
			  173,  172,    9,    0,    0,    0,  171,    0,   15,   14,
			   13,   12,   11,   10,    9,  170,    0,    7,    0,    0,
			    0,    0,    0,  169,  168,  167,    8,  176,  175,  174,
			   12,  173,  172,    9,    0,    0,    0,  171,    8,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			  170,  332,    7,    0,    0,    0,    0,    8,  169,  168,
			  167,  166,  165,    0,    7,    0,    0,    0,  164,  163,

			  162,    0,    0,    0,    0,    0,  161,    0,  160,    0,
			    0,  170,    0,    7,    0,    0,    0,    0,    0,  169,
			  168,  167,    0,    0,    0,    0,  166,  165,    0,    0,
			    0,    0,    0,  164,  163,  162,    0,    0,    6,    5,
			    0,  161,    0,  160,    0,  176,  175,  174,   12,  173,
			  172,    9,    0,    0,    0,  171,   12,  166,  165,    9,
			  408,    0,    0,    0,  164,  163,  162,  264,    0,    0,
			  407,    0,  161,  406,  160,    8,    0,    0,  514,    0,
			    0,    0,    0,    0,    0,  405,    0,  404,    0,   12,
			    0,  403,    9,  408,    0,    0,    0,    0,    0,  170,

			    0,    7,    0,  407,  402,    0,  406,  169,  168,  167,
			  488,    0,    0,    0,    0,  401,  400,  167,  405,    0,
			  404,    0,    0,    0,  403,    0,    0,    0,    0,    0,
			   12,    0,    0,    9,  408,    0,    0,  402,    0,    0,
			    0,    0,    0,    0,  407,  166,  165,  406,  401,  400,
			  167,    0,  164,  163,  162,    0,    0,    0,    0,  405,
			  161,  404,  160,  399,    0,  403,  111,    0,  161,    0,
			  398,   12,  397,    0,    9,  408,    0,    0,  402,    0,
			    0,    0,    0,    0,    0,  407,    0,    0,  406,  401,
			  400,  167,    0,  479,    0,    0,  399,    0,    0,    0,

			  405,  161,  404,  398,   12,  397,  403,    9,  408,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,  407,  402,
			    0,  406,    0,   15,   14,   13,   12,   11,   10,    9,
			  401,  400,  167,  405,    0,  404,    0,  399,    0,  403,
			    0,  509,  161,    0,  398,    0,  397,    0,    0,    0,
			    0,    0,  402,    8,   15,   14,   13,   12,   11,   10,
			    9,    0,    0,  401,  400,  167,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,  399,    7,
			    0,    0,    0,  161,    8,  398,    0,  397,  283,  282,
			  281,  280,  279,  278,  277,  276,  275,  274,  273,  272,

			  271,  270,  269,  268,  267,  266,    0,    0,    0,    0,
			    7,  399,    0,    0,    0,    0,  161,    0,  398,    0,
			  397,    0,    0,    6,    5,    0,    0,    0,    0,    0,
			  511,    0,    0,   44,  279,  278,  277,  276,  275,  274,
			  273,  272,  271,  270,  269,  268,  267,  266,  505,    0,
			    0,    0,    0,    0,    6,    5,    0,    0,    0,    0,
			    0,    0,    0,    0,   36,  283,  282,  281,  280,  279,
			  278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
			  268,  267,  266,  283,  282,  281,  280,  279,  278,  277,
			  276,  275,  274,  273,  272,  271,  270,  269,  268,  267,

			  266,  450,  283,  282,  281,  280,  279,  278,  277,  276,
			  275,  274,  273,  272,  271,  270,  269,  268,  267,  266,
			    0,    0,    0,    0,    0,  448,    0,    0,    0,    0,
			  447,    0,    0,    0,    0,    0,  283,  282,  281,  280,
			  279,  278,  277,  276,  275,  274,  273,  272,  271,  270,
			  269,  268,  267,  266,  283,  282,  281,  280,  279,  278,
			  277,  276,  275,  274,  273,  272,  271,  270,  269,  268,
			  267,  266,  283,  282,  281,  280,  279,  278,  277,  276,
			  275,  274,  273,  272,  271,  270,  269,  268,  267,  266,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

			  384,  283,  282,  281,  280,  279,  278,  277,  276,  275,
			  274,  273,  272,  271,  270,  269,  268,  267,  266,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,  304,
			  283,  282,  281,  280,  279,  278,  277,  276,  275,  274,
			  273,  272,  271,  270,  269,  268,  267,  266,  218,  217,
			  216,  215,  214,  213,  212,  211,  210,  209,  208,  207,
			  206,  205,  204,  203,  202,  201,  282,  281,  280,  279,
			  278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
			  268,  267,  266,  280,  279,  278,  277,  276,  275,  274,
			  273,  272,  271,  270,  269,  268,  267,  266>>)
		end

	yycheck_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    1,  117,   86,   58,  257,  258,  145,   90,  132,  143,
			    1,  195,   14,  179,   58,  167,   17,    6,    6,    3,
			    4,    9,    6,  156,  298,    9,   17,  110,   26,    4,
			    0,    6,  381,   22,    9,   36,  385,    6,   39,   40,
			   41,  408,   43,    6,   45,   36,    9,    6,   39,   40,
			    9,   63,    6,   22,   45,    9,   64,  310,  407,   60,
			  115,    6,   22,   71,    9,  394,   64,   79,   38,  343,
			  153,  115,   22,  156,  423,   76,  405,   78,    0,  446,
			   40,   65,   66,   67,   34,   39,  114,   88,   89,   90,
			   91,   36,  120,  442,   39,   49,  235,  350,  264,  223,

			  234,  115,  431,   66,   49,   28,   65,  121,  241,  110,
			  111,   65,   66,  115,  115,  444,  117,  120,  302,  103,
			  104,  450,   93,   94,  113,  113,  113,    7,  103,  104,
			  383,  118,   62,  134,  118,    0,  120,  220,  221,  222,
			   89,    6,   91,  472,   17,    6,    6,   28,    9,    9,
			  151,  152,  153,  292,  483,  156,   21,   22,  241,   24,
			  161,  244,  346,   36,  135,   30,  120,  138,  113,  498,
			   30,   34,   45,   38,   12,  392,  505,  394,  179,   42,
			  509,  115,  511,  123,   44,  134,  338,  121,  405,    6,
			  123,   56,    9,  410,   24,    6,   56,  115,    9,  351,

			   30,   18,  123,  121,  160,  422,  162,  163,  164,  165,
			  166,  115,  429,  397,  431,  171,  120,   74,   75,  220,
			  221,  222,   39,  306,   63,   57,   56,  444,   39,   28,
			   62,  448,   49,  450,   91,   92,    7,  454,   49,  114,
			  241,   28,  243,  244,  461,  120,    7,    6,  113,  115,
			    9,   24,   25,  119,  471,  472,  339,  474,  259,   32,
			  122,   93,   94,  264,   80,  482,  483,  484,   17,  486,
			   86,  115,  115,  117,  117,   48,   53,   36,  120,  496,
			   39,  498,  114,  284,  116,   26,   27,  504,  505,  123,
			   49,   29,  509,  510,  511,  512,  513,  298,    7,  255,

			   15,   16,  123,  135,  123,  306,  138,  109,  110,   52,
			  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
			  276,  277,  278,  279,  280,  281,  282,  283,  480,  114,
			  115,   28,  448,   45,   31,    4,    5,  410,  339,    4,
			    5,   28,  343,   67,  345,  429,  121,   43,   28,  422,
			   55,   19,  119,   50,   51,  471,  429,  348,   55,  315,
			  361,  123,  114,   60,   28,   50,  482,   28,  484,  105,
			  106,  107,  108,  109,  110,   28,  332,    4,  115,  335,
			  381,  454,    4,  118,  385,   28,  387,  120,  461,   60,
			   28,  392,   28,  394,   19,  115,  352,    6,   28,  115,

			   28,  474,  358,   11,  405,   31,  407,  408,   28,  410,
			  116,    7,  115,  486,    3,    4,    5,    6,    7,    8,
			    9,  422,  423,  496,   13,  113,   47,   21,  429,  358,
			  431,  504,  116,  114,   38,  484,  482,  510,  471,  512,
			  513,  442,  398,  444,   33,  446,  489,  403,  404,  450,
			  463,  387,  244,  454,  101,  456,   79,   75,   75,   75,
			  461,    3,    4,    5,    6,    7,    8,    9,   57,  141,
			   59,  472,   70,  474,  475,   39,   65,   66,   67,  348,
			   40,   36,  483,  439,   71,  486,   54,    2,   -1,  348,
			   -1,   33,   -1,   -1,   -1,  496,   -1,  498,   -1,   -1,

			   -1,   -1,   -1,  504,  505,   -1,   -1,   -1,  509,  510,
			  511,  512,  513,   -1,  103,  104,   -1,   59,   -1,  475,
			   -1,  110,  111,  112,   -1,   -1,   -1,   -1,   -1,  118,
			   -1,  120,  488,   -1,    6,  124,  492,    9,   10,   -1,
			   -1,   -1,   -1,   -1,  500,   -1,  502,   -1,   20,   -1,
			   -1,   23,   -1,   -1,   26,   27,   28,   29,   -1,   -1,
			   -1,  103,  104,   35,   -1,   37,   -1,   -1,   -1,   41,
			   42,  113,   -1,    3,    4,    5,    6,    7,    8,    9,
			   -1,   53,   54,   13,   -1,   -1,   -1,   -1,   -1,   -1,
			   62,   63,   64,   65,   66,   67,   -1,   -1,   -1,   -1,

			   -1,   -1,   -1,   33,   -1,   -1,   -1,   -1,    3,    4,
			    5,    6,    7,    8,    9,   -1,   -1,   -1,   13,    3,
			    4,    5,   -1,    7,    8,   -1,   -1,   57,   58,   59,
			   -1,   26,   -1,   -1,   -1,   65,   66,   67,   33,   -1,
			   -1,  113,   -1,   -1,   -1,   -1,  118,   -1,  120,   33,
			  122,  123,  103,  104,  105,  106,  107,  108,  109,  110,
			   -1,   -1,   57,   47,   59,   -1,   -1,   -1,   -1,   -1,
			   65,   66,   67,  103,  104,   59,   -1,   61,   -1,   -1,
			  110,  111,  112,   -1,   -1,   -1,   -1,   -1,  118,   -1,
			  120,    3,    4,    5,    6,    7,    8,    9,   -1,   -1,

			   -1,   13,   -1,   -1,   -1,   -1,   -1,   -1,  103,  104,
			   -1,   -1,   -1,   -1,   26,  110,  111,  112,   -1,  103,
			  104,   33,   -1,  118,   -1,  120,    3,    4,    5,    6,
			    7,    8,    9,   -1,   -1,   -1,   13,   -1,    3,    4,
			    5,    6,    7,    8,    9,   57,   -1,   59,   -1,   -1,
			   -1,   -1,   -1,   65,   66,   67,   33,    3,    4,    5,
			    6,    7,    8,    9,   -1,   -1,   -1,   13,   33,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
			   57,   58,   59,   -1,   -1,   -1,   -1,   33,   65,   66,
			   67,  103,  104,   -1,   59,   -1,   -1,   -1,  110,  111,

			  112,   -1,   -1,   -1,   -1,   -1,  118,   -1,  120,   -1,
			   -1,   57,   -1,   59,   -1,   -1,   -1,   -1,   -1,   65,
			   66,   67,   -1,   -1,   -1,   -1,  103,  104,   -1,   -1,
			   -1,   -1,   -1,  110,  111,  112,   -1,   -1,  103,  104,
			   -1,  118,   -1,  120,   -1,    3,    4,    5,    6,    7,
			    8,    9,   -1,   -1,   -1,   13,    6,  103,  104,    9,
			   10,   -1,   -1,   -1,  110,  111,  112,  113,   -1,   -1,
			   20,   -1,  118,   23,  120,   33,   -1,   -1,   28,   -1,
			   -1,   -1,   -1,   -1,   -1,   35,   -1,   37,   -1,    6,
			   -1,   41,    9,   10,   -1,   -1,   -1,   -1,   -1,   57,

			   -1,   59,   -1,   20,   54,   -1,   23,   65,   66,   67,
			   27,   -1,   -1,   -1,   -1,   65,   66,   67,   35,   -1,
			   37,   -1,   -1,   -1,   41,   -1,   -1,   -1,   -1,   -1,
			    6,   -1,   -1,    9,   10,   -1,   -1,   54,   -1,   -1,
			   -1,   -1,   -1,   -1,   20,  103,  104,   23,   65,   66,
			   67,   -1,  110,  111,  112,   -1,   -1,   -1,   -1,   35,
			  118,   37,  120,  113,   -1,   41,   42,   -1,  118,   -1,
			  120,    6,  122,   -1,    9,   10,   -1,   -1,   54,   -1,
			   -1,   -1,   -1,   -1,   -1,   20,   -1,   -1,   23,   65,
			   66,   67,   -1,   28,   -1,   -1,  113,   -1,   -1,   -1,

			   35,  118,   37,  120,    6,  122,   41,    9,   10,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   20,   54,
			   -1,   23,   -1,    3,    4,    5,    6,    7,    8,    9,
			   65,   66,   67,   35,   -1,   37,   -1,  113,   -1,   41,
			   -1,   46,  118,   -1,  120,   -1,  122,   -1,   -1,   -1,
			   -1,   -1,   54,   33,    3,    4,    5,    6,    7,    8,
			    9,   -1,   -1,   65,   66,   67,   -1,   -1,   -1,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  113,   59,
			   -1,   -1,   -1,  118,   33,  120,   -1,  122,   93,   94,
			   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,

			  105,  106,  107,  108,  109,  110,   -1,   -1,   -1,   -1,
			   59,  113,   -1,   -1,   -1,   -1,  118,   -1,  120,   -1,
			  122,   -1,   -1,  103,  104,   -1,   -1,   -1,   -1,   -1,
			   58,   -1,   -1,  113,   97,   98,   99,  100,  101,  102,
			  103,  104,  105,  106,  107,  108,  109,  110,   58,   -1,
			   -1,   -1,   -1,   -1,  103,  104,   -1,   -1,   -1,   -1,
			   -1,   -1,   -1,   -1,  113,   93,   94,   95,   96,   97,
			   98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
			  108,  109,  110,   93,   94,   95,   96,   97,   98,   99,
			  100,  101,  102,  103,  104,  105,  106,  107,  108,  109,

			  110,   58,   93,   94,   95,   96,   97,   98,   99,  100,
			  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
			   -1,   -1,   -1,   -1,   -1,   64,   -1,   -1,   -1,   -1,
			  121,   -1,   -1,   -1,   -1,   -1,   93,   94,   95,   96,
			   97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
			  107,  108,  109,  110,   93,   94,   95,   96,   97,   98,
			   99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
			  109,  110,   93,   94,   95,   96,   97,   98,   99,  100,
			  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,

			  121,   93,   94,   95,   96,   97,   98,   99,  100,  101,
			  102,  103,  104,  105,  106,  107,  108,  109,  110,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  121,
			   93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
			  103,  104,  105,  106,  107,  108,  109,  110,   74,   75,
			   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
			   86,   87,   88,   89,   90,   91,   94,   95,   96,   97,
			   98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
			  108,  109,  110,   96,   97,   98,   99,  100,  101,  102,
			  103,  104,  105,  106,  107,  108,  109,  110>>)
		end

feature {NONE} -- Constants

	yyFinal: INTEGER is 516
			-- Termination state id

	yyFlag: INTEGER is -32768
			-- Most negative INTEGER

	yyNtbase: INTEGER is 125
			-- Number of tokens

	yyLast: INTEGER is 1397
			-- Upper bound of `yytable' and `yycheck'

	yyMax_token: INTEGER is 359
			-- Maximum token id
			-- (upper bound of `yytranslate'.)

	yyNsyms: INTEGER is 242
			-- Number of symbols
			-- (terminal and nonterminal)

feature -- User-defined features



feature {NONE} -- Initialization

	make is
			-- Create a new Eiffel parser.
		do
			make_eiffel_scanner
			make_parser_skeleton
		end

	execute is
			-- Parse Eiffel files `arguments (1..argument_count)'.
		local
			j, n: INTEGER
			a_filename: STRING
			a_file: like INPUT_STREAM_TYPE
		do
			make
			n := Arguments.argument_count
			if n = 0 then
				std.error.put_string ("usage: eiffel_parser filename ...%N")
				Exceptions.die (1)
			else
				from j := 1 until j > n loop
					a_filename := Arguments.argument (j)
					a_file := INPUT_STREAM_.make_file_open_read (a_filename)
					if INPUT_STREAM_.is_open_read (a_file) then
						reset
						set_input_buffer (new_file_buffer (a_file))
						parse
						INPUT_STREAM_.close (a_file)
					else
						std.error.put_string ("eiffel_parser: cannot read %'")
						std.error.put_string (a_filename)
						std.error.put_string ("%'%N")
					end
					j := j + 1
				end
			end
		end

	benchmark is
			-- Parse Eiffel file `argument (2)' `argument (1)' times.
		local
			j, n: INTEGER
			a_filename: STRING
			a_file: like INPUT_STREAM_TYPE
		do
			make
			if
				Arguments.argument_count < 2 or else
				not STRING_.is_integer (Arguments.argument (1))
			then
				std.error.put_string ("usage: eiffel_parser nb filename%N")
				Exceptions.die (1)
			else
				n := Arguments.argument (1).to_integer
				a_filename := Arguments.argument (2)
				from j := 1 until j > n loop
					a_file := INPUT_STREAM_.make_file_open_read (a_filename)
					if INPUT_STREAM_.is_open_read (a_file) then
						reset
						set_input_buffer (new_file_buffer (a_file))
						parse
						INPUT_STREAM_.close (a_file)
					else
						std.error.put_string ("eiffel_parser: cannot read %'")
						std.error.put_string (a_filename)
						std.error.put_string ("%'%N")
						Exceptions.die (1)
					end
					j := j + 1
				end
			end
		end

feature -- Error handling

	report_error (a_message: STRING) is
			-- Print error message.
		local
			f_buffer: YY_FILE_BUFFER
		do
			f_buffer ?= input_buffer
			if f_buffer /= Void then
				std.error.put_string (INPUT_STREAM_.name (f_buffer.file))
				std.error.put_string (", line ")
			else
				std.error.put_string ("line ")
			end
			std.error.put_integer (eif_lineno)
			std.error.put_string (": ")
			std.error.put_string (a_message)
			std.error.put_character ('%N')
		end

end -- class EIFFEL_PARSER
