/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : Prolog engine                                                   */
/* File  : TEST_CTRLC.c                                                    */
/* Descr.: main file (for test)                                            */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <setjmp.h>



/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/


/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

jmp_buf jmp;


/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

/*-------------------------------------------------------------------------*/
/* INTERRUPT_HANDLER                                                       */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Interrupt_Handler(int sig)

{
 int c;
 sigset_t set;

 printf("\nCatching signal:%d\n",sig);
#if 1
 signal(sig,Interrupt_Handler);
#endif

 sigemptyset(&set);
 /*
 sigprocmask(0,NULL,&set);
 */
 sigaddset(&set,sig);
 sigprocmask(SIG_UNBLOCK,&set,NULL);
 

 longjmp(jmp,1);
}




/*-------------------------------------------------------------------------*/
/* MAIN                                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int main()

{
 int c;

 if (setjmp(jmp)!=0)
    {
     printf("return from interrupt\n");
     goto loop;
    }

#if 1
 signal(SIGINT,Interrupt_Handler);
 signal(SIGQUIT,Interrupt_Handler);
#endif

loop:

 while((c=getchar())!=EOF)
    printf("input %c\n",c);

 return 0;
}


