/* 
   DPSOperators.h

   Display Postscript operators and functions

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: September 1995
   
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_DPSOperators
#define _GNUstep_H_DPSOperators

#include <DPS/dpsclient.h>
#include <DPS/psops.h>

#include <AppKit/NSGraphicsContext.h>

#define	GSCTXT	NSGraphicsContext

/* ----------------------------------------------------------------------- */
/* GNUstep Event and other I/O extensions */
/* ----------------------------------------------------------------------- */
static inline NSEvent*
DPSGetEvent(GSCTXT *ctxt, unsigned mask, NSDate* limit, NSString *mode)
{
  return (ctxt->methods->DPSGetEventMatchingMask_beforeDate_inMode_dequeue_)
    (ctxt, @selector(DPSGetEventMatchingMask:beforeDate:inMode:dequeue:),
    mask, limit, mode, YES);
}

static inline NSEvent*
DPSPeekEvent(GSCTXT *ctxt, unsigned mask, NSDate* limit, NSString *mode)
{
  return (ctxt->methods->DPSGetEventMatchingMask_beforeDate_inMode_dequeue_)
    (ctxt, @selector(DPSGetEventMatchingMask:beforeDate:inMode:dequeue:),
    mask, limit, mode, NO);
}

static inline void
DPSDiscardEvents(GSCTXT *ctxt, unsigned mask, NSEvent* limit)
{
  (ctxt->methods->DPSDiscardEventsMatchingMask_beforeEvent_)
    (ctxt, @selector(DPSDiscardEventsMatchingMask:beforeEvent:), mask, limit);
}

static inline void
DPSPostEvent(GSCTXT *ctxt, NSEvent* anEvent, BOOL atStart)
{
  (ctxt->methods->DPSPostEvent_atStart_)
    (ctxt, @selector(DPSPostEvent:atStart:), anEvent, atStart);
}

static inline void
DPSmouselocation(GSCTXT *ctxt, float *x, float *y)
{
  (ctxt->methods->DPSmouselocation__)
    (ctxt, @selector(DPSmouselocation::), x, y);
}

static inline void
DPSsetwindowlevel(GSCTXT *ctxt, int level, int win)
{
  (ctxt->methods->DPSsetwindowlevel__)
    (ctxt, @selector(DPSsetwindowlevel::), level, win);
}

static inline void
DPSsetcursorcolor(GSCTXT *ctxt, float fr, float fg, float fb, float br, float bg, float bb, void * cid)
{
  (ctxt->methods->DPSsetcursorcolor_______)
    (ctxt, @selector(DPSsetcursorcolor:::::::), fr, fg, fb, br, bg, bb, cid);
}

#endif /* _GNUstep_H_DPSOperators */
