/* XGContextPrivate - Private definitinos for XGContext files.

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1998
   
   This file is part of the GNU Objective C User Interface Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifndef _XGContextPrivate_h_INCLUDE
#define _XGContextPrivate_h_INCLUDE

#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSException.h>
#include <base/fast.x>

/* Mapping DPS composite operators to X11 logic functions */
typedef enum {
  nx_clear     = 0,
  nx_copy      = 3,
  nx_sover     = 7,
  nx_sin       = 0, 
  nx_sout      = 0, 
  nx_satop     = 0, 
  nx_dover     = 0, 
  nx_din       = 0, 
  nx_dout      = 0, 
  nx_datop     = 0, 
  nx_xor       = 0, 
  nx_plusd     = 0,
  nx_highlight = 0, 
  nx_plusl     = 0, 
} composite_map_t;  

typedef struct _font_t 
{
  char *name;
  char *internal_name;
  XFontStruct *info;
  float size;
  char  *weight;
  char  slant;
  Font  id;
} font_t;

/* The memory zone where all global objects are allocated from (Contexts
   are also allocated from this zone) */
extern NSZone *_globalGSZone;

/* Macros we use alot */
static inline char * copy_string_buffer(const char *str)
{
  char *new = malloc(strlen(str)+1);
  strcpy(new, str);
  return new;
}

#define CTXT_OBJ_ALLOC(class) \
  [class allocWithZone: (alloc_mode == alloc_local) \
    ? fastZone(self) : _globalGSZone]

/* Error Macros */
#define DPS_ERROR(type, resp, args...) \
    [NSException raise: type format: resp, ## args]

#define DPS_FATAL(type, resp, args...) \
    [NSException raise: type format: resp, ## args]

/* Current keys used for the info dictionary:
       Key:           Value:
     DisplayName  -- (NSString)name of X server
     ScreenNumber -- (NSNumber)screen number
     ContextData  -- (NSData)context data
     DebugContext -- (NSNumber)YES or NO
*/

extern NSString *DPSconfigurationerror;
extern NSString *DPSinvalidaccess;
extern NSString *DPSinvalidcontext;
extern NSString *DPSinvalidexit;
extern NSString *DPSinvalidfileaccess;
extern NSString *DPSinvalidfont;
extern NSString *DPSinvalidid;
extern NSString *DPSinvalidrestore;
extern NSString *DPSinvalidparam;
extern NSString *DPSioerror;
extern NSString *DPSlimitcheck;
extern NSString *DPSnocurrentpoint;
extern NSString *DPSnulloutput;
extern NSString *DPSrangecheck;
extern NSString *DPSstackoverflow;
extern NSString *DPSstackunderflow;
extern NSString *DPStypecheck;
extern NSString *DPSundefined;
extern NSString *DPSundefinedfilename;
extern NSString *DPSundefinedresource;
extern NSString *DPSundefinedresult;
extern NSString *DPSunmatchedmark;
extern NSString *DPSunregistered;
extern NSString *DPSVMerror;

/* Error macros */
#define CHECK_NULL_OUTPUT(outvar) \
  if (outvar == NULL) \
    DPS_ERROR(DPSnulloutput, @"NULL output variable specified")

#define CHECK_INVALID_ACCESS(obj, need_zone) \
  if (fastZone(obj) != _globalGSZone && fastZone(obj) != need_zone) \
    DPS_ERROR(DPSinvalidaccess, @"Allocating object from incorrect zone")

#define CHECK_INVALID_FONT(ident) \
  if (ident >= [fontid count]) \
    DPS_ERROR(DPSinvalidfont, @"Cannot find indicated font")

#define CHECK_STACK_UNDERFLOW(stack) \
  if (GSIArrayCount((GSIArray)stack) == 0) \
    DPS_ERROR(DPSstackunderflow, @"Attempt to pop from empty stack")

#if 0
#define CHECK_TYPECHECK(obj, kind) \
  if ([kind class] != Nil && !fastInstanceIsKindOfClass(obj, [kind class])) \
    DPS_ERROR(DPStypecheck, @"Invalid object")
#else
#define CHECK_TYPECHECK(obj,kind)
#endif

#define ctxt_pop(object, stack, kind) \
  do { \
    CHECK_STACK_UNDERFLOW(stack); \
    object = (GSIArrayLastItem((GSIArray)stack)).obj; \
    CHECK_TYPECHECK(object, kind); \
    AUTORELEASE(RETAIN(object)); \
    GSIArrayRemoveLastItem((GSIArray)stack); \
  } while (0)

#define ctxt_push(object, stack) \
  GSIArrayAddItem((GSIArray)stack, (GSIArrayItem)object)

#endif
