#include <iostream>
#include <gtk--.h>

// Gtk-- version of the "entry" example from the gtk+ tutorial

class Entry : public Gtk_Window
{
  Gtk_HBox m_hbox;
  Gtk_VBox m_vbox;
  Gtk_Entry m_entry;
  Gtk_Button m_bClose;
  Gtk_CheckButton m_cbEditable, m_cbVisible;

  void toggleEditable() { m_entry.set_editable(m_cbEditable.get_active()); }
  
  void toggleVisibility() { m_entry.set_visibility(m_cbVisible.get_active()); }
  void enterCallback();

  gint delete_event_impl(GdkEventAny*) { 
    Gtk_Main::instance()->quit(); return 0; 
  }
  
public:
  Entry();
};

Entry::Entry() :
  m_hbox(false, 0),
  m_vbox(false, 0),
  m_entry(50),
  m_bClose("Close"),
  m_cbEditable("Editable"),
  m_cbVisible("Visible")
{

  set_usize(200, 100);
  set_title("Gtk-- Entry");
  
  add(&m_vbox);
  
  connect_to_method(m_entry.activate, this, &enterCallback);
  m_entry.set_text("hello");
  m_entry.append_text(" world");
  m_entry.select_region(0, m_entry.get_text_length());
  m_vbox.pack_start(m_entry);
  
  // Note that add() can also be used instead of pack_xxx()
  m_vbox.add(&m_hbox);

  m_hbox.pack_start(m_cbEditable);
  connect_to_method(m_cbEditable.toggled, this, &toggleEditable);
  m_cbEditable.set_active(true);

  m_hbox.pack_start(m_cbVisible);
  connect_to_method(m_cbVisible.toggled, this, &toggleVisibility);
  m_cbVisible.set_active(true);

  connect_to_method(m_bClose.clicked, Gtk_Main::instance(), &Gtk_Main::quit);
  m_vbox.pack_start(m_bClose);
  m_bClose.set_flags(GTK_CAN_DEFAULT);
  m_bClose.grab_default();
  
  show_all();
}

void
Entry::enterCallback()
{
  cout << "Entry contents : " << m_entry.get_text() << endl;
}

  

// Gtk-- version of the "entry" example from the gtk+ tutorial

int main (int argc, char *argv[])
{
  Gtk_Main myapp(&argc, &argv);

  Entry entry;

  myapp.run();
  return 0;
}

