/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: fqwrite.c,v 6.2 1999/06/12 17:11:30 kmeyer1 Exp $
 * 
 *	Function:	- writes data to an open file descriptor
 *			- length limited to MAXNMSGLEN
 *			- must be aware of Cubix multi mode
 *	Accepts:	- filed request
 */

#include <errno.h>

#include "filed.h"
#include <freq.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern char		fbuf[MAXNMSGLEN];
					/* body of filed request */

/*
 * external functions
 */
extern struct fdesc	*fdfind();	/* find a filed descriptor */
extern void		fsendr();	/* general purpose file reply */
extern void		fdactivate();	/* make sure tfd is active */
extern int4		fmywrite();

void
fqwrite(fq)

struct freq		*fq;

{
	struct fdesc	*f;		/* ptr to target descriptor */
	int4		ret;		/* bytes written by mywrite() */
	int		err;		/* errno */

	f = fdfind(fq->fq_tfd);

	if (f == FDNULL) {
		fsendr(fq->fq_src_node, fq->fq_src_event,
				EBADF, (int4) ERROR, INT4_NIL, INT4_NIL);
		return;
	}

	f->f_src_node = fq->fq_src_node;
	f->f_src_event = fq->fq_src_event;
/*
 * Ensure that the file is activated.
 */
	fdactivate(f);
	ret = fmywrite(f->f_fd, fbuf, fq->fq_length);

	if (ret != ERROR) {
		f->f_flow += ret;
		f->f_ptr += ret;
		err = 0;
	}

	else {
		err = errno;
	}

	if (! (f->f_tflags & LAM_O_1WAY)) {
		fsendr(fq->fq_src_node, fq->fq_src_event,
				err, ret, INT4_NIL, INT4_NIL);
	}
}
