/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Id: kstate.c,v 6.3 1999/09/02 01:19:42 jsquyres Exp $
 * 
 *	Function:	- obtains process status from kernel
 *	Accepts:	- process ID
 *			- kernel status structure ptr
 *	Returns:	- 0 or ERROR
 */

#include <string.h>

#include <kio.h>
#include <kreq.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* kernel I/O block */
extern int		errno;

/*
 * external functions
 */
extern int		_cipc_kreq();	/* make kernel request */

int
kstate(pid, pstate)

int			pid;
struct kstatus		*pstate;

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */
/*
 * Formulate the KQSTATE kernel request.
 */
	req.kq_req = KQSTATE;
	req.kq_index = _kio.ki_index;
	req.kq_pid = pid;

	if (_cipc_kreq(&req, &reply)) {
		return(LAMERROR);
	}

	if (reply.kr_reply) {
		errno = reply.kr_reply;
		return(LAMERROR);
	}

	pstate->ks_state = reply.kr_state;
	pstate->ks_priority = reply.kr_priority; 
	pstate->ks_event = reply.kr_event;
	pstate->ks_type = reply.kr_type;
	pstate->ks_length = reply.kr_length;
	pstate->ks_signal = reply.kr_sigs;
	memcpy((char *) pstate->ks_fyi, (char *) reply.kr_fyi,
			sizeof(reply.kr_fyi));

	return(0);
}
