/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wgroup.c,v 1.0 1999/07/21 19:00:22 jsquyres Exp $
 *
 *	Function:	- get window group
 *	Accepts:	- window
 *			- group (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Win_get_group(win, group)

MPI_Win			win;
MPI_Group		*group;

{
	lam_initerr();
	lam_setfunc(BLKMPIWINGETGROUP);

	if (win == MPI_WIN_NULL) {
		return(lam_err_comm(MPI_COMM_WORLD,
		    			MPI_ERR_WIN, 0, "null handle"));
	}

	if (group == 0) {
		return(lam_err_win(win, MPI_ERR_ARG, 0, "null group pointer"));
	}

	*group = win->w_comm->c_group;
	win->w_comm->c_group->g_refcount++;

	lam_resetfunc(BLKMPIWINGETGROUP);
  	return(MPI_SUCCESS);
}
