/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef LCL_CONSTANTS_H
# define LCL_CONSTANTS_H

/* lclsyntable */

/*@constant unsigned long int INITSYNTABLE; @*/
# define INITSYNTABLE   1024

/*@constant double DELTASYNTABLE; @*/
# define DELTASYNTABLE  2.0

/* syntable */

/*@constant int SYNTABLE_BASESIZE; @*/
# define SYNTABLE_BASESIZE 256   

/* lcltokentable */
/*@constant unsigned long int INITTOKENTABLE; @*/
# define INITTOKENTABLE   1024

/*@constant double DELTATOKENTABLE; @*/
# define DELTATOKENTABLE  2.0

/* string2sym */

/*@constant int INITCHARSTRING; @*/
# define INITCHARSTRING    8192 

/*@constant int DELTACHARSTRING; @*/
# define DELTACHARSTRING   2  

/*@constant int INITSTRINGENTRY; @*/
# define INITSTRINGENTRY   1024

/*@constant int DELTASTRINGENTRY; @*/
# define DELTASTRINGENTRY  2  

/*@constant int HASHSIZE; @*/
# define HASHSIZE          1024

/*@constant int HASHMASK; @*/
# define HASHMASK          (HASHSIZE-1)	/* HASHSIZE must be 2^n     */

/*@constant observer char *INITFILENAME; @*/
# define INITFILENAME	"lclinit.lci"

/*@constant observer char *IO_SUFFIX; @*/
# define IO_SUFFIX              ".lcs"

/*@constant observer char *LCL_SUFFIX; @*/
# define LCL_SUFFIX		".lcl"

/*@constant observer char *LCLINIT_SUFFIX; @*/
# define LCLINIT_SUFFIX 	".lci"

/*@constant observer char *LH_SUFFIX; @*/
# define LH_SUFFIX              ".lh"

/*@constant observer char *CTRAITSYMSNAME; @*/
# define CTRAITSYMSNAME         "CTrait.syms"

/*@constant observer char *CTRAITSPECNAME; @*/
# define CTRAITSPECNAME         "CTrait.lsl"

/*@constant observer char *CTRAITFILENAMEN; @*/
# define CTRAITFILENAMEN        "CTrait"


# else
# error "Multiple include"
# endif






