/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef LLMAIN_H
# define LLMAIN_H

extern int main (int p_argc, char *p_argv[])
# ifdef NOLCL
  /*@globals killed undef g_currentloc,
	     killed undef yyin,
                    undef g_msgstream,
   @*/
  /*@modifies g_currentloc, fileSystem, internalState, yyin; 
  @*/
# else
  /*@globals killed undef g_currentloc,
	     killed       g_localSpecPath,  
	     killed undef g_currentSpec,
	     killed undef g_currentSpecName,
	     killed undef g_currentloc,
	     killed undef yyin,
                    undef g_msgstream;
   @*/
  /*@modifies g_currentloc,
              g_localSpecPath, g_currentSpec, g_currentSpecName,
	      yyin, internalState, fileSystem; 
  @*/ 
# endif
  ;

extern /*@exits@*/ void llexit (int p_status);      
extern void showHerald (void);

/*@-redecl@*/
extern int yyparse (void);
extern void yyrestart (FILE *p_f);

# ifndef NOLCL
extern int ylparse (void);
extern int lslparse (void);
# endif

/*@=redecl@*/

/*@-incondefs@*/ /*@-redecl@*/
extern /*@dependent@*/ FILE *yyin;
/*@=incondefs@*/ /*@=redecl@*/


# endif


