package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class ComposeExpr extends ConvertibleNodeSetExpr {
  private final ConvertibleNodeSetExpr expr1;
  private final ConvertibleNodeSetExpr expr2;

  ComposeExpr(ConvertibleNodeSetExpr expr1, ConvertibleNodeSetExpr expr2) {
    this.expr1 = expr1;
    this.expr2 = expr2;
  }

  public NodeIterator eval(Node node, ExprContext context) throws XSLException {
    NodeIterator iter = expr1.eval(node, context);
    NodeIterator[] iters = new NodeIterator[10];
    int length = 0;
    for (;;) {
      Node tem = iter.next();
      if (tem == null)
	break;
      if (length == iters.length) {
	NodeIterator[] oldIters = iters;
	iters = new NodeIterator[oldIters.length * 2];
	System.arraycopy(oldIters, 0, iters, 0, oldIters.length);
      }
      iters[length++] = expr2.eval(tem, context);
    }
    switch (length) {
    case 0:
      return new NullNodeIterator();
    case 1:
      return iters[0];
    case 2:
      return new UnionNodeIterator(iters[0], iters[1]);
    }
    return new MergeNodeIterator(iters, length);
  }

  int getOptimizeFlags() {
    return expr1.getOptimizeFlags() & expr2.getOptimizeFlags();
  }
}
