package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class ExtensionFunctionAvailableFunction implements Function {
  public ConvertibleExpr makeCallExpr(ConvertibleExpr e[],
				      final NamespacePrefixMap prefixMap)
    throws ParseException {
    if (e.length != 1)
      throw new ParseException("expected one argument");
    final StringExpr se = e[0].makeStringExpr();
    return new ConvertibleBooleanExpr() {
      public boolean eval(Node node, ExprContext context) throws XSLException {
	Name name = prefixMap.expandAttributeName(se.eval(node, context), node);
	String ns = name.getNamespace();
	if (ns == null)
	  return false;
	return context.getExtensionContext(ns).available(name.getLocalPart());
      }
    };
  }
}
