package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.expr.DescendantsOrSelfNodeIterator;

class AnyLevelNumberAction implements Action {
  private Pattern count;
  private Pattern from;
  private NumberListFormatTemplate formatTemplate;

  AnyLevelNumberAction(Pattern count, Pattern from, NumberListFormatTemplate formatTemplate) {
    this.count = count;
    this.from = from;
    this.formatTemplate = formatTemplate;
  }

  public void invoke(ProcessContext context, Node node, Result result) throws XSLException {
    NumberListFormat format = formatTemplate.instantiate(context, node);
    Node root = node;
    for (;;) {
      Node tem = root.getParent();
      if (tem == null)
        break;
      root = tem;
    }
    int n = 0;
    if (count != null || node.getType() == Node.ELEMENT) {
      for (NodeIterator iter = new DescendantsOrSelfNodeIterator(root);;) {
	Node tem = iter.next();
	if (tem == null)
	  break;
	if (from != null && from.matches(tem, context))
	  n = 0;
	else if (count == null) {
	  if (node.getName().equals(tem.getName()) && tem.getType() == Node.ELEMENT)
	    n++;
	}
	else if (count.matches(tem, context))
	  n++;
	if (tem.equals(node))
	  break;
      }
    }
    result.characters(format.getPrefix(0));
    result.characters(format.formatNumber(0, n));
    result.characters(format.getSuffix());
  }
}
