<xsl:stylesheet xmlns:xsl="http://www.w3.org/XSL/Transform/1.0">

<xsl:template match="file">
  <xsl:call-template name="write">
    <xsl:with-param name="file" select="@name"/>
    <xsl:with-param name="contents"><xsl:apply-templates mode="copy"/></xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="write">
  <xsl:param name="contents"/>
  <xsl:param name="file"/>
  <xsl:value-of select="w:write($contents,string($file))"
     xmlns:w="http://www.jclark.com/xt/java/com.jclark.xsl.sax.XMLFileWriter"
   />
</xsl:template>

<xsl:template mode="copy" match="*|@*">
  <xsl:copy>
    <xsl:apply-templates select="@*" mode="copy"/>
    <xsl:apply-templates select="node()" mode="copy"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
