#ifndef SIGCXX_TYPE_H
#define SIGCXX_TYPE_H

#include <sigc++config.h>

#ifdef SIGC_CXX_NAMESPACES
namespace SigC
{
#endif

/* some classes for making parameter passing easier */

#ifdef SIGC_CXX_SPECIALIZE_REFERENCES
template <typename T>
struct Trait
  {
   typedef const T& ref;
   typedef T        type;
  };

template <typename T>
struct Trait<T&>
  {
   typedef T& ref;
   typedef T& type;
  };
#else
template <typename T>
struct Trait
  {
   typedef T ref;  // VC++ does not support reference typedef
   typedef T type;
  };
#endif

template <>
struct Trait<void>:public Trait<int>
  {};


#ifdef SIGC_CXX_NAMESPACES
}
#endif

#endif
