#include "account.h"

int
main (int argc, char *argv[])
{
  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv, "mico-local-orb");

  /*
   * Connect to the Bank
   */

  CORBA::Object_var obj = orb->bind ("IDL:Bank:1.0");

  if (CORBA::is_nil (obj)) {
    printf ("oops: bind to Bank failed\n");
    exit (1);
  }

  Bank_var bank = Bank::_narrow (obj);
  assert (!CORBA::is_nil (bank));

  /*
   * Open an account
   */

  Account_var account = bank->create ();

  if (CORBA::is_nil (account)) {
    printf ("oops: account is nil\n");
    exit (1);
  }

  /*
   * Deposit and withdraw some money
   */

  account->deposit (700);
  account->withdraw (450);

  printf ("Balance is %ld.\n", account->balance ());

  return 0;
}
