/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JComponent;
import com.sun.java.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;

public class ProgramCanvas
extends JComponent
implements ComponentListener {
    Graphics currG;
    public ClogDisplay parent;
    boolean blink = false;
    boolean blFlag = true;
    Vector procVector;
    Vector dprocVector;
    Vector dtypeV;
    double xDensity;
    double yDensity;
    int _xPix;
    int _yPix;
    int widthCan;
    int heightCan;
    double maxT;
    double tMaxT;
    int maxH;
    int zDist;
    int panePosX;
    int sbPos;
    int cursorPos;
    int tbegH;
    boolean fflagH;
    boolean bflagH;
    public double zoomH;
    double zF;
    double begTime;
    double endTime;
    double currTime;
    double zXTime;
    double elapsedPoint;
    private boolean elTLineDispStatus = true;
    private boolean zoomLkLineDispStatus = true;
    int proct;
    int dproct;
    int pu = 1;
    int endGap = 5;
    MyImage[] img;
    MyImage currImg;
    int lineSize;
    int rulerHt;
    int hBWt;
    int allDispHt;
    int eachDispHt;
    int eachDispIHt;
    int fDescent;
    public int dpi;
    public FontMetrics fm;
    int maxLevel;
    double nestFactor;
    boolean message = false;
    boolean Windows = false;
    boolean arrowDispStatus = true;
    public boolean setupComplete;
    Timer timer;
    int totalProc;
    private int elTimeStrW;
    private int zLockStrW;

    void init(ClogDisplay clogDisplay) {
        this.setupComplete = false;
        this.parent = clogDisplay;
        this.setupData();
        this.adjustCanvasStuff();
        this.setupStates();
        this.setupNestedStates();
        this.dtypeV = new Vector();
        this.dtypeV.addElement(new Integer(this.parent.dtype));
        this.parent.optionsDlg.addDisplay(this.parent.dtype);
        this.totalProc = this.proct;
        this.tMaxT = this.maxT;
        this.timer = new Timer(200, (ActionListener)new TimerListener());
        this.Resize();
        this.setupEventHandlers();
        this.adjustStartEndTimes();
        this.setupComplete = true;
    }

    private void setupData() {
        this.proct = 0;
        this.dproct = 0;
        this.procVector = new Vector();
        this.dprocVector = new Vector();
        this.nestFactor = 0.1;
        this.zoomH = 1.0;
        this.zF = 2.0;
        this.begTime = 0.0;
        this.zXTime = 0.0;
        this.elapsedPoint = 0.0;
        this.hBWt = 2;
    }

    private void adjustCanvasStuff() {
        Font font = this.parent.frameFont;
        ((Component)((Object)this)).setFont(font);
        this.fm = ((Component)((Object)this)).getToolkit().getFontMetrics(font);
        this.lineSize = this.fm.getHeight();
        this.rulerHt = 3 * this.lineSize;
        this.zLockStrW = this.fm.stringWidth("Zoom Lock");
        this.elTimeStrW = this.fm.stringWidth("Elapsed Time");
        this.fDescent = this.fm.getDescent();
        this.dpi = ((Component)((Object)this)).getToolkit().getScreenResolution();
    }

    private void setupStates() {
        Object object;
        Enumeration enumeration = this.parent.data.elements();
        while (enumeration.hasMoreElements()) {
            object = (StateInfo)enumeration.nextElement();
            this.addState((StateInfo)object);
        }
        enumeration = this.procVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (JProcess)enumeration.nextElement();
            ((JProcess)object).begT = ((ProcessState)((JProcess)object).procStateVector.firstElement()).info.begT;
        }
    }

    private void setupNestedStates() {
        this.waitCursor();
        this.maxLevel = 0;
        Enumeration enumeration = this.procVector.elements();
        while (enumeration.hasMoreElements()) {
            StateInfo stateInfo = null;
            JProcess jProcess = (JProcess)enumeration.nextElement();
            Vector vector = jProcess.procStateVector;
            int n = vector.size() - 1;
            while (n >= 0) {
                ProcessState processState = (ProcessState)vector.elementAt(n);
                if (processState.info.stateDef.checkbox.isSelected()) {
                    if (stateInfo != null) {
                        if (stateInfo.begT <= processState.info.begT) {
                            processState.info.level = stateInfo.level + 1;
                            processState.info.higher = stateInfo;
                        } else {
                            StateInfo stateInfo2 = stateInfo.higher;
                            processState.info.level = stateInfo.level;
                            while (stateInfo2 != null && stateInfo2.begT > processState.info.endT) {
                                --processState.info.level;
                                stateInfo2 = stateInfo2.higher;
                            }
                            processState.info.higher = stateInfo2;
                        }
                    }
                    stateInfo = processState.info;
                }
                if (processState.info.level > this.maxLevel) {
                    this.maxLevel = processState.info.level;
                }
                --n;
            }
        }
        this.normalCursor();
    }

    private void drawInitImg() {
        double d = this.begTime;
        double d2 = this.getTime(this._xPix);
        this.img[0].drawRegion(d, d2);
        this.currImg = this.img[0];
        this.panePosX = this._xPix;
        ((Component)((Object)this)).repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        this.requestFocus();
        if (this.setupComplete && this.currImg != null) {
            n = this.getPrev(this.currImg.imgIdH);
            int n2 = this.getNext(this.currImg.imgIdH);
            if (this.blFlag || !this.timer.isRunning()) {
                this.img[n].paintStuff1(0, graphics, (ImageObserver)((Object)this));
                this.currImg.paintStuff1(this._xPix, graphics, (ImageObserver)((Object)this));
                this.img[n2].paintStuff1(this._xPix + this._xPix, graphics, (ImageObserver)((Object)this));
            } else {
                this.img[n].paintStuff2(0, graphics, (ImageObserver)((Object)this));
                this.currImg.paintStuff2(this._xPix, graphics, (ImageObserver)((Object)this));
                this.img[n2].paintStuff2(this._xPix + this._xPix, graphics, (ImageObserver)((Object)this));
            }
        }
        if (this.zoomLkLineDispStatus && this.zXTime >= this.begTime && this.zXTime <= this.endTime) {
            n = this.panePosX + this.getEvtXCord(this.zXTime - this.begTime);
            graphics.setColor(Color.white);
            graphics.drawLine(n, 0, n, this._yPix);
            graphics.fillRect(n, this._yPix - this.lineSize, this.zLockStrW + 2, this.lineSize);
            graphics.setColor(Color.black);
            graphics.drawRect(n, this._yPix - this.lineSize, this.zLockStrW + 1, this.lineSize - 1);
            graphics.setColor(Color.red);
            graphics.drawString("Zoom Lock", n + 1, this._yPix - this.fDescent);
        }
        if (this.elTLineDispStatus && this.elapsedPoint >= this.begTime && this.elapsedPoint <= this.endTime) {
            n = this.panePosX + this.getEvtXCord(this.elapsedPoint - this.begTime);
            graphics.setColor(Color.white);
            graphics.drawLine(n, 0, n, this._yPix);
            graphics.fillRect(n, this._yPix - this.lineSize, this.elTimeStrW + 2, this.lineSize);
            graphics.setColor(Color.black);
            graphics.drawRect(n, this._yPix - this.lineSize, this.elTimeStrW + 1, this.lineSize - 1);
            graphics.setColor(Color.red);
            graphics.drawString("Elapsed Time", n + 1, this._yPix - this.fDescent);
        }
    }

    private void setupImg() {
        this.killImgs();
        this.setValues();
        ((Component)((Object)this.parent.vcanvas1)).repaint();
        ((Component)((Object)this.parent.vcanvas2)).repaint();
        this.img = new MyImage[3];
        int n = 0;
        while (n < 3) {
            this.img[n] = new MyImage(n, this._xPix, this._yPix, this.dtypeV, this);
            ++n;
        }
    }

    protected void setValues() {
        int n = this.dtypeV.size();
        this.allDispHt = this._yPix - this.rulerHt;
        this.eachDispHt = (int)Math.rint((double)this.allDispHt / (double)n);
        this.eachDispIHt = this.eachDispHt - 2 * this.hBWt;
        if (this.eachDispHt < 1) {
            this.eachDispHt = 1;
        }
        this.calcYDensity();
    }

    Image getOffScreenImage(int n, int n2) {
        return ((Component)((Object)this)).createImage(n, n2);
    }

    private void killImgs() {
        if (this.img != null) {
            int n = 0;
            while (n < 3) {
                if (this.img[n] != null) {
                    this.img[n].kill();
                    this.img[n] = null;
                }
                ++n;
            }
        }
    }

    void adjustImgH(int n) {
        boolean bl;
        this.getPrev(this.currImg.imgIdH);
        this.getNext(this.currImg.imgIdH);
        int n2 = this.getEvtXCord(this.currImg.begT);
        int n3 = this.getEvtXCord(this.currImg.endT);
        int n4 = n;
        int n5 = n + this.widthCan;
        int n6 = this.tbegH + this.widthCan;
        int n7 = n2 - n4;
        int n8 = n5 - n3;
        this.panePosX += n4 - this.tbegH;
        if (n4 < n2 && this.tbegH > n2) {
            this.bflagH = true;
        } else if (n4 > n2 && this.tbegH < n2) {
            this.bflagH = false;
        }
        if (n5 > n3 && n6 < n3) {
            this.fflagH = true;
        } else if (n5 < n3 && n6 > n3) {
            this.fflagH = false;
        }
        int n9 = this.getCurrGridH(n);
        boolean bl2 = bl = this.bflagH && n7 >= this.widthCan || this.fflagH && n8 >= this.widthCan || n7 > this._xPix || n8 > this._xPix;
        if (bl) {
            this.getImgH(n9);
            this.panePosX = this._xPix + (n - n9 * this._xPix);
            this.bflagH = false;
            this.fflagH = false;
        }
        this.tbegH = n4;
        this.begTime = this.getTime(this.tbegH);
        this.adjustStartEndTimes();
    }

    private int getGridValue(int n) {
        return n - this.getCurrGridH(n) * this._xPix;
    }

    private void getImgH(int n) {
        double d;
        double d2 = this.getTime(n * this._xPix);
        MyImage myImage = this.searchImg(d2, d = d2 + this.getTime(this._xPix));
        if (myImage != null) {
            this.currImg = myImage;
        } else {
            this.currImg.drawRegion(d2, d);
        }
        this.centralizeH();
        ((Component)((Object)this)).repaint();
    }

    private MyImage searchImg(double d, double d2) {
        int n = 0;
        while (n < 3) {
            MyImage myImage = this.img[n];
            if (myImage != null && myImage.begT == d && myImage.endT == d2) {
                return myImage;
            }
            ++n;
        }
        return null;
    }

    private int getNext(int n) {
        return (n + 1) % 3;
    }

    private int getPrev(int n) {
        int n2 = (n - 1) % 3;
        if (n == 0) {
            n2 = 2;
        }
        return n2;
    }

    private void centralizeH() {
        int n;
        double d = this.currImg.endT - this.currImg.begT;
        if (this.currImg.endT < this.maxT) {
            n = this.getNext(this.currImg.imgIdH);
            if (this.img[n].begT != this.currImg.endT || this.img[n].endT != this.currImg.endT + d) {
                this.renderNextH(1);
            }
        }
        if (this.currImg.begT > 0.0) {
            n = this.getPrev(this.currImg.imgIdH);
            if (this.img[n].endT != this.currImg.begT || this.img[n].begT != this.currImg.begT - d) {
                this.renderPrevH(1);
            }
        }
    }

    private void renderPrevH(int n) {
        int n2 = this.getPrev(this.currImg.imgIdH);
        double d = this.getTime(this._xPix);
        this.img[n2].drawRegion(this.currImg.begT - (double)n * d, this.currImg.begT - (double)(n - 1) * d);
    }

    private void renderNextH(int n) {
        int n2 = this.getNext(this.currImg.imgIdH);
        double d = this.getTime(this._xPix);
        this.img[n2].drawRegion(this.currImg.endT + (double)(n - 1) * d, this.currImg.endT + (double)n * d);
    }

    private int getCurrGridH(int n) {
        return n / this._xPix;
    }

    private void addState(StateInfo stateInfo) {
        int n = stateInfo.procId;
        if (stateInfo.endT > this.maxT) {
            this.maxT = stateInfo.endT;
        }
        if (this.proct - 1 < n) {
            this.addProcess(n);
        }
        JProcess jProcess = (JProcess)this.procVector.elementAt(n);
        ProcessState processState = new ProcessState(stateInfo, jProcess);
        jProcess.procStateVector.addElement(processState);
    }

    private void addProcess(int n) {
        int n2 = this.proct;
        while (n > this.proct - 1) {
            JProcess jProcess = new JProcess(n2);
            this.procVector.addElement(jProcess);
            ++this.proct;
            ++n2;
        }
    }

    private void calcYDensity() {
        this.yDensity = (double)this.eachDispIHt / ((double)this.proct + (double)(this.proct + 1) / 5.0);
    }

    double getProcYCord(int n) {
        return (double)this.hBWt + (double)(2 * n + 1) * this.yDensity / 2.0 + (double)(n + 1) * this.yDensity / 5.0;
    }

    double getEvtYCord(int n) {
        return this.getProcYCord(n) - this.yDensity / 2.0;
    }

    int getEvtXCord(double d) {
        return (int)Math.rint(d * this.xDensity);
    }

    double getTime(int n) {
        double d = 1.0 / this.xDensity * (double)n;
        return d;
    }

    int getW(double d, double d2) {
        return (int)Math.rint(d2 * this.xDensity) - (int)Math.rint(d * this.xDensity);
    }

    void updateH() {
        this.maxH = this.getW(0.0, this.maxT);
    }

    int findIndex(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.proct) {
            int n4 = (int)Math.rint(this.getEvtYCord(n3));
            int n5 = n4 + (int)Math.rint(this.yDensity);
            if (n >= n4 && n <= n5) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    private ProcessState findState(int n, int n2) {
        int n3 = n2 / this.eachDispHt;
        if ((Integer)this.dtypeV.elementAt(n3) != 0) {
            return null;
        }
        int n4 = this.findIndex(n2 % this.eachDispHt);
        n2 %= this.eachDispHt;
        if (n4 != -1) {
            JProcess jProcess = (JProcess)this.procVector.elementAt(n4);
            if (jProcess.dispStatus) {
                Enumeration enumeration = jProcess.procStateVector.elements();
                while (enumeration.hasMoreElements()) {
                    ProcessState processState = (ProcessState)enumeration.nextElement();
                    if (!processState.info.stateDef.checkbox.isSelected() || this.getEvtXCord(processState.info.begT - this.currImg.begT) > this.cursorPos || this.cursorPos > this.getEvtXCord(processState.info.endT - this.currImg.begT) || !this.checkLevel(processState, n2)) continue;
                    return processState;
                }
            }
        }
        return null;
    }

    private boolean checkLevel(ProcessState processState, int n) {
        return n >= processState.y && n <= processState.y + processState.h;
    }

    int getIndex(Vector vector, int n) {
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            JProcess jProcess = (JProcess)enumeration.nextElement();
            if (jProcess.procId == n) break;
            ++n2;
        }
        return n2;
    }

    private ArrowInfo findMsg(int n, int n2) {
        if (this.arrowDispStatus) {
            int n3 = n2 / this.eachDispHt;
            if ((Integer)this.dtypeV.elementAt(n3) != 0) {
                return null;
            }
            int n4 = this.findIndex(n2 % this.eachDispHt);
            n2 %= this.eachDispHt;
            if (n4 != -1) {
                JProcess jProcess = (JProcess)this.procVector.elementAt(n4);
                Enumeration enumeration = this.parent.quiver.arrowVector.elements();
                while (enumeration.hasMoreElements()) {
                    ArrowInfo arrowInfo = (ArrowInfo)enumeration.nextElement();
                    if (arrowInfo.begProcId != jProcess.procId) continue;
                    int n5 = this.getEvtXCord(arrowInfo.begT - this.currImg.begT);
                    int n6 = jProcess.y;
                    if (n5 - this.img[0].brad > n - this._xPix || n - this._xPix > n5 + this.img[0].brad || n6 - this.img[0].brad > n2 || n2 > n6 + this.img[0].brad) continue;
                    return arrowInfo;
                }
            }
        }
        return null;
    }

    void calcArrowLens() {
        Enumeration enumeration = this.parent.quiver.arrowVector.elements();
        while (enumeration.hasMoreElements()) {
            ArrowInfo arrowInfo = (ArrowInfo)enumeration.nextElement();
            arrowInfo.lenT = (double)arrowInfo.size / (arrowInfo.endT - arrowInfo.begT);
        }
    }

    private void setupEventHandlers() {
        ((Component)((Object)this)).enableEvents(56L);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            this.adjustTimeField(mouseEvent.getX());
            this.adjustElTimeField();
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && this.parent.dtype == 0) {
            this.message = this.handleMsgDlg(mouseEvent);
            if (!this.message) {
                this.handleEventDlg(mouseEvent);
                return;
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    private void handleEventDlg(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 >= this.allDispHt) {
            return;
        }
        ProcessState processState = this.findState(n, n2);
        if (processState != null) {
            StateDlg stateDlg = new StateDlg((Frame)((Object)this.parent), processState);
            Point point = ((Component)((Object)this)).getLocationOnScreen();
            int n3 = n;
            int n4 = n2;
            ((Component)((Object)stateDlg)).setLocation(n3 += point.x, n4 += point.y);
            ((Component)((Object)stateDlg)).setVisible(true);
        }
    }

    private boolean handleMsgDlg(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 >= this.allDispHt) {
            return false;
        }
        ArrowInfo arrowInfo = this.findMsg(n, n2);
        if (arrowInfo != null) {
            MsgDlg msgDlg = new MsgDlg((Frame)((Object)this.parent), arrowInfo);
            Point point = ((Component)((Object)this)).getLocationOnScreen();
            int n3 = n;
            int n4 = n2;
            ((Component)((Object)msgDlg)).setLocation(n3 += point.x, n4 += point.y);
            ((Component)((Object)msgDlg)).setVisible(true);
            return true;
        }
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getID() == 401) {
            if (n == 90) {
                this.lockZoom();
                return;
            }
            if (n == 84) {
                this.fixElTimePointer(this.currTime);
                return;
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    private void lockZoom() {
        if (this.zoomLkLineDispStatus) {
            this.zXTime = this.currTime;
            ((Component)((Object)this)).repaint();
        }
    }

    void fixElTimePointer(double d) {
        if (this.elTLineDispStatus) {
            this.elapsedPoint = d;
            ((Component)((Object)this)).repaint();
        }
    }

    void zoomInH() {
        this.waitCursor();
        this.zoomH(this.zF);
        this.normalCursor();
    }

    void zoomOutH() {
        this.waitCursor();
        this.zoomH(1.0 / this.zF);
        this.normalCursor();
    }

    void resetView() {
        this.waitCursor();
        this.changeConst(1.0 / this.zoomH);
        if (this.maxH != this.widthCan) {
            this.maxT = this.tMaxT;
            this.xDensity = (double)this.widthCan / this.maxT;
            this.maxT += (double)this.endGap / this.xDensity;
            this.xDensity = (double)this.widthCan / this.maxT;
            this.updateH();
        }
        this.adjustZoomImg(0);
        this.normalCursor();
    }

    void zoomH(double d) {
        int n = this.maxH;
        this.zDist = this.getW(this.getTime(this.tbegH), this.zXTime);
        this.changeConst(d);
        int n2 = this.getEvtXCord(this.zXTime);
        int n3 = this.sbPos = (n > this.widthCan || this.maxH > this.widthCan) && n2 > this.zDist ? n2 - this.zDist : 0;
        if (this.sbPos + this.parent.hbar.getVisibleAmount() >= this.maxH) {
            this.sbPos = this.maxH - this.parent.hbar.getVisibleAmount();
        }
        if (this.sbPos < 0) {
            this.sbPos = 0;
        }
        this.adjustZoomImg(this.sbPos);
    }

    private void changeConst(double d) {
        this.zoomH *= d;
        this.xDensity *= d;
        this.updateH();
    }

    private void adjustZoomImg(int n) {
        this.getImgH(this.getCurrGridH(n));
        this.bflagH = false;
        this.fflagH = false;
        this.tbegH = n;
        if (n > 0) {
            int n2;
            int n3 = this.getW(this.currImg.begT, this.zXTime) - this.zDist;
            if (n3 > (n2 = this.getW(this.currImg.begT, this.maxT) - this.widthCan)) {
                n3 = n2;
            }
            this.panePosX = this._xPix + n3;
        } else {
            this.panePosX = this._xPix;
        }
        this.begTime = this.getTime(this.tbegH);
        this.adjustStartEndTimes();
    }

    void changeZoomFactor(double d) {
        if (d <= 0.0) {
            new ErrorDiag(null, "Value must be > 0");
            return;
        }
        this.zF = d;
    }

    void changeExTime(double d, double d2) {
        double d3 = d2 - d;
        if (d3 <= 0.0) {
            return;
        }
        int n = this.getW(0.0, d);
        this.parent.hbar.setValue(n);
        this.parent.setPosition(n);
        this.zoomH((this.endTime - this.begTime) / d3);
        this.parent.zoomH();
    }

    void changeToTime(double d) {
        if (d <= this.begTime) {
            new ErrorDiag(null, "value must be > " + Double.toString(this.begTime));
            return;
        }
        double d2 = d - this.begTime;
        int n = this.getW(0.0, this.begTime);
        this.parent.hbar.setValue(n);
        this.parent.setPosition(n);
        this.zoomH((this.endTime - this.begTime) / d2);
        this.parent.zoomH();
    }

    void changeFromTime(double d) {
        if (d >= this.endTime || d < 0.0) {
            new ErrorDiag(null, "value must be >= 0 and < " + Double.toString(this.endTime));
            return;
        }
        double d2 = this.endTime - d;
        int n = this.getW(0.0, d);
        this.parent.hbar.setValue(n);
        this.parent.setPosition(n);
        this.zoomH((this.endTime - this.begTime) / d2);
        this.parent.zoomH();
    }

    void Resize() {
        this.waitCursor();
        Dimension dimension = this.parent.vport.getExtentSize();
        this.widthCan = dimension.width;
        this.heightCan = dimension.height;
        this._xPix = 3 * this.widthCan;
        this._yPix = this.heightCan;
        if (this._yPix < 1) {
            this._yPix = 1;
        }
        if (this._xPix < 1) {
            this._xPix = 1;
        }
        this.setPreferredSize(this.getPreferredSize());
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        this.maxT = this.tMaxT;
        this.xDensity = (double)this.widthCan / this.maxT * this.zoomH;
        this.maxT += (double)this.endGap / this.xDensity;
        this.xDensity = (double)this.widthCan / this.maxT * this.zoomH;
        this.updateH();
        this.setupImg();
        if (!this.setupComplete) {
            this.drawInitImg();
        } else {
            this.sbPos = this.getEvtXCord(this.begTime);
            this.currImg = this.img[0];
            this.adjustZoomImg(this.sbPos);
        }
        this.panePosX = this._xPix + this.getW(this.currImg.begT, this.begTime);
        this.parent.zoomH();
        this.normalCursor();
    }

    void Refresh() {
        this.waitCursor();
        this.blink = false;
        this.blFlag = true;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        int n = this.getPrev(this.currImg.imgIdH);
        int n2 = this.getNext(this.currImg.imgIdH);
        this.setupNestedStates();
        this.img[n].drawStuff();
        this.img[n2].drawStuff();
        this.currImg.drawStuff();
        if (this.blink) {
            this.timer.start();
        }
        ((Component)((Object)this)).repaint();
        ((Component)((Object)this.parent.vcanvas1)).repaint();
        ((Component)((Object)this.parent.vcanvas2)).repaint();
        this.parent.vport.setViewPosition(new Point(this.panePosX, 0));
        this.normalCursor();
    }

    void DeleteProc(int n) {
        JProcess jProcess = (JProcess)this.procVector.elementAt(n);
        this.procVector.removeElementAt(n);
        this.dprocVector.addElement(jProcess);
        --this.proct;
        ++this.dproct;
        this.calcYDensity();
    }

    void InsertProc(int n, int n2) {
        JProcess jProcess = (JProcess)this.dprocVector.elementAt(n);
        this.dprocVector.removeElementAt(n);
        this.procVector.insertElementAt(jProcess, this.getIndex(this.procVector, n2));
        ++this.proct;
        --this.dproct;
        this.calcYDensity();
    }

    private void pushTimeLine(JProcess jProcess, double d) {
        Enumeration enumeration = jProcess.procStateVector.elements();
        ProcessState processState = (ProcessState)jProcess.procStateVector.firstElement();
        if (processState != null) {
            processState.info.begT += d;
            if (processState.info.begT < 0.0) {
                d -= processState.info.begT;
                processState.info.begT = 0.0;
            }
            processState.info.endT += d;
            enumeration.nextElement();
        }
        while (enumeration.hasMoreElements()) {
            processState = (ProcessState)enumeration.nextElement();
            processState.info.begT += d;
            processState.info.endT += d;
        }
        this.pushArrows(jProcess, d);
        this.adjustPosition();
    }

    void pushTimeLine(JProcess jProcess, int n, boolean bl) {
        double d = this.getTime(n);
        if (!bl) {
            d *= -1.0;
        }
        this.pushTimeLine(jProcess, d);
    }

    private void pushArrows(JProcess jProcess, double d) {
        Enumeration enumeration = this.parent.quiver.arrowVector.elements();
        while (enumeration.hasMoreElements()) {
            ArrowInfo arrowInfo = (ArrowInfo)enumeration.nextElement();
            if (arrowInfo.begProcId == jProcess.procId) {
                arrowInfo.begT += d;
            }
            if (arrowInfo.endProcId != jProcess.procId) continue;
            arrowInfo.endT += d;
        }
    }

    private void adjustPosition() {
        double d = 0.0;
        Enumeration enumeration = this.procVector.elements();
        while (enumeration.hasMoreElements()) {
            JProcess jProcess = (JProcess)enumeration.nextElement();
            ProcessState processState = (ProcessState)jProcess.procStateVector.lastElement();
            if (!(processState.info.endT > d)) continue;
            d = processState.info.endT;
        }
        boolean bl = false;
        if (d < this.tMaxT || d > this.tMaxT) {
            if (d < this.tMaxT) {
                bl = true;
            }
            double d2 = this.tMaxT - d;
            this.tMaxT = d;
            this.maxT -= d2;
            this.updateH();
            this.parent.setHoriz();
            this.centralizeH();
        }
        if (bl && this.parent.hbar.getValue() + this.parent.hbar.getVisibleAmount() >= this.parent.hbar.getMaximum()) {
            this.parent.hbar.setValue(this.maxH - this.widthCan);
            this.adjustImgH(this.parent.hbar.getValue());
            this.parent.vport.setViewPosition(new Point(this.panePosX, 0));
        }
    }

    int getMaxDiff(JProcess jProcess) {
        if (jProcess.procStateVector.size() > 0) {
            ProcessState processState = (ProcessState)jProcess.procStateVector.firstElement();
            return this.getEvtXCord(processState.info.begT - 0.0);
        }
        return 0;
    }

    void resetTimeLine(JProcess jProcess) {
        ProcessState processState = (ProcessState)jProcess.procStateVector.firstElement();
        this.pushTimeLine(jProcess, jProcess.begT - processState.info.begT);
    }

    void changeNestFactor(double d) {
        if (this.maxLevel < 1) {
            return;
        }
        double d2 = 1.0 / (double)this.maxLevel;
        if (d < 0.0 || d >= d2) {
            new ErrorDiag(null, "Value must be > 0 and < " + new Double(d2).toString());
            return;
        }
        this.nestFactor = d;
        this.Refresh();
    }

    double doAppropNesting() {
        this.changeNestFactor(1.0 / ((double)this.maxLevel + 1.0));
        return this.nestFactor;
    }

    int getPanePosX() {
        return this.panePosX;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._xPix * 3, this._yPix);
    }

    void adjustTimeField(int n) {
        this.cursorPos = n - this._xPix;
        this.currTime = this.currImg.begT + this.getTime(this.cursorPos);
        this.parent.adjustTimeField(this.currTime);
    }

    void adjustElTimeField() {
        this.parent.adjustElTimeField(this.currTime - this.elapsedPoint);
    }

    void adjustStartEndTimes() {
        this.endTime = this.begTime + this.getTime(this.widthCan);
        this.parent.optionsDlg.adjustTimes(this.begTime, this.endTime);
    }

    void addDisplay(int n) {
        this.waitCursor();
        this.dtypeV.addElement(new Integer(n));
        this.setupImg();
        this.sbPos = this.getEvtXCord(this.begTime);
        this.currImg = this.img[0];
        this.adjustZoomImg(this.sbPos);
        this.panePosX = this._xPix + this.getW(this.currImg.begT, this.begTime);
        this.parent.zoomH();
        this.normalCursor();
    }

    void removeDisplay(int n) {
        this.waitCursor();
        this.dtypeV.removeElementAt(n);
        this.setupImg();
        this.sbPos = this.getEvtXCord(this.begTime);
        this.currImg = this.img[0];
        this.adjustZoomImg(this.sbPos);
        this.panePosX = this._xPix + this.getW(this.currImg.begT, this.begTime);
        this.parent.zoomH();
        this.normalCursor();
    }

    void waitCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(3));
    }

    void normalCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(1));
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.parent.waitCursor();
        if (this.parent.setupComplete) {
            this.Resize();
        }
        this.parent.normalCursor();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void kill() {
        this.resetProcTimes();
        this.procVector = null;
        this.dprocVector = null;
        this.killImgs();
    }

    private void resetProcTimes() {
        int n = 0;
        while (n < this.procVector.size()) {
            this.resetTimeLine((JProcess)this.procVector.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.dprocVector.size()) {
            this.resetTimeLine((JProcess)this.dprocVector.elementAt(n2));
            ++n2;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    boolean getZLkLineDStat() {
        return this.zoomLkLineDispStatus;
    }

    boolean getElTLineDStat() {
        return this.elTLineDispStatus;
    }

    void updateZLkLineDStat(boolean bl) {
        this.zoomLkLineDispStatus = bl;
        ((Component)((Object)this)).repaint();
    }

    void updateElTLineDStat(boolean bl) {
        this.elTLineDispStatus = bl;
        ((Component)((Object)this)).repaint();
    }

    class TimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ProgramCanvas.this.blFlag = !ProgramCanvas.this.blFlag;
            ((Component)((Object)ProgramCanvas.this)).repaint();
        }

        TimerListener() {
            ProgramCanvas.this = ProgramCanvas.this;
        }
    }
}

