/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTree;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.CellEditorListener;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.AbstractTreeUI;
import com.sun.java.swing.plaf.basic.BasicLargeTreeModelNode;
import com.sun.java.swing.plaf.basic.BasicTreeCellEditor;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import com.sun.java.swing.plaf.basic.BasicVisibleTreeNode;
import com.sun.java.swing.plaf.basic.LargeTreeModelNode;
import com.sun.java.swing.plaf.basic.VisibleTreeNode;
import com.sun.java.swing.tree.TreeCellEditor;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import com.sun.java.swing.tree.TreeSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class BasicTreeUI
extends AbstractTreeUI
implements CellEditorListener,
FocusListener,
KeyListener,
MouseListener,
PropertyChangeListener {
    private static final int LEFT_CHILD_INDENT = 7;
    private static final int RIGHT_CHILD_INDENT = 13;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected Action repeatKeyAction;
    protected boolean isKeyDown;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension cPreferredSize;
    protected boolean validCachedPreferredSize;
    protected transient ComponentAdapter componentListener;
    protected Vector drawingCache;
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public void setLargeModel(boolean bl) {
        if (bl && this.tree != null && this.componentListener == null) {
            this.componentListener = new 1();
            this.tree.addComponentListener(this.componentListener);
        } else if (!bl && this.tree != null && this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
        super.setLargeModel(bl);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        this.tree = (JTree)jComponent;
        this.drawingCache = new Vector();
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.setLeftChildIndent(7);
        this.setRightChildIndent(13);
        this.cPreferredSize = new Dimension();
        this.rendererPane = this.createCellRendererPane(jComponent);
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
        this.installKeyboardActions(jComponent);
        this.setRowHeight(this.tree.getRowHeight());
        this.setRootVisible(this.tree.isRootVisible());
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.setModel(this.tree.getModel());
        this.setSelectionModel(this.tree.getSelectionModel());
        this.setLargeModel(this.tree.isLargeModel());
        this.updateRenderer();
        this.validCachedPreferredSize = false;
    }

    protected void installDefaults(JComponent jComponent) {
        if (jComponent.getBackground() == null || jComponent.getBackground() instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (jComponent.getFont() == null || jComponent.getFont() instanceof UIResource) {
            ((Component)jComponent).setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
    }

    protected void installListeners(JComponent jComponent) {
        this.propertyChangeListener = this.createPropertyChangeListener(jComponent);
        if (this.propertyChangeListener != null) {
            jComponent.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener(jComponent)) != null) {
            jComponent.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener(jComponent)) != null) {
            jComponent.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener(jComponent)) != null) {
            jComponent.addKeyListener(this.keyListener);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return this;
    }

    protected MouseListener createMouseListener(JComponent jComponent) {
        return this;
    }

    protected FocusListener createFocusListener(JComponent jComponent) {
        return this;
    }

    protected KeyListener createKeyListener(JComponent jComponent) {
        return this;
    }

    protected CellRendererPane createCellRendererPane(JComponent jComponent) {
        return new CellRendererPane();
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.tree.remove(this.rendererPane);
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
        this.uninstallKeyboardActions(jComponent);
        this.checkConsistency();
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.setModel(null);
        this.tree = null;
        this.drawingCache = null;
    }

    protected void uninstallDefaults(JComponent jComponent) {
    }

    protected void uninstallListeners(JComponent jComponent) {
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            jComponent.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            jComponent.removeMouseListener(this.mouseListener);
        }
        if (this.focusListener != null) {
            jComponent.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            jComponent.removeKeyListener(this.keyListener);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.tree) {
            String string = propertyChangeEvent.getPropertyName();
            this.completeEditing();
            if (string.equals("cellRenderer")) {
                this.updateRenderer();
                this.tree.repaint();
                return;
            }
            if (string.equals("treeModel")) {
                this.setModel((TreeModel)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("rootVisible")) {
                this.setRootVisible((Boolean)propertyChangeEvent.getNewValue());
                this.tree.repaint();
                return;
            }
            if (string.equals("showsRootHandles")) {
                this.setShowsRootHandles((Boolean)propertyChangeEvent.getNewValue());
                this.tree.repaint();
                return;
            }
            if (string.equals("rowHeight")) {
                this.setRowHeight((Integer)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("cellEditor")) {
                this.updateCellEditor();
                return;
            }
            if (string.equals("editable")) {
                this.updateCellEditor();
                return;
            }
            if (string.equals("largeModel")) {
                this.setLargeModel(this.tree.isLargeModel());
                return;
            }
            if (string.equals("selectionModel")) {
                this.setSelectionModel(this.tree.getSelectionModel());
                return;
            }
        } else if (propertyChangeEvent.getSource() == this.treeSelectionModel) {
            this.treeSelectionModel.resetRowSelection();
        }
    }

    protected void installKeyboardActions(JComponent jComponent) {
        jComponent.registerKeyboardAction(new TreeIncrementAction(-1, "UP"), KeyStroke.getKeyStroke(38, 0), 0);
        jComponent.registerKeyboardAction(new TreeIncrementAction(1, "DOWN"), KeyStroke.getKeyStroke(40, 0), 0);
        jComponent.registerKeyboardAction(new TreeTraverseAction(1, "RIGHT"), KeyStroke.getKeyStroke(39, 0), 0);
        jComponent.registerKeyboardAction(new TreeTraverseAction(-1, "LEFT"), KeyStroke.getKeyStroke(37, 0), 0);
        jComponent.registerKeyboardAction(new TreePageAction(-1, "P_UP"), KeyStroke.getKeyStroke(33, 0), 0);
        jComponent.registerKeyboardAction(new TreePageAction(1, "P_DOWN"), KeyStroke.getKeyStroke(34, 0), 0);
        jComponent.registerKeyboardAction(new TreeHomeAction(-1, "HOME"), KeyStroke.getKeyStroke(36, 0), 0);
        jComponent.registerKeyboardAction(new TreeHomeAction(1, "END"), KeyStroke.getKeyStroke(35, 0), 0);
        jComponent.registerKeyboardAction(new TreeToggleAction("TOGGLE"), KeyStroke.getKeyStroke(10, 0), 0);
    }

    protected void uninstallKeyboardActions(JComponent jComponent) {
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(36, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(35, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
    }

    protected void updateCellEditor() {
        TreeCellEditor treeCellEditor;
        this.completeEditing();
        if (this.tree == null) {
            treeCellEditor = null;
        } else if (this.tree.isEditable()) {
            treeCellEditor = this.tree.getCellEditor();
            if (treeCellEditor == null && (treeCellEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(treeCellEditor);
                this.createdCellEditor = true;
            }
        } else {
            treeCellEditor = null;
        }
        if (treeCellEditor != this.cellEditor) {
            if (this.cellEditor != null) {
                this.cellEditor.removeCellEditorListener(this);
            }
            this.cellEditor = treeCellEditor;
            if (treeCellEditor != null) {
                treeCellEditor.addCellEditorListener(this);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer == null && this.tree != null) {
            this.tree.setCellRenderer(this.createDefaultCellRenderer());
            this.createdRenderer = true;
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = treeCellRenderer;
            if (!this.largeModel) {
                this.updateNodeSizes(true);
            }
            if (this.createdCellEditor && this.tree != null) {
                this.tree.setCellEditor(null);
            }
        }
        this.updateCellEditor();
    }

    public boolean checkConsistency() {
        if (this.tree != null && this.updateNodeSizes) {
            if (!this.largeModel) {
                this.updateNodeSizes(true);
            }
            return true;
        }
        return false;
    }

    public void updateNodeSizes(boolean bl) {
        super.updateNodeSizes(bl);
        this.validCachedPreferredSize = false;
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof BasicTreeCellRenderer) {
            return new BasicTreeCellEditor((BasicTreeCellRenderer)this.currentCellRenderer);
        }
        return new BasicTreeCellEditor(null);
    }

    public TreeCellRenderer createDefaultCellRenderer() {
        return new BasicTreeCellRenderer();
    }

    public int getXOriginOfNode(VisibleTreeNode visibleTreeNode) {
        int n = visibleTreeNode.getVisibleLevel();
        if (this.getShowsRootHandles()) {
            ++n;
        }
        return this.totalChildIndent * n;
    }

    public Dimension getSizeOfNode(VisibleTreeNode visibleTreeNode, int n) {
        Component component = null;
        if (this.currentCellRenderer != null) {
            component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, visibleTreeNode.getValue(), false, visibleTreeNode.isExpanded(), visibleTreeNode.isLeaf(), n, false);
            if (this.tree != null) {
                this.rendererPane.add(component);
                component.validate();
                return component.getPreferredSize();
            }
            return component.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    protected Rectangle getLargeBoundsOf(LargeTreeModelNode largeTreeModelNode, int n, Object object) {
        return this.getLargeBoundsOf(largeTreeModelNode, n, object, null, null);
    }

    protected Rectangle getLargeBoundsOf(LargeTreeModelNode largeTreeModelNode, int n, Object object, Component component, Rectangle[] rectangleArray) {
        int n2;
        Rectangle rectangle = rectangleArray == null ? new Rectangle() : rectangleArray[0];
        if (largeTreeModelNode == null) {
            n2 = 0;
        } else {
            n2 = largeTreeModelNode.getVisibleLevel() + 1;
            if (this.getShowsRootHandles()) {
                ++n2;
            }
        }
        rectangle.x = this.totalChildIndent * n2;
        rectangle.y = n * this.rowHeight;
        rectangle.height = this.rowHeight;
        if (component == null) {
            if (this.currentCellRenderer != null) {
                Component component2 = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, object, false, false, false, n, false);
                if (this.tree != null) {
                    this.rendererPane.add(component2);
                    component2.validate();
                }
                Dimension dimension = component2.getPreferredSize();
                rectangle.width = dimension.width;
            } else {
                rectangle.width = 0;
            }
        } else {
            Dimension dimension = component.getPreferredSize();
            rectangle.width = dimension.width;
        }
        return rectangle;
    }

    protected void updateCachedPreferredSize() {
        if (!this.largeModel) {
            int n;
            int n2 = this.getRowCount();
            if (n2 > 0) {
                if (!this.isFixedRowHeight()) {
                    VisibleTreeNode visibleTreeNode = this.getNode(n2 - 1);
                    n = visibleTreeNode.getYOrigin() + visibleTreeNode.getPreferredSize().height;
                } else {
                    n = this.getRowHeight() * n2;
                }
            } else {
                n = 0;
            }
            this.cPreferredSize.height = n;
            this.cPreferredSize.width = this.getMaxNodeWidth();
        } else if (this.tree != null) {
            int n = 0;
            Rectangle rectangle = this.tree.getVisibleRect();
            int n3 = this.getRowContainingYLocation(rectangle.y);
            int n4 = this.getRowContainingYLocation(rectangle.y + rectangle.height);
            if (n3 != -1 && n3 != -1) {
                while (n3 <= n4) {
                    Rectangle rectangle2 = this.getRowBounds(n3);
                    if (rectangle2 != null) {
                        n = Math.max(n, rectangle2.x + rectangle2.width);
                    }
                    ++n3;
                }
            }
            this.cPreferredSize.width = n;
            this.cPreferredSize.height = this.getRowCount() * this.getRowHeight();
        } else {
            this.cPreferredSize.height = 0;
            this.cPreferredSize.width = 0;
        }
        this.validCachedPreferredSize = true;
    }

    public void visibleNodesChanged() {
        if (this.tree != null) {
            this.validCachedPreferredSize = false;
            this.tree.treeDidChange();
        }
    }

    protected void pathWasExpanded(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(treePath);
        }
    }

    protected void pathWasCollapsed(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(treePath);
        }
    }

    public void ensureRowsAreVisible(int n, int n2) {
        if (this.tree != null && n >= 0 && n2 < this.getRowCount()) {
            Rectangle rectangle;
            if (n == n2) {
                this.tree.scrollRectToVisible(this.getRowBounds(n));
                return;
            }
            Rectangle rectangle2 = rectangle = this.getRowBounds(n);
            int n3 = rectangle.y;
            int n4 = rectangle.x + rectangle.width;
            int n5 = rectangle.x;
            int n6 = this.tree.getVisibleRect().height;
            int n7 = n + 1;
            while (n7 < n2) {
                rectangle2 = this.getRowBounds(n7);
                if (rectangle2.width + rectangle2.x > n4) {
                    n4 = rectangle2.width + rectangle2.x;
                }
                if (rectangle2.x < n5) {
                    n5 = rectangle2.x;
                }
                if (rectangle2.y + rectangle2.height - n3 > n6) {
                    n7 = n2;
                }
                ++n7;
            }
            this.tree.scrollRectToVisible(new Rectangle(n5, n3, n4 - n5, rectangle2.y + rectangle2.height - n3));
        }
    }

    public void scrollPathToVisible(TreePath treePath) {
        this.makeVisible(treePath);
        Rectangle rectangle = this.getPathBounds(treePath);
        if (rectangle != null && this.tree != null) {
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    public void scrollRowToVisible(int n) {
        Rectangle rectangle = this.getRowBounds(n);
        if (rectangle != null && this.tree != null) {
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    public TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    protected LargeTreeModelNode createExpandedNodeForValue(Object object, int n) {
        return new BasicLargeTreeModelNode(this, object, n);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        if (this.tree != jComponent) {
            throw new InternalError("incorrect component");
        }
        this.checkConsistency();
        this.getCellRenderer();
        this.tree.getBackground();
        jComponent.getSize();
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowContainingYLocation(rectangle.y);
        int n2 = this.getRowContainingYLocation(rectangle.y + rectangle.height);
        boolean bl2 = bl = n > -1 && n2 > -1;
        if (bl && this.largeModel) {
            int[] nArray = new int[1];
            if (this.isRootVisible()) {
                nArray[0] = 0;
                ((BasicLargeTreeModelNode)this.largeRoot).paintAll(new BasicTreeUIPaintInfo(this, graphics), nArray, n, n2, 0, this);
                return;
            }
            nArray[0] = -1;
            ((BasicLargeTreeModelNode)this.largeRoot).paintAll(new BasicTreeUIPaintInfo(this, graphics), nArray, n, n2, -1, this);
            return;
        }
        if (bl) {
            graphics.setColor(this.getHashColor());
            VisibleTreeNode visibleTreeNode = this.getNode(n);
            VisibleTreeNode visibleTreeNode2 = (VisibleTreeNode)visibleTreeNode.getParent();
            while (visibleTreeNode2 != null) {
                VisibleTreeNode visibleTreeNode3 = (VisibleTreeNode)visibleTreeNode2.getLastChild();
                this.drawVerticalPartOfLeg(graphics, jComponent, visibleTreeNode2.getVisibleLevel(), this.getNodeY(visibleTreeNode2), this.getNodeY(visibleTreeNode3), this.getNodeHeight(visibleTreeNode2), this.getNodeHeight(visibleTreeNode3));
                this.drawingCache.addElement(visibleTreeNode2);
                visibleTreeNode2 = (VisibleTreeNode)visibleTreeNode2.getParent();
            }
            int n3 = n;
            while (n3 <= n2) {
                visibleTreeNode = this.getNode(n3);
                visibleTreeNode2 = (VisibleTreeNode)visibleTreeNode.getParent();
                if (visibleTreeNode2 != null && !this.drawingCache.contains(visibleTreeNode2)) {
                    VisibleTreeNode visibleTreeNode4 = (VisibleTreeNode)visibleTreeNode2.getLastChild();
                    this.drawVerticalPartOfLeg(graphics, jComponent, visibleTreeNode2.getVisibleLevel(), this.getNodeY(visibleTreeNode2), this.getNodeY(visibleTreeNode4), this.getNodeHeight(visibleTreeNode2), this.getNodeHeight(visibleTreeNode4));
                    this.drawingCache.addElement(visibleTreeNode2);
                }
                if (visibleTreeNode2 != null) {
                    this.drawHorizontalPartOfLeg(graphics, jComponent, this.getNodeY(visibleTreeNode) + this.getNodeHeight(visibleTreeNode) / 2, this.getNodeX(visibleTreeNode2) + 8, this.getNodeX(visibleTreeNode));
                }
                int n4 = this.getNodeX(visibleTreeNode);
                int n5 = this.getNodeY(visibleTreeNode);
                int n6 = this.getNodeHeight(visibleTreeNode);
                if (this.shouldPaintExpandControl(visibleTreeNode2, visibleTreeNode)) {
                    this.paintExpandControl(graphics, jComponent, visibleTreeNode2, visibleTreeNode, n4, n5, n6, n3);
                }
                this.paintRow(graphics, jComponent, visibleTreeNode2, visibleTreeNode, n4, n5, n6, n3);
                ++n3;
            }
            this.drawingCache.removeAllElements();
        }
    }

    protected boolean shouldPaintExpandControl(VisibleTreeNode visibleTreeNode, VisibleTreeNode visibleTreeNode2) {
        boolean bl = true;
        if (visibleTreeNode2.getLevel() == 0 && !this.getShowsRootHandles() || visibleTreeNode2.getLevel() == 1 && !this.isRootVisible() && !this.getShowsRootHandles()) {
            bl = false;
        }
        return bl;
    }

    protected int getNodeX(VisibleTreeNode visibleTreeNode) {
        int n = this.getShowsRootHandles() ? 1 : 0;
        return (visibleTreeNode.getVisibleLevel() + n) * this.totalChildIndent;
    }

    protected int getNodeY(VisibleTreeNode visibleTreeNode) {
        return visibleTreeNode.getYOrigin();
    }

    protected int getNodeHeight(VisibleTreeNode visibleTreeNode) {
        if (this.isFixedRowHeight()) {
            return this.getRowHeight();
        }
        return visibleTreeNode.getPreferredSize().height;
    }

    public void drawVerticalPartOfLeg(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getShowsRootHandles() ? 1 : 0;
        int n7 = (n + n6) * this.totalChildIndent + 8;
        Rectangle rectangle = graphics.getClipBounds();
        int n8 = rectangle.x;
        int n9 = rectangle.x + (rectangle.width - 1);
        if (n7 > n8 && n7 < n9) {
            int n10 = rectangle.y;
            int n11 = rectangle.y + rectangle.height;
            int n12 = Math.max(n2 + n4 + this.getVerticalLegBuffer(), n10);
            int n13 = Math.min(n3 + n5 / 2, n11);
            graphics.setColor(this.getHashColor());
            this.drawVerticalLine(graphics, jComponent, n7, n12, n13);
        }
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    protected void drawVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.drawLine(n, n2, n, n3);
    }

    public void drawHorizontalPartOfLeg(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = rectangle.x;
        int n5 = rectangle.x + (rectangle.width - 1);
        int n6 = rectangle.y;
        int n7 = rectangle.y + (rectangle.height - 1);
        if (n > n6 && n < n7 && (n3 -= this.getHorizontalLegBuffer()) > n4 && n2 < n5) {
            n2 = Math.max(n2, n4);
            n3 = Math.min(n3, n5);
            graphics.setColor(this.getHashColor());
            this.drawHorizontalLine(graphics, jComponent, n, n2, n3);
        }
    }

    protected void drawHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.drawLine(n2, n, n3, n);
    }

    protected void paintRow(Graphics graphics, JComponent jComponent, VisibleTreeNode visibleTreeNode, VisibleTreeNode visibleTreeNode2, int n, int n2, int n3, int n4) {
        int n5 = -1;
        if (this.tree.hasFocus()) {
            n5 = this.tree.getLeadSelectionRow();
        }
        Component component = this.getCellRenderer().getTreeCellRendererComponent(this.tree, visibleTreeNode2.getValue(), this.isSelectedIndex(n4), visibleTreeNode2.isExpanded(), visibleTreeNode2.isLeaf(), n4, n5 == n4);
        this.rendererPane.paintComponent(graphics, component, this.tree, n, n2, visibleTreeNode2.getPreferredSize().width, n3, true);
    }

    protected void paintExpandControl(Graphics graphics, JComponent jComponent, VisibleTreeNode visibleTreeNode, VisibleTreeNode visibleTreeNode2, int n, int n2, int n3, int n4) {
        if (!(visibleTreeNode2.isLeaf() || visibleTreeNode2.hasBeenExpanded() && visibleTreeNode2.getModelChildCount() <= 0)) {
            int n5 = n - (this.getRightChildIndent() - 1);
            int n6 = n2 + n3 / 2;
            if (visibleTreeNode2.isExpanded()) {
                Icon icon = this.getExpandedIcon();
                if (icon != null) {
                    this.drawCentered(jComponent, graphics, icon, n5, n6);
                    return;
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                if (icon != null) {
                    this.drawCentered(jComponent, graphics, icon, n5, n6);
                }
            }
        }
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, n - icon.getIconWidth() / 2, n2 - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        int n4 = n2;
        while (n4 <= n3) {
            graphics.drawLine(n4, n, n4, n);
            n4 += 2;
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        int n4 = n2;
        while (n4 <= n3) {
            graphics.drawLine(n, n4, n, n4);
            n4 += 2;
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, true);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        Dimension dimension = this.getPreferredMinSize();
        if (bl) {
            this.checkConsistency();
        }
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.cPreferredSize.width), Math.max(dimension.height, this.cPreferredSize.height));
            }
            return new Dimension(this.cPreferredSize.width, this.cPreferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Rectangle rectangle;
        this.completeEditing();
        super.valueChanged(treeSelectionEvent);
        this.lastSelectedRow = this.getMinSelectionRow();
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        Rectangle rectangle2 = this.tree.getVisibleRect();
        boolean bl = true;
        int n = this.tree.getSize().width;
        if (treePathArray != null) {
            int n2 = treePathArray.length;
            if (n2 > 4) {
                this.tree.repaint();
                bl = false;
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    rectangle = this.getPathBounds(treePathArray[n3]);
                    if (rectangle != null && rectangle2.intersects(rectangle)) {
                        this.tree.repaint(0, rectangle.y, n, rectangle.height);
                    }
                    ++n3;
                }
            }
        }
        if (bl) {
            rectangle = this.getPathBounds(treeSelectionEvent.getOldLeadSelectionPath());
            if (rectangle != null && rectangle2.intersects(rectangle)) {
                this.tree.repaint(0, rectangle.y, n, rectangle.height);
            }
            if ((rectangle = this.getPathBounds(treeSelectionEvent.getNewLeadSelectionPath())) != null && rectangle2.intersects(rectangle)) {
                this.tree.repaint(0, rectangle.y, n, rectangle.height);
            }
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        this.completeEditing(false, false, true);
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.completeEditing(false, false, false);
    }

    public boolean isEditing() {
        return this.editingComponent != null;
    }

    public boolean stopEditing() {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing() {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            TreePath treePath = this.editingPath;
            TreeCellEditor treeCellEditor = this.cellEditor;
            Object object = treeCellEditor.getCellEditorValue();
            Rectangle rectangle = this.getPathBounds(this.editingPath);
            this.editingComponent = null;
            this.editingPath = null;
            if (bl) {
                treeCellEditor.stopCellEditing();
            } else if (bl2) {
                treeCellEditor.cancelCellEditing();
            }
            this.tree.remove(component);
            rectangle.x = 0;
            rectangle.width = this.tree.getSize().width;
            this.tree.repaint(rectangle);
            if (bl3) {
                this.treeModel.valueForPathChanged(treePath, object);
            }
        }
    }

    public void startEditingAtPath(TreePath treePath) {
        this.scrollPathToVisible(treePath);
        if (treePath != null && this.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(treePath)) {
            int n = this.getRowForPath(treePath);
            this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, treePath.getLastPathComponent(), this.isPathSelected(treePath), this.isExpanded(treePath), this.treeModel.isLeaf(treePath.getLastPathComponent()), n);
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                Rectangle rectangle = this.getPathBounds(treePath);
                if (this.editingComponent.getFont() == null) {
                    this.editingComponent.setFont(this.tree.getFont());
                }
                this.editingComponent.getPreferredSize();
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.editingPath = treePath;
                this.editingComponent.validate();
                this.tree.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.tree.setSelectionRow(n);
                    }
                    catch (Exception exception) {
                        System.out.println("Editing exception: " + exception);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (mouseEvent != null && mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.tree, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    new BasicTreeMouseListener(this.tree, SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y), mouseEvent);
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    public TreePath getEditingPath() {
        return this.editingPath;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (this.tree != null && this.tree.isEnabled()) {
            this.tree.requestFocus();
        }
        this.checkConsistency();
        if (this.tree != null && this.tree.isEnabled()) {
            n = this.getRowContainingYLocation(mouseEvent.getY());
            if (n != -1) {
                Rectangle rectangle = this.getRowBounds(n);
                if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                    n = -1;
                }
            }
        } else {
            n = -1;
        }
        if (n > -1 && n < this.getRowCount()) {
            int n2;
            int n3;
            int n4 = -1;
            LargeTreeModelNode largeTreeModelNode = null;
            VisibleTreeNode visibleTreeNode = null;
            if (!this.largeModel) {
                visibleTreeNode = this.getNode(n);
                n3 = visibleTreeNode.getVisibleLevel();
            } else if (n == 0 && this.isRootVisible()) {
                largeTreeModelNode = this.largeRoot;
                n3 = 0;
            } else {
                int[] nArray = new int[1];
                largeTreeModelNode = this.getLargeParentAndChildIndexOfRow(n, nArray);
                n3 = largeTreeModelNode.getVisibleLevel() + 1;
                n4 = nArray[0];
            }
            this.checkForClickInExpandControl(visibleTreeNode, largeTreeModelNode, n4, n, n3, mouseEvent.getX(), mouseEvent.getY());
            int n5 = mouseEvent.getX();
            int n6 = this.getShowsRootHandles() ? this.totalChildIndent * (n3 + 1) : this.totalChildIndent * n3;
            if (n5 > n6 && n5 <= (n2 = !this.largeModel ? visibleTreeNode.getPreferredSize().width : this.getRowBounds((int)n).width) + n6 && !this.startEditing(this.getPathForRow(n), mouseEvent)) {
                int n7 = this.lastSelectedRow;
                if (n7 >= this.getRowCount() || !this.isSelectedIndex(n7)) {
                    n7 = -1;
                }
                if (mouseEvent.isControlDown()) {
                    if (this.isSelectedIndex(n)) {
                        this.tree.removeSelectionInterval(n, n);
                    } else {
                        this.tree.addSelectionInterval(n, n);
                    }
                    if (n7 != -1) {
                        this.lastSelectedRow = n7;
                        return;
                    }
                } else if (mouseEvent.isShiftDown()) {
                    if (n7 == -1) {
                        this.tree.addSelectionInterval(n, n);
                    } else {
                        if (n < n7) {
                            this.tree.setSelectionInterval(n, n7);
                        } else {
                            this.tree.setSelectionInterval(n7, n);
                        }
                        this.lastSelectedRow = n7;
                    }
                    if (n7 != -1) {
                        this.lastSelectedRow = n7;
                        return;
                    }
                } else {
                    this.tree.setSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        if (!this.largeModel) {
                            visibleTreeNode.toggleExpanded();
                            this.ensureRowsAreVisible(n, n + Math.min(10, visibleTreeNode.visibleChildCount()));
                            return;
                        }
                        if (n4 == -1) {
                            largeTreeModelNode.toggleExpanded();
                            this.ensureRowsAreVisible(n, n + Math.min(10, largeTreeModelNode.getTotalChildCount()));
                            return;
                        }
                        if (!this.isExpanded(n)) {
                            this.expandRow(n);
                        } else {
                            this.collapseRow(n);
                        }
                        LargeTreeModelNode largeTreeModelNode2 = this.getLargeTreeModelNodeForRow(n, false);
                        if (largeTreeModelNode2 != null) {
                            this.ensureRowsAreVisible(n, n + Math.min(10, largeTreeModelNode2.getTotalChildCount()));
                            return;
                        }
                        this.ensureRowsAreVisible(n, n);
                    }
                }
            }
        }
    }

    protected void checkForClickInExpandControl(VisibleTreeNode visibleTreeNode, LargeTreeModelNode largeTreeModelNode, int n, int n2, int n3, int n4, int n5) {
        if (this.clickedInExpandControl(visibleTreeNode, largeTreeModelNode, n2, n3, n4, n5)) {
            this.handleExpandControlClick(visibleTreeNode, largeTreeModelNode, n, n2);
        }
    }

    protected boolean clickedInExpandControl(VisibleTreeNode visibleTreeNode, LargeTreeModelNode largeTreeModelNode, int n, int n2, int n3, int n4) {
        if (visibleTreeNode != null && visibleTreeNode.isLeaf()) {
            return false;
        }
        int n5 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
        int n6 = this.getShowsRootHandles() ? n2 * this.totalChildIndent + this.getLeftChildIndent() - n5 / 2 : (n2 - 1) * this.totalChildIndent + this.getLeftChildIndent() - n5 / 2;
        int n7 = n6 + n5;
        return n3 >= n6 && n3 <= n7;
    }

    public void handleExpandControlClick(VisibleTreeNode visibleTreeNode, LargeTreeModelNode largeTreeModelNode, int n, int n2) {
        if (!this.largeModel) {
            visibleTreeNode.toggleExpanded();
            this.ensureRowsAreVisible(n2, n2 + Math.min(10, visibleTreeNode.visibleChildCount()));
            return;
        }
        if (n == -1) {
            largeTreeModelNode.toggleExpanded();
            this.ensureRowsAreVisible(n2, n2 + Math.min(10, largeTreeModelNode.getTotalChildCount()));
            return;
        }
        this.toggleExpandState(n2);
        LargeTreeModelNode largeTreeModelNode2 = this.getLargeTreeModelNodeForRow(n2, false);
        if (largeTreeModelNode2 != null) {
            this.ensureRowsAreVisible(n2, n2 + Math.min(10, largeTreeModelNode2.getTotalChildCount()));
        }
    }

    protected void toggleExpandState(int n) {
        if (!this.isExpanded(n)) {
            this.expandRow(n);
            return;
        }
        this.collapseRow(n);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        int n;
        if (this.tree != null && (n = this.tree.getLeadSelectionRow()) != -1) {
            this.tree.repaint(this.getRowBounds(n));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focusGained(focusEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.tree.hasFocus() && this.tree.isEnabled()) {
            ActionListener actionListener;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
            this.repeatKeyAction = this.tree.getConditionForKeyStroke(keyStroke) == 0 ? ((actionListener = this.tree.getActionForKeyStroke(keyStroke)) instanceof Action ? (Action)actionListener : null) : null;
            if (this.isKeyDown && this.repeatKeyAction != null) {
                this.repeatKeyAction.actionPerformed(null);
                keyEvent.consume();
                return;
            }
            this.isKeyDown = true;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.isKeyDown = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setModel(TreeModel treeModel) {
        this.completeEditing();
        super.setModel(treeModel);
    }

    public void rebuild() {
        this.completeEditing();
        super.rebuild();
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        this.completeEditing();
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this);
        }
        super.setSelectionModel(treeSelectionModel);
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected VisibleTreeNode createNodeForValue(Object object, int n) {
        return new BasicVisibleTreeNode(this, object, n);
    }

    protected LargeTreeModelNode createLargeTreeModelNodeForValue(Object object, int n) {
        return new BasicLargeTreeModelNode(this, object, n);
    }

    protected void repaintNode(BasicLargeTreeModelNode basicLargeTreeModelNode) {
        if (this.tree != null) {
            this.tree.repaint(0, basicLargeTreeModelNode.getRow() * this.rowHeight, this.tree.getSize().width, this.rowHeight);
        }
    }

    protected void repaintNode(VisibleTreeNode visibleTreeNode) {
        Rectangle rectangle = visibleTreeNode.getNodeBounds();
        if (this.tree != null) {
            this.tree.repaint(0, rectangle.y, this.tree.getSize().width, rectangle.height);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.collapsedIcon != null && this.collapsedIcon instanceof Serializable) {
            vector.addElement("collapsedIcon");
            vector.addElement(this.collapsedIcon);
        }
        if (this.expandedIcon != null && this.expandedIcon instanceof Serializable) {
            vector.addElement("expandedIcon");
            vector.addElement(this.expandedIcon);
        }
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof Serializable) {
            vector.addElement("currentCellRenderer");
            vector.addElement(this.currentCellRenderer);
        }
        if (this.cellEditor != null && this.cellEditor instanceof Serializable) {
            vector.addElement("cellEditor");
            vector.addElement(this.cellEditor);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("collapsedIcon")) {
            this.collapsedIcon = (Icon)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("expandedIcon")) {
            this.expandedIcon = (Icon)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("currentCellRenderer")) {
            this.currentCellRenderer = (TreeCellRenderer)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("cellEditor")) {
            this.cellEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
        if (this.largeModel && this.tree != null && this.componentListener == null) {
            this.componentListener = new 2();
            this.tree.addComponentListener(this.componentListener);
        }
    }

    private final class 1
    extends ComponentAdapter {
        public void componentMoved(ComponentEvent componentEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentMoved(ComponentEvent componentEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
        }

        /* synthetic */ 2() {
        }
    }

    private class TreeTraverseAction
    extends AbstractAction
    implements Serializable {
        private int direction;

        public TreeTraverseAction(int n, String string) {
            super(string);
            BasicTreeUI.this = BasicTreeUI.this;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount()) > 0) {
                int n2;
                int n3 = BasicTreeUI.this.tree.getMinSelectionRow();
                if (n3 == -1) {
                    n2 = 0;
                } else if (this.direction == 1) {
                    if (!BasicTreeUI.this.isLeaf(n3) && !BasicTreeUI.this.isExpanded(n3)) {
                        BasicTreeUI.this.expandRow(n3);
                        n2 = -1;
                    } else {
                        n2 = Math.min(n3 + 1, n - 1);
                    }
                } else if (!BasicTreeUI.this.isLeaf(n3) && BasicTreeUI.this.isExpanded(n3)) {
                    BasicTreeUI.this.collapseRow(n3);
                    n2 = -1;
                } else {
                    try {
                        if (!BasicTreeUI.this.largeModel) {
                            n2 = ((VisibleTreeNode)BasicTreeUI.this.getNode(n3).getParent()).getRow();
                        } else {
                            int[] nArray = new int[1];
                            LargeTreeModelNode largeTreeModelNode = BasicTreeUI.this.getLargeParentAndChildIndexOfRow(n3, nArray);
                            n2 = largeTreeModelNode.getRow();
                        }
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                }
                if (n2 != -1) {
                    BasicTreeUI.this.tree.setSelectionInterval(n2, n2);
                    BasicTreeUI.this.ensureRowsAreVisible(n2, n2);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreePageAction
    extends AbstractAction
    implements Serializable {
        private int direction;

        public TreePageAction(int n, String string) {
            super(string);
            BasicTreeUI.this = BasicTreeUI.this;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount()) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                int n2;
                Rectangle rectangle;
                Dimension dimension = BasicTreeUI.this.tree.getSize();
                Rectangle rectangle2 = BasicTreeUI.this.tree.getVisibleRect();
                int n3 = Math.max(0, dimension.height - rectangle2.height);
                int n4 = this.direction == -1 ? BasicTreeUI.this.getMinSelectionRow() : BasicTreeUI.this.getMaxSelectionRow();
                if (n4 != -1) {
                    rectangle = BasicTreeUI.this.getRowBounds(n4);
                    rectangle2.y = this.direction == -1 ? Math.max(0, rectangle.y + rectangle.height - rectangle2.height) : Math.min(n3, rectangle.y);
                } else {
                    rectangle2.y = Math.min(n3, rectangle2.y + rectangle2.height * this.direction);
                }
                if (this.direction == 1) {
                    n2 = BasicTreeUI.this.getClosestRowForLocation(rectangle2.x, rectangle2.y + rectangle2.height - 1);
                    rectangle = BasicTreeUI.this.getRowBounds(n2);
                    rectangle2.y = Math.min(n3, rectangle.y + rectangle.height - rectangle2.height);
                } else {
                    n2 = BasicTreeUI.this.getClosestRowForLocation(rectangle2.x, rectangle2.y + 1);
                    rectangle = BasicTreeUI.this.getRowBounds(n2);
                    rectangle2.y = Math.min(n3, rectangle.y);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(rectangle2);
                BasicTreeUI.this.tree.setSelectionRow(n2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeIncrementAction
    extends AbstractAction
    implements Serializable {
        private int direction;

        public TreeIncrementAction(int n, String string) {
            super(string);
            BasicTreeUI.this = BasicTreeUI.this;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.treeSelectionModel != null && (n = BasicTreeUI.this.getRowCount()) > 0) {
                int n2 = BasicTreeUI.this.tree.getMaxSelectionRow();
                int n3 = n2 == -1 ? (this.direction == 1 ? 0 : n - 1) : Math.min(n - 1, Math.max(0, n2 + this.direction));
                BasicTreeUI.this.tree.setSelectionInterval(n3, n3);
                BasicTreeUI.this.ensureRowsAreVisible(n3, n3);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeHomeAction
    extends AbstractAction
    implements Serializable {
        private int direction;

        public TreeHomeAction(int n, String string) {
            super(string);
            BasicTreeUI.this = BasicTreeUI.this;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount();
            if (BasicTreeUI.this.tree != null && n > 0) {
                if (this.direction == -1) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                    return;
                }
                BasicTreeUI.this.ensureRowsAreVisible(n - 1, n - 1);
                BasicTreeUI.this.tree.setSelectionInterval(n - 1, n - 1);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeToggleAction
    extends AbstractAction
    implements Serializable {
        public TreeToggleAction(String string) {
            super(string);
            BasicTreeUI.this = BasicTreeUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.tree.getMinSelectionRow()) != -1 && !BasicTreeUI.this.isLeaf(n)) {
                if (BasicTreeUI.this.isExpanded(n)) {
                    BasicTreeUI.this.collapseRow(n);
                    return;
                }
                BasicTreeUI.this.expandRow(n);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class BasicTreeMouseListener
    implements MouseListener,
    MouseMotionListener,
    Serializable {
        protected Component source;
        protected Component destination;

        public BasicTreeMouseListener(Component component, Component component2, MouseEvent mouseEvent) {
            BasicTreeUI.this = BasicTreeUI.this;
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    public static class BasicTreeUIPaintInfo {
        public Graphics g;
        public TreeCellRenderer renderer;
        public int totalIndent;
        public Color hashColor;
        public int halfRowHeight;
        public int levelOffset;
        public Icon expandedIcon;
        public Icon collapsedIcon;
        public int rChildIndent;
        public int rowHeight;
        public JTree tree;
        public TreeModel treeModel;
        public int leadIndex;

        public BasicTreeUIPaintInfo(BasicTreeUI basicTreeUI, Graphics graphics) {
            this.reset(basicTreeUI, graphics);
        }

        public void reset(BasicTreeUI basicTreeUI, Graphics graphics) {
            this.g = graphics;
            this.renderer = basicTreeUI.getCellRenderer();
            this.totalIndent = basicTreeUI.totalChildIndent;
            this.hashColor = basicTreeUI.getHashColor();
            this.halfRowHeight = basicTreeUI.getRowHeight() / 2;
            this.levelOffset = basicTreeUI.getShowsRootHandles() ? 1 : 0;
            this.expandedIcon = basicTreeUI.getExpandedIcon();
            this.collapsedIcon = basicTreeUI.getCollapsedIcon();
            this.rChildIndent = basicTreeUI.getRightChildIndent();
            this.rowHeight = basicTreeUI.getRowHeight();
            this.tree = basicTreeUI.tree;
            this.treeModel = basicTreeUI.getModel();
            if (!basicTreeUI.tree.hasFocus()) {
                this.leadIndex = -1;
                return;
            }
            this.leadIndex = basicTreeUI.tree.getLeadSelectionRow();
        }
    }
}

