/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */


#ifndef __Scope_h
#define __Scope_h

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __PArray_h
#include "PArray.h"
#endif

#ifndef __Variable_h
#include "Variable.h"
#endif

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

class Symbol;
class Context;


class Scope : public PLinkS<Scope>, public AutoFree
{
public:
				Scope(Context *c);
				~Scope();

	bool				Define(const Symbol *name, int var);
	int					Lookup(const Symbol *name);
	bool				Contains(const Symbol *name)	{ return Lookup1(name)!= kIllegalVar; }
	
private:
	struct Mapping
	{
						Mapping() : fName(0), fVar(kIllegalVar) {}
						Mapping(const Symbol *name, int var) : fName(name), fVar(var) {}
						
		const Symbol *	fName;
		int				fVar;
	};
	
	int					Lookup1(const Symbol *name);
	
	PArray<Mapping>		fBindings;
	Context*			fContext;
	int					fContextMark;
};

#endif
