/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __Stmt_h
#define __Stmt_h

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

class Bytecode;
class CheckState;
class Mapping;

class Stmt :  public PLinkS<Stmt>, public AutoFree
{
public:
					Stmt()	{ fNullable = false; }
	virtual 		~Stmt();

	virtual bool	Check(CheckState &state);
	virtual void	Emit(Bytecode &b) = 0;
	virtual Stmt*	Clone(Mapping *b) const = 0;

			bool	IsNullable() const	{ return fNullable; }
	

protected:
	bool	fNullable;
};



#endif
