/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "VarPool.h"
#include "RCX_Constants.h"


//#define DEBUG_VARS

#ifdef DEBUG_VARS
#include <stdio.h>
#endif


VarPool::VarPool()
{
	for(int i=0; i<kRCX_MaxVars; i++)
		fModes[i] = kFree;
}


int VarPool::Allocate(VarMode mode)
{
	for(int i=0; i<kRCX_MaxVars; i++)
	{
		VarMode m = fModes[i];
		
		if (m==kFree || m==kUsed)
		{
			fModes[i] = mode;
#ifdef DEBUG_VARS
			printf("Allocate var %d\n", i);
#endif
			return i;
		}
	}
	
	return kIllegalVar;
}


void VarPool::Release(int v, VarMode m)
{
	if (IsLegal(v) &&
		(fModes[v] == m))
	{
#ifdef DEBUG_VARS
	printf("Release var %d\n", v);
#endif
		fModes[v] = kUsed;
	}
}

bool VarPool::IsTemp(int v) const
{
	return IsLegal(v) && fModes[v]==kTemp;
}


bool VarPool::IsFree(int v) const
{
	return IsLegal(v) && fModes[v]==kFree;
}


void VarPool::ReserveUsed()
{
	for(int i=0; i<kRCX_MaxVars; i++)
	{
#ifdef DEBUG_VARS
		if (fModes[i] == kTemp)
			printf("Unreleased temp var %d\n", i);
		else if (fModes[i] == kLocal)
			printf("Unreleased temp var %d\n", i);
#endif

		if (fModes[i] != kFree)
			fModes[i] = kReserved;
	}
}
