/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __RCX_Image_h
#define __RCX_Image_h

#ifndef __RCX_Result_h
#include "RCX_Result.h"
#endif

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __PArray_h
#include "PArray.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef _STDIO_H
#include <stdio.h>
#endif


class RCX_Link;
class RCX_Printer;

class RCX_Image
{
public:
				RCX_Image();
				~RCX_Image()	{ Clear(); }
	
	RCX_Result	Read(const char *filename);
	RCX_Result	Write(const char *filename);

	RCX_Result	Download(RCX_Link *link, int programNumber=0);
	void		Print(RCX_Printer *dst);

	void		SetFragmentCount(int count);
	int			GetFragmentCount() const	{ return fFragments.GetLength(); }
	void		SetFragment(int index, RCX_FragmentType type, UByte number, const UByte *data,
							int length, const char *name);

	void		SetVariable(int index, const char *name);
	
	void		Clear();

private:
	int			CountSymbols() const;
	char**		GetNamePtr(UByte type, UByte index);
	
	class	Fragment
	{
	public:
				Fragment();
				~Fragment();
				
		int		fLength;
		UByte*	fData;
		UByte	fNumber;
		RCX_FragmentType fType;
		char*	fName;
	};
	
	PArray<Fragment> fFragments;
	char*			fVarNames[kRCX_MaxVars];
};


#endif
