
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: matsqsq.m,v 1.2 1999/07/06 19:48:10 stes Exp $
 */

#include "cakit.h"

@implementation CAMatrixSequenceSequences
- _setUpContent:aMatrix
{
  content = aMatrix;
  numRows = [content numRows];
  return self;
}

+ content:aMatrix
{
  return [[super new] _setUpContent:aMatrix];
}


- (unsigned) size
{
  return numRows;
}

- (BOOL) isEmpty
{
  return numRows == 0;
}

- toFirst
{
  index = -1;
  return self;
}

- toLast
{
  index = numRows;
  return self;
}

- toElementAt:(int)i
{
  index = i - 1;
  return self;
}

- currentMember
{
  if (0 <= index && index < numRows)
    currentMember = [[content rowAt:index] eachScalar];
  return currentMember;
}

- next
{
  index = (index <= numRows) ? index + 1 : numRows;
  return [self currentMember];
}

- previous
{
  index = (index >= 0) ? index - 1 : -1;
  return [self currentMember];
}

@end
 
