/*
 * S.H - header file for S
 *
 */

#ifndef PCK_S

#define PCK_S

#include <panace.h>
#include <global.h>
#include <lag.h>
#include <misc.h>

#define A_INTEGER 1
#undef A_LONG
#define A_LONG	  2
#define A_FLOAT	  3
#define A_DOUBLE  4
#undef A_CHAR
#define A_CHAR	  5
#undef A_PART
#define A_PART	  6

/*--------------------------------------------------------------------------*/

/*                           STRUCT DEFINITIONS                             */

/*--------------------------------------------------------------------------*/

struct s_time_list
   {int length;
    pcons *list;};

typedef struct s_time_list time_list;

struct s_source_record
   {char *name;
    double time;
    int *indexes;
    double *data;};

typedef struct s_source_record source_record;

/*--------------------------------------------------------------------------*/

/*                             PROCEDURAL MACROS                            */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/*                           VARIABLE DECLARATIONS                          */

/*--------------------------------------------------------------------------*/

extern PDBfile
 *pdsf;

extern FILE
 *strm;

extern HASHTAB
 *commands,
 *srctab;

extern double
 conversion_s;

extern int
 N_Variables;

extern char
 in_deck[],                                       /* global input deck name */
 msg[],                                  /* global temporary string storage */
 *PAN_SOURCE;

/*--------------------------------------------------------------------------*/

/*                           FUNCTION DECLARATIONS                          */

/*--------------------------------------------------------------------------*/

/* SCMD.C declarations */

extern void
 SC_DECLARE(inst_s, (byte)),
 SC_DECLARE(readh, (char *str)),
 SC_DECLARE(S_gen, (char *s));

#endif



