/*
 * PANACE.H - header in support of PANACEA
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */
 
#ifndef PCK_PANACEA

#include "cpyright.h"

#define PCK_PANACEA

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */

#ifdef THINK_C

# include "ppc.h"
# include "pml.h"
# include "pdb.h"
# include "pgs.h"

#else

# ifdef __MWERKS__

#  include "ppc.h"
#  include "pml.h"
#  include "pdb.h"
#  include "pgs.h"

# else

#  include <ppc.h>
#  include <pml.h>
#  include <pdb.h>
#  include <pgs.h>

# endif

#endif
    
/*--------------------------------------------------------------------------*/

/*                           CONSTANT DEFINES                               */

/*--------------------------------------------------------------------------*/

#undef UNREFL
#define UNREFL     1
#undef REFL
#define REFL      -1

#undef SEC

#define DIMENSION   NULL
#define DONE        -3
#define PER         -2
#define UNITS       -1

#define N_ATTRIBUTES 10

#define RAD       PA_radian
#define STER      PA_steradian
#define MOLE      PA_mole
#define Q         PA_electric_charge
#define CM        PA_cm
#define SEC       PA_sec
#define G         PA_gram
#define EV        PA_eV
#define K         PA_kelvin
#define ERG       PA_erg
#define CC        PA_cc

#define SCOPE     'a'
#define DEFN     -1
#define RESTART  -2
#define DMND     -3
#define RUNTIME  -4
#define EDIT     -5
#define SCRATCH  -6

#define CLASS     'b'
#undef REQU
#define REQU    1
#undef OPTL
#define OPTL    2
#define PSEUDO  3

#define PERSIST   'c'
#define REL      -10
#define KEEP     -11
#define CACHE_F  -12
#define CACHE_R  -13

/* CENTER is defined in pgs.h and is out of sequence w.r.t these
 * also, the centerings are already defined in pml.h
 */

#define ALLOCATION 'e'
#define STATIC  -100
#define DYNAMIC -101

#define ATTRIBUTE 'f'

#define  INT_CGS  -20
#define  INT_EXT  -21
#define  EXT_CGS  -22
#define  EXT_INT  -23
#define  CGS_INT  -24
#define  CGS_EXT  -25
#undef NONE
#define  NONE     -26

#define NO_VALUE_I 0x80000000

#define PA_FORCE  -32765
#define PA_DELAY  -32766

#define PA_UPPER_LOWER    0xFFFF
#define PA_OFFSET_NUMBER  0xFFFE

#define LAST_TAG                0
#define PA_INFO_TYPE           -1
#define PA_INFO_N_DIMS         -2
#define PA_INFO_DIMS           -3
#define PA_INFO_SCOPE          -4
#define PA_INFO_CLASS          -5
#define PA_INFO_CENTER         -6
#define PA_INFO_PERSISTENCE    -7
#define PA_INFO_ALLOCATION     -8
#define PA_INFO_FILE_NAME      -9
#define PA_INFO_INIT_VAL       -10
#define PA_INFO_INIT_FNC       -11
#define PA_INFO_CONV           -12
#define PA_INFO_UNIT           -13
#define PA_INFO_KEY            -14
#define PA_INFO_ATTRIBUTE      -15
#define PA_INFO_UNITS          -16
#define PA_INFO_DATA_PTR       -17
#define PA_INFO_UNIT_NUMER     -18
#define PA_INFO_UNIT_DENOM     -19
#define PA_INFO_APPL_ATTR      -20
#define PA_INFO_DEFAULT        -21
#define PA_INFO_SHARE          -22
#define PA_INFO_ATT_NAME       -23
#define PA_INFO_DIM_NAME       -24
#define PA_INFO_UNITS_NAME     -25
#define PA_INFO_DOMAIN_NAME    -26
#define PA_INFO_MAP_DOMAIN     -27
#define PA_INFO_BUILD_DOMAIN   -28

#define PA_scale_array   PM_scale_array
#define PA_set_value     PM_set_value
#define PA_copy_array    PM_copy_array
#define PA_index_min     PM_index_min
#define PA_find_index    PM_find_index
#define PA_max_value     PM_max_value

#define PA_flush         PD_flush
#define PA_family        PD_family

#define PA_advance_name  SC_advance_name
#define PA_assoc         SC_assoc

#define PA_add_alist(a, n, v)     SC_add_alist(a, n, NULL, v)
#define PA_add_hook(s, f)         _PA_add_hook((s), (PFByte) (f))
#define PA_set_default_offset(d)  _PA_default_offset = d
#define PA_get_default_offset(d)  _PA_default_offset

#define PA_complete_premap PA_get_range_info

#define PA_ERR    (*PA_error_hook)
#define PA_WARN   (*PA_warn_hook)

#define PA_FILE      -1
#define PA_DATABASE  -2

/*--------------------------------------------------------------------------*/

/*                           PROCEDURAL MACROS                              */

/*--------------------------------------------------------------------------*/

/* PA_GET_FUNCTION - return a pointer to the named function */

#define PA_GET_FUNCTION(type, name)                                          \
    (_SC_addr_.memaddr = (char *) SC_def_lookup(name, PA_symbol_tab),        \
     (type) _SC_addr_.funcaddr)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_GET_PCK_FUNCTION - return a pointer to the given package function */

#define PA_GET_PCK_FUNCTION(pck, type, name)                                 \
    (_SC_addr_.memaddr = (char *) PA_assoc(PA_PACKAGE_ATTR(pck), name),      \
     (type) _SC_addr_.funcaddr)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_GET_VAR_FUNCTION - return a pointer to the given variable function */

#define PA_GET_VAR_FUNCTION(pp, type, name)                                  \
    (_SC_addr_.memaddr = (char *) PA_assoc(PA_VARIABLE_ATTR(pp), name),      \
     (type) _SC_addr_.funcaddr)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INTERN_V - intern a given scalar value in the variable data base */

#define PA_INTERN_V(var, name)                                               \
    _PA_intern((byte *) &var, name)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INTERN - intern a given array in the variable data base */

#define PA_INTERN(var, name)                                                 \
    _PA_intern((byte *) var, name)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INTERN_PTR - intern the given array in the variable data base
 *               - this is necessary to ensure that a pointer to the type
 *               - associated with the variable is handed off to PDBLib
 *               - e.g.  char **s -> .., "char **", &s, ...
 */

#define PA_INTERN_PTR(var, name, type)                                       \
    var = (type *) *_PA_intern((byte *) &var, name)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_CONNECT - connect a given pointer to the named data */

#define PA_CONNECT(var, name, track)                                         \
    _PA_get_access((byte **) &var, name, -1L, 0L, track)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_LOAD_VARIABLE - load/init the variable data into its memory space
 *                  - intended for STATIC variables
 */

#define PA_LOAD_VARIABLE(name) _PA_load_data(name)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DISCONNECT - disconnect a given pointer from the named data */

#define PA_DISCONNECT(name, ptr)                                             \
    _PA_rel_access((byte **) &ptr, name, -1L, 0L)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_ACCESS - return a connection to a sub-space of an array */

#define PA_ACCESS(var, name, type, offs, ne, track)                          \
   (type) _PA_get_access((byte **) &var, name, offs, ne, track)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_RELEASE - release the access to an array sub-space */

#define PA_RELEASE(name, ptr, offs, ne)                                      \
    _PA_rel_access(&(byte *) ptr, name, offs, ne)
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_VAR_DIM - return the number of elements
 *            - implied by the dimension range
 */

#define PA_VAR_DIM(dm)                                                       \
    ((((dm)->method) == PA_UPPER_LOWER) ?                                    \
     ((long) (*((dm)->index_max) - *((dm)->index_min) + 1)) :                \
     ((long) *((dm)->index_max)))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_LST_VAL - access the first integer element of the list */

#define PA_LST_VAL(lst)  (*((int *) (lst)->car))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_SELECT - build a list of unique variables to save
 *            - for post processing
 */

#define _PA_SELECT(crv, nsn, ntn, nm, nmint, axs, axsint, idx, zn, iu, nu)   \
   tmp = pr->axs;                                                            \
   for (match = FALSE, iu = 0; iu < nu; iu++)                                \
       if (strcmp(tmp, nm[iu]) == 0)                                         \
          {match = TRUE;                                                     \
           crv.idx = iu;                                                     \
           break;};                                                          \
   if (!match)                                                               \
      {nm[iu] = tmp;                                                         \
       if (pr->axsint == NULL)                                               \
          nmint[iu] = pr->axs;                                               \
       else                                                                  \
          nmint[iu] = pr->axsint;                                            \
       nsn = crv.npts;                                                       \
       ntn = pr->zn;                                                         \
       crv.idx = iu;                                                         \
       nu++;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_PR_RANGE_SIZE - reset the size of the plot request range */

#define PA_PR_RANGE_SIZE(pr, n)                                              \
    {pr->size = n;                                                           \
     pr->data->n_elements = n;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_STASH_SP_SCALAR - save a scalar value for a spatial pseudo variable
 *                    - plot request
 */

#define PA_STASH_SP_SCALAR(name, indx, val)                                  \
    if (strcmp(vr, name) == 0)                                               \
       {data[indx] += (val)*pr->conv;                                        \
        continue;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_STASH_TV_SCALAR - save a scalar value for a time pseudo variable
 *                    - plot request
 */

#define PA_STASH_TV_SCALAR(name, val)                                        \
    if (strcmp(vr, name) == 0)                                               \
       {t_data[pr->str_index] += (val)*pr->conv;                             \
        continue;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_MESH_RANGE_SEARCH - loop the range specification of the plot request
 *                      - to setup an invokation of PA_STASH_SP_SCALAR
 */

#define PA_MESH_RANGE_SEARCH(pr, off, fn)                                    \
   {int nde;                                                                 \
    char *vr;                                                                \
    double **elem, *data;                                                    \
    PA_set_spec *rp;                                                         \
    PM_set *set;                                                             \
    set = pr->data;                                                          \
    PA_ERR((set == NULL), "BAD PLOT REQUEST %s - %s", pr->text, fn);         \
    elem = (double **) set->elements;                                        \
    nde  = 0;                                                                \
    for (rp = pr->range; rp != NULL; rp = rp->next)                          \
        {vr   = rp->var_name;                                                \
         data = elem[nde++] + off

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_TIME_RANGE_SEARCH - loop the range specification of the plot request
 *                      - to setup an invokation of PA_STASH_TV_SCALAR
 */

#define PA_TIME_RANGE_SEARCH(pr, fn)                                         \
   {char *vr;                                                                \
    PA_set_spec *rp;                                                         \
    for (rp = pr->range; rp != NULL; rp = rp->next)                          \
        {vr = rp->var_name

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_END_MESH_SEARCH - gracefully terminate the loop started by
 *                    - PA_MESH_RANGE_SEARCH
 *                    - this is mainly for lexical clarity
 */

#define PA_END_MESH_SEARCH(pr, expr) }; expr;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_END_TIME_SEARCH - gracefully terminate the loop started by
 *                    - PA_TIME_RANGE_SEARCH
 *                    - this is purely for lexical clarity
 */

#define PA_END_TIME_SEARCH(pr) };}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_STORE_TV - save away the given time value data */

#define PA_STORE_TV(pr, val)                                                 \
   t_data[pr->str_index] = (val)*pr->conv

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_MARK_SPACE - mark the current allocated space */

#define PA_MARK_SPACE(pck)                                                   \
   {long lsp;                                                                \
    SC_mem_stats(&lsp, NULL, NULL, NULL);                                    \
    PA_NTH_THREAD.mark_space = (double) lsp;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_ACCM_SPACE - count the space allocated since the previous MARK_SPACE */

#define PA_ACCM_SPACE(pck)                                                   \
   {long lsp;                                                                \
    SC_mem_stats(&lsp, NULL, NULL, NULL);                                    \
    (pck)->space += ((double) lsp - PA_NTH_THREAD.mark_space);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_MARK_TIME - mark the current CPU time */

#define PA_MARK_TIME(pck)                                                    \
   PA_NTH_THREAD.mark_time = SC_cpu_time()

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_ACCM_TIME - count the time allocated since the previous MARK_TIME */

#define PA_ACCM_TIME(pck)                                                    \
   {double dt;                                                               \
    dt = SC_cpu_time() - PA_NTH_THREAD.mark_time;                            \
    (pck)->time += ((dt > 0.0) ? dt : 0.0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_ALIAS - handle alias definitions a little bit more nicely */

#define PA_DEF_ALIAS(n, t, ts, v)                                            \
   {t x;                                                                     \
    x = (t) v;                                                               \
    PA_def_alias(n, ts, &x);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INQUIRE_VARIABLE - return a PA_variable pointer from
 *                     - the PA_variable_tab
 */

#define PA_INQUIRE_VARIABLE(x)                                               \
    ((PA_variable *) SC_def_lookup((x), PA_variable_tab))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INQUIRE_PACKAGE - return a PA_package pointer from
 *                    - the PA_variable_tab
 */

#define PA_INQUIRE_PACKAGE(x)                                                \
    ((PA_package *) SC_def_lookup((x), PA_variable_tab))

/*--------------------------------------------------------------------------*/

#define PA_SET_MAX_NAME_SPACE(f)   PA_name_spaces = f
#define PA_GET_MAX_NAME_SPACE(f)   f = PA_name_spaces

#define PA_VARIABLE_NAME(x)             ((x)->name)
#define PA_VARIABLE_FILE(x)             ((x)->file)
#define PA_VARIABLE_FILE_CONVERS(x)     ((x)->file_conv)
#define PA_VARIABLE_CACHE_FILE_NAME(x)  ((x)->cache_file)

#define PA_VARIABLE_DATA(x)         ((x)->data)
#define PA_VARIABLE_INIT_VAL(x)     ((x)->init_val)
#define PA_VARIABLE_INIT_FUNC(x)    ((x)->init)
#define PA_VARIABLE_SIZE(x)         ((x)->size)

#define PA_VARIABLE_INT_UNIT(x)     ((x)->unit)
#define PA_VARIABLE_EXT_UNIT(x)     ((x)->conv)

#define PA_VARIABLE_DESC(x)         ((x)->desc)
#define PA_VARIABLE_TYPE(x)         ((x)->type)
#define PA_VARIABLE_TYPE_S(x)       ((x)->desc->type)
#define PA_VARIABLE_DIMS(x)         ((x)->dims)
#define PA_VARIABLE_N_DIMS(x)       ((x)->n_dimensions)

#define PA_VARIABLE_ACCESS_LIST(x)     ((x)->access_list)
#define PA_VARIABLE_REFERENCE_LIST(x)  ((x)->reference_list)

#define PA_VARIABLE_SCOPE(x)        ((x)->scope)
#define PA_VARIABLE_CLASS(x)        ((x)->option)
#define PA_VARIABLE_PERSISTENCE(x)  ((x)->persistence)
#define PA_VARIABLE_CENTERING(x)    ((x)->centering)
#define PA_VARIABLE_ALLOCATION(x)   ((x)->allocation)

#define PA_VARIABLE_PACKAGE(x)      ((x)->pck)
#define PA_VARIABLE_UNIT_NUMER(x)   ((x)->numer_list)
#define PA_VARIABLE_UNIT_DENOM(x)   ((x)->denom_list)
#define PA_VARIABLE_FILE_NAME(x)    ((x)->file_name)
#define PA_VARIABLE_ATTR(x)         ((x)->alist)

#define PA_PACKAGE_NAME(x)          ((x)->name)
#define PA_PACKAGE_SPACE(x)         ((x)->space)
#define PA_PACKAGE_TIME(x)          ((x)->time)
#define PA_PACKAGE_DT(x)            ((x)->dt)
#define PA_PACKAGE_DT_ZONE(x)       ((x)->dt_zone)
#define PA_PACKAGE_PLOTS(x)         ((x)->pseudo_pr)
#define PA_PACKAGE_ATTR(x)          ((x)->alist)
#define PA_PACKAGE_SWITCHES(x)      ((x)->iswtch)
#define PA_PACKAGE_PARAMS(x)        ((x)->rparam)
#define PA_PACKAGE_NAMES(x)         ((x)->ascii)
#define PA_PACKAGE_ON(x)            ((x)->on)
#define PA_PACKAGE_PROB_DT(x)       ((x)->p_dt)
#define PA_PACKAGE_PROB_T(x)        ((x)->p_t)

#define PA_get_n_threads(n)         (n = PA_thread_list.n_threads)
#define PA_set_n_threads(n)                                                  \
   SC_SET_N_THREADS(PA_thread_state, PA_thread_list, (n))

#define PA_NTH_THREAD SC_GET_NTH_THREAD(PA_thread_state, PA_thread_list)

#define SWTCH  (PA_NTH_THREAD.iswtch)
#define PARAM  (PA_NTH_THREAD.rparam)
#define NAME   (PA_NTH_THREAD.aname)

/*--------------------------------------------------------------------------*/

/*                   TYPEDEF AND STRUCT DEFINITIONS                         */

/*--------------------------------------------------------------------------*/

struct s_PA_dimens
   {int *index_min;
    int *index_max;
    int method;
    struct s_PA_dimens *next;};

typedef struct s_PA_dimens PA_dimens;


struct s_PA_command
   {char type;
    int *vr;
    int num;
    char *name;
    PFVoid proc;
    PFVoid handler;};

typedef struct s_PA_command PA_command;


/* PA_SET_SPEC is PD_DEFSTR'd in PA_DEF_STR in PANACEA.C
 * so any changes here must be reflected there
 */

struct s_PA_set_spec
   {char *var_name;
    char *function;
    char *text;
    int n_values;
    double *values;
    struct s_PA_set_spec *next;};

typedef struct s_PA_set_spec PA_set_spec;


/* PA_PLOT_REQUEST is PD_DEFSTR'd in PA_DEF_STR in PANACEA.C
 * so any changes here must be reflected there
 */

struct s_PA_plot_request
   {PA_set_spec *range;
    char *range_name;
    PA_set_spec *domain;
    char *base_domain_name;
    C_array *domain_map;         /* this is easy to work with at run time */
    char *text;
    int time_plot;                   /* flag to identify time/cycle plots */
    int mesh_plot;                    /* flag to identify full mesh plots */
    int status;              /* flag for PSEUDO vars for proper treatment */
    long size;              /* size of space for PSEUDO variables (range) */
    long offset;        /* offset into space for PSEUDO variables (range) */
    long stride;     /* stride through space for PSEUDO variables (range) */
    int str_index;          /* index into time data stripe for time plots */
    double conv;
    int centering;
    int allocate_data;                   /* permit set allocation if TRUE */
    PM_set *data;           /* storage space for PSEUDO variables (range) */
    int data_index;                   /* index into the source data array */ 
    int data_type;
    struct s_PA_plot_request *next;};

typedef struct s_PA_plot_request PA_plot_request;


struct s_PA_package
   {char *name;                                             /* package name */
    int on;                                      /* on/off flag for package */
    double p_t;                                             /* problem time */
    double p_dt;                                       /* problem time step */
    int p_cycle;                                           /* problem cycle */
    double time;                           /* cpu time spent in the package */
    double space;        /* bytes of dynamic memory required by the package */
    double dt;                           /* package vote for next time step */
    int dt_zone;                  /* zone controlling the package time step */
    PFInt gencmd;          /* function which defines the generator commands */
    PFInt dfstrc;              /* function to define structures for rs-dump */
    PFInt intrn;          /* function which interns variables at generation */
    PFInt defun;                        /* function which defines new units */
    PFInt defvar;           /* function which defines the package variables */
    PFInt defcnt;            /* function which defines the package controls */
    PFInt inizer;                 /* function which initializes the package */
    PFInt main;                                /* main entry in the package */
    PFPPM_mapping ppsor;      /* function to handle package specific output */
    PFInt finzer;                  /* function which closes out the package */
    PFInt ppcmd;      /* function which defines the post-processor commands */
    int n_swtch;                                      /* number of switches */
    int *iswtch;                     /* package control switches (integers) */
    int n_param;                                    /* number of parameters */
    double *rparam;                   /* package control parameters (reals) */
    int n_ascii;                                       /* number of strings */
    char **ascii;                   /* package control strings (characters) */
    PA_plot_request *pseudo_pr;        /* list of edits of pseudo variables */
    char *db_file;               /* name of text file defining the database */
    pcons *db_list;               /* list of the database names from a file */
    pcons *alist;                        /* list of package level functions */
    struct s_PA_package *next;};               /* point to the next package */

typedef struct s_PA_package PA_package;


/* added a pointer to the number of elements so that variables could be
 * installed with zero length and when read from restart dumps, source
 * files, or the generator deck the size can be dynamically set
 * this also allows for error checking by comparing desc->number with
 * *size when both are non-zero
 */

struct s_PA_variable
   {char *name;                  /* name by which the variable is installed */
    PA_package *pck;                /* the package which owns this variable */
    byte *data;                               /* pointer to the actual data */
    defstr *type;
    long size;         /* pointer to the number of elements in the variable */
    int n_dimensions;                 /* the dimensionality of the variable */
    PA_dimens *dims;           /* pointer to the dimensions of the variable */
    int scope;                        /* DEFN, RESTART, DMND, RUNTIME, EDIT */
    int option;                                       /* REQU, OPTL, PSEUDO */
    int persistence;                         /* REL, KEEP, CACHE_F, CACHE_R */
    int centering;                         /* FALSE for node, TRUE for zone */
    int allocation;                                    /* STATIC or DYNAMIC */
    double conv;                         /* external unit conversion factor */
    double unit;                         /* internal unit conversion factor */
    pcons *numer_list;                    /* list of units in the numerator */
    pcons *denom_list;                  /* list of units in the denominator */
    syment *desc;        /* information about the variable (see PDBLib Doc) */
    char *file_name;
    int file_conv;
    byte *init_val;
    byte SC_DECLARE((*init), (byte *p, long sz, char *s));
    pcons *alist;
    pcons *access_list;
    pcons *reference_list;
    PDBfile *file;
    char *cache_file;};

typedef struct s_PA_variable PA_variable;


struct s_PA_src_variable
   {char *name;                             /* variable name (with indexes) */
    PA_variable *pp;                        /* associated database variable */
    int var_index;    /* an index into times identifying the last read time */
    int n_times;             /* the number of times for which there is data */
    double conv_fact;       /* conversion factor from CGS to INTERNAL units */
    double *times;                      /* the times at which there is data */
    double *queue_times;              /* the times of the data in the queue */
    double **queue;                  /* a queue buffer for some of the data */
    int index;        /* an index into times identifying the last read time */
    int size;                        /* the size of the arrays in the queue */
    int interpolate;       /* flag to indicate the need to interpolate data */
    PDBfile *file;};                 /* the source file containing the data */

typedef struct s_PA_src_variable PA_src_variable;


struct s_PA_thread_state
   {double mark_space;
    double mark_time;
    int *iswtch;            
    double *rparam;
    char **aname;
    PA_package *current;};

typedef struct s_PA_thread_state PA_thread_state;


/* IV_SPECIFICATION is PD_DEFSTR'd in PA_DEF_STR in PANACEA.C
 * so any changes here must be reflected there
 */

struct s_PA_iv_specification
   {int type;
    char *name;                                /* name of the specification */
    char *file;                   /* file from which to get the data if any */
    int num;                               /* number of data points in data */
    int index;            /* an index into data - used at runtime if needed */
    int interpolate;       /* flag to indicate the need to interpolate data */
    pcons *spec;                    /* list of data read at generation time */
    double *data;                      /* runtime storage of data from spec */
    struct s_PA_iv_specification *next;};

typedef struct s_PA_iv_specification PA_iv_specification;


/* UNIT_SPEC - specify information for building units out of other
 *           - existing units
 */

struct s_PA_unit_spec
   {int index;
    double factor;
    int fundamental;
    int n_num;
    int *numerator;
    int n_den;
    int *denominator;
    struct s_PA_unit_spec *next;};

typedef struct s_PA_unit_spec PA_unit_spec;


/* SET_INDEX - aid to selecting elements out of PM_sets
 *           - this is PD_defstr'd in PANACEA.C changes must be reflected there!!!
 */

struct s_PA_set_index
   {double val;
    int index;
    int imax;
    double conv;
    char *name;};

typedef struct s_PA_set_index PA_set_index;

struct s_PA_tab_head
   {char *name;
    char *type;
    pcons *entries;
    long n_entries;
    long n_fields;};

typedef struct s_PA_tab_head PA_tab_head;

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/

/*                          VARIABLE DECLARATIONS                           */

/*--------------------------------------------------------------------------*/

extern PFVoid
 PA_error_hook,
 PA_warn_hook;

extern PA_iv_specification
 *iv_spec_lst;

extern PA_package
 *Packages;

extern PA_variable
 *_PA_default_variable;

extern PA_plot_request
 *plot_reqs;

extern PROCESS
 *PA_pp;

extern SC_thread_array
 PA_thread_list;

extern HASHTAB
 *PA_alias_tab,
 *PA_commands,
 *PA_symbol_tab,
 *PA_variable_tab,
 *PA_var_att_tab,
 *PA_var_def_tab,
 *PA_var_dim_tab,
 *PA_var_domain_tab,
 *PA_var_unit_tab,
 *PA_cpp_name_tab,
 *PA_cpp_value_tab;

extern PDBfile
 *PA_cache_file,
 **_PA_state_files,
 *PA_vif,
 *PA_pva_file,
 *PA_pp_file;

extern FILE
 *PA_edit_file;

extern PA_src_variable
 **SV_List;

extern char
 errbuf[],                      /* global buffer for certain error messages */
 PA_err[],
 **global_name,
 _PA_base_name[],
 *_PA_rsname,
 *PA_strtok_p,
 *PA_token_delimiters,
 *PAN_COMMAND,
 *PAN_CPP_NODE,
 *PAN_EDIT,
 *PAN_PLOT_REQ,
 *PAN_PACKAGE,
 *PAN_SOURCE,
 *PAN_VARIABLE,
 *PAN_ATTRIBUTE,
 *PAN_DIMENSION,
 *PAN_DOMAIN,
 *PAN_EDIT_REQUEST,
 *PAN_EDIT_OUT,
 *PAN_UNIT,
 *PA_SET_INDEX_S,
 *PA_SET_INDEX_P_S;

extern char
 *PA_INFO_TYPE_S,
 *PA_INFO_N_DIMS_S,
 *PA_INFO_DIMS_S,
 *PA_INFO_SCOPE_S,
 *PA_INFO_CLASS_S,
 *PA_INFO_CENTER_S,
 *PA_INFO_PERSISTENCE_S,
 *PA_INFO_ALLOCATION_S,
 *PA_INFO_FILE_NAME_S,
 *PA_INFO_INIT_VAL_S,
 *PA_INFO_INIT_FNC_S,
 *PA_INFO_CONV_S,
 *PA_INFO_UNIT_S,
 *PA_INFO_KEY_S,
 *PA_INFO_ATTRIBUTE_S,
 *PA_INFO_UNITS_S,
 *PA_INFO_DATA_PTR_S,
 *PA_INFO_UNIT_NUMER_S,
 *PA_INFO_UNIT_DENOM_S,
 *PA_INFO_APPL_ATTR_S,
 *PA_INFO_DEFAULT_S,
 *PA_INFO_SHARE_S,
 *PA_INFO_ATT_NAME_S,
 *PA_INFO_DIM_NAME_S,
 *PA_INFO_UNITS_NAME_S,
 *PA_INFO_DOMAIN_NAME_S,
 *PA_INFO_MAP_DOMAIN_S,
 *PA_INFO_BUILD_DOMAIN_S,
 *PA_CPP_INFO,
 *PA_CPP_ALLOCATION,
 *PA_CPP_SCOPE,
 *PA_CPP_CLASS,
 *PA_CPP_CENTER,
 *PA_CPP_PERSISTENCE,
 *PA_CPP_UNITS,
 *PA_CPP_TYPE,
 *PA_CPP_TYPE_SC,
 *PA_CPP_TYPE_S;

extern int
 *global_swtch,
 N_graphs,
 N_plots,
 N_Packages,
 N_Switches,
 N_Parameters,
 N_Names,
 N_Units,
 N_Variables,
 N_time_plots,
 N_unique_variables,
 PA_name_spaces,
 PA_current_pp_cycle,
 _PA_ul_print_flag,
 _PA_n_state_files,
 _PA_default_offset,
 _PA_halt_fl,
 *PA_DUL,
 *PA_DON,
 PA_radian,
 PA_steradian,
 PA_mole,
 PA_electric_charge,
 PA_cm,
 PA_sec,
 PA_gram,
 PA_eV,
 PA_kelvin,
 PA_erg,
 PA_cc,
 STAND_ALONE;                                           /* stand alone flag */

extern double
 *convrsn,
 *global_param,
 *t_data,
 *unit;

/* CODE UNITS VARIABLES AND CONSTANTS */

extern double
 alpha,              /* fine structure constant e^2/HbarC  - 7.297353080e-3 */
 c,                              /* speed of light (cm/sec) - 2.99792458e10 */
 Coulomb,                /* Coulomb in fundamental charges - 6.241506363e18 */
 e,                              /* electron charge in esu - 4.80320680e-10 */
 eV_erg,                                      /* eV to erg - 1.60217733e-12 */
 Gn,       /* Newtonian gravitational constant (cm^3/g-sec^2) - 6.673231e-8 */
 Hbar,                                  /* Hbar in erg-sec - 1.05457267e-27 */
 HbarC,                                  /* Hbar*C in eV-cm - 1.97327054e-5 */
 kBoltz,                     /* Boltzman constant in (erg/K) - 1.380658e-16 */
 K_eV,                                        /* Kelvin to eV 8.6173856e-05 */
 M_a,                            /* atomic mass unit in g - 1.660540210e-24 */
 M_e,                               /* electron mass in g - 9.109389754e-28 */
 M_e_eV,                              /* electron mass in eV - 5.10999065e5 */
 N0,                                   /* Avagadro's number - 6.02213665e23 */
 Ryd,                           /* (M_e*c^2*alpha^2)/2 in eV - 13.605698140 */

 icm_g,                                /* inverse cm to g  - 3.51767578e-38 */
 g_icm,                                 /* g to inverse cm  - 2.84278615e37 */

 icm_eV,                                       /* inverse cm to eV  - HbarC */
 eV_icm,                                 /* eV toinverse cm  - 5.06772882e4 */

 icm_erg,                            /* inverse cm to erg  - 3.16152932e-17 */
 erg_icm;                             /* erg to inverse cm  - 3.16302617e16 */

/*--------------------------------------------------------------------------*/

/*                          FUNCTION DECLARATIONS                           */

/*--------------------------------------------------------------------------*/

/* PAPKG.C declarations */

extern void
 SC_DECLARE(PA_gencmd, ()),
 SC_DECLARE(PA_defunc, ()),
 SC_DECLARE(PA_defcnt,());


/* PACCESS.C declarations */

extern byte
 *SC_DECLARE(_PA_get_access,
	     (byte **vr, char *sn, long offs, long ne, int track)),
 *SC_DECLARE(_PA_load_data, (char *s)),
 *SC_DECLARE(_PA_init_space, (PA_variable *pp, long psz)),
 *SC_DECLARE(_PA_alloc, 
             (defstr *dp, char *type, long nitems, byte *pval));

extern void
 SC_DECLARE(PA_equivalence, (byte *vr, char *s)),
 SC_DECLARE(PA_set_equiv, (char *s, byte *vl)),
 SC_DECLARE(_PA_rel_access, (byte **vp, char *s, long offs, long ne));

extern PA_variable
 *SC_DECLARE(PA_inquire_variable, (char *x));


/* PADSYS.C declarations */

extern int
 SC_DECLARE(PA_current_thread, (byte));

extern PA_package
 *SC_DECLARE(PA_current_package, (byte)),
 *SC_DECLARE(PA_gen_package,
	     (char *name, PFInt cmd, PFInt dfs, PFInt dfu, PFInt dfr,
	      PFInt cnt, PFInt inr, char *fname));

extern void
 SC_DECLARE(_PA_init, (byte)),
 SC_DECLARE(_PA_internal_init, (void)),
 SC_DECLARE(PA_run_time_package,
	    (char *name, PFInt dfs, PFInt dfu, PFInt dfr,
	     PFInt cnt, PFInt izr, PFInt mn, PFPPM_mapping psr,
	     PFInt fzr, char *fname)),
 SC_DECLARE(PA_def_package,
	    (char *name, PFInt gcmd, PFInt dfs, PFInt dfu, PFInt dfr,
	     PFInt cnt, PFInt izr, PFInt inr, PFInt mn,
	     PFPPM_mapping psr, PFInt fzr, PFInt pcmd, char *fname)),
 SC_DECLARE(PA_control_set, (char *s));


/* PADUMP.C declarations */

extern int
 SC_DECLARE(_PA_get_data,
	    (double *d, char *vr, long nitems, long offset, long stride)),
 SC_DECLARE(PA_dump_time,
	    (PA_set_spec *pi, double tc, double dtc, int cycle));

extern void
 SC_DECLARE(_PA_init_pp, (char *ppname, char *gfname)),
 SC_DECLARE(_PA_scan_pp, (byte)),
 SC_DECLARE(PA_dump_pp, (double t, double dt, int cycle)),
 SC_DECLARE(PA_get_range_info, (PA_plot_request *pr)),
 SC_DECLARE(PA_put_set, (PDBfile *file, PM_set *s)),
 SC_DECLARE(PA_put_picture, (PG_device *dev, PDBfile *file,
			     PM_mapping *f, int ptyp,
			     int bndp, int cbnd, int sbnd, double wbnd,
			     int mshp, int cmsh, int smsh, double wmsh)),
 SC_DECLARE(PA_put_mapping,
	    (PG_device *dev, PDBfile *file, PM_mapping *f,
	     int ptyp)),
 SC_DECLARE(_PA_allocate_mapping_space, (PA_package *pck)),
 SC_DECLARE(_PA_dump_package_mappings,
	    (PA_package *pck, double t, double dt, int cycle));

extern double
 *SC_DECLARE(PA_set_data, (char *name, C_array *arr, int *pcent)),
 *SC_DECLARE(PA_fill_component, 
             (double *data, int len, int *pist, int ne));

extern PA_plot_request
 *SC_DECLARE(_PA_splice_out_request,
	     (PA_plot_request *pr, PA_plot_request *lst));

extern PM_mapping
 *SC_DECLARE(PA_build_mapping,
	     (PA_plot_request *pr, PFPPM_set build_ran, double t));

extern PA_set_spec
 *SC_DECLARE(PA_non_time_domain, (PA_plot_request *pr));

extern C_array
 *SC_DECLARE(PA_get_domain_info, (PA_plot_request *pr, char *dname));


/* PAFI.C declarations */

extern int
 SC_DECLARE(PA_connect_ptrs_p, 
            (char *name, char **pvn, byte **pp, int *pn));

extern void
 SC_DECLARE(PA_read_def, (PA_package *pck, char *name)),
 SC_DECLARE(PA_install_function, (char *s, PFByte fnc)),
 SC_DECLARE(PA_install_identifier, (char *s, byte *vr)),
 SC_DECLARE(_PA_add_hook, (char *name, PFByte val));


/* PAGNRD.C declarations */

extern HASHTAB
 *SC_DECLARE(PA_inst_com, (byte));

extern int
 SC_DECLARE(PA_function_form, (char *t, PA_set_spec *spec));

extern void
 SC_DECLARE(PA_inst_pck_gen_cmmnds, (byte)),
 SC_DECLARE(PA_intern_pck_db, (byte)),
 SC_DECLARE(PA_def_alias, (char *name, char *type, byte *pv)),
 SC_DECLARE(PA_inst_c,
	    (char *cname, byte *cvar, int ctype, int cnum, PFVoid cproc,
	     PFVoid chand)),
 SC_DECLARE(PA_specifyh, (byte)),
 SC_DECLARE(PA_sh, (byte)),
 SC_DECLARE(PA_proc_iv_spec, (PA_iv_specification *lst)),
 SC_DECLARE(PA_clear, (byte)),
 SC_DECLARE(PA_packh, (byte)),
 SC_DECLARE(PA_pshand, (PA_command *cp)),
 SC_DECLARE(PA_nploth, (byte)),
 SC_DECLARE(PA_time_plot, (char *rname, byte *vr)),
 SC_DECLARE(PA_wrrstrth, (byte)),
 SC_DECLARE(PA_name_files,
	    (char *base_name, char **ped, char **prs,
	     char **ppp, char **pgf)),
 SC_DECLARE(PA_readh, (char *str)),
 SC_DECLARE(PA_get_commands,
	    (FILE *fp, DECLFPTR(byte, errfnc, (char *token)))),
 SC_DECLARE(PA_done, (byte));

extern double
 SC_DECLARE(PA_alias_value, (char *s));

extern char
 *SC_DECLARE(PA_get_next_line, (byte)),
 *SC_DECLARE(PA_get_field, (char *s, char *t, int optp));

extern PA_plot_request
 *SC_DECLARE(_PA_mk_plot_request,
	     (PA_set_spec *range, PA_set_spec *domain, char *text,
	      PA_plot_request *req));

extern PA_set_spec
 *SC_DECLARE(_PA_proc_set_spec, (char *s, PA_set_spec *lst));


/* PAHAND.C declarations */

extern void
 SC_DECLARE(PA_zargs, (PA_command *cp)),
 SC_DECLARE(PA_sargs, (PA_command *cp)),
 SC_DECLARE(PA_strarg, (PA_command *cp));


/* PAMM.C declarations */

extern PA_variable
 *SC_DECLARE(_PA_mk_variable,
	     (char *vname, PA_dimens *vdims, byte *iv,
	      DECLFPTR(byte, ifn, (byte *p, long sz, char *s)),
	      int *vattr, char *vtype,
	      double conv_fact, double unit_fact,
	      pcons *nu, pcons *du, pcons *alist));

extern PA_dimens
 *SC_DECLARE(_PA_mk_dimens, (int *mini, int *maxi, int method));

extern dimdes
 *SC_DECLARE(_PA_mk_sym_dims, (PA_dimens *vdims));

extern PA_src_variable
 *SC_DECLARE(_PA_mk_src_variable,
	     (char *name, int vindx, int n, double *pt, PDBfile *fp));

extern PA_iv_specification
 *SC_DECLARE(_PA_mk_spec,
	     (char *id, int type, char *fn, int n, int interp,
	      pcons *lst, PA_iv_specification *nxt));

extern void
 SC_DECLARE(PA_mk_control,
	    (PA_package *pck, char *s, int n_a, int n_p, int n_s)),
 SC_DECLARE(_PA_rl_variable, (PA_variable *pp)),
 SC_DECLARE(_PA_rl_set_spec, (PA_set_spec *ip)),
 SC_DECLARE(_PA_rl_request, (PA_plot_request *rq)),
 SC_DECLARE(_PA_rl_spec, (PA_iv_specification *lst)),
 SC_DECLARE(_PA_rl_domain_map, (PA_set_index *dmap));

extern long
 SC_DECLARE(_PA_list_to_dims, (PA_dimens *vd, dimdes *sd)),
 SC_DECLARE(_PA_dims_to_list, (dimdes *sd, PA_dimens *vd)),
 SC_DECLARE(_PA_consistent_size, (PA_variable *pp, int flag)),
 SC_DECLARE(_PA_comp_size, (PA_dimens *vdims));


/* PANACEA.C declarations */

extern void
 SC_DECLARE(PA_simulate,
	    (double tc, int nc, int nz, double ti, double tf,
	     double dtf_init, double dtf_min, double dtf_max, double dtf_inc,
	     char *rsname, char *edname, char *ppname, char *gfname)),
 SC_DECLARE(PA_trap_signals, (int nsig, ...)),
 SC_DECLARE(PA_signal_handler, (int sig)),
 SC_DECLARE(PA_interrupt_handler, (int sig)),
 SC_DECLARE(_PA_init_files, (char *edname, char *ppname, char *gfname)),
 SC_DECLARE(PA_file_mon, (char *edname, char *ppname, char *gfname)),
 SC_DECLARE(PA_rd_restart, (char *rsname, int convs)),
 SC_DECLARE(PA_wr_restart, (char *rsname)),
 SC_DECLARE(PA_init_system,
	    (double t, double dt, int nc,
	     char *edname, char *ppname, char *gfname)),
 SC_DECLARE(PA_init_strings, (byte)),
 SC_DECLARE(PA_def_str, (PDBfile *pdrs)),
 SC_DECLARE(PA_run_packages, (double t, double dt, int cycle)),
 SC_DECLARE(PA_fin_system, (int nz, int nc, int silent)),
 SC_DECLARE(PA_terminate,
	    (char *edname, char *ppname, char *gfname, int cycle)),
 SC_DECLARE(PA_close_pp, (byte));

extern double
 SC_DECLARE(PA_advance_t, (double dtmn, double dtn, double dtmx));


/* PANTH.C declarations */

extern int
 SC_DECLARE(PA_th_write,
	    (PDBfile *strm, char *name, char *type, int inst, int nr, byte *vr)),
 SC_DECLARE(PA_th_wr_iattr,
	    (PDBfile *strm, char *vr, int inst, char *attr, byte *avl)),
 SC_DECLARE(PA_th_transpose, (char *name, int ncpf)),
 SC_DECLARE(PA_th_trans_family, (char *name, int ord, int ncpf)),
 SC_DECLARE(PA_th_family_list, (char *name, int c, char ***pfiles)),
 SC_DECLARE(PA_th_trans_name, (int n, char **names, int ord, int ncpf)),
 SC_DECLARE(PA_th_name_list,
	    (int n, char **names, char ***pthfiles)),
 SC_DECLARE(PA_th_trans_link, (int n, char **names, int ord, int ncpf)),
 SC_DECLARE(PA_th_link_list,
	    (int n, char **names, char ***pthfiles)),
 SC_DECLARE(PA_th_trans_files,
	    (char *name, int ncpf, int nthf, char **thfiles, int ord, int flag)),
 SC_DECLARE(PA_merge_family, (char *base, char *family, int ncpf)),
 SC_DECLARE(PA_merge_files, (char *base, int n, char **files, int ncpf)),
 SC_DECLARE(PA_th_wr_member, 
            (PDBfile *strm, char *name, char *member, char *type,
             int inst, byte *vr));

extern defstr
 *SC_DECLARE(PA_th_def_rec,
	     (PDBfile *file, char *name, char *type, int nmemb,
	      char **members, char **labels));

extern PDBfile
 *SC_DECLARE(PA_th_open, (char *name, char *mode, long size, char *prev)),
 *SC_DECLARE(PA_th_family, (PDBfile *file));


/* PAPP.C declarations */

extern void
 SC_DECLARE(PA_transpose_pp, (char *ppname, int ntp, int nuv)),
 SC_DECLARE(_PA_proc_time, (char *ufname));


/* PASHAR.C declarations */

extern byte
 *SC_DECLARE(_PA_pdb_read,
	     (PDBfile *file, char *name, syment **psp, long *indx)),
 *SC_DECLARE(_PA_intern, (byte *vr, char *name));

extern void
 SC_DECLARE(PA_def_var,
	    (char *vname, char *vtype, byte *viv,
	     DECLFPTR(byte, vif, (byte *p, long sz, char *s)), ...)),
 SC_DECLARE(PA_inst_var,
	    (char *vname, char *vtype, byte *viv,
	     DECLFPTR(byte, vif, (byte *p, long sz, char *s)), ...)),
 SC_DECLARE(PA_inst_scalar,
	    (char *vname, char *vtype, byte *vaddr, byte *viv,
	     DECLFPTR(byte, vif, (byte *p, long sz, char *s)), ...)),
 SC_DECLARE(PA_init_scalar, (char *s)),
 SC_DECLARE(_PA_install_var, (char *vname, PA_variable *pp)),
 SC_DECLARE(_PA_rd_variable,
	    (PDBfile *pdrs, PA_variable *pp, int conv_flag, int scope)),
 SC_DECLARE(_PA_wrrstrt, (char *rsname, int conv_flag)),
 SC_DECLARE(_PA_rdrstrt, (char *fname, int conv_flag)),
 SC_DECLARE(PA_error_handler, (int test, char *fmt, ...)),
 SC_DECLARE(PA_warning_handler, (int test, char *fmt, ...)),
 SC_DECLARE(PA_error, (char *msg));

extern PDBfile
 *SC_DECLARE(PA_open, (char *name, char *mode, int flag));


/* PASHAS.C declarations */

extern void
 SC_DECLARE(PA_change_dim, (int *pdm, int val)),
 SC_DECLARE(PA_change_size, (char *name, int flag)),
 SC_DECLARE(PA_init_threads, (int nt, PFVoid tid)),
 SC_DECLARE(PA_do_threads, (void *(*fnc)(), void **ret));

extern int
 SC_DECLARE(_PA_sizeof, (char *s));


/* PASRC.C declartions */

extern PA_src_variable
 *SC_DECLARE(PA_get_source, (char *s, int start_flag));

extern PA_iv_specification 
 *SC_DECLARE(PA_get_iv_source, (char *name)),
 *SC_DECLARE(PA_find_iv_source, (char *name, int off));

extern double
 SC_DECLARE(PA_intr_spec,
	    (PA_iv_specification *sp, double t, double val, long off));

extern void
 SC_DECLARE(_PA_init_sources, (double t, double dt)),
 SC_DECLARE(_PA_init_queue, (PA_src_variable *svp, double t, double dt)),
 SC_DECLARE(_PA_step_queue, (PA_src_variable *svp, double t)),
 SC_DECLARE(PA_interp_src,
	    (byte *v, PA_src_variable *svp, int ni, int nf,
	     double t, double dt)),
 SC_DECLARE(PA_source_variables, (double t, double dt));


/* PASTR.C declarations */

extern byte
 *SC_DECLARE(PA_mk_instance, (char *name, char *type, long n)),
 *SC_DECLARE(PA_get_member, (char *name, char *member));

extern void
 SC_DECLARE(PA_rl_instance, (char *name)),
 SC_DECLARE(PA_set_member, (char *name, byte *data, char *member));

extern syment
 *SC_DECLARE(PA_int_instance,
             (char *name, char *type, long n, byte *data));


/* PAVARS.C declarations */

extern void
 SC_DECLARE(PA_sub_select,
	    (PA_variable *pp, C_array *arr, long *pitems,
	     long *poffs, long *pstr)),
 SC_DECLARE(PA_general_select,
	    (PA_variable *pp, C_array *arr,
	     unsigned long *pitems, unsigned long *pdims,
	     unsigned long *poffs, unsigned long *pstr,
	     unsigned long *pmax)),
 SC_DECLARE(PA_definitions, (byte)),
 SC_DECLARE(PA_variables, (int flag)),
 SC_DECLARE(PA_proc_units, (byte)),
 SC_DECLARE(PA_def_units, (int flag)),
 SC_DECLARE(PA_set_conversions, (int flag)),
 SC_DECLARE(PA_physical_constants_int, (byte)),
 SC_DECLARE(PA_physical_constants_ext, (byte)),
 SC_DECLARE(PA_physical_constants_cgs, (byte));

extern int
 SC_DECLARE(PA_def_unit, (double fac, ...));


/* PADEF.C declarations */

extern void
 SC_DECLARE(PA_def_var_init, ()),
 SC_DECLARE(PA_def_var_domain, (char *name, ...));

extern PA_variable
 *SC_DECLARE(PA_def_variable, (char *name, ...)),
 *SC_DECLARE(PA_def_var_default, (char *name, ...)),
 *SC_DECLARE(_PA_process_def_var, (char *vname, va_list *list));

extern PA_dimens
 *SC_DECLARE(PA_def_var_dimension, (char *name, ...)),
 *SC_DECLARE(_PA_process_dimension, (va_list *list));

extern pcons
 *SC_DECLARE(PA_var_to_alist, (PA_variable *pp)),
 *SC_DECLARE(_PA_process_att, (int tag, va_list *list, pcons *alist)),
 *SC_DECLARE(PA_def_var_attribute, (char *name, ...)),
 *SC_DECLARE(PA_def_var_units, (char *name, ...)),
 *SC_DECLARE(_PA_process_units, (va_list *list, pcons *alist));

extern HASHTAB
 *SC_DECLARE(PA_install_table, 
             (char *s, byte *vr, char *type, HASHTAB *tab));


/* PAINFO.C declarations */

extern int 
 SC_DECLARE(PA_info_check, (int info, int value));

extern char
 *SC_DECLARE(PA_info_name, (int info)),
 *SC_DECLARE(PA_info_type, (int info)),
 *SC_DECLARE(PA_info_value, (int info, int value));

extern void
 SC_DECLARE(PA_info_init, ()),
 SC_DECLARE(PA_info_print, ());


/* PACPP.C */

extern int
 SC_DECLARE(PA_cpp_symbol_itype, (char *name)),
 SC_DECLARE(convert_type_s_i, (char *type_name)),
 SC_DECLARE(PA_cpp_name_itype, (char *name));

extern char
 *SC_DECLARE(PA_cpp_value_to_name, (char *group, ...)),
 *SC_DECLARE(convert_type_i_s, (int type));

extern void
 SC_DECLARE(PA_cpp_init, ()),
 SC_DECLARE(PA_cpp_add_group, (char *name, int itype, char *type)),
 SC_DECLARE(PA_cpp_add_name, (char *name, char *group, ...)),
 SC_DECLARE(PA_cpp_default, ());

extern byte
 *SC_DECLARE(PA_cpp_name_to_value, (char *name));

#ifdef __cplusplus
}
#endif

#endif

