/*
 * GSMOUS.C - mouse handling routines for PGS
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

#ifndef NO_WINDOWS
#ifdef DOS

#define ADDRESS_SEGMENT(fp) ((unsigned int) ((unsigned long) (fp) >> 16))
#define ADDRESS_OFFSET(fp)  ((unsigned int) (fp))

static union REGS
 inreg,
 outreg;

PG_mouse_cursor
 PG_mouse_I_Beam      = {{0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,

                          0x0C60, 0x0280, 0x0100, 0x0100,
                          0x0100, 0x0100, 0x0100, 0x0100,
                          0x0100, 0x0100, 0x0100, 0x0100,
                          0x0100, 0x0100, 0x0280, 0x0C60},
                         7, 7},

 PG_mouse_NW_Arrow    = {{0x3FFF, 0x1FFF, 0x1FFF, 0x0FFF,
                          0x0FFF, 0x07FF, 0x03FF, 0x01FF,
                          0x07FF, 0xC7FF, 0xE3FF, 0xE3FF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,

                          0x0000, 0x4000, 0x4000, 0x6000,
                          0x6000, 0x7000, 0x7800, 0x7C00,
                          0x5000, 0x1000, 0x0800, 0x0800,
                          0x0000, 0x0000, 0x0000, 0x0000},
                         0, 3},

/*
 PG_mouse_NW_Arrow    = {{0x3FFF, 0x1FFF, 0x0FFF, 0x07FF,
                          0x03FF, 0x01FF, 0x00FF, 0x007F,
                          0x003F, 0x001F, 0x01FF, 0x10FF,
                          0x30FF, 0xF87F, 0xF87F, 0xFC3F,

                          0x0000, 0x4000, 0x6000, 0x7000,
                          0x7800, 0x7C00, 0x7E00, 0x7F00,
                          0x7F80, 0x7FC0, 0x7C00, 0x4600,
                          0x0600, 0x0300, 0x0300, 0x0180},
                         0, 3},
*/
 PG_mouse_Left_Arrow  = {{0xFE1F, 0xF01F, 0x0000, 0x0000,
                          0x0000, 0xF01F, 0xFE1F, 0xFFFF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,

                          0x0000, 0x00C0, 0x07C0, 0x7FFE,
                          0x07C0, 0x00C0, 0x0000, 0x0000,
                          0x0000, 0x0000, 0x0000, 0x0000,
                          0x0000, 0x0000, 0x0000, 0x0000},
                         0, 3},

 PG_mouse_Cross       = {{0xFC7F, 0xFC7F, 0xFC7F, 0xE00F,
                          0xE00F, 0xE00F, 0xFC7F, 0xFC7F,
                          0xFC7F, 0xFFFF, 0xFFFF, 0xFFFF,
                          0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,

                          0x0000, 0x0100, 0x0100, 0x0100,
                          0x0FE0, 0x0100, 0x0100, 0x0100,
                          0x0000, 0x0000, 0x0000, 0x0000,
                          0x0000, 0x0000, 0x0000, 0x0000},
                         7, 4},

 PG_mouse_Hand        = {{0xE1FF, 0xE1FF, 0xE1FF, 0xE1FF,
                          0xE1FF, 0xE000, 0xE000, 0xE000,
                          0x0000, 0x0000, 0x0000, 0x0000,
                          0x0000, 0x0000, 0x0000, 0x0000,

                          0x1E00, 0x1200, 0x1200, 0x1200,
                          0x1200, 0x13FF, 0x1249, 0x1249,
                          0x1249, 0x9001, 0x9001, 0x9001,
                          0x8001, 0x8001, 0x8001, 0xFFFF},
                         5, 0};

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_RESET_MOUSE - reset the mouse to default stats
 *                - returns a pointer to a structure indicating whether
 *                - or not the mouse is installed and how many buttons
 *                - it has
 *                - this should be called during program initialization
 */

PG_mouse_state *PG_reset_mouse()
   {static PG_mouse_state m;

/* set up function 0 - initialize mouse */
    inreg.x.ax = 0;

/* make the call to the mouse device driver */
    CALL_MDD;

    m.exists    = outreg.x.ax;
    m.n_buttons = outreg.x.bx;

/* let's have a nicer cursor */
    PG_set_mouse_gr_cursor(&PG_mouse_NW_Arrow);

    return(&m);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SHOW_MOUSE - make the mouse cursor visible
 *               - don't call this if cursor is already visible
 *               - alternate with calls to PG_hide_mouse
 */

void PG_show_mouse()

/* set up function 1 - show mouse */
   {inreg.x.ax = 1;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_HIDE_MOUSE - make the mouse cursor invisible
 *               - don't call this if cursor is already hidden
 *               - alternate with calls to PG_show_mouse
 *               - movements and buttons are still tracked
 */

void PG_hide_mouse()

/* set up function 2 - hide mouse */
   {inreg.x.ax = 2;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_GET_MOUSE_POSITION - get the mouse cursor position and button status
 *                       - return a pointer to the PG_mouse_location
 */

PG_mouse_location *PG_get_mouse_position()
   {static PG_mouse_location m;

/* set up function 3 - get mouse */
    inreg.x.ax = 3;

/* make the call to the mouse device driver */
    CALL_MDD;

    m.button = outreg.x.bx;
    m.x      = outreg.x.cx;
    m.y      = outreg.x.dx;

    return(&m);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_MOUSE_POSITION - move the mouse cursor to the specified
 *                       - position in PIXEL coordinates
 */

void PG_set_mouse_position(x, y)
   int x, y;

/* set up function 4 - move mouse */
   {inreg.x.ax = 4;
    inreg.x.cx = y;
    inreg.x.dx = x;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_GET_MOUSE_PRESSED - return pressed status of named mouse button:
 *                      - current status (up/down);
 *                      - times pressed since last call;
 *                      - position at last press.
 *                      - resets count and position info
 *                      - buttons are: 0 - left, 1 - right on MS mouse
 *                      - returns pointer to PG_mouse_location
 */

PG_mouse_location *PG_get_mouse_pressed(button)
   int button;
   {static PG_mouse_location m;

/* set up function 5 - get mouse button pressed */
    inreg.x.ax = 5;
    inreg.x.bx = button;

/* make the call to the mouse device driver */
    CALL_MDD;

    m.button = outreg.x.ax;
    m.count  = outreg.x.bx;
    m.x      = outreg.x.cx;
    m.y      = outreg.x.dx;

    return(&m);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_GET_MOUSE_RELEASED - return released status of named mouse button:
 *                       - current status (up/down);
 *                       - times pressed since last call;
 *                       - position at last press.
 *                       - resets count and position info
 *                       - buttons are: 0 - left, 1 - right on MS mouse
 *                       - returns pointer to PG_mouse_location
 */

PG_mouse_location *PG_get_mouse_released(button)
   int button;
   {static PG_mouse_location m;

/* set up function 6 - get mouse button released */
    inreg.x.ax = 6;
    inreg.x.bx = button;

/* make the call to the mouse device driver */
    CALL_MDD;

    m.button = outreg.x.ax;
    m.count  = outreg.x.bx;
    m.x      = outreg.x.cx;
    m.y      = outreg.x.dx;

    return(&m);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_MOUSE_DX - set the horizontal range of mouse motion */

void PG_set_mouse_dx(xmn, xmx)
   int xmn, xmx;

/* set up function 7 - set x range for mouse */
   {inreg.x.ax = 7;
    inreg.x.cx = xmn;
    inreg.x.dx = xmx;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_MOUSE_DY - set the vertical range of mouse motion */

void PG_set_mouse_dy(ymn, ymx)
   int ymn, ymx;

/* set up function 8 - set y range for mouse */
   {inreg.x.ax = 8;
    inreg.x.cx = ymn;
    inreg.x.dx = ymx;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_MOUSE_GR_CURSOR - set the graphic cursor shape */

void PG_set_mouse_gr_cursor(cursor)
   PG_mouse_cursor *cursor;
   {struct SREGS seg;

/* set up function 9 - set mouse graphic cursor shape */
    inreg.x.ax = 9;
    inreg.x.bx = cursor->hX;
    inreg.x.cx = cursor->hY;
    inreg.x.dx = ADDRESS_OFFSET(cursor->image);
    seg.es     = ADDRESS_SEGMENT(cursor->image);

/* make the call to the mouse device driver */
    int86x(0x33, &inreg, &outreg, &seg);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_MOUSE_TX_CURSOR - set the text cursor shape
 *                        - type: 0 - software, 1 - hardware
 *                        - for software arg1 and arg2 are
 *                        - screen and cursor mask
 *                        - for hardware arg1 and arg2 are
 *                        - scan line start/stop (shape)
 */

void PG_set_mouse_tx_cursor(type, arg1, arg2)
   int type;
   unsigned int arg1, arg2;
   {struct SREGS seg;

/* set up function 10 - set mouse text cursor shape */
    inreg.x.ax = 10;
    inreg.x.bx = type;
    inreg.x.cx = arg1;
    inreg.x.dx = arg2;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_GET_MOUSE_MOTION - get net motion of cursor since last call
 *                     - position in PIXEL coordinates
 */

PG_mouse_motion *PG_get_mouse_motion()
   {static PG_mouse_motion m;

/* set up function 11 - get mouse motion */
    inreg.x.ax = 11;

/* make the call to the mouse device driver */
    CALL_MDD;

    m.dx = outreg.x.cx;
    m.dy = outreg.x.dx;

    return(&m);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_INSTALL_MOUSE_HOOK - install a user-defined task to be executed upon
 *                       - one or more mouse events specified by mask
 */

void PG_install_mouse_hook(mask, handler)
   unsigned int mask;
   PFInt handler;
   {struct SREGS seg;

/* set up function 12 - define mouse event handler */
    inreg.x.ax = 12;
    inreg.x.cx = mask;
    inreg.x.dx = ADDRESS_OFFSET(handler);
    seg.es     = ADDRESS_SEGMENT(handler);

/* make the call to the mouse device driver */
    int86x(0x33, &inreg, &outreg, &seg);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_MOUSE_LIGHT_PEN_ON - turn on light pen emulation (default) */

void PG_mouse_light_pen_on()

/* set up function 13 - turn on light pen emulation */
   {inreg.x.ax = 13;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_MOUSE_LIGHT_PEN_OFF - turn off light pen emulation */

void PG_mouse_light_pen_off()

/* set up function 14 - turn off light pen emulation */
   {inreg.x.ax = 14;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_MOUSE_RATIO - sets motion-to-pixel ratio where ratio is R/8
 *                    - default is 16 for vertical and 8 for horizontal
 */

void PG_set_mouse_ratio(x, y)
   int x, y;

/* set up function 15 - set motion to pixel ratio */
   {inreg.x.ax = 15;
    inreg.x.cx = x;
    inreg.x.dx = y;

/* make the call to the mouse device driver */
    CALL_MDD;

    return;}

/*--------------------------------------------------------------------------*/

#endif

/*--------------------------------------------------------------------------*/

/* PG_GET_MOUSE_EVENT - wait for a mouse button to be pressed
 *                    - return the position at which it was pressed
 *                    - through the pointers in the arg list
 *                    - the position is in world coordinates
 *                    - and return the button pressed
 */

PG_get_mouse_event(dev, px, py)
   PG_device *dev;
   REAL *px, *py;
   {int ix, iy;
    REAL x, y;
    PG_mouse_location *pm;

    while (TRUE)
       {pm = PG_get_mouse_released(MOUSE_LEFT);
        if (pm->count > 0)
           {ix = pm->x;
            iy = pm->y;
            PtoS(dev, ix, iy, x, y);
            StoW(dev, x, y);
            *px    = x;
            *py    = y;
            return(MOUSE_LEFT);};

        pm = PG_get_mouse_released(MOUSE_RIGHT);
        if (pm->count > 0)
           {ix = pm->x;
            iy = pm->y;
            PtoS(dev, ix, iy, x, y);
            StoW(dev, x, y);
            *px    = x;
            *py    = y;
            return(MOUSE_RIGHT);};};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
