/*
 * GSPR_BGI.C - PGS BGI primitive routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "pgs.h"

/*--------------------------------------------------------------------------*/

/*                         STATE QUERY ROUTINES                             */

/*--------------------------------------------------------------------------*/

/* _PG_BGI_GET_TEXT_EXT_NDC - return the text extent in NDC
 *                          - of the given string
 */

void _PG_bgi_get_text_ext_NDC(dev, s, px, py)
   PG_device *dev;
   char *s;
   REAL *px, *py;
   {REAL tx, ty;
    int ix, iy;

    tx = strlen(s)*(dev->char_width_s + dev->char_space_s) -
         dev->char_space_s;
    ty = dev->char_height_s;

    ix = textwidth(s);
    tx = ix/dev->window_width;
    iy = textheight(s);
    ty = iy/dev->window_height;

    *px = tx;
    *py = ty;

    return;}

/*--------------------------------------------------------------------------*/

/*                          STATE CHANGE ROUTINES                           */

/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_LOGICAL_OP - set the logical operation */
 
void _PG_bgi_set_logical_op(dev, lop)
   PG_device *dev;
   int lop;
   {dev->logical_op = lop;

    switch (lop)
       {case GS_XOR :
/* GOTCHA: Put something appropriate here */
	     break;

	default      :
        case GS_COPY :
/* GOTCHA: Put something appropriate here */
	     break;};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_LINE_STYLE - set the line style */
 
void _PG_bgi_set_line_style(dev, style)
   PG_device *dev;
   int style;
   {dev->line_style = style;

    switch (style)
       {case LINE_DASHED    :
	     setlinestyle(DASHED_LINE, 0, 1);
	     break;
        case LINE_DOTTED    :
	     setlinestyle(DOTTED_LINE, 0, 1);
	     break;
        case LINE_DOTDASHED :
	     setlinestyle(CENTER_LINE, 0, 1);
	     break;
        case LINE_SOLID     :
	default             :
	     setlinestyle(SOLID_LINE, 0, 1);
	     break;};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_LINE_WIDTH - set the line width */
 
void _PG_bgi_set_line_width(dev, width)
   PG_device *dev;
   double width;
   {dev->line_width = width;
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_LINE_COLOR - set the line color */
 
void _PG_bgi_set_line_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {dev->line_color = color;

    if (mapped)
       color = _PG_trans_color(dev, color);

    PG_SET_COLOR(color);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_TEXT_COLOR - set the color of the text */
 
void _PG_bgi_set_text_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {dev->text_color = color;

    if (mapped)
       color = _PG_trans_color(dev, color);

    PG_SET_COLOR(color);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_FILL_COLOR - sets current fill color */

void _PG_bgi_set_fill_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {dev->fill_color = color;

    PG_SET_COLOR(color);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_FONT - set the character font */

int _PG_bgi_set_font(dev, face, style, size)
   PG_device *dev;
   char *face, *style;
   int size;
   {int nfont, nstyle;
    char *font_name;

    if (!PG_setup_font(dev, face, style, size, &font_name, &nfont, &nstyle))
       return(FALSE);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_CHAR_SIZE_NDC - set the character size in NCD */

void _PG_bgi_set_char_size_NDC(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_height_s = (REAL) y;
    dev->char_width_s  = (REAL) x;

    PG_set_font(dev, dev->type_face, dev->type_style, dev->type_size);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_CHAR_PATH - set the direction along which text will be written
 *                       - defaults to (1, 0)
 */

void _PG_bgi_set_char_path(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_path_x = x;
    dev->char_path_y = y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_CHAR_PRECISION - set the character precision
 *                            - fast and fixed size or
 *                            - slow and flexible
 */

void _PG_bgi_set_char_precision(dev, p)
   PG_device *dev;
   int p;
   {dev->char_precision = p;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_CHAR_SPACE - set the space between characters */

void _PG_bgi_set_char_space(dev, s)
   PG_device *dev;
   double s;
   {dev->char_space = (REAL) s;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_SET_CHAR_UP - set the direction which is up for individual
 *                     - characters
 *                     - defaults to (0, 1)
 */

void _PG_bgi_set_char_up(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_up_x = (REAL) x;
    dev->char_up_y = (REAL) y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_CHAR_LINE - set the number characters per line */
 
void _PG_bgi_set_char_line(dev, n)
   PG_device *dev;
   int n;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SET_CLIPPING - set clipping
 *                      - flag = FALSE  -->  clipping off
 *                      - flag = TRUE   -->  clipping on
 */

void _PG_bgi_set_clipping(dev, flag)
   PG_device *dev;
   int flag;
   {int ix0, iy0, ix1, iy1;
    int iw, ih;
    REAL xmin, xmax, ymin, ymax;

    PG_get_viewport_WC(dev, &xmin, &xmax, &ymin, &ymax);

    _PG_find_clip_region(dev, xmin, xmax, ymin, ymax,
			 &ix0, &iy0, &ix1, &iy1, flag, FALSE);

    setviewport(ix0, iy1, ix1, iy0, flag);
 
    dev->clipping = flag;

    return;}
 
/*--------------------------------------------------------------------------*/

/*                          MOVE AND DRAW ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_MOVE_GR_ABS - move the current graphics cursor position to the
 *                     - given absolute coordinates in WC
 */
 
void _PG_bgi_move_gr_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {short x1, y1;
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->gcurx = x;
    dev->gcury = y;

    WtoS(dev, x, y);
    StoP(dev, x, y, x1, y1);
 
    PG_MOVE_TO(x1, y1);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_MOVE_TX_ABS - move the current text cursor position to the
 *                     - given coordinates in WC
 */
 
void _PG_bgi_move_tx_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {short x1, y1;
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx = x;
    dev->tcury = y;

    WtoS(dev, x, y);

    y += dev->char_height_s;

    StoP(dev, x, y, x1, y1);
 
    PG_MOVE_TO(x1, y1);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_MOVE_TX_REL - move the current text cursor position to the
 *                     - given relative coordinates in WC
 */
 
void _PG_bgi_move_tx_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {short x1, y1;

/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx += x;
    dev->tcury += y;

    x = dev->tcurx;
    y = dev->tcury;
    
    WtoS(dev, x, y);
    
    y += dev->char_height_s;
    
    StoP(dev, x, y, x1, y1);
    
    PG_MOVE_TO(x1, y1);
    
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_DRAW_TO_ABS - draw a line from current position to
 *                     - absolute position (x, y)
 *                     - in WC
 */
 
void _PG_bgi_draw_to_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {int ix1, iy1, ix2, iy2;
    REAL x1, y1;

/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);

    dev->gcurx = x;
    dev->gcury = y;

    WtoS(dev, x, y);
    StoP(dev, x, y, x1, y1);
 
    PG_LINE_TO(x1, y1);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_DRAW_TO_REL - draw a line from current position to
 *                     - relative position (x, y)
 *                     - in WC
 */
 
void _PG_bgi_draw_to_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {short x1, y1;

/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->gcurx += x;
    dev->gcury += y;

/* resuse x and y to rescale to pixel coordinates */
    x = dev->gcurx;
    y = dev->gcury;

    WtoS(dev, x, y);
    StoP(dev, x, y, x1, y1);
 
    PG_LINE_TO(x1, y1);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_DRAW_POLYLINE - plot line segments between points specified
 *                       - by values from an array of x and an array of
 *                       - y values make our own calls to lineabs so that
 *                       - log plots will always work
 */
 
void _PG_bgi_draw_polyline(dev, x, y, n)
   PG_device *dev;
   REAL *x, *y;
   int n;
   {int i;

    PG_move_gr_abs(dev, x[0], y[0]);

    for (i = 1; i < n; i++)
        PG_draw_to_abs(dev, x[i], y[i]);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_DRAW_CURVE - draw a PG_curve */
 
void _PG_bgi_draw_curve(dev, crv, clip)
   PG_device *dev;
   PG_curve *crv;
   int clip;
   {int i, n, xo, yo, ix, iy;
    int *x, *y;

    n  = crv->n;
    x  = crv->x;
    y  = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;

    for (i = 1; i < n; i++)
        {ix = x[i] + xo;
         iy = y[i] + yo;
         PG_LINE_TO(ix, iy);};

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_DRAW_DISJOINT_POLYLINE_2 - draws disjoint two dimensional
 *                                  - line segments specified in WC
 */

void _PG_bgi_draw_disjoint_polyline_2(dev, x, y, n, flag, coord)
   PG_device *dev;
   REAL *x, *y;
   long n;
   int flag, coord;
   {REAL *px, *py;
    int i;

/* if auto ranging or domaining is on the data will control the WC system */
    if (flag && (dev->autorange || dev->autodomain))
       PG_set_limits(dev, x, y, 2*n, CARTESIAN);

    px = x;
    py = y;

    PG_move_gr_abs(dev, x[0], y[0]);

    if (coord)
       {for (i = 0; i < n; i++)
            PG_draw_line(dev, *px++, *py++, *px++, *py++);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_SHADE_POLY - polygon shading routine */

void _PG_bgi_shade_poly(dev, x, y, n)
   PG_device *dev;
   REAL *x, *y;
   int n;
   {int i, ix, iy;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_FILL_CURVE - fill a closed PG_curve */

void _PG_bgi_fill_curve(dev, crv)
   PG_device *dev;
   PG_curve *crv;
   {int i, n, xo, yo;
    int *x, *y;

    n  = crv->n;
    x  = crv->x;
    y  = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;
    
    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_PUT_IMAGE - put the image on the screen
 *                   - the image buffer may be overwritten by the pseudo
 *                   - color mapping if it is needed!!
 */

void _PG_bgi_put_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {int i, k, l, n_pal_colors, n_dev_colors;
    REAL rvl
    PG_palette *pal;
    RGB_color_map *pseudo_cm;
    unsigned char *pbf;

    pal          = dev->current_palette;
    n_dev_colors = dev->absolute_n_color;
    n_pal_colors = pal->n_pal_colors;
    pseudo_cm    = pal->pseudo_colormap;

    PG_invert_image_data(bf, nx, ny, 1);

    if ((n_dev_colors < n_pal_colors) && (pseudo_cm != NULL))
       {pbf = bf;
        PM_random(-1);
        for (l = 0; l < ny; l++)
            for (k = 0; k < nx; k++)
                {i      = *pbf;
                 rv     = 3.5*PM_random(1) - 0.83;
                 *pbf++ = (rv < pseudo_cm[i].red) ?
                          pseudo_cm[i].green : pseudo_cm[i].blue;};};

/* nobody home */

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_GET_IMAGE - get the image on the screen into
 *                   - the image buffer
 */

void _PG_bgi_get_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

