/*
 * GSRAST.H
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_RASTER

#define PCK_RASTER

/*--------------------------------------------------------------------------*/

/*                            MACRO DEFINITIONS                             */

/*--------------------------------------------------------------------------*/

#define MPEG_DEVICE    134
#define JPEG_DEVICE    135
#define IMAGE_DEVICE   136

#define N_RAST_COLOR 256

#define GET_RST_DEVICE(_d)      ((PG_RAST_device *) (_d)->file)
#define GET_RAST_DEVICE(_d, _r) ((_r)       = (PG_RAST_device *) (_d)->file)
#define SET_RAST_DEVICE(_d, _r) ((_d)->file = (FILE *) (_r))

#define INTRA           0

#define WRITE_LENGTH    4096
#define NUM_P           2        /* priority level, fixed 2 */
#define DCT_SIZE        8
#define MBSIZE          16

#define DCT_SIZE_2      (DCT_SIZE*DCT_SIZE)
#define MBSIZE_2        (MBSIZE*MBSIZE)

#define RANGE(x, a, b)  (((x) < (a)) ? (a) : (((x) > (b)) ? (b) : (x)))
#define sgn(x)          (((x) > 0) ? 1 : (((x) < 0) ? -1 : 0))

#define _PG_PUT_BITS(dev, v) _PG_write_code(dev, v.data, v.length)

#define GET_RGB(fr, r, g, b)                                                 \
   {r = fr->Y;                                                               \
    g = fr->Cr;                                                              \
    b = fr->Cb;}

#define PUT_RGB(fr, r, g, b)                                                 \
   {fr->Y  = r;                                                              \
    fr->Cr = g;                                                              \
    fr->Cb = b;}

#define MPG_DEVICE(dev) (dev->type_index == MPEG_DEVICE)
#define JPG_DEVICE(dev) (dev->type_index == JPEG_DEVICE)

/* #define DEBUG(y) */
#define DEBUG(y) PRINT(stdout, y)

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/

/*                       STRUCTS AND TYPEDEFS                               */

/*--------------------------------------------------------------------------*/

typedef struct s_vlcdata vlcdata;
typedef struct s_mb mb;
typedef struct s_frame frame;
typedef struct s_PG_RAST_device PG_RAST_device;
typedef struct s_PG_CS_info PG_CS_info;


/* VLCDATA */

struct s_vlcdata
   {unsigned int data;
    int length;};

/* MACRO BLOCK */

struct s_mb
   {short **data;};  /* pointer to each macro block 
                      * each MB's are represented by 
                      * one dimension short array with 6*64 factors */

struct s_frame
   {unsigned char *Y;
    unsigned char *Cr;
    unsigned char *Cb;
    int width;
    int height;};

struct s_PG_RAST_device
   {int quant;        /* quantization scale */
    int dctnum;       /* beta, number of DCT coefficients in HP class */
    int width;        /* width of video data */
    int height;       /* height of video data */
    int rgb_mode;     /* do RGB or lookup color */
    char *out_fname;  /* raster data file/device name */

    int mb_bits;      /* counter for MB generation */
    int mb_type;      /* macro block type: 1 - intra, 2 - pred or Bi-Dir */

    FILE *fp;

    unsigned int data[WRITE_LENGTH];
    int off;
    int bits_left;

    frame **first_recon_frame;
    frame **last_recon_frame;
    frame *inner_frame;
    frame *last_frame;};

struct s_PG_CS_info
   {REAL old_wc[4];
    REAL old_nc[4];
    REAL new_nc[4];};

/*--------------------------------------------------------------------------*/

/*                          VARIABLE DECLARATIONS                           */

/*--------------------------------------------------------------------------*/

extern vlcdata
 dct_codes[32][40],
 dct_dc_size_y[9],
 dct_dc_size_uv[9];

/*--------------------------------------------------------------------------*/

/*                          FUNCTION DECLARATIONS                           */

/*--------------------------------------------------------------------------*/

/* GSPR_MP.C declarations */

extern int
 SC_DECLARE(_PG_do_intra, (PG_RAST_device *dev));


/* GSDV_RST.C declarations */

extern void
 SC_DECLARE(PG_free_raster_device, (PG_RAST_device *rdev)),
 SC_DECLARE(PG_setup_mpeg_device, (PG_device *dev)),
 SC_DECLARE(PG_setup_jpeg_device, (PG_device *dev)),
 SC_DECLARE(PG_setup_raster_device, (PG_device *dev)),
 SC_DECLARE(_PG_code_vl, 
	    (PG_RAST_device *dev, short *block, int type, int dctnum)),
 SC_DECLARE(_PG_align, (PG_RAST_device *dev)),
 SC_DECLARE(_PG_write_code, (PG_RAST_device *dev, unsigned int data, int nb)),
 SC_DECLARE(_PG_rst_set_dev_prop, (PG_device *dev, int dx, int dy, int nc)),
 SC_DECLARE(_PG_free_frame, (frame *fr)),
 SC_DECLARE(_PG_copy_frame, (frame *fr1, frame *fr2));

extern frame
 *SC_DECLARE(_PG_make_frame, (int w, int h));

extern PG_RAST_device
 *SC_DECLARE(PG_make_raster_device, (int w, int h, char *name,
				     frame *infr, int rgb, FILE *fp));

#ifdef __cplusplus
}
#endif

#endif
