/*
 * MLOPER.C - field operation routines for PML
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pml.h"

PM_field
 REAL_Opers = {(PFByte) PM_fplus, (PFByte) PM_fminus, NULL,
                 (PFByte) PM_ftimes, (PFByte) PM_fdivide},
 Int_Opers = {(PFByte) PM_iplus, (PFByte) PM_iminus, NULL, 
              (PFByte) PM_itimes, (PFByte) PM_idivide},
 Long_Opers = {(PFByte) PM_lplus, (PFByte) PM_lminus, NULL, 
               (PFByte) PM_ltimes, (PFByte) PM_ldivide},
 *PM_REAL_Opers = &REAL_Opers,
 *PM_Int_Opers = &Int_Opers,
 *PM_Long_Opers = &Long_Opers;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_IPLUS - integer addition in C */

int PM_iplus(x, y)
   int x, y;
   {return(x+y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_LPLUS - long integer addition in C */

long PM_lplus(x, y)
   long x, y;
   {return(x+y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_FPLUS - floating point addition in C */

double PM_fplus(x, y)
   double x, y;
   {return(x+y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_IMINUS - integer subtraction in C */

int PM_iminus(x, y)
   int x, y;
   {return(x-y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_LMINUS - long integer subtraction in C */

long PM_lminus(x, y)
   long x, y;
   {return(x-y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_FMINUS - floating point subtraction in C */

double PM_fminus(x, y)
   double x, y;
   {return(x-y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_ITIMES - integer multiplication in C */

int PM_itimes(x, y)
   int x, y;
   {return(x*y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_LTIMES - long integer multiplication in C */

long PM_ltimes(x, y)
   long x, y;
   {return(x*y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_FTIMES - floating point multiplication in C */

double PM_ftimes(x, y)
   double x, y;
   {return(x*y);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_IDIVIDE - integer division in C */

int PM_idivide(x, y)
   int x, y;
   {if (y != 0)
       return(x/y);
    else
       return(INT_MAX);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_LDIVIDE - long integer division in C */

long PM_ldivide(x, y)
   long x, y;
   {if (y != 0)
       return(x/y);
    else
       return(LONG_MAX);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_IMODULO - return the remainder after integer division in C */

int PM_imodulo(x, y)
   int x, y;
   {if (y != 0)
       return(x % y);
    else
       return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_LMODULO - return the remainder after long integer division in C */

long PM_lmodulo(x, y)
   long x, y;
   {if (y != 0)
       return(x % y);
    else
       return(0L);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_FDIVIDE - floating point division in C */

double PM_fdivide(x, y)
   double x, y;
   {if (y != 0.0)
       return(x/y);
    else
       return(DBL_MAX);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_FMIN - floating point min in C */

double PM_fmin(x, y)
   double x, y;
   {return(min(x, y));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PM_FMAX - floating point max in C */

double PM_fmax(x, y)
   double x, y;
   {return(max(x, y));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
