;
; RUNT.SCM - some runtime Scheme procedures not implemented at
;	   - C level in the interpreter
;
; Source Version: 3.0
; Software Release #92-0043
;
; #include <pact-copyright.h>
;

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; -1+ - decrement by 1

(define (-1+ n) (- n 1))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CAAAAR 

(define (caaaar x) (car (caaar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDAAAR 

(define (cdaaar x) (cdr (caaar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CADAAR 

(define (cadaar x) (car (cdaar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDDAAR 

(define (cddaar x) (cdr (cdaar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CAADAR 

(define (caadar x) (car (cadar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDADAR 

(define (cdadar x) (cdr (cadar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CADDAR 

(define (caddar x) (car (cddar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDDDAR 

(define (cdddar x) (cdr (cddar x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CAAADR 

(define (caaadr x) (car (caadr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDAADR 

(define (cdaadr x) (cdr (caadr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CADADR 

(define (cadadr x) (car (cdadr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDDADR 

(define (cddadr x) (cdr (cdadr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CAADDR 

(define (caaddr x) (car (caddr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDADDR 

(define (cdaddr x) (cdr (caddr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CADDDR 

(define (cadddr x) (car (cdddr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; CDDDDR 

(define (cddddr x) (cdr (cdddr x)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; DO - the do special form

(define-macro (do local-vars test-expr . body)
   (let* ((vars (lambda (x)
		  (if (null? x)
		      ()
		      (cons (caar x) (vars (cdr x))))))
	  (inits (lambda (x)
		   (if (null? x)
		       ()
		       (cons (cadar x) (inits (cdr x))))))
	  (repts (lambda (x)
		   (if (null? x)
		       ()
		       (cons (caddar x) (repts (cdr x))))))
	  (test (car test-expr))
	  (exit (cdr test-expr))
	  (form `(lambda ,(vars local-vars)
		   (if ,test
		       (begin ,@exit)
		       (begin ,@body
			      (loop ,@(repts local-vars))))))
	  (loop (eval form)))
     (apply loop (inits local-vars))))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; FOR - a simpler FORTRAN style do

(define-macro (for local-var start stop incr . body)
   (let* ((form `(lambda (,local-var)
		   (if (<= ,local-var ,stop)
		       (begin ,@body
			      (loop (+ ,local-var ,incr))))))
	  (loop (eval form)))
     (apply loop (list (eval start)))))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; LETREC - temporarily reassign letrec to let* to ease the transition from
;        - the original incorrect definition of letrec

(define-macro (letrec . args)
   (printf nil "\nUse let* instead of letrec. It is the correct function.\n")
   (printf nil "In the future letrec will be defined to its standard meaning.\n\n")
   (set! letrec let*)
   (apply let* args))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; ERROR - some error reporting procedure

(define (error x) (newline) (display x) (newline) (break))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; AUTOLOAD* - do real autoloading of procedures

(define (autoload* funcname filename)
    (apply define-global
	   (list funcname
		 (eval (list lambda 'x
			     (list printf nil "Auto-loading %s ... " filename)
			     (list load filename)
			     (list printf nil "done\n")
			     (list apply (list eval funcname) 'x))))))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; AUTOLOAD - do real autoloading of macros

(define (autoload funcname filename)
    (apply define-global-macro
	   (list funcname
		 (eval (list lambda 'x
			     (list printf nil "Auto-loading %s ... " filename)
			     (list load filename)
			     (list printf nil "done\n")
			     (list apply (list eval funcname) 'x))))))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

(define (test-scheme)
   (do ((i 0 (+ i 1))) ((= i 50) (newline)) (display i)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

