/*
 * SHINT.C - C interface routines for SCHEME
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

PFVoid
 SS_arg_hook = (PFVoid) NULL;

PFPObject
 SS_call_arg_hook = (PFPObject) NULL;

static char
 _SS_bf[MAXLINE];

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_FIX_ARG - get a C level fix point data item from
 *             - a single Scheme object
 */

static void _SS_fix_arg(obj, v, type)
   object *obj;
   byte *v;
   int type;
   {BIGINT l;
#ifdef _LARGE_FILES
    BIGINT *llp;
#endif
    long *lp;
    int *ip;
    short *sp;
    char *cp;

    if (SS_integerp(obj))
       l = SS_INTEGER_VALUE(obj);

    else if (SS_floatp(obj))
       l = PM_fix(SS_FLOAT_VALUE(obj));

    else if (SS_charobjp(obj))
       l = SS_CHARACTER_VALUE(obj);

    else if (SS_procedurep(obj))
       {PFPObject hand;
        SC_address u;

        switch (SS_PROCEDURE_TYPE(obj))
           {case SS_MACRO : 
            case SS_PROC  :
                 SS_error("CAN'T MAKE VALUE - _SS_FIX_ARG", obj);
                 break;

            default       :
                 hand       = SS_C_PROCEDURE_HANDLER_PTR(obj);
                 u.funcaddr = (PFInt) SS_C_PROCEDURE_FUNCTION_PTR(obj);
                 if (hand == SS_acc_char)
                    l = *(char *) u.memaddr;
                 else if (hand == SS_acc_int)
                    l = *(int *) u.memaddr;
                 else if (hand == SS_acc_long)
                    l = *(long *) u.memaddr;
                 else if (hand == SS_acc_REAL)
                    l = *(REAL *) u.memaddr;
                 else
                    SS_error("BAD VARIABLE TYPE - _SS_FIX_ARG", obj);};}
    else
       SS_error("BAD OBJECT - _SS_FIX_ARG", obj);

    switch (type)
       {case SC_CHAR_I     : cp  = (char *) v;
                             *cp = (char) l;
                             break;
        case SC_SHORT_I    : sp  = (short *) v;
                             *sp = (short) l;
                             break;
        case SC_INTEGER_I  : ip  = (int *) v;
                             *ip = (int) l;
                             break;
        case SC_LONG_I     : lp  = (long *) v;
                             *lp = (long) l;
#ifndef _LARGE_FILES
                             break;};
#else
                             break;
        case SC_LONGLONG_I : llp  = (BIGINT *) v;
                             *llp =  l;
                             break;};
#endif
    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_FLOAT_ARG - get a C level floating point data item from
 *               - a single Scheme object
 */

static void _SS_float_arg(obj, v, type)
   object *obj;
   byte *v;
   int type;
   {int which;
    double d, *dp;
    float *fp;

    if (SS_integerp(obj))
       d = SS_INTEGER_VALUE(obj);

    else if (SS_floatp(obj))
       d = SS_FLOAT_VALUE(obj);

    else if (SS_charobjp(obj))
       d = SS_CHARACTER_VALUE(obj);

    else if (SS_procedurep(obj))
       {PFPObject hand;
        SC_address u;

        switch (SS_PROCEDURE_TYPE(obj))
           {case SS_MACRO : 
            case SS_PROC  :
                 SS_error("CAN'T MAKE VALUE - _SS_FLOAT_ARG", obj);
                 break;

            default       :
                 hand       = SS_C_PROCEDURE_HANDLER_PTR(obj);
                 u.funcaddr = (PFInt) SS_C_PROCEDURE_FUNCTION_PTR(obj);
                 if (hand == SS_acc_char)
                    d = *(char *) u.memaddr;
                 else if (hand == SS_acc_int)
                    d = *(int *) u.memaddr;
                 else if (hand == SS_acc_long)
                    d = *(long *) u.memaddr;
                 else if (hand == SS_acc_REAL)
                    d = *(REAL *) u.memaddr;
                 else
                    SS_error("BAD VARIABLE TYPE - _SS_FLOAT_ARG", obj);};}
    else
       SS_error("BAD OBJECT - _SS_FLOAT_ARG", obj);

    which = (sizeof(REAL) == sizeof(double));
    if (which)
       {switch (type)
           {case SC_FLOAT_I  : fp  = (float *) v;
                               *fp = (float) d;
                               break;
            case SC_REAL_I   :
            case SC_DOUBLE_I : dp  = (double *) v;
                               *dp = d;
                               break;};}
    else
       {switch (type)
           {case SC_REAL_I   :
            case SC_FLOAT_I  : fp  = (float *) v;
                               *fp = (float) d;
                               break;
            case SC_DOUBLE_I : dp  = (double *) v;
                               *dp = d;
                               break;};}

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_ARGS - get a C level data item from a single SCHEME object */

static void _SS_args(obj, v, type)
   object *obj;
   byte *v;
   int type;
   {byte **pv;
    char *s;

    pv = (byte **) v;

/* if the object has been GC'd along the line NULL out the C level item */
    if (obj->val == NULL)
       {DEREF(v) = NULL;
        return;};

    switch (type)
       {case SC_CHAR_I     :
        case SC_SHORT_I    :
        case SC_INTEGER_I  :
#ifdef _LARGE_FILES
        case SC_LONGLONG_I :
#endif
        case SC_LONG_I     : 
             _SS_fix_arg(obj, v, type);
             break;

        case SC_FLOAT_I    :
        case SC_REAL_I     :
        case SC_DOUBLE_I   : 
             _SS_float_arg(obj, v, type);
             break;

        case SC_STRING_I   : 
             if (obj->print_name != NULL)
                s = SC_strsavef(obj->print_name, "char*:_SS_ARGS_:string");
             else
                s = SC_strsavef("- no print name -", "char*:_SS_ARGS:string");
             DEREF(v) = s;
             break;

        case SS_OBJECT_I   :
             *pv = (byte *) obj;
             break;

#ifdef LARGE

        case HASH_ELEMENT :
	     if (!SS_hash_elementp(obj))
	        SS_error("OBJECT NOT HASH_ELEMENT - _SS_ARGS", obj);
	     *pv = obj->val;
	     break;

        case HASH_TABLE :
	     if (!SS_hash_tablep(obj))
	        SS_error("OBJECT NOT HASH_TABLE - _SS_ARGS", obj);
	     *pv = obj->val;
	     break;

        case PROCESS_OBJ :
	     if (!SS_processp(obj))
	        SS_error("OBJECT NOT PROCESS - _SS_ARGS", obj);
	     *pv = obj->val;
	     break;

#endif

        default :
	     if (SS_arg_hook != NULL)
	        (*SS_arg_hook)(obj, v, type);
	     else
	        *pv = obj->val;

	     break;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ARGS - break out the C level data analogs from a Scheme
 *         - object of list of objects
 *         - this is for ease of use
 *         - return the number of Scheme arguments
 */

#ifdef PCC

int SS_args(s, va_alist)
   object *s;
   va_dcl

#endif

#ifdef ANSI

int SS_args(object *s, ...)

#endif

   {object *obj;
    byte *v;
    int type, len;

    if (SS_nullobjp(s))
       return(0);

    SC_VA_START(s);

    if (!SS_consp(s))
       {len  = 1;
        obj  = s;
        type = SC_VA_ARG(int);
        if (type != 0)
           {v = SC_VA_ARG(byte *);
            _SS_args(obj, v, type);};}
    else
       {len = _SS_length(s);
        while (SS_consp(s))
           {obj = SS_car(s);
            s   = SS_cdr(s);

            type = SC_VA_ARG(int);
            if (type == 0)
               break;

            v = SC_VA_ARG(byte *);
            if (v == (byte *) LAST)
               break;

            _SS_args(obj, v, type);};};

    SC_VA_END;

    return(len);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_DEFINE_CONSTANT - bind a given compiled value as
 *                    - a SCHEME variable of a specified type
 */

#ifdef PCC

object *SS_define_constant(n, va_alist)
   int n;
   va_dcl

#endif

#ifdef ANSI

object *SS_define_constant(int n, ...)

#endif

   {object *vr, *val;
    char *name;
    int type;

    SC_VA_START(n);

    while ((name = SC_VA_ARG(char *)) != NULL)
      {type = SC_VA_ARG(int);
       switch (type)
          {case SC_CHAR_I     :
           case SC_SHORT_I    :
           case SC_INTEGER_I  :
                val = SS_mk_integer((BIGINT) SC_VA_ARG(int));
                break;

           case SC_LONG_I     :
                val = SS_mk_integer((BIGINT) SC_VA_ARG(long));
                break;
#ifdef _LARGE_FILES
           case SC_LONGLONG_I :
                val = SS_mk_integer((BIGINT) SC_VA_ARG(BIGINT));
                break;
#endif
           case SC_FLOAT_I    :
           case SC_DOUBLE_I   :
                val = SS_mk_float((double) SC_VA_ARG(double));
                break;

           case SC_STRING_I   :
                val = SS_mk_string(SC_VA_ARG(char *));
                break;

           default            :
                SS_error("UNSUPPORTED TYPE - SX_DEFINE_CONSTANT",
                         SS_null);};

       vr = SS_mk_variable(name, SS_null);
       SS_UNCOLLECT(vr);

       SC_install(name, vr, SS_POBJECT_S, SS_symtab);
       SS_def_var(vr, val, SS_Global_Env);};

    SC_VA_END;

    return(vr);}

/*---------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_VAR_VALUE - given the name of a current SCHEME object which
 *              - has correspondence with a C or FORTRAN variable
 *              - make the given pointer point to its value
 *              - if flag is TRUE and the object is a variable return its
 *              - binding in the current environment
 */

void SS_var_value(s, type, vr, flag)
   char *s;
   int type;
   byte *vr;
   int flag;
   {object *obj;

    obj = SS_INQUIRE_OBJECT(s);

    if (flag && SS_variablep(obj))
       obj = SS_lk_var_val(obj, SS_Env);

    if (SS_nullobjp(obj))
       DEREF(vr) = NULL;
    else
       SS_args(obj, type, vr, 0);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_VAR_REFERENCE - given the name of a current SCHEME object which
 *                  - has correspondence with a C or FORTRAN variable
 *                  - return a pointer to its value
 */

byte *SS_var_reference(s)
   char *s;
   {object *obj;
    byte *vr;

    obj = SS_INQUIRE_OBJECT(s);
    if (SS_variablep(obj))
       obj = SS_lk_var_val(obj, SS_Env);

    if (SS_integerp(obj) || SS_floatp(obj) || SS_charobjp(obj))
       vr = SS_OBJECT(obj);

    else if (SS_stringp(obj))
       vr = SS_STRING_TEXT(obj);

    else if (SS_procedurep(obj))
       {PFPObject hand;
        SC_address u;

        switch (SS_PROCEDURE_TYPE(obj))
           {case SS_MACRO : 
            case SS_PROC  :
                 SS_error("CAN'T MAKE VALUE - _SS_FLOAT_ARG", obj);
                 break;

            default       :
                 hand       = SS_C_PROCEDURE_HANDLER_PTR(obj);
                 u.funcaddr = (PFInt) SS_C_PROCEDURE_FUNCTION_PTR(obj);
                 if ((hand == SS_acc_char) ||
                     (hand == SS_acc_int) ||
                     (hand == SS_acc_long) ||
                     (hand == SS_acc_REAL))
                    vr = u.memaddr;
                 else
                    SS_error("BAD VARIABLE TYPE - SS_VAR_REFERENCE", obj);};}
    else
       SS_error("BAD OBJECT - SS_VAR_REFERENCE", obj);

    return(vr);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_MAKE_LIST - make a SCHEME list from a C arg list */

static object *_SS_make_list(n, type, ptr)
   int n, *type;
   byte **ptr;
   {int i, j, c;
    long l;
#ifdef _LARGE_FILES
    BIGINT ll;
#endif
    double d;
    char *s;
    object *o, *lst;
    HASHTAB *ht;
    hashel *hp;

    lst = SS_null;
    for (i = 0; i < n; i++)
        {switch (type[i])
            {case SC_SHORT_I   :
             case SC_INTEGER_I :
                  j   = *(int *) ptr[i];
                  lst = SS_mk_cons(SS_mk_integer((BIGINT)j), lst);
                 break;
 
             case SC_LONG_I    :
                  l   = *(long *) ptr[i];
                  lst = SS_mk_cons(SS_mk_integer((BIGINT)l), lst);
                 break;
#ifdef _LARGE_FILES
             case SC_LONGLONG_I    :
                  ll   = *(BIGINT *) ptr[i];
                  lst = SS_mk_cons(SS_mk_integer(ll), lst);
                 break;
#endif
             case SC_FLOAT_I   :
                  d   = *(float *) ptr[i];
                  lst = SS_mk_cons(SS_mk_float(d), lst);
                  break;

             case SC_REAL_I   :
                  d   = *(REAL *) ptr[i];
                  lst = SS_mk_cons(SS_mk_float(d), lst);
                  break;

             case SC_DOUBLE_I  :
                  d   = *(double *) ptr[i];
                  lst = SS_mk_cons(SS_mk_float(d), lst);
                  break;
 
             case SC_STRING_I  :
                  s   = (char *) ptr[i];
                  lst = SS_mk_cons(SS_mk_string(s), lst);
                  break;
 
             case SS_OBJECT_I  :
                  o   = (object *) ptr[i];
                  lst = SS_mk_cons(o, lst);
                  break;
 
#ifdef LARGE
 
             case SC_CHAR_I    :
                  c   = *(int *) ptr[i];
                  lst = SS_mk_cons(SS_mk_char(c), lst);
                  break;
 
             case HASH_ELEMENT :
                  hp   = (hashel *) ptr[i];
                  lst = SS_mk_cons(SS_mk_hash_element(hp), lst);
                  break;
 
             case HASH_TABLE   :
                  ht   = (HASHTAB *) ptr[i];
                  lst = SS_mk_cons(SS_mk_hash_table(ht), lst);
                  break;
 
#endif
 
             default           :
                  if (SS_call_arg_hook != NULL)
                     {o   = (*SS_call_arg_hook)(type[i], ptr[i]);
                      lst = SS_mk_cons(o, lst);}
                  else
                     lst = SS_mk_cons(SS_null, lst);
                  break;};};

    return(SS_reverse(lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_MAKE_LIST - make a SCHEME list at the C level */

#ifdef PCC

object *SS_make_list(first, va_alist)
   int first;
   va_dcl

#endif

#ifdef ANSI

object *SS_make_list(int first, ...)

#endif

   {int i, type[MAXLINE];
    byte *ptr[MAXLINE];

    SC_VA_START(first);

    type[0] = first;
    ptr[0]  = SC_VA_ARG(byte *);

    for (i = 1; i < MAXLINE; i++)
        {type[i] = SC_VA_ARG(int);
         if (type[i] == 0)
            break;

         ptr[i]  = SC_VA_ARG(byte *);
         if (ptr[i] == (byte *) LAST)
            break;};

    SC_VA_END;

    return(_SS_make_list(i, type, ptr));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SSCHEM - do a Fortran version of SS_call_scheme */

#ifdef PCC

FIXNUM F77_ID(sschem_, sschem, SSCHEM)(pnc, name, va_alist)
   FIXNUM *pnc;
   F77_string name;
   va_dcl

#endif

#ifdef ANSI

FIXNUM F77_ID(sschem_, sschem, SSCHEM)(FIXNUM *pnc, F77_string name, ...)

#endif
   {int i, type[MAXLINE];
    object *fnc, *expr;
    byte *ptr[MAXLINE];
    char func[80];
    SC_address ret;
    
    SC_FORTRAN_STR_C(func, name, *pnc);

    SC_VA_START(name);

    fnc = (object *) SC_def_lookup(func, SS_symtab);
    if (fnc == NULL)
       SS_error("UNKNOWN PROCEDURE - SSCHEM", SS_mk_string(func));

    for (i = 0; i < MAXLINE; i++)
        {type[i] = *SC_VA_ARG(int *);
         if (type[i] == 0)
            break;

         ptr[i] = (byte *) *SC_VA_ARG(char **);
         if (ptr[i] == (byte *) LAST)
            break;};

    SC_VA_END;

    expr = SS_null;
    SS_Assign(expr, SS_mk_cons(fnc, _SS_make_list(i, type, ptr)));

    SS_eval(expr);

    SS_Assign(expr, SS_null);

    ret.memaddr = (char *) SS_Val;

    return((FIXNUM) ret.diskaddr);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CALL_SCHEME - make a C level call to a SCHEME level function
 *                - return the SCHEME result object
 */

#ifdef PCC

object *SS_call_scheme(func, va_alist)
   char *func;
   va_dcl

#endif

#ifdef ANSI

object *SS_call_scheme(char *func, ...)

#endif

   {int i, type[MAXLINE];
    object *fnc, *expr;
    byte *ptr[MAXLINE];

    SC_VA_START(func);

    fnc = (object *) SC_def_lookup(func, SS_symtab);
    if (fnc == NULL)
       SS_error("UNKNOWN PROCEDURE - SS_CALL_SCHEME", SS_mk_string(func));

    for (i = 0; i < MAXLINE; i++)
        {type[i] = SC_VA_ARG(int);
         if (type[i] == 0)
            break;

         ptr[i] = SC_VA_ARG(byte *);
         if (ptr[i] == (byte *) LAST)
            break;};

    SC_VA_END;

    SC_mem_stats_set(0L, 0L);

    expr = SS_mk_cons(fnc, _SS_make_list(i, type, ptr));
    SC_mark(expr, 1);

    SS_eval(expr);

    SS_GC(expr);

    SS_Assign(SS_Env, SS_Global_Env);
    SS_Assign(SS_This, SS_null);
    SS_Assign(SS_Exn, SS_null);
    SS_Assign(SS_Unev, SS_null);
    SS_Assign(SS_Argl, SS_null);
    SS_Assign(SS_Fun, SS_null);

    return(SS_Val);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_RUN - evaluate a single form which is given on the command line 
 *         - as a string
 */

static int _SS_run()
   {int iret;
    object *port, *ret;
    
    port = SS_mk_inport(stdin);
    strcpy(SS_BUFFER(port), _SS_bf);
    SS_PTR(port) = SS_BUFFER(port);

    ret  = SS_eval(_SS_read(port));
    iret = FALSE;
    if (_SS_numberp(ret))
       SS_args(ret,
	       SC_INTEGER_I, &iret,
	       0);

    else if (SS_true(ret))
       iret = TRUE;

    return(iret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_RUN - evaluate a single form which is given on the command line 
 *        - as a string
 */

int SS_run(s)
   char *s;
   {

    while (strchr(" \t\n\r\f", *s++) != NULL);
    strcpy(_SS_bf, --s);

    return(SS_err_catch(_SS_run, NULL));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_LOAD_SCM - load an SCHEME file with error protection */

static int _SS_load_scm()
   {SS_call_scheme("load",
                   SC_STRING_I, _SS_bf,
                   SS_OBJECT_I, SS_t,
                   0);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LOAD_SCM - load an SCHEME file with error protection */

int SS_load_scm(name)
   char *name;
   {strcpy(_SS_bf, name);

    return(SS_err_catch(_SS_load_scm, NULL));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
