,(use regex)

(define http-addr-part (reg-expr->proc '(or #\/ #\?)))

(define (unescape-http-addr-segment (seg <string>))
  (unescape-str! seg))


(define (parse-http-address (addr <string>))
  (let (((n <fixnum>) (string-length addr)))
    (let loop (((i <fixnum>) 0)
	       (r '()))
      (if (< i n)
	  (let ((x (http-addr-part addr i)))
	    (if x
		(if (eq? (string-ref addr x) #\/)
		    (loop (+ x 1) 
			  (cons (unescape-http-addr-segment 
				 (substring addr i x))
				r))
		    (begin
		      (assert (eq? (string-ref addr x) #\?))
		      (reverse! (cons* (substring addr (+ x 1))
				       '?
				       (unescape-http-addr-segment 
					(substring addr i x))
				       r))))
		(reverse! (cons (unescape-http-addr-segment 
				 (substring addr i))
				r))))
	  (reverse! (cons "" r))))))
