#include "alloc.h"
#include "htable.h"

static unsigned ptr_hash( void *ptr )
{
unsigned long h = (unsigned long)ptr;

    h = h + (h >> 8) + (h >> 16) + (h >> 24);
    return h;
}

void htable_init( struct htable *tbl )
{
unsigned i;

    tbl->table_mask = 511;
    tbl->table = ALLOCN( struct htent *, tbl->table_mask + 1 );
    for (i=tbl->table_mask+1; i>0;)
    {
	tbl->table[--i] = NULL;
    }
}

struct htent *htable_lookup( struct htable *tbl, void *key )
{
struct htent *e;
unsigned h;

    h = ptr_hash(key) & tbl->table_mask;
    e = tbl->table[h];
    while (e)
    {
	if (e->key == key)
	    return e;
	e = e->next;
    }
    return NULL;
}

struct htent *htable_insert( struct htable *tbl, void *key )
{
struct htent *e;
unsigned h;

    h = ptr_hash(key) & tbl->table_mask;
    e = ALLOC(struct htent);
    e->next = tbl->table[h];
    e->key = key;
    e->value = NULL;
    tbl->table[h] = e;
    return e;
}

void *htable_remove( struct htable *tbl, void *key )
{
struct htent *prev, *e;
unsigned h;

    h = ptr_hash(key) & tbl->table_mask;
    e = tbl->table[h];
    prev = NULL;
    while (e)
    {
	if (e->key == key)
	{
	void *v = e->value;
	
	    if (prev)
		prev->next = e->next;
	    else
		tbl->table[h] = e->next;
	    free(e);
	    return v;
	}
	prev = e;
	e = e->next;
    }
    return NULL;
}

#ifdef UNIT_TEST

int main( int argc, const char **argv )
{
struct htable t;
int i;

    htable_init( &t );
    
    for (i=1; i<argc; i++)
    {
	void *k, *v;
	
	if (strchr(argv[i],'='))
	{
	    sscanf( argv[i], "%d=%d", &k, &v );
	    htable_insert( &t, k )->value = v;
	    printf( "insert %d => %d\n", k, v );
	}
	else if (argv[i][0] == '-')
	{
	    sscanf( argv[i]+1, "%d", &k );
	    v = htable_remove( &t, k );
	    printf( "remove %d => %d\n", k, v );
	}
	else
	{
	struct htent *e;
	
	    sscanf( argv[i], "%d", &k );
	    printf( "lookup %d => ", k );
	    e = htable_lookup( &t, k );
	    if (e)
		printf( "%d\n", e->value );
	    else
		printf( "not found\n" );
	}
    }
    return 0;
}

#endif
