/*-----------------------------------------------------------------*-C-*---
 * File:    handc/platform/sunos/dynlink.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.6
 * File mod date:    1998.01.03 19:02:18
 * System build:     v0.7.3.1-b39, 1999-12-25
 *
 * Purpose:          SunOS dynamic linking interface
 *------------------------------------------------------------------------*/

#include <stdio.h>
#include "dynlink.h"

#ifdef HAVE_LIBDL
#include <dlfcn.h>
#endif

void *resolve_link_symbol( void *info, const char *sym )
{
#if HAVE_LIBDL
    return dlsym( info, sym );
#else
    return NULL;
#endif
}

void *dynamic_link_file( const char *path )
{
#if HAVE_LIBDL
    return dlopen( path, 1 );
#else
    return NULL;
#endif
}

char *dynamic_link_errors( void )
{
#if HAVE_LIBDL
  return dlerror();
#else
  return NULL;
#endif
}

void done_resolving( void *info )
{
}

void init_dynamic_link( const char *argv0 )
{
}


