/*
 * Real-Time Linux v2.x compatibility layer
 * Copyright (C) 1999 Michael Barabanov
 *
 */
#ifndef __RTL_RT_IRQ_H__
#define __RTL_RT_IRQ_H__
#include <asm/ptrace.h>
#include <linux/rtl.h>
#include <rtl_time.h>
#include <rtl_core.h>
#include <asm/irq.h>

#define r_sti() __asm__ __volatile__ ("sti": : :"memory")
#define r_cli() __asm__ __volatile__ ("cli": : :"memory")

#define r_save_flags(x) \
__asm__ __volatile__("pushfl ; popl %0":"=g" (x): /* no input */ :"memory")

#define r_restore_flags(x) \
__asm__ __volatile__("pushl %0 ; popfl": /* no output */ :"g" (x):"memory")


typedef void (*RTL_V1_HANDLER)(void);
extern RTL_V1_HANDLER rtl_v1_irq[NR_IRQS];

extern unsigned int rtl_compat_irq_handler(unsigned int irq, struct pt_regs *regs);

extern inline int request_RTirq(unsigned   int   irq,   void (*handler)(void))
{
	int ret;
	rtl_v1_irq[irq] = handler;
	ret = rtl_request_global_irq(irq, rtl_compat_irq_handler);
	if (ret) {
		return ret;
	}
	rtl_hard_enable_irq(irq);
	return 0;
}

extern inline int free_RTirq(unsigned int irq)
{
	return rtl_free_global_irq (irq);
}


#endif
